/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.statusdevice;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.statusdevice.StatusDeviceListNew;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.common.BeanCopierGenerator;
import ru.infor.websocket.client.SocketClientFactory;
import ru.infor.websocket.transport.SubscribingOptions;
import ru.infor.websocket.transport.UnsubscribingOptions;
import ru.infor.ws.business.vms.websocket.NDDataSocketIntf;
import ru.infor.ws.business.vms.websocket.objects.SubscribingOptions_SendListNDData;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.ext.NDDataExt;
import ru.infor.ws.objects.vms.ext.StatusDeviceExt;

@ListView(views={@View(title="", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class StatusDeviceList3
extends StatusDeviceListNew
implements NDDataSocketIntf {
    String sid;
    List<Long> devices;
    HashMap<Long, StatusDeviceExt> mapdevices;

    public StatusDeviceList3(String keyPage) {
        super(keyPage);
    }

    public void sendList(List<NDData> datas) {
        this.acceptData(datas);
    }

    @Override
    protected void initData() {
        super.initData();
        this.startCycleBegin();
    }

    public void connected() {
        new Thread(){

            @Override
            public void run() {
                try {
                    SubscribingOptions_SendListNDData options = new SubscribingOptions_SendListNDData();
                    options.setContext(InitializedVariable.getContext((String)StatusDeviceList3.this.getKeyPage()));
                    options.setServiceName("NDDataWS");
                    options.setMethodName("sendList");
                    options.setDeviceIdList(StatusDeviceList3.this.devices);
                    options.setSid(StatusDeviceList3.this.sid);
                    StatusDeviceList3.this.sid = SocketClientFactory.subscribe((Object)((Object)StatusDeviceList3.this), (SubscribingOptions)options, (String)InitializedVariable.getAppShortName((String)StatusDeviceList3.this.getKeyPage()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    @Override
    public void startCycle() {
        this.devices = new ArrayList<Long>();
        this.mapdevices = new HashMap();
        int i = 0;
        while (i < this.ndItems.size()) {
            StatusDeviceExt sde = (StatusDeviceExt)this.ndItems.get(i);
            if (sde.getOccurence() != 0) {
                if (sde.getDeviceId() != null) {
                    this.devices.add(sde.getDeviceId());
                    this.mapdevices.put(sde.getDeviceId(), sde);
                } else {
                    sde.setOccurence(0);
                    sde.setCode("\u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043f\u0440\u0438\u0431\u043e\u0440");
                }
            }
            ++i;
        }
        this.connected();
    }

    private void addData(NDData d) {
        NDDataExt de = new NDDataExt();
        BeanCopierGenerator.getInstance(NDData.class, (boolean)false).copy((Object)d, (Object)de, null);
        Object[] dd = null;
        if (this.data != null) {
            dd = new Object[this.data.length + 1];
            int i = 0;
            while (i < this.data.length) {
                dd[i] = this.data[i];
                ++i;
            }
            dd[this.data.length] = de;
            this.data = dd;
        } else {
            dd = new Object[]{de};
            this.data = dd;
        }
        new Thread(){

            @Override
            public void run() {
                StatusDeviceList3.this.getCurrentPC().getPanel().updateUIForPresentatorName("data");
            }
        }.start();
    }

    private void acceptData(List<NDData> datas) {
        Collections.sort(datas, (Comparator)new Comparator<NDData>(){

            @Override
            public int compare(NDData o1, NDData o2) {
                return o1.getCreatedDateTime().compareTo(o2.getCreatedDateTime());
            }
        });
        for (NDData d : datas) {
            StatusDeviceExt sde = this.mapdevices.get(d.getDeviceId());
            if (sde == null) continue;
            sde.setLevelMissing(this.calcLevelMissing(d == null ? null : d.getCreatedDateTime()));
            sde.setLastDate(d.getCreatedDateTime());
            sde = this.fillFields(sde, d, null);
            if (!d.getDeviceId().equals(this.getDeviceId())) continue;
            this.addData(d);
        }
        this.updateStatusDevice();
    }

    @Override
    public void beforeDestroy(PanelContext pc) {
        super.beforeDestroy(pc);
        this.close();
    }

    public void close() {
        try {
            if (this.sid != null) {
                UnsubscribingOptions options = new UnsubscribingOptions();
                options.setContext(InitializedVariable.getContext((String)this.getKeyPage()));
                options.setServiceName("NDDataWS");
                options.setMethodName("sendList");
                options.setSid(this.sid);
                SocketClientFactory.unsubscribe((UnsubscribingOptions)options, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startCycleBegin() {
        new Thread(){

            @Override
            public void run() {
                StatusDeviceList3.this.calcStatusDevice(StatusDeviceList3.this.devices.toArray(new Long[0]));
                StatusDeviceList3.this.updateStatusDevice();
            }
        }.start();
    }

    @Override
    public Double[] calcMileage(Date dateFrom, Date dateTill, Long[] devices) {
        return null;
    }
}

