/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.systemparameter.multiplechanges;

public class ConformityConditions {
    private String filter = null;
    private boolean starts = false;
    private boolean ends = false;

    public ConformityConditions(String line) {
        if (line != null && !line.isEmpty()) {
            this.filter = line;
            if (this.filter.startsWith("*")) {
                this.starts = true;
                this.filter = this.filter.substring(1);
            }
            if (this.filter.endsWith("*")) {
                this.ends = true;
                this.filter = this.filter.substring(0, this.filter.length() - 1);
            }
        }
    }

    public boolean conformityEquals(String field) {
        if (field != null) {
            if (this.filter == null) {
                return true;
            }
            if (!this.starts && !this.ends) {
                return field.contains(this.filter);
            }
            if (this.starts && this.ends) {
                return field.equals(this.filter);
            }
            if (this.starts && !this.ends) {
                return field.startsWith(this.filter);
            }
            if (!this.starts && this.ends) {
                return field.endsWith(this.filter);
            }
        }
        return false;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean isStarts() {
        return this.starts;
    }

    public void setStarts(boolean starts) {
        this.starts = starts;
    }

    public boolean isEnds() {
        return this.ends;
    }

    public void setEnds(boolean ends) {
        this.ends = ends;
    }
}

