/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.territorialorder.geom;

import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import org.postgis.Geometry;
import org.postgis.MultiLineString;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.mapviewer.MapValue;
import ru.blok.vms.ui.roads.RoadList;
import ru.blok.vms.ui.roads.roadspoint.roadobject.PainterRoad;
import ru.blok.vms.ui.roads.roadspoint.roadobject.PainterTraffic;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.client.soap.proxy.vms.RoadWAWSProxy;
import ru.infor.ws.objects.vms.entities.RoadWA;
import ru.infor.ws.objects.vms.entities.TerritorialOrderObject;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;
import ru.infor.ws.objects.vms.entities.ext.TerritorialOrderExt;

public class MapViewer
extends ru.blok.vms.ui.mapviewer.MapViewer {
    PainterTraffic<JXMapViewer> trafficPainter;
    protected Double[] coord;
    MapValue value;
    PainterRoad<JXMapViewer> roadpainter;
    TerritorialOrderExt order;
    RoadWAExt current = null;
    RoadWAWSProxy proxy = (RoadWAWSProxy)CurrentProxyFactory.getProxy(RoadWA.class);

    public MapViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.trafficPainter = new PainterTraffic();
        this.painter.addPainter(this.trafficPainter, 1);
        this.roadpainter = new PainterRoad();
        this.painter.addPainter(this.roadpainter);
        this.coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)""));
        this.value = new MapValue(this.coord[0], this.coord[1], this.coord[2].intValue());
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object arg0) {
        if (this.getViewerContext() != null) {
            this.order = (TerritorialOrderExt)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject());
            this.updateRoad();
            this.trafficPainter.clear();
            if (this.order != null && this.order.getTooList() != null) {
                for (TerritorialOrderObject obj : this.order.getTooList()) {
                    System.out.println("geom = " + obj.getGeomRoadSection());
                    this.trafficPainter.addObject(obj.getGeomRoadSection());
                }
            }
        }
        super.setValue(this.value);
        this.zoomToTracks();
    }

    public void updateRoad() {
        if (this.order == null || this.order.getTooList() == null) {
            this.current = null;
            return;
        }
        if (this.current != null && this.current.getId().equals(this.order.getRoad().getId())) {
            return;
        }
        if (this.order != null && this.order.getRoad() != null) {
            this.current = (RoadWAExt)this.proxy.getCurrentObject(InitializedVariable.context, this.order.getRoad().getId());
            RoadList.updateObjectGeom(this.current);
            this.roadpainter.setRoad(this.current);
        }
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.current != null) {
            MultiLineString lineString = this.current.getCurrentLine();
            if (lineString != null) {
                int i = 0;
                while (i < lineString.numPoints()) {
                    double lat = lineString.getPoint(i).getY();
                    double lon = lineString.getPoint(i).getX();
                    if (minLat == null || lat < minLat) {
                        minLat = lat;
                    }
                    if (maxLat == null || lat > maxLat) {
                        maxLat = lat;
                    }
                    if (minLon == null || lon < minLon) {
                        minLon = lon;
                    }
                    if (maxLon == null || lon > maxLon) {
                        maxLon = lon;
                    }
                    ++i;
                }
            } else {
                Geometry g = this.current.getCurrentPolygon();
                if (g != null) {
                    int i = 0;
                    while (i < g.numPoints()) {
                        double lat = g.getPoint(i).getY();
                        double lon = g.getPoint(i).getX();
                        if (minLat == null || lat < minLat) {
                            minLat = lat;
                        }
                        if (maxLat == null || lat > maxLat) {
                            maxLat = lat;
                        }
                        if (minLon == null || lon < minLon) {
                            minLon = lon;
                        }
                        if (maxLon == null || lon > maxLon) {
                            maxLon = lon;
                        }
                        ++i;
                    }
                }
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    public Class getTableCellViewerClass() {
        return CellViewer.class;
    }

    public static class CellViewer<T>
    extends DefaultTableCellViewer<T> {
        public CellViewer(UIFactory<T> factory) {
            super(factory);
        }

        public void setValue(Object object) {
            super.setValue((Object)"---");
        }
    }
}

