/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.test;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.Tile;
import org.jxmapviewer.viewer.TileCache;
import org.jxmapviewer.viewer.TileFactoryInfo;
import org.jxmapviewer.viewer.util.GeoUtil;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.geo.GeoUtils;
import ru.blok.vms.ui.mapviewer.cache.TileCacheFile;
import ru.infor.client.soap.proxy.vms.NDDataWSProxy;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.vms.NDDataSearchCriteria;
import ru.infor.ws.objects.vms.RouteSearchCriteria;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.Route;

public class MapTest {
    SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    NDDataWSProxy proxy = (NDDataWSProxy)CurrentProxyFactory.getProxy(NDData.class);
    RouteWSProxy routeProxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);
    DecimalFormat coordFormat = new DecimalFormat("#0.############");
    final Color trackColor = new Color(255, 0, 0, 150);
    final Color infoColor = new Color(0, 0, 0, 255);
    final Color fillColor = new Color(127, 255, 255, 255);
    final Color vioColor = new Color(255, 50, 100, 150);
    final Font font = new Font("", 1, 9);
    final float[] dash1 = new float[]{1.0f};
    final BasicStroke dashed = new BasicStroke(4.0f, 1, 1, 0.0f, this.dash1, 0.0f);

    public void testMap() {
        System.out.println("--- begin  testMap");
        try {
            ArrayList<Object[]> rez = new ArrayList<Object[]>();
            rez.add(this.createRec(1, "06.01.2011 09:09:53", "\u041e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u0435 \u043e\u0442 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430", "\u041e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u0435 \u043e\u0442 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430", "06.01.2011 09:09:53", 1, 0, 31589601L));
            rez.add(this.createRec(9, "06.01.2011 09:13:49", "\u041e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u0435 \u043e\u0442 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430", "\u041e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u0435 \u043e\u0442 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430", "06.01.2011 09:13:49", 1, 0, 31589717L));
            rez.add(this.createRec(10, "06.01.2011 09:18:26", "\u041e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u0435 \u043e\u0442 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430", "\u041e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u0435 \u043e\u0442 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430", "06.01.2011 09:18:26", 1, 0, 31589875L));
            rez.add(this.createRec(2, "06.01.2011 09:12:40", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430( 25, 93 \u043a\u043c/\u0447)", "06.01.2011 09:13:09", 1, 0, 31589686L));
            rez.add(this.createRec(3, "06.01.2011 09:12:45", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430( 20, 37 \u043a\u043c/\u0447)", null, 0, 0, 31589687L));
            rez.add(this.createRec(4, "06.01.2011 09:12:50", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430( 24, 08 \u043a\u043c/\u0447)", null, 0, 0, 31589688L));
            rez.add(this.createRec(5, "06.01.2011 09:12:56", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430( 24, 08 \u043a\u043c/\u0447)", null, 0, 0, 31589692L));
            rez.add(this.createRec(6, "06.01.2011 09:13:01", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430( 25, 93 \u043a\u043c/\u0447)", null, 0, 0, 31589693L));
            rez.add(this.createRec(7, "06.01.2011 09:13:03", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430( 24, 08 \u043a\u043c/\u0447)", null, 0, 0, 31589695L));
            rez.add(this.createRec(8, "06.01.2011 09:13:09", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430( 20, 37 \u043a\u043c/\u0447)", null, 0, 0, 31589699L));
            Date begDate = this.df.parse("06.01.2011 09:00:00");
            Date endDate = this.df.parse("06.01.2011 09:30:00");
            Long transportId = 23343836L;
            ArrayList<Long> listRouteId = new ArrayList<Long>();
            HashMap<Long, String> mapNDDVio = new HashMap<Long, String>();
            HashMap<Long, Integer> mapIndex = new HashMap<Long, Integer>();
            int i = 0;
            while (i < rez.size()) {
                Object[] re2 = (Object[])rez.get(i);
                Long idR = null;
                try {
                    idR = Long.valueOf((String)re2[11]);
                }
                catch (Exception exception) {}
                if (idR != null && listRouteId.indexOf(idR) < 0) {
                    listRouteId.add(idR);
                }
                Long idNDD = null;
                try {
                    idNDD = Long.valueOf((String)re2[10]);
                }
                catch (Exception exception) {}
                if (idNDD != null && mapNDDVio.get(idNDD) == null) {
                    mapNDDVio.put(idNDD, (String)re2[3]);
                    mapIndex.put(idNDD, i);
                }
                ++i;
            }
            NDDataSearchCriteria scNDD = new NDDataSearchCriteria();
            scNDD.setCount(Integer.valueOf(Integer.MAX_VALUE));
            scNDD.setTransportId(transportId);
            scNDD.setCreatedDateTimeFrom(begDate);
            scNDD.setCreatedDateTimeTill(endDate);
            scNDD.appendSorting(SortObject.getInstance((String)"createdDateTime", (String)SortObject.DIRECTION_ASC));
            NDDataWSProxy.SearchResultListNDData sr = this.proxy.getList(InitializedVariable.context, scNDD);
            HashMap<Long, NDData> mapNDD = new HashMap<Long, NDData>();
            int i2 = 0;
            while (i2 < sr.getObjList().length) {
                NDData ndd = (NDData)sr.getObjList()[i2];
                mapNDD.put(ndd.getId(), ndd);
                ++i2;
            }
            this.savePicture(null, "image.png", listRouteId, mapNDD, mapNDDVio, mapIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Object[] createRec(int i, String dat, String message, String description, String dt_end, int j, int k, Long nddata_id) {
        Object[] re = new Object[]{"\u0418\u041f \u041b\u0435\u0431\u0435\u0434\u0435\u0432", String.valueOf(i), dat, message, "\u043a952\u0443\u043a76", "\u0412\u0435\u043b\u0438\u043a\u0438\u0439 \u0423\u0441\u0442\u044e\u0433 -1", description, dt_end, String.valueOf(j), String.valueOf(k), String.valueOf(nddata_id).trim(), "48136517"};
        return re;
    }

    public String savePicture(TileFactoryInfo info, String fileName, List<Long> listRouteId, HashMap<Long, NDData> mapNDD, HashMap<Long, String> mapNDDVio, HashMap<Long, Integer> mapIndex) throws MalformedURLException {
        if (info == null) {
            info = this.getDefaultInfo();
        }
        DefaultTileFactory tf = new DefaultTileFactory(info);
        tf.setTileCache((TileCache)new TileCacheFile(this.getPathTileCache()));
        int zoom = -1;
        Point2D p1 = null;
        Point2D p2 = null;
        int sizePictureX = 730;
        int sizePictureY = 1024;
        long begin = System.currentTimeMillis();
        Long end = System.currentTimeMillis();
        Double maxLon = Double.MIN_VALUE;
        Double maxLat = Double.MIN_VALUE;
        Double minLon = Double.MAX_VALUE;
        Double minLat = Double.MAX_VALUE;
        for (Long key : mapNDDVio.keySet()) {
            NDData ndd = mapNDD.get(key);
            if (maxLon < ndd.getLon()) {
                maxLon = ndd.getLon();
            }
            if (maxLat < ndd.getLat()) {
                maxLat = ndd.getLat();
            }
            if (minLon > ndd.getLon()) {
                minLon = ndd.getLon();
            }
            if (!(minLat > ndd.getLat())) continue;
            minLat = ndd.getLat();
        }
        int deltaX = 0;
        int deltaY = 0;
        int dxt = 0;
        int dyt = 0;
        long xt = 0L;
        long yt = 0L;
        BufferedImage im = null;
        while (true) {
            p1 = GeoUtil.getBitmapCoordinate((double)maxLat, (double)minLon, (int)(++zoom), (TileFactoryInfo)tf.getInfo());
            p2 = GeoUtil.getBitmapCoordinate((double)minLat, (double)maxLon, (int)zoom, (TileFactoryInfo)tf.getInfo());
            deltaX = (int)Math.abs(p1.getX() - p2.getX());
            deltaY = (int)Math.abs(p1.getY() - p2.getY());
            if (deltaY > sizePictureY || deltaX > sizePictureX) continue;
            xt = Math.round(p1.getX() / (double)tf.getTileSize(zoom)) - 1L;
            yt = Math.round(p1.getY() / (double)tf.getTileSize(zoom)) - 1L;
            dxt = (int)Math.abs(Math.round((p2.getX() - p1.getX()) / (double)tf.getTileSize(zoom) + 0.5)) + 2;
            dyt = (int)Math.abs(Math.round((p2.getY() - p1.getY()) / (double)tf.getTileSize(zoom) + 0.5)) + 2;
            if (dxt * tf.getTileSize(zoom) < sizePictureX) {
                dxt = sizePictureX / tf.getTileSize(zoom) + 2;
            }
            if (dyt * tf.getTileSize(zoom) < sizePictureY) {
                dxt = sizePictureY / tf.getTileSize(zoom) + 2;
            }
            if (sizePictureX * dyt > sizePictureY * dxt) {
                dxt = sizePictureX / sizePictureY * dyt + 3;
            } else {
                dyt = sizePictureY / sizePictureX * dxt + 2;
            }
            if (dxt * tf.getInfo().getTileSize(zoom) * dyt * tf.getInfo().getTileSize(zoom) <= 0x960000) break;
        }
        im = new BufferedImage(dxt * tf.getInfo().getTileSize(zoom), dyt * tf.getInfo().getTileSize(zoom), 1);
        int i = 0;
        while (i < dxt) {
            int j = 0;
            while (j < dyt) {
                Tile tile = tf.getTile((int)xt + i, (int)yt + j, zoom);
                int time = 300;
                while (!tile.isLoaded() && time-- > 0) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (time > 0) {
                    im.getGraphics().drawImage(tile.getImage(), i * tf.getInfo().getTileSize(zoom), j * tf.getInfo().getTileSize(zoom), tf.getInfo().getTileSize(zoom), tf.getInfo().getTileSize(zoom), null);
                }
                ++j;
            }
            ++i;
        }
        Point2D.Double pStart = new Point2D.Double((long)tf.getInfo().getTileSize(zoom) * xt, (long)tf.getInfo().getTileSize(zoom) * yt);
        Graphics2D graph = (Graphics2D)im.getGraphics();
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graph.setRenderingHints(rh);
        String square = "POLYGON ((";
        square = square.concat(this.coordFormat.format(minLon).replaceAll(",", ".")).concat(" ");
        square = square.concat(this.coordFormat.format(minLat).replaceAll(",", ".")).concat(",");
        square = square.concat(this.coordFormat.format(minLon).replaceAll(",", ".")).concat(" ");
        square = square.concat(this.coordFormat.format(maxLat).replaceAll(",", ".")).concat(",");
        square = square.concat(this.coordFormat.format(maxLon).replaceAll(",", ".")).concat(" ");
        square = square.concat(this.coordFormat.format(maxLat).replaceAll(",", ".")).concat(",");
        square = square.concat(this.coordFormat.format(maxLon).replaceAll(",", ".")).concat(" ");
        square = square.concat(this.coordFormat.format(minLat).replaceAll(",", ".")).concat(",");
        square = square.concat(this.coordFormat.format(minLon).replaceAll(",", ".")).concat(" ");
        square = square.concat(this.coordFormat.format(minLat).replaceAll(",", ".")).concat("))");
        System.out.println("--- square =" + square);
        RouteSearchCriteria sc = new RouteSearchCriteria();
        sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        sc.setIdList(listRouteId.toArray(new Long[listRouteId.size()]));
        sc.setListWithAreaRoute(Integer.valueOf(1));
        RouteWSProxy.SearchResultListRoute sr = this.routeProxy.getList(InitializedVariable.context, sc);
        if (sr.isEmpty()) {
            return new File(fileName).getAbsolutePath();
        }
        graph.setColor(this.trackColor);
        graph.setStroke(this.dashed);
        graph.setFont(this.font);
        GeoPosition g1 = null;
        Geometry gSquare = GeoUtils.geometryPG2GT(square);
        int i2 = 0;
        while (i2 < sr.getObjList().length) {
            String geom = ((Route)sr.getObjList()[i2]).getAreaRouteGeom();
            System.out.println(" i=" + i2 + " --- AreaRouteGeom =" + geom);
            if (geom != null && !geom.trim().equals("")) {
                Geometry gGeom = GeoUtils.geometryPG2GT(geom);
                Geometry gInters = gGeom.intersection(gSquare);
                int k = 0;
                while (k < gInters.getDimension()) {
                    System.out.println(" k=" + k);
                    Geometry r = gInters.getGeometryN(k);
                    Coordinate[] cca = r.getCoordinates();
                    if (cca != null && cca.length > 0) {
                        Polygon pp = new Polygon();
                        String ss = "POLYGON ((";
                        int kk = 0;
                        while (kk < cca.length) {
                            ss = ss.concat(this.coordFormat.format(cca[kk].x).replaceAll(",", ".")).concat(" ");
                            ss = ss.concat(this.coordFormat.format(cca[kk].y).replaceAll(",", ".")).concat(",");
                            g1 = new GeoPosition(cca[kk].x, cca[kk].y);
                            p1 = tf.geoToPixel(g1, zoom);
                            pp.addPoint((int)Math.round(p1.getX()) - (int)Math.round(((Point2D)pStart).getX()), (int)Math.round(p1.getY()) - (int)Math.round(((Point2D)pStart).getY()));
                            ++kk;
                        }
                        System.out.println(String.valueOf(ss) + "))");
                        g1 = new GeoPosition(cca[0].x, cca[0].y);
                        p1 = tf.geoToPixel(g1, zoom);
                        pp.addPoint((int)Math.round(p1.getX()) - (int)Math.round(((Point2D)pStart).getX()), (int)Math.round(p1.getY()) - (int)Math.round(((Point2D)pStart).getY()));
                        graph.drawPolygon(pp);
                        GeneralPath path = new GeneralPath(pp);
                        graph.fill(path);
                    }
                    ++k;
                }
            }
            ++i2;
        }
        GeoPosition g2 = null;
        try {
            if (mapNDD != null && mapNDD.size() > 0) {
                graph.setStroke(this.dashed);
                graph.setFont(this.font);
                ArrayList<NDData> idSet = new ArrayList<NDData>(mapNDD.values());
                Collections.sort(idSet, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return ((NDData)o1).getCreatedDateTime().compareTo(((NDData)o2).getCreatedDateTime());
                    }
                });
                int i1 = 0;
                while (i1 < idSet.size()) {
                    g1 = new GeoPosition(((NDData)idSet.get(i1)).getLat().doubleValue(), ((NDData)idSet.get(i1)).getLon().doubleValue());
                    p1 = tf.geoToPixel(g1, zoom);
                    if (i1 < idSet.size() - 1) {
                        NDData ndd = (NDData)idSet.get(i1 + 1);
                        g2 = new GeoPosition(ndd.getLat().doubleValue(), ndd.getLon().doubleValue());
                        p2 = tf.geoToPixel(g2, zoom);
                        graph.setColor(this.trackColor);
                        if (mapNDDVio.get(ndd.getId()) != null) {
                            Integer ind = mapIndex.get(ndd.getId());
                            if (ind != null) {
                                graph.setColor(this.infoColor);
                                graph.drawString(String.valueOf(ind).trim(), (int)Math.round(p2.getX()) - (int)Math.round(((Point2D)pStart).getX()) - 3, (int)Math.round(p2.getY()) - (int)Math.round(((Point2D)pStart).getY()) + 3);
                            }
                            graph.setColor(this.vioColor);
                        }
                        graph.drawLine((int)Math.round(p1.getX()) - (int)Math.round(((Point2D)pStart).getX()), (int)Math.round(p1.getY()) - (int)Math.round(((Point2D)pStart).getY()), (int)Math.round(p2.getX()) - (int)Math.round(((Point2D)pStart).getX()), (int)Math.round(p2.getY()) - (int)Math.round(((Point2D)pStart).getY()));
                    }
                    ++i1;
                }
            }
            begin = System.currentTimeMillis();
            this.endProcessingImage(fileName, tf, zoom, sizePictureX, sizePictureY, minLon, maxLat, deltaX, deltaY, xt, yt, im);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        end = System.currentTimeMillis();
        System.out.println("savePicture end..... " + (end - begin) + " ms   fileName=" + new File(fileName).getAbsolutePath());
        return new File(fileName).getAbsolutePath();
    }

    public void endProcessingImage(String fileName, DefaultTileFactory tf, int zoom, int sizePictureX, int sizePictureY, Double minLon, Double maxLat, int deltaX, int deltaY, long xt, long yt, BufferedImage im) {
        BufferedImage im2 = new BufferedImage(sizePictureX, sizePictureY, 1);
        Point2D.Double pStart = new Point2D.Double((long)tf.getInfo().getTileSize(zoom) * xt, (long)tf.getInfo().getTileSize(zoom) * yt);
        GeoPosition g1 = new GeoPosition(maxLat.doubleValue(), minLon.doubleValue());
        Point2D p1 = tf.geoToPixel(g1, zoom);
        int pX = (int)Math.round(p1.getX()) - (int)Math.round(((Point2D)pStart).getX()) - (im2.getWidth() - deltaX) / 2;
        int pY = (int)Math.round(p1.getY()) - (int)Math.round(((Point2D)pStart).getY()) - (im2.getHeight() - deltaY) / 2;
        if (pX < 0) {
            pX = 0;
        }
        if (pY < 0) {
            pY = 0;
        }
        if (pX + im2.getWidth() > im.getWidth()) {
            pX = im.getWidth() - im2.getWidth();
        }
        if (pY + im2.getHeight() > im.getHeight()) {
            pY = im.getHeight() - im2.getHeight();
        }
        if (pX < 0) {
            pX = 0;
        }
        if (pY < 0) {
            pY = 0;
        }
        im2.getGraphics().drawImage(im, 0, 0, sizePictureX, sizePictureY, pX, pY, pX + sizePictureX, pY + sizePictureY, null);
        try {
            ImageIO.write((RenderedImage)im2, "png", new File(fileName));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error create file: " + e.getMessage());
        }
    }

    private String getPathTileCache() {
        return "";
    }

    public TileFactoryInfo getDefaultInfo() {
        TileFactoryInfo info = new TileFactoryInfo(0, 16, 18, 256, true, true, "http://tile.openstreetmap.org", "x", "y", "z"){

            public String getTileUrl(int x, int y, int zoom) {
                zoom = 18 - zoom;
                String url = String.valueOf(this.baseURL) + "/" + zoom + "/" + x + "/" + y + ".png";
                return url;
            }
        };
        return info;
    }
}

