/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.test;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.awt.geom.Point2D;
import org.geotools.referencing.GeodeticCalculator;

public class TestCalcPoint {
    static GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);

    public static void main(String[] args) {
        Double lon = 38.692897731406;
        Double lat = 58.089596702174;
        System.out.println("POINT(" + lon + " " + lat + ")");
        Point st = geometryFactory.createPoint(new Coordinate(lon.doubleValue(), lat.doubleValue()));
        Point fi = TestCalcPoint.farthestPoint(st, 20.0, 90.0);
        System.out.println("POINT(" + fi.getX() + " " + fi.getY() + ")");
    }

    private static Point farthestPoint(Point point, double meters, double azimuth) {
        GeodeticCalculator calc = new GeodeticCalculator();
        calc.setStartingGeographicPoint(point.getX(), point.getY());
        calc.setDirection(azimuth, meters);
        Point2D dest2D = calc.getDestinationGeographicPoint();
        if (dest2D.getX() < point.getX()) {
            calc.setDirection(-azimuth, meters);
            dest2D = calc.getDestinationGeographicPoint();
        }
        return point.getFactory().createPoint(new Coordinate(dest2D.getX(), dest2D.getY()));
    }
}

