/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.test;

import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.report.RunReport;
import ru.blok.vms.core.ResourceStrings;
import ru.blok.vms.ui.WindowMessageFactory;
import ru.blok.vms.ui.test.MapTest;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WindowMessage;
import ru.infor.beanviewer.swing.viewers.ListActionViewer;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.core.UIModuleWSProxy;
import ru.infor.client.soap.proxy.core.WorkPlaceWSProxy;
import ru.infor.client.soap.proxy.vms.NDDataWSProxy;
import ru.infor.client.soap.proxy.vms.RecordTypeWSProxy;
import ru.infor.client.soap.proxy.vms.WatchAreaTypeWSProxy;
import ru.infor.websocket.client.SocketClientFactory;
import ru.infor.websocket.transport.SubscribingOptions;
import ru.infor.ws.business.vms.websocket.NDDataSocketIntf;
import ru.infor.ws.business.vms.websocket.objects.SubscribingOptions_SendListNDData;
import ru.infor.ws.objects.core.DirectoriesSearchCriteria;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.core.UseModulesSearchCriteria;
import ru.infor.ws.objects.core.entities.UIModule;
import ru.infor.ws.objects.core.entities.WorkPlace;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.RecordType;
import ru.infor.ws.objects.vms.entities.WatchAreaType;

@ListView(views={@View(title="Test Window Common", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class TestWindowCommon {
    List<BeanViewerAction<ViewerContext>> listEasyBt = new ArrayList<BeanViewerAction<ViewerContext>>();
    RunReport brRep;
    NDDataWSProxy nddataProxy = (NDDataWSProxy)CurrentProxyFactory.getProxy(NDData.class);
    WorkPlaceWSProxy proxy = (WorkPlaceWSProxy)CurrentProxyFactory.getProxy(WorkPlace.class);
    RecordTypeWSProxy proxyRT = (RecordTypeWSProxy)CurrentProxyFactory.getProxy(RecordType.class);
    RecordType recordType;
    SimpleDateFormat dfSource = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    List<NDData> listN1 = new ArrayList<NDData>();
    List<NDData> listN2 = new ArrayList<NDData>();
    List<NDData> listN3 = new ArrayList<NDData>();
    Long delta1;
    Long delta2;
    Long delta3;
    long zoom = 1L;
    BeanViewerAction<ViewerContext> btCreateImage = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            ((PanelContext)TestWindowCommon.this.getCurrentContext().getParentContext()).getPanel().updateMainObject();
            MapTest mapTest = new MapTest();
            mapTest.testMap();
        }

        public String getHint() {
            return "\u0422\u0435\u0441\u0442 create ";
        }

        public String getIcon() {
            return ResourceStrings.btIndex1;
        }
    };
    public int cnt = 0;
    BeanViewerAction<ViewerContext> btWindowMessage = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            ((PanelContext)TestWindowCommon.this.getCurrentContext().getParentContext()).getPanel().updateMainObject();
            WindowMessage windowMessage = null;
            ++TestWindowCommon.this.cnt;
            if (TestWindowCommon.this.cnt % 5 == 1) {
                windowMessage = new WindowMessageFactory.WinDanger();
            }
            if (TestWindowCommon.this.cnt % 5 == 2) {
                windowMessage = new WindowMessageFactory.WinWarning();
            }
            if (TestWindowCommon.this.cnt % 5 == 3) {
                windowMessage = new WindowMessageFactory.WinError();
            }
            if (TestWindowCommon.this.cnt % 5 == 4) {
                windowMessage = new WindowMessageFactory.WinInfo();
            }
            if (TestWindowCommon.this.cnt % 5 == 0) {
                windowMessage = new WindowMessageFactory.WinHelp();
            }
            windowMessage.setTitle("\u041e\u043a\u043d\u043e " + String.valueOf(TestWindowCommon.this.cnt));
            InitializedVariable.factory.runWindow(windowMessage, "key" + String.valueOf(TestWindowCommon.this.cnt), new BeanViewerAction[]{new MessageOKButton()});
        }

        public String getHint() {
            return "\u0422\u0435\u0441\u0442 WindowMessage";
        }

        public String getIcon() {
            return ResourceStrings.btInfo;
        }
    };
    private BeanViewerAction<ViewerContext> testStyles = new BeanViewerAction<ViewerContext>(){

        public String getName() {
            return "\u0422\u0435\u0441\u0442 \u0441\u0442\u0438\u043b\u0435\u0439";
        }

        public void actionPerformed(Object message) {
            JFrame f = new JFrame("Styles Example 2");
            StyleContext sc = new StyleContext();
            DefaultStyledDocument doc = new DefaultStyledDocument(sc);
            JTextPane pane = new JTextPane(doc);
            Style defaultStyle = sc.getStyle("default");
            Style mainStyle = sc.addStyle("MainStyle", defaultStyle);
            StyleConstants.setLeftIndent(mainStyle, 16.0f);
            StyleConstants.setRightIndent(mainStyle, 16.0f);
            StyleConstants.setFirstLineIndent(mainStyle, 16.0f);
            StyleConstants.setFontFamily(mainStyle, "serif");
            StyleConstants.setFontSize(mainStyle, 12);
            Style cwStyle = sc.addStyle("ConstantWidth", null);
            StyleConstants.setFontFamily(cwStyle, "monospaced");
            StyleConstants.setForeground(cwStyle, Color.green);
            Style cwStyle2 = sc.addStyle("ConstantWidth", null);
            StyleConstants.setFontFamily(cwStyle2, "monospaced");
            StyleConstants.setForeground(cwStyle2, Color.blue);
            Style heading2Style = sc.addStyle("Heading2", null);
            StyleConstants.setForeground(heading2Style, Color.red);
            StyleConstants.setFontSize(heading2Style, 16);
            StyleConstants.setFontFamily(heading2Style, "serif");
            StyleConstants.setBold(heading2Style, true);
            StyleConstants.setLeftIndent(heading2Style, 8.0f);
            StyleConstants.setFirstLineIndent(heading2Style, 0.0f);
            try {
                doc.setLogicalStyle(0, mainStyle);
                doc.insertString(0, TestWindowCommon.text, null);
                doc.setCharacterAttributes(49, 13, cwStyle, false);
                doc.setCharacterAttributes(223, 14, cwStyle2, false);
                doc.setCharacterAttributes(249, 14, cwStyle, false);
                doc.setCharacterAttributes(286, 8, cwStyle2, false);
                doc.setCharacterAttributes(475, 14, cwStyle, false);
                doc.setCharacterAttributes(497, 21, cwStyle2, false);
                doc.setCharacterAttributes(557, 9, cwStyle, false);
                doc.setCharacterAttributes(639, 12, cwStyle2, false);
                doc.setCharacterAttributes(733, 21, cwStyle, false);
                doc.setCharacterAttributes(759, 9, cwStyle2, false);
                doc.setParagraphAttributes(0, 1, heading2Style, false);
            }
            catch (BadLocationException badLocationException) {}
            f.getContentPane().add(new JScrollPane(pane));
            f.setSize(400, 300);
            f.setVisible(true);
        }
    };
    BeanViewerAction<ViewerContext> btChangeUser = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
        }

        public String getHint() {
            return "btChangeUser";
        }

        public String getIcon() {
            return ResourceStrings.btChangeGo;
        }
    };
    public static final String text = "Attributes, Styles and Style Contexts\nThe simple PlainDocument class that you saw in the previous chapter is only capable of holding text. The more complex text components use a more sophisticated model that implements the StyledDocument interface. StyledDocument is a sub-interface of Document that contains methods for manipulating attributes that control the way in which the text in the document is displayed. The Swing text package contains a concrete implementation of StyledDocument called DefaultStyledDocument that is used as the default model for JTextPane and is also the base class from which more specific models, such as the HTMLDocument class that handles input in HTML format, can be created. In order to make use of DefaultStyledDocument and JTextPane, you need to understand how Swing represents and uses attributes.\n";
    BeanViewerAction<ViewerContext> btCreateMenu = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            ((PanelContext)TestWindowCommon.this.getCurrentContext().getParentContext()).getPanel().updateMainObject();
            UIModuleWSProxy proxyUIM = (UIModuleWSProxy)CurrentProxyFactory.getProxy(UIModule.class);
            UseModulesSearchCriteria sc = new UseModulesSearchCriteria();
            sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
            sc.setType(Integer.valueOf(0));
            sc.appendSorting(SortObject.getInstance((String)"name", (String)SortObject.DIRECTION_ASC));
            UIModuleWSProxy.SearchResultListUIModule sr = proxyUIM.getModules(InitializedVariable.context, sc);
            UIModule ui = null;
            Long topId = 46344234L;
            int nu_ = 1;
            String nu = "01";
            WorkPlaceWSProxy proxy = (WorkPlaceWSProxy)CurrentProxyFactory.getProxy(WorkPlace.class);
            WorkPlace wp = proxy.save(InitializedVariable.context, this.createWP(ui, topId, "test_" + nu, 0));
            Long parentId = wp.getId();
            int num = 0;
            int i = 0;
            while (i < sr.getObjList().length) {
                UIModule uim = (UIModule)sr.getObjList()[i];
                if (++num > 25) {
                    num = 1;
                    wp = proxy.save(InitializedVariable.context, this.createWP(ui, topId, "test_" + (++nu_ < 10 ? "0".concat(String.valueOf(nu_).trim()) : String.valueOf(nu_).trim()), 0));
                    parentId = wp.getId();
                }
                wp = proxy.save(InitializedVariable.context, this.createWP(uim, parentId, uim.getName(), num * 10));
                ++i;
            }
        }

        private WorkPlace createWP(UIModule parent, Long topId, String title, Integer index) {
            WorkPlace wp = new WorkPlace();
            wp.setTitle(title);
            wp.setOwner_id(topId);
            wp.setOrderIndex(index);
            wp.setModule(parent);
            wp.setOneWindow(Integer.valueOf(0));
            wp.setSeparateWindow(Integer.valueOf(0));
            return wp;
        }

        public String getHint() {
            return "btCreateMenu";
        }

        public String getIcon() {
            return ResourceStrings.btAddMap;
        }
    };
    BeanViewerAction<ViewerContext> btLoadAllList = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            ((PanelContext)TestWindowCommon.this.getCurrentContext().getParentContext()).getPanel().updateMainObject();
            WatchAreaTypeWSProxy cfr_ignored_0 = (WatchAreaTypeWSProxy)CurrentProxyFactory.getProxy(WatchAreaType.class);
            System.out.println("");
        }

        public String getHint() {
            return "btLoadAllList";
        }

        public String getIcon() {
            return ResourceStrings.btAddStation;
        }
    };
    BeanViewerAction<ViewerContext> btSubscrib = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            try {
                SubscribingOptions_SendListNDData options = new SubscribingOptions_SendListNDData();
                options.setContext(InitializedVariable.context);
                options.setServiceName("NDDataWS");
                options.setMethodName("sendList");
                options.setDeviceIdList(Arrays.asList(49376753L, 49376754L, 49376739L, 49376740L, 48166115L, 48166151L, 48146081L, 48166136L, 48166128L));
                String sid = SocketClientFactory.subscribe((Object)new NDDataListener1(), (SubscribingOptions)options);
                System.out.println("session ID (new): " + sid);
                Thread.sleep(3000000L);
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
            }
        }

        public String getHint() {
            return "btSubscrib";
        }

        public String getIcon() {
            return ResourceStrings.btMailGet;
        }
    };
    BeanViewerAction<ViewerContext> btRunData = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            ((PanelContext)TestWindowCommon.this.getCurrentContext().getParentContext()).getPanel().updateMainObject();
            TestWindowCommon.this.runShow1();
            TestWindowCommon.this.runShow2();
            TestWindowCommon.this.runShow3();
        }

        public String getHint() {
            return "\u041f\u0443\u0441\u043a \u0434\u0430\u043d\u043d\u044b\u0445";
        }

        public String getIcon() {
            return ResourceStrings.imgTargetNo;
        }
    };

    public TestWindowCommon() {
        this.brRep = new RunReport();
        this.addListEasyBt(this.btChangeUser);
        this.addListEasyBt(this.btCreateImage);
        this.addListEasyBt(this.btWindowMessage);
        this.addListEasyBt(this.btCreateMenu);
        this.addListEasyBt(this.btRunData);
        this.addListEasyBt(this.btLoadAllList);
        this.addListEasyBt(this.btSubscrib);
        DirectoriesSearchCriteria dSC = new DirectoriesSearchCriteria();
        dSC.setDescription("*\u043f\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438*");
        RecordTypeWSProxy.SearchResultListRecordType dSR = this.proxyRT.getList(InitializedVariable.context, dSC);
        this.recordType = (RecordType)dSR.getObjList()[0];
        String dat1 = "2014-11-20 09:43:27";
        String dat2 = "2014-11-20 09:49:20";
        String dat3 = "2014-11-20 08:59:55";
        Calendar calCur = Calendar.getInstance();
        calCur.setTime(new Date());
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(this.dfSource.parse(dat1));
            cal.set(1, calCur.get(1));
            cal.set(2, calCur.get(2));
            cal.set(5, calCur.get(5));
            this.delta1 = calCur.getTime().getTime() - cal.getTime().getTime();
            cal.setTime(this.dfSource.parse(dat2));
            cal.set(1, calCur.get(1));
            cal.set(2, calCur.get(2));
            cal.set(5, calCur.get(5));
            this.delta2 = calCur.getTime().getTime() - cal.getTime().getTime();
            cal.setTime(this.dfSource.parse(dat3));
            cal.set(1, calCur.get(1));
            cal.set(2, calCur.get(2));
            cal.set(5, calCur.get(5));
            this.delta3 = calCur.getTime().getTime() - cal.getTime().getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private List<NDData> getData(long newId, String name, int npp) {
        ArrayList<NDData> listN = new ArrayList<NDData>();
        File fileName = new File(name);
        String line = null;
        try {
            FileInputStream is = new FileInputStream(fileName);
            BufferedReader fr = new BufferedReader(new InputStreamReader(is));
            while ((line = fr.readLine()) != null) {
                String[] dd = line.split(";");
                NDData n = new NDData();
                n.setId(null);
                n.setDeviceId(Long.valueOf(newId));
                n.setCreatedDateTime(this.dfSource.parse(dd[1]));
                n.setSpeed(Double.valueOf(dd[2]));
                n.setLon(Double.valueOf(dd[3]));
                n.setLat(Double.valueOf(dd[4]));
                n.setTripIndex(Integer.valueOf(npp));
                n.setType(this.recordType);
                listN.add(n);
                if (line != null) continue;
                break;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return listN;
    }

    @ListField(fields={@Field(title="", order=170, propertiesLayout="Split1/h/l/0.25:6", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getbtCalcToHouse() {
        return this.brRep;
    }

    private ViewerContext getCurrentContext() {
        return (ViewerContext)this.brRep.getContext();
    }

    @ListField(fields={@Field(title="", propertiesUI={"onlyOnePressed=false"}, order=40, propertiesLayout="Split1/h/l/0.25:1", viewer={ListActionViewer.class})})
    public List<BeanViewerAction<ViewerContext>> getListEasyBt() {
        return this.listEasyBt;
    }

    public void addListEasyBt(BeanViewerAction<ViewerContext> newA) {
        this.listEasyBt.add(newA);
    }

    @ListField(fields={@Field(title="", order=50, propertiesLayout="Split1/h/l/0.25:1", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getTestStyles() {
        return this.testStyles;
    }

    public Double getAngle(NDData prev, NDData last) {
        Double angle = null;
        Double len = Math.sqrt((last.getLon() - prev.getLon()) * (last.getLon() - prev.getLon()) + (last.getLat() - prev.getLat()) * (last.getLat() - prev.getLat()));
        if (len > 1.0E-10) {
            angle = Math.asin((last.getLat() - prev.getLat()) / len);
            angle = 90.0 - 180.0 * angle / Math.PI;
            if (last.getLon() - prev.getLon() > 0.0) {
                angle = 360.0 - angle;
            }
            angle = 360.0 - angle;
        }
        return angle;
    }

    public void runShow1() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Long tt = TestWindowCommon.this.listN1.get(0).getCreatedDateTime().getTime() + TestWindowCommon.this.delta1;
                while (true) {
                    try {
                        block5: while (true) {
                            int l = 0;
                            while (true) {
                                if (l >= TestWindowCommon.this.listN1.size()) continue block5;
                                NDData ndd = TestWindowCommon.this.listN1.get(l);
                                if (l > 0) {
                                    ndd.setDirection(TestWindowCommon.this.getAngle(ndd, TestWindowCommon.this.listN1.get(l - 1)));
                                }
                                ndd.setCreatedDateTime(new Date(ndd.getCreatedDateTime().getTime() + TestWindowCommon.this.delta1));
                                TestWindowCommon.this.nddataProxy.saveList(InitializedVariable.context, new NDData[]{ndd});
                                System.out.println("save " + ndd);
                                try {
                                    Thread.sleep(Math.round(1.0 * (double)(ndd.getCreatedDateTime().getTime() - tt) / (double)TestWindowCommon.this.zoom));
                                }
                                catch (InterruptedException interruptedException) {}
                                tt = ndd.getCreatedDateTime().getTime();
                                ++l;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    public void runShow2() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Long tt = TestWindowCommon.this.listN2.get(0).getCreatedDateTime().getTime() + TestWindowCommon.this.delta2;
                while (true) {
                    try {
                        block5: while (true) {
                            int l = 0;
                            while (true) {
                                if (l >= TestWindowCommon.this.listN2.size()) continue block5;
                                NDData ndd = TestWindowCommon.this.listN2.get(l);
                                if (l > 0) {
                                    ndd.setDirection(TestWindowCommon.this.getAngle(ndd, TestWindowCommon.this.listN1.get(l - 1)));
                                }
                                ndd.setCreatedDateTime(new Date(ndd.getCreatedDateTime().getTime() + TestWindowCommon.this.delta2));
                                TestWindowCommon.this.nddataProxy.saveList(InitializedVariable.context, new NDData[]{ndd});
                                System.out.println("save " + ndd);
                                try {
                                    Thread.sleep(Math.round(1.0 * (double)(ndd.getCreatedDateTime().getTime() - tt) / (double)TestWindowCommon.this.zoom));
                                }
                                catch (InterruptedException interruptedException) {}
                                tt = ndd.getCreatedDateTime().getTime();
                                ++l;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    public void runShow3() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Long tt = TestWindowCommon.this.listN3.get(0).getCreatedDateTime().getTime() + TestWindowCommon.this.delta3;
                while (true) {
                    try {
                        block5: while (true) {
                            int l = 0;
                            while (true) {
                                if (l >= TestWindowCommon.this.listN3.size()) continue block5;
                                NDData ndd = TestWindowCommon.this.listN3.get(l);
                                if (l > 0) {
                                    ndd.setDirection(TestWindowCommon.this.getAngle(ndd, TestWindowCommon.this.listN1.get(l - 1)));
                                }
                                ndd.setCreatedDateTime(new Date(ndd.getCreatedDateTime().getTime() + TestWindowCommon.this.delta3));
                                TestWindowCommon.this.nddataProxy.saveList(InitializedVariable.context, new NDData[]{ndd});
                                System.out.println("save " + ndd);
                                try {
                                    Thread.sleep(Math.round(1.0 * (double)(ndd.getCreatedDateTime().getTime() - tt) / (double)TestWindowCommon.this.zoom));
                                }
                                catch (InterruptedException interruptedException) {}
                                tt = ndd.getCreatedDateTime().getTime();
                                ++l;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    public class NDDataListener1
    implements NDDataSocketIntf {
        public void sendList(List<NDData> datas) {
            Collections.sort(datas, (Comparator)new Comparator<NDData>(){

                @Override
                public int compare(NDData o1, NDData o2) {
                    return o1.getCreatedDateTime().compareTo(o2.getCreatedDateTime());
                }
            });
            System.out.println("datas.size()== " + datas.size());
            for (NDData n : datas) {
                System.out.println("=> " + n.getDeviceId() + " - " + df.format(n.getCreatedDateTime()));
            }
        }
    }
}

