/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.timetableoutput;

import java.text.SimpleDateFormat;
import java.util.logging.Logger;
import ru.blok.common.ui.directories.FRCAsyncDirectoryViewer;
import ru.blok.common.ui.list.ObjectUIList;
import ru.blok.vms.ui.timetableoutput.TimetableOutputList;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.simple.ExtendedDirectoryViewer;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.vms.entities.TimetableOutput;

public class TimetableOutputDirectoryViewer<T>
extends FRCAsyncDirectoryViewer<T> {
    TimetableOutputList list;

    public Class getTableCellViewerClass() {
        return TimetableOutputDirectoryCellViewer.class;
    }

    public TimetableOutputDirectoryViewer(UIFactory<T> factory) {
        super(factory);
    }

    public void setContentClass(Class<?> cls) {
        super.setContentClass(TimetableOutput.class);
    }

    public String objectToString(Object o) {
        if (o == null) {
            return super.objectToString(o);
        }
        return TimetableOutputDirectoryViewer.getIdentifier((TimetableOutput)o);
    }

    private static String getIdentifier(TimetableOutput tto) {
        String rez = "";
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        if (tto.getRoute() != null) {
            rez = rez.concat(tto.getRoute().getNum()).concat(" - ( ");
        }
        if (tto.getOutputOnRoute() != null) {
            rez = rez.concat(df.format(tto.getOutputOnRoute())).concat(" - ");
        }
        if (tto.getReturnWithRoute() != null) {
            rez = rez.concat(df.format(tto.getReturnWithRoute())).concat(" )");
        }
        return rez;
    }

    public void buttonActionPerfomed() {
        try {
            if (this.list == null) {
                this.list = new TimetableOutputList(this.getViewerContext().getKeyPage());
            }
            this.getFactory().newPage(TimetableOutput.class, TimetableOutputList.class, (Object)this.list, this.getViewerContext(), "filterInList");
            Object o = this.getValue();
            ((ObjectUIList)this.list.getItems()).setSelection(o);
        }
        catch (Exception exception) {
            Logger.getLogger(ExtendedDirectoryViewer.class.getName()).severe("Can't create directory presentation " + this.getPresentationClass().getName());
        }
    }

    public CommonSearchCriteria updateSearchCriteria(CommonSearchCriteria sc, String value) {
        return sc;
    }

    public static class TimetableOutputDirectoryCellViewer<T>
    extends DefaultTableCellViewer<T> {
        public TimetableOutputDirectoryCellViewer(UIFactory<T> factory) {
            super(factory);
        }

        public void setValue(Object object) {
            super.setValue((Object)(object == null ? "" : TimetableOutputDirectoryViewer.getIdentifier((TimetableOutput)object)));
        }
    }
}

