/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PlotEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.DateRange;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.VerticalAlignment;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.pointsui.viewers.Utils;
import ru.blok.vms.ui.tracks.TrackAll;
import ru.blok.vms.ui.tracks.TrackAllWithPeriods;
import ru.blok.vms.ui.tracks.parameterdevice.Parameter;
import ru.blok.vms.ui.tracks.parameterdevice.ParameterViewer;
import ru.infor.beanviewer.core.ChartPanel;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.vms.DeviceParameterCalibrationWSProxy;
import ru.infor.client.soap.proxy.vms.DeviceParameterNamesWSProxy;
import ru.infor.common.BeanCopierGenerator;
import ru.infor.ws.objects.core.DirectoriesSearchCriteria;
import ru.infor.ws.objects.vms.DeviceParameterCalibrationSearchCriteria;
import ru.infor.ws.objects.vms.entities.CalibrationItem;
import ru.infor.ws.objects.vms.entities.DeviceParameterCalibration;
import ru.infor.ws.objects.vms.entities.DeviceParameterNames;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.Transport;

public class GraphicsViewer<T>
extends FieldViewer<T>
implements SwingItem {
    static SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    DeviceParameterNamesWSProxy deviceParameterNamesWSProxy = (DeviceParameterNamesWSProxy)CurrentProxyFactory.getProxy(DeviceParameterNames.class);
    HashMap<String, DeviceParameterCalibration> map = new HashMap();
    static Double CHANGE_FUEL = 8.0;
    static int HIGH_PASS_FILTER_COUNT = 20;
    Double minFueling;
    static int CHANGE_FUEL_PERIOD = 40000;
    static int HIGH_CHANGE_FUEL_PERIOD = 0x6DDD00;
    long minChangeFuelPeriod;
    long maxChangeFuelPeriod;
    static Long per = 1200000L;
    Double minSpeed = 5.4;
    static Double MAX_DIFF = 1.0;
    String fuelMessage = "";
    Double fuel;
    Long workTime;
    private T panel;
    ChartPanel chartPanel;
    public static Stroke defaultStroke = new BasicStroke(1.5f, 1, 1);
    private List<Parameter> parameters;
    private List<Parameter> parametersAll;
    private List<NDData> datasTemp;
    private List<NDData> datas;

    public GraphicsViewer(UIFactory<T> factory) {
        super(factory);
        this.panel = factory.getAugmentPanel();
    }

    public int getShape() {
        return 1;
    }

    public T getComponent(boolean isSelected, boolean hasFocus) {
        return this.panel;
    }

    private JFreeChart createChart(List<TimeSeriesCollection> datasets) {
        XYPlot plot = new XYPlot();
        int i = 0;
        for (TimeSeriesCollection ds : datasets) {
            NumberAxis va = new NumberAxis(this.parameters.get(i).getName());
            if (this.parameters.get(i).getAn() == 0) {
                va.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            }
            plot.setDataset(i, (XYDataset)ds);
            plot.setRangeAxis(i, (ValueAxis)va);
            plot.mapDatasetToRangeAxis(i, i);
            StandardXYItemRenderer r = new StandardXYItemRenderer();
            r.setSeriesPaint(0, this.getColorParameter(this.parameters.get(i).getName()));
            plot.setRenderer(i, (XYItemRenderer)r);
            ++i;
        }
        plot.setDomainAxis((ValueAxis)new DateAxis("\u0412\u0440\u0435\u043c\u044f"));
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.getLegend().setPosition(RectangleEdge.RIGHT);
        chart.getLegend().setVerticalAlignment(VerticalAlignment.TOP);
        return chart;
    }

    private JFreeChart createChartToSave(List<TimeSeriesCollection> datasets) {
        XYPlot plot = new XYPlot();
        int i = 0;
        for (TimeSeriesCollection ds : datasets) {
            NumberAxis va = new NumberAxis(this.parameters.get(i).getName());
            if (this.parameters.get(i).getAn() == 0) {
                va.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            }
            plot.setDataset(i, (XYDataset)ds);
            plot.setRangeAxis(i, (ValueAxis)va);
            plot.mapDatasetToRangeAxis(i, i);
            StandardXYItemRenderer r = new StandardXYItemRenderer();
            r.setSeriesPaint(0, this.getColorParameter(this.parameters.get(i).getName()));
            plot.setRenderer(i, (XYItemRenderer)r);
            ++i;
        }
        plot.setDomainAxis((ValueAxis)new DateAxis("\u0412\u0440\u0435\u043c\u044f"));
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.getLegend().setPosition(RectangleEdge.TOP);
        chart.getLegend().setVerticalAlignment(VerticalAlignment.TOP);
        return chart;
    }

    private void init() {
        block80: {
            Transport transport = ((TrackAll)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject())).getTransport();
            this.minFueling = ((TrackAll)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject())).getMinLitersForFueling();
            if (transport != null && transport.getMinimumLitersForFueling() != null) {
                this.minFueling = transport.getMinimumLitersForFueling();
            }
            if (this.minFueling.compareTo(1.0) < 0) {
                this.minFueling = CHANGE_FUEL;
            }
            this.minChangeFuelPeriod = ((TrackAll)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject())).getMinChangeFuelPeriod();
            if (this.minChangeFuelPeriod < 1000L) {
                this.minChangeFuelPeriod = CHANGE_FUEL_PERIOD;
            }
            this.maxChangeFuelPeriod = ((TrackAll)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject())).getMaxChangeFuelPeriod();
            if (this.maxChangeFuelPeriod < 10000L) {
                this.maxChangeFuelPeriod = HIGH_CHANGE_FUEL_PERIOD;
            }
            this.map.clear();
            if (transport != null && transport.getId() != null) {
                DeviceParameterCalibrationWSProxy calibrationWSProxy = (DeviceParameterCalibrationWSProxy)CurrentProxyFactory.getProxy(DeviceParameterCalibration.class);
                DeviceParameterCalibrationSearchCriteria deviceCalibrSc = new DeviceParameterCalibrationSearchCriteria();
                deviceCalibrSc.setTransportIdList(new Long[]{transport.getId()});
                deviceCalibrSc.setActiveOnDate(((TrackAll)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject())).getDateFrom());
                DeviceParameterCalibrationWSProxy.SearchResultListDeviceParameterCalibration sr = calibrationWSProxy.getList(InitializedVariable.context, deviceCalibrSc);
                if (!sr.isEmpty()) {
                    int i = 0;
                    while (i < sr.getObjList().length) {
                        DeviceParameterCalibration dpc = (DeviceParameterCalibration)sr.getObjList()[i];
                        String namePar = (dpc = calibrationWSProxy.getCurrentObject(InitializedVariable.context, dpc.getId())).getParameterNames().getDescription().trim();
                        if (namePar.toLowerCase().indexOf(ParameterViewer.FUEL_NAME.toLowerCase()) > -1) {
                            namePar = String.valueOf(namePar) + " (" + String.valueOf(dpc.getIndexField() == null ? 1 : dpc.getIndexField()) + ")";
                        }
                        this.map.put(namePar, dpc);
                        ++i;
                    }
                }
            }
            this.getFactory().clearContainer(this.panel);
            ArrayList<TimeSeriesCollection> cc = new ArrayList<TimeSeriesCollection>();
            HashMap<Integer, XYBarRenderer> renders = new HashMap<Integer, XYBarRenderer>();
            this.fuelMessage = "";
            this.fuel = null;
            if (this.parameters == null || this.datas.size() <= 0) break block80;
            this.datasTemp = new ArrayList<NDData>(this.datas.size());
            int i = 0;
            while (i < this.datas.size()) {
                NDData ndd = new NDData();
                BeanCopierGenerator.getInstance(NDData.class, (boolean)false).copy((Object)this.datas.get(i), (Object)ndd, null);
                this.datasTemp.add(i, ndd);
                ++i;
            }
            for (Parameter parameter : this.parameters) {
                TimeSeries ds;
                TimeSeriesCollection tsc;
                block81: {
                    if (parameter == null) continue;
                    String name = parameter.getName();
                    tsc = new TimeSeriesCollection();
                    ds = new TimeSeries((Comparable)((Object)name));
                    CalibrationItem[] cabI = this.getCalibrationItemsForName(name);
                    if (name.toLowerCase().indexOf(ParameterViewer.FUEL_NAME.toLowerCase()) > -1) {
                        Double sumF = this.calculationFuel(parameter, name, cabI);
                        this.workTime = null;
                        if (this.map.get(name.trim()) != null && Integer.valueOf(1).equals(this.map.get(name.trim()).getFlagLitersPerHour())) {
                            this.minSpeed = ((TrackAll)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject())).getMinSpeed();
                            this.workTime = this.calcTimeLitersPerHour(this.datasTemp);
                        }
                        if (this.map.get(name.trim()) != null && Integer.valueOf(1).equals(this.map.get(name.trim()).getInCalculation())) {
                            for (Parameter parameter2 : this.parametersAll) {
                                String name_;
                                if (parameter2 == null || (name_ = parameter2.getName()).toLowerCase().indexOf(ParameterViewer.FUEL_NAME.toLowerCase()) <= -1 || name_.equalsIgnoreCase(name) || this.map.get(name_.trim()) == null || !Integer.valueOf(1).equals(this.map.get(name_.trim()).getInCalculation())) continue;
                                CalibrationItem[] cabI_ = this.getCalibrationItemsForName(name_);
                                sumF = sumF + this.calculationFuel(parameter2, name_, cabI_);
                            }
                        }
                        if (sumF > 0.0) {
                            this.fuelMessage = String.valueOf(new DecimalFormat("###0.##").format(sumF)) + " \u043b";
                            this.fuel = sumF;
                        }
                    }
                    block0 : switch (parameter.getAn()) {
                        case -1: {
                            switch (parameter.getIndex()) {
                                case 0: {
                                    for (NDData n22222222222222222222 : this.datasTemp) {
                                        if (n22222222222222222222.getSpeed() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n22222222222222222222.getCreatedDateTime()), (Number)n22222222222222222222.getSpeed());
                                    }
                                    break block0;
                                }
                                case 1: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getGpsSatCount() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), (Number)n.getGpsSatCount());
                                    }
                                    break block0;
                                }
                                case 2: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getGsmSignalLevel() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), (Number)n.getGsmSignalLevel());
                                    }
                                    break block0;
                                }
                                case 3: {
                                    for (NDData n : this.datasTemp) {
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), (double)n.getAlarmDevice());
                                    }
                                    break block0;
                                }
                                case 4: {
                                    for (NDData n : this.datasTemp) {
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), 1.0);
                                    }
                                    if (this.datasTemp != null && this.datasTemp.size() > 0) {
                                        ds.update(this.datasTemp.size() - 1, (Number)20);
                                    }
                                    XYBarRenderer renderer2 = new XYBarRenderer();
                                    renderer2.setShadowVisible(false);
                                    renders.put(cc.size(), renderer2);
                                    break;
                                }
                                case 5: {
                                    for (NDData nDData : this.datasTemp) {
                                        if (nDData.getPowerValue() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(nDData.getCreatedDateTime()), (Number)nDData.getPowerValue());
                                    }
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (parameter.getIndex()) {
                                case 0: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getAe0() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), GraphicsViewer.calibrationData(n.getAe0(), cabI));
                                    }
                                    break block0;
                                }
                                case 1: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getAe1() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), GraphicsViewer.calibrationData(n.getAe1(), cabI));
                                    }
                                    break block0;
                                }
                                case 2: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getAe2() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), GraphicsViewer.calibrationData(n.getAe2(), cabI));
                                    }
                                    break block0;
                                }
                                case 3: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getAe3() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), GraphicsViewer.calibrationData(n.getAe3(), cabI));
                                    }
                                    break block0;
                                }
                                case 4: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getAe4() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), GraphicsViewer.calibrationData(n.getAe4(), cabI));
                                    }
                                    break block0;
                                }
                                case 5: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getAe5() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), GraphicsViewer.calibrationData(n.getAe5(), cabI));
                                    }
                                    break block0;
                                }
                                case 6: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getAe6() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), GraphicsViewer.calibrationData(n.getAe6(), cabI));
                                    }
                                    break block0;
                                }
                                case 7: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getAe7() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), GraphicsViewer.calibrationData(n.getAe7(), cabI));
                                    }
                                    break block0;
                                }
                                case 8: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getAe8() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), GraphicsViewer.calibrationData(n.getAe8(), cabI));
                                    }
                                    break block0;
                                }
                                case 9: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getAe9() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), GraphicsViewer.calibrationData(n.getAe9(), cabI));
                                    }
                                }
                            }
                            break;
                        }
                        case 0: {
                            switch (parameter.getIndex()) {
                                case 0: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getDe0() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), this.calibrationData(n.getDe0(), cabI));
                                    }
                                    break block81;
                                }
                                case 1: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getDe1() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), this.calibrationData(n.getDe1(), cabI));
                                    }
                                    break block81;
                                }
                                case 2: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getDe2() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), this.calibrationData(n.getDe2(), cabI));
                                    }
                                    break block81;
                                }
                                case 3: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getDe3() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), this.calibrationData(n.getDe3(), cabI));
                                    }
                                    break block81;
                                }
                                case 4: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getDe4() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), this.calibrationData(n.getDe4(), cabI));
                                    }
                                    break block81;
                                }
                                case 5: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getDe5() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), this.calibrationData(n.getDe5(), cabI));
                                    }
                                    break block81;
                                }
                                case 6: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getDe6() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), this.calibrationData(n.getDe6(), cabI));
                                    }
                                    break block81;
                                }
                                case 7: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getDe7() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), this.calibrationData(n.getDe7(), cabI));
                                    }
                                    break block81;
                                }
                                case 8: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getDe8() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), this.calibrationData(n.getDe8(), cabI));
                                    }
                                    break block81;
                                }
                                case 9: {
                                    for (NDData n : this.datasTemp) {
                                        if (n.getDe9() == null) continue;
                                        ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getCreatedDateTime()), this.calibrationData(n.getDe9(), cabI));
                                    }
                                }
                            }
                        }
                    }
                }
                tsc.addSeries(ds);
                cc.add(tsc);
            }
            JFreeChart f = this.createChart(cc);
            this.chartPanel = (ChartPanel)this.getFactory().getChartPanel(f);
            XYPlot plot = (XYPlot)this.chartPanel.getChart().getPlot();
            Iterator iterator = renders.keySet().iterator();
            while (iterator.hasNext()) {
                int i2 = (Integer)iterator.next();
                plot.setRenderer(i2, (XYItemRenderer)renders.get(i2));
            }
            this.chartPanel.addChartMouseListener(new ChartMouseListener(){

                public void chartMouseMoved(ChartMouseEvent mouseChartEvent) {
                }

                public void chartMouseClicked(ChartMouseEvent mouseChartEvent) {
                    ChartEntity e = mouseChartEvent.getEntity();
                    if (e instanceof XYItemEntity) {
                        GraphicsViewer.this.setState(((XYItemEntity)e).getItem());
                    }
                    if (e instanceof PlotEntity) {
                        double chartX = GraphicsViewer.this.chartPanel.getChartXFromChartMouseEvent(mouseChartEvent);
                        XYPlot plot = (XYPlot)mouseChartEvent.getChart().getPlot();
                        int i = GraphicsViewer.this.getNearElement(chartX, plot, 0);
                        GraphicsViewer.this.setState(i);
                    }
                }
            });
            this.getFactory().putObjectToContainer((Object)this.chartPanel, this.panel, null);
        }
        this.getFactory().revalidate(this.panel);
        this.updateFuel();
    }

    public void setStateLine(Integer i) {
        this.chartPanel.setStateLine(i);
    }

    private Double calculationFuel(Parameter parameter, String name, CalibrationItem[] cabI) {
        Double sumF = this.calcFuel(this.datasTemp, parameter, cabI);
        if (!(((PanelContext)this.getViewerContext().getParentContext()).getObject() instanceof TrackAllWithPeriods)) {
            String drainFuelMessage = "";
            List<TrackAllWithPeriods.RefuelingVolume> listD = this.calcDrainFuel(this.datasTemp, parameter, cabI);
            if (listD != null && listD.size() > 0) {
                double sumD = 0.0;
                int i = 0;
                while (i < listD.size()) {
                    sumD += listD.get(i).getVolume().doubleValue();
                    ++i;
                }
                drainFuelMessage = String.valueOf(new DecimalFormat("###0.##").format(sumD)) + " \u043b";
            }
            ((TrackAll)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject())).setDrainFuel(drainFuelMessage);
            ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("drainFuel");
        }
        return sumF;
    }

    private Long calcTimeLitersPerHour(List<NDData> datas2) {
        Long time = 0L;
        Date begDate = null;
        int i = 0;
        while (i < datas2.size()) {
            if (!(begDate != null && datas2.get(i).getSpeed() > this.minSpeed || begDate == null && datas2.get(i).getSpeed() <= this.minSpeed)) {
                if (begDate == null && datas2.get(i).getSpeed() > this.minSpeed) {
                    begDate = datas2.get(i).getCreatedDateTime();
                } else if (begDate != null && datas2.get(i).getSpeed() <= this.minSpeed) {
                    time = time + datas2.get(i - 1).getCreatedDateTime().getTime() - begDate.getTime();
                    begDate = null;
                }
            }
            ++i;
        }
        if (begDate != null) {
            time = time + datas2.get(datas2.size() - 1).getCreatedDateTime().getTime() - begDate.getTime();
        }
        return time;
    }

    private Long calcTimeLitersPerHour2(List<NDData> datas2, Parameter par, Integer onIgnition) {
        Long time = 0L;
        return time;
    }

    private CalibrationItem[] getCalibrationItemsForName(String name) {
        if (this.map.get(name.trim()) == null) {
            return null;
        }
        Object[] cabI = this.map.get(name.trim()).getItems();
        if (cabI != null) {
            List listCI = Arrays.asList((Object[])cabI);
            Collections.sort(listCI, GraphicsViewer.compareCI());
            cabI = listCI.toArray(new CalibrationItem[listCI.size()]);
        }
        return cabI;
    }

    private DateRange[] checkPaar(List<NDData> datas2, Parameter par, CalibrationItem[] cabI) {
        ArrayList<DateRange> mapP = new ArrayList<DateRange>();
        Date begD = datas2.get(0).getCreatedDateTime();
        Date endD = datas2.get(datas2.size() - 1).getCreatedDateTime();
        int i = 1;
        while (i < datas2.size()) {
            endD = datas2.get(i).getCreatedDateTime();
            Double endF = GraphicsViewer.calibrationData(GraphicsViewer.getAnData(datas2.get(i), par), cabI).doubleValue();
            if (i == datas2.size() - 1) break;
            Date endDN = datas2.get(i + 1).getCreatedDateTime();
            Double endFN = GraphicsViewer.calibrationData(GraphicsViewer.getAnData(datas2.get(i + 1), par), cabI).doubleValue();
            if (endFN - endF > this.minFueling && endDN.getTime() - endD.getTime() > this.minChangeFuelPeriod) {
                if (endD.getTime() - begD.getTime() > 1000L) {
                    mapP.add(new DateRange(begD, endD));
                }
                begD = endDN;
            }
            ++i;
        }
        mapP.add(new DateRange(begD, endD));
        Collections.sort(mapP, this.compareDR());
        return mapP.toArray(new DateRange[mapP.size()]);
    }

    private Comparator<? super DateRange> compareDR() {
        return new Comparator<DateRange>(){

            @Override
            public int compare(DateRange arg0, DateRange arg1) {
                return arg0.getLowerDate().compareTo(arg0.getLowerDate());
            }
        };
    }

    private Double calcFuel(List<NDData> datas2, Parameter par, CalibrationItem[] cabI) {
        ArrayList<TrackAllWithPeriods.RefuelingVolume> listRefuelingVolumes = new ArrayList<TrackAllWithPeriods.RefuelingVolume>();
        Double sumT = 0.0;
        Date begD = datas2.get(0).getCreatedDateTime();
        Double begF = GraphicsViewer.calibrationData(GraphicsViewer.getAnData(datas2.get(0), par), cabI).doubleValue();
        Date endD = datas2.get(datas2.size() - 1).getCreatedDateTime();
        Double endF = GraphicsViewer.calibrationData(GraphicsViewer.getAnData(datas2.get(datas2.size() - 1), par), cabI).doubleValue();
        sumT = begF - endF;
        Date endDN = begD;
        Double endFN = begF;
        boolean up = false;
        int prevI = 0;
        int i = 1;
        while (i < datas2.size()) {
            endD = datas2.get(i).getCreatedDateTime();
            double sou = GraphicsViewer.getAnData(datas2.get(i), par);
            endF = GraphicsViewer.calibrationData(sou, cabI).doubleValue();
            if (endFN.equals(endF) && endFN.equals(0.0)) {
                up = false;
                begD = endD;
                begF = endF;
                endDN = begD;
                endFN = begF;
                prevI = i;
            } else if (endFN <= endF) {
                if (!up) {
                    up = true;
                }
                endDN = endD;
                endFN = endF;
            } else {
                if (endDN.getTime() - begD.getTime() > this.minChangeFuelPeriod && endDN.getTime() - begD.getTime() < this.maxChangeFuelPeriod && endFN - begF > this.minFueling) {
                    Long sumt = datas2.get(prevI).getCreatedDateTime().getTime();
                    Double prevs = GraphicsViewer.calibrationData(GraphicsViewer.getAnData(datas2.get(prevI), par), cabI).doubleValue();
                    int k = 0;
                    k = prevI - 1;
                    while (k > 0) {
                        prevs = prevs + GraphicsViewer.calibrationData(GraphicsViewer.getAnData(datas2.get(k), par), cabI).doubleValue();
                        if (per.compareTo(sumt - datas2.get(k).getCreatedDateTime().getTime()) < 0) break;
                        --k;
                    }
                    sumt = datas2.get(i).getCreatedDateTime().getTime();
                    Double nexts = GraphicsViewer.calibrationData(GraphicsViewer.getAnData(datas2.get(i), par), cabI).doubleValue();
                    int k2 = 0;
                    k2 = i + 1;
                    while (k2 < datas2.size()) {
                        nexts = nexts + GraphicsViewer.calibrationData(GraphicsViewer.getAnData(datas2.get(k2), par), cabI).doubleValue();
                        if (per.compareTo(datas2.get(k2).getCreatedDateTime().getTime() - sumt) < 0) break;
                        ++k2;
                    }
                    if (nexts / (double)(k2 - i) - prevs / (double)(prevI - k + 1) > this.minFueling) {
                        sumT = sumT + endFN - begF;
                        TrackAllWithPeriods.RefuelingVolume r = new TrackAllWithPeriods.RefuelingVolume();
                        r.setVolume(endFN - begF);
                        r.setDate(endDN);
                        r.setBegin(prevI);
                        r.setEnd(i);
                        listRefuelingVolumes.add(r);
                    }
                }
                up = false;
                begD = endD;
                begF = endF;
                endDN = begD;
                endFN = begF;
                prevI = i;
            }
            ++i;
        }
        if (up && endDN.getTime() - begD.getTime() > this.minChangeFuelPeriod && endDN.getTime() - begD.getTime() < this.maxChangeFuelPeriod && endFN - begF > this.minFueling) {
            System.out.println(" " + df.format(endDN) + " - " + df.format(begD) + " v=" + (endFN - begF));
            sumT = sumT + endFN - begF;
            TrackAllWithPeriods.RefuelingVolume r = new TrackAllWithPeriods.RefuelingVolume();
            r.setVolume(endFN - begF);
            r.setDate(endDN);
            r.setBegin(prevI);
            r.setEnd(datas2.size() - 1);
            listRefuelingVolumes.add(r);
        }
        if (((PanelContext)this.getViewerContext().getParentContext()).getObject() instanceof TrackAllWithPeriods) {
            ((TrackAllWithPeriods)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject())).setListRefuelingVolumes(listRefuelingVolumes);
            ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("listRefuelingVolumes");
        }
        return sumT;
    }

    private List<TrackAllWithPeriods.RefuelingVolume> calcDrainFuel(List<NDData> datas2, Parameter par, CalibrationItem[] cabI) {
        ArrayList<NDData> datas2R = new ArrayList<NDData>(datas2.size());
        double maxd = 0.0;
        int i = 0;
        while (i < datas2.size()) {
            NDData ndd = new NDData();
            BeanCopierGenerator.getInstance(NDData.class, (boolean)false).copy((Object)datas2.get(i), (Object)ndd, null);
            if (maxd < GraphicsViewer.getAnData(ndd, par)) {
                maxd = GraphicsViewer.getAnData(ndd, par);
            }
            datas2R.add(i, ndd);
            ++i;
        }
        i = 0;
        while (i < datas2R.size()) {
            NDData n = (NDData)datas2R.get(i);
            double prev = GraphicsViewer.getAnData(n, par);
            GraphicsViewer.setAnData(n, par.getAn(), par.getIndex(), maxd - prev);
            ++i;
        }
        ArrayList<TrackAllWithPeriods.RefuelingVolume> listRefuelingVolumes = new ArrayList<TrackAllWithPeriods.RefuelingVolume>();
        Double sumT = 0.0;
        Date begD = ((NDData)datas2R.get(0)).getCreatedDateTime();
        Double begF = GraphicsViewer.calibrationData(GraphicsViewer.getAnData((NDData)datas2R.get(0), par), cabI).doubleValue();
        Date endD = ((NDData)datas2R.get(datas2R.size() - 1)).getCreatedDateTime();
        Double endF = GraphicsViewer.calibrationData(GraphicsViewer.getAnData((NDData)datas2R.get(datas2R.size() - 1), par), cabI).doubleValue();
        sumT = begF - endF;
        Date endDN = begD;
        Double endFN = begF;
        boolean up = false;
        int prevI = 0;
        int i2 = 1;
        while (i2 < datas2R.size()) {
            endD = ((NDData)datas2R.get(i2)).getCreatedDateTime();
            double sou = GraphicsViewer.getAnData((NDData)datas2R.get(i2), par);
            endF = GraphicsViewer.calibrationData(sou, cabI).doubleValue();
            if (endFN.equals(endF) && endFN.equals(0.0)) {
                up = false;
                begD = endD;
                begF = endF;
                endDN = begD;
                endFN = begF;
                prevI = i2;
            } else if (endFN <= endF) {
                if (!up) {
                    up = true;
                }
                endDN = endD;
                endFN = endF;
            } else {
                if (endDN.getTime() - begD.getTime() > this.minChangeFuelPeriod && endDN.getTime() - begD.getTime() < this.maxChangeFuelPeriod && endFN - begF > this.minFueling) {
                    Long sumt = ((NDData)datas2R.get(prevI)).getCreatedDateTime().getTime();
                    Double prevs = GraphicsViewer.calibrationData(GraphicsViewer.getAnData((NDData)datas2R.get(prevI), par), cabI).doubleValue();
                    int k = 0;
                    k = prevI - 1;
                    while (k > 0) {
                        prevs = prevs + GraphicsViewer.calibrationData(GraphicsViewer.getAnData((NDData)datas2R.get(k), par), cabI).doubleValue();
                        if (per.compareTo(sumt - ((NDData)datas2R.get(k)).getCreatedDateTime().getTime()) < 0) break;
                        --k;
                    }
                    sumt = ((NDData)datas2R.get(i2)).getCreatedDateTime().getTime();
                    Double nexts = GraphicsViewer.calibrationData(GraphicsViewer.getAnData((NDData)datas2R.get(i2), par), cabI).doubleValue();
                    int k2 = 0;
                    k2 = i2 + 1;
                    while (k2 < datas2R.size()) {
                        nexts = nexts + GraphicsViewer.calibrationData(GraphicsViewer.getAnData((NDData)datas2R.get(k2), par), cabI).doubleValue();
                        if (per.compareTo(((NDData)datas2R.get(k2)).getCreatedDateTime().getTime() - sumt) < 0) break;
                        ++k2;
                    }
                    if (nexts / (double)(k2 - i2) - prevs / (double)(prevI - k + 1) > this.minFueling) {
                        sumT = sumT + endFN - begF;
                        TrackAllWithPeriods.RefuelingVolume r = new TrackAllWithPeriods.RefuelingVolume();
                        r.setVolume(endFN - begF);
                        r.setDate(endDN);
                        r.setBegin(prevI);
                        r.setEnd(i2);
                        listRefuelingVolumes.add(r);
                    }
                }
                up = false;
                begD = endD;
                begF = endF;
                endDN = begD;
                endFN = begF;
                prevI = i2;
            }
            ++i2;
        }
        if (up && endDN.getTime() - begD.getTime() > this.minChangeFuelPeriod && endDN.getTime() - begD.getTime() < this.maxChangeFuelPeriod && endFN - begF > this.minFueling) {
            System.out.println(" " + df.format(endDN) + " - " + df.format(begD) + " v=" + (endFN - begF));
            sumT = sumT + endFN - begF;
            TrackAllWithPeriods.RefuelingVolume r = new TrackAllWithPeriods.RefuelingVolume();
            r.setVolume(endFN - begF);
            r.setDate(endDN);
            r.setBegin(prevI);
            r.setEnd(datas2R.size() - 1);
            listRefuelingVolumes.add(r);
        }
        if (((PanelContext)this.getViewerContext().getParentContext()).getObject() instanceof TrackAllWithPeriods) {
            ((TrackAllWithPeriods)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject())).setListRefuelingVolumes(listRefuelingVolumes);
            ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("listRefuelingVolumes");
        }
        return listRefuelingVolumes;
    }

    private Double calcFuel(List<NDData> datas2, Parameter par, CalibrationItem[] cabI, DateRange[] mapPaar) {
        Double sumT = 0.0;
        Double sumPrev = GraphicsViewer.calibrationData(GraphicsViewer.getAnData(datas2.get(0), par), cabI).doubleValue();
        DateRange curDR = this.findDateRange(datas2.get(0).getCreatedDateTime(), mapPaar);
        int i = 1;
        do {
            NDData n = datas2.get(i);
            if (curDR != null && !n.getCreatedDateTime().after(curDR.getUpperDate())) {
                Double cur = GraphicsViewer.calibrationData(GraphicsViewer.getAnData(n, par), cabI).doubleValue();
                sumT = sumT + (sumPrev - cur);
                sumPrev = cur;
                ++i;
                continue;
            }
            DateRange tempDR = null;
            do {
                tempDR = this.findDateRange(datas2.get(i).getCreatedDateTime(), mapPaar);
            } while (++i < datas2.size() - 1 && tempDR == null);
            curDR = tempDR;
            sumPrev = GraphicsViewer.calibrationData(GraphicsViewer.getAnData(datas2.get(i), par), cabI).doubleValue();
        } while (i < datas2.size() - 1);
        return sumT;
    }

    private DateRange findDateRange(Date createdDateTime, DateRange[] mapPaar) {
        int i = 0;
        while (i < mapPaar.length) {
            DateRange cur = mapPaar[i];
            if (!createdDateTime.before(cur.getLowerDate()) && !createdDateTime.after(cur.getUpperDate())) {
                return cur;
            }
            ++i;
        }
        return null;
    }

    public static List<NDData> highpassFilter(List<NDData> datas2, Parameter par, int cp) {
        int allSize = datas2.size();
        ArrayList<NDData> rez = new ArrayList<NDData>(allSize);
        int i = 0;
        while (i < allSize) {
            NDData ndd = new NDData();
            BeanCopierGenerator.getInstance(NDData.class, (boolean)false).copy((Object)datas2.get(i), (Object)ndd, null);
            double zn = 0.0;
            int cn = 0;
            int j = i - cp;
            while (j < i + cp) {
                if (j >= 0 && j < allSize) {
                    double znC = GraphicsViewer.getAnData(datas2.get(j), par);
                    zn += znC;
                    ++cn;
                }
                ++j;
            }
            if (cn > 0) {
                GraphicsViewer.setAnData(ndd, par.getAn(), par.getIndex(), zn / (double)cn);
                rez.add(i, ndd);
            }
            ++i;
        }
        return rez;
    }

    private List<NDData> highpassFilter2(List<NDData> datas2, Parameter par, int cp) {
        int allSize = datas2.size();
        ArrayList<NDData> rez = new ArrayList<NDData>(allSize);
        double znP = GraphicsViewer.getAnData(datas2.get(0), par);
        int i = 0;
        while (i < allSize) {
            NDData n = datas2.get(i);
            double znC = GraphicsViewer.getAnData(n, par);
            if (Math.abs(znP - znC) > (double)cp && n.getSpeed() > 10.0) {
                znC = znP;
            }
            znP = znC;
            GraphicsViewer.setAnData(n, par.getAn(), par.getIndex(), znC);
            rez.add(i, n);
            ++i;
        }
        return rez;
    }

    private List<NDData> highpassFilter3(List<NDData> datas2, Parameter par, Double cp) {
        NDData n;
        int allSize = datas2.size();
        ArrayList<NDData> rez = new ArrayList<NDData>(allSize);
        int j = 0;
        Double prev = 0.0;
        int i = 0;
        while (i < allSize) {
            prev = GraphicsViewer.getAnData(datas2.get(i), par);
            if (prev.compareTo(cp) < 0 && prev.compareTo(0.0) > 0) {
                j = i;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < j) {
            n = datas2.get(i);
            GraphicsViewer.setAnData(n, par.getAn(), par.getIndex(), prev);
            rez.add(i, n);
            ++i;
        }
        i = j;
        while (i < allSize) {
            n = datas2.get(i);
            Double znC = GraphicsViewer.getAnData(n, par);
            if (znC.compareTo(cp) > 0 || znC.compareTo(0.0) == 0) {
                znC = prev;
            }
            prev = znC;
            GraphicsViewer.setAnData(n, par.getAn(), par.getIndex(), znC);
            rez.add(i, n);
            ++i;
        }
        return rez;
    }

    private List<NDData> highpassFilter5(List<NDData> datas2, Parameter par, Double cp) {
        NDData n;
        int allSize = datas2.size();
        ArrayList<NDData> rez = new ArrayList<NDData>(allSize);
        int j = 0;
        Double prev = 0.0;
        int i = 0;
        while (i < allSize) {
            prev = GraphicsViewer.getAnData(datas2.get(i), par);
            if (prev.compareTo(cp) > 0) {
                j = i;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < j) {
            n = datas2.get(i);
            GraphicsViewer.setAnData(n, par.getAn(), par.getIndex(), prev);
            rez.add(i, n);
            ++i;
        }
        i = j;
        while (i < allSize) {
            n = datas2.get(i);
            Double znC = GraphicsViewer.getAnData(n, par);
            if (znC.compareTo(cp) < 0) {
                znC = prev;
            }
            prev = znC;
            GraphicsViewer.setAnData(n, par.getAn(), par.getIndex(), znC);
            rez.add(i, n);
            ++i;
        }
        return rez;
    }

    private List<NDData> highpassFilter4(List<NDData> datas2, Parameter par, int cp) {
        int allSize = datas2.size();
        ArrayList<NDData> rez = new ArrayList<NDData>(allSize);
        int i = 0;
        while (i < allSize) {
            NDData ndd = new NDData();
            BeanCopierGenerator.getInstance(NDData.class, (boolean)false).copy((Object)datas2.get(i), (Object)ndd, null);
            double znPrev = 0.0;
            int cnPrev = 0;
            int j = i - cp;
            while (j < i + cp + 1) {
                if (j >= 0 && j < allSize) {
                    double znC = GraphicsViewer.getAnData(datas2.get(j), par);
                    znPrev += znC;
                    ++cnPrev;
                }
                ++j;
            }
            double zn1 = znPrev / (double)cnPrev;
            double zn0 = (znPrev - GraphicsViewer.getAnData(ndd, par)) / (double)(cnPrev - 1);
            double pr1 = zn0 * 100.0 / zn1;
            if (Math.abs(100.0 - pr1) > 10.0 * MAX_DIFF) {
                GraphicsViewer.setAnData(ndd, par.getAn(), par.getIndex(), zn0);
            }
            rez.add(i, ndd);
            ++i;
        }
        return rez;
    }

    public static double getAnData(NDData n, Parameter par) {
        Object rez = Utils.getParameterValue(n, par);
        if (rez == null) {
            return 0.0;
        }
        return ((Number)rez).doubleValue();
    }

    public static void setAnData(NDData n, int an, int index, Double d) {
        block0 : switch (an) {
            case -1: {
                switch (index) {
                    case 0: {
                        n.setSpeed(d);
                        break;
                    }
                    case 1: {
                        n.setGpsSatCount(Integer.valueOf(d.intValue()));
                        break;
                    }
                    case 2: {
                        n.setGsmSignalLevel(Integer.valueOf(d.intValue()));
                        break;
                    }
                    case 3: {
                        n.setAlarm(d.intValue());
                        break;
                    }
                    case 4: {
                        n.setPowerValue(Double.valueOf(d));
                    }
                }
                break;
            }
            case 1: {
                switch (index) {
                    case 0: {
                        n.setAe0(d);
                        break;
                    }
                    case 1: {
                        n.setAe1(d);
                        break;
                    }
                    case 2: {
                        n.setAe2(d);
                        break;
                    }
                    case 3: {
                        n.setAe3(d);
                        break;
                    }
                    case 4: {
                        n.setAe4(d);
                        break;
                    }
                    case 5: {
                        n.setAe5(d);
                        break;
                    }
                    case 6: {
                        n.setAe6(d);
                        break;
                    }
                    case 7: {
                        n.setAe7(d);
                        break;
                    }
                    case 8: {
                        n.setAe8(d);
                        break;
                    }
                    case 9: {
                        n.setAe9(d);
                    }
                }
                break;
            }
            case 0: {
                switch (index) {
                    case 0: {
                        n.setDe0(Integer.valueOf(d.intValue()));
                        break block0;
                    }
                    case 1: {
                        n.setDe1(Integer.valueOf(d.intValue()));
                        break block0;
                    }
                    case 2: {
                        n.setDe2(Integer.valueOf(d.intValue()));
                        break block0;
                    }
                    case 3: {
                        n.setDe3(Integer.valueOf(d.intValue()));
                        break block0;
                    }
                    case 4: {
                        n.setDe4(Integer.valueOf(d.intValue()));
                        break block0;
                    }
                    case 5: {
                        n.setDe5(Integer.valueOf(d.intValue()));
                        break block0;
                    }
                    case 6: {
                        n.setDe6(Integer.valueOf(d.intValue()));
                        break block0;
                    }
                    case 7: {
                        n.setDe7(Integer.valueOf(d.intValue()));
                        break block0;
                    }
                    case 8: {
                        n.setDe8(Integer.valueOf(d.intValue()));
                        break block0;
                    }
                    case 9: {
                        n.setDe9(Integer.valueOf(d.intValue()));
                    }
                }
            }
        }
    }

    public static Comparator<CalibrationItem> compareCI() {
        return new Comparator<CalibrationItem>(){

            @Override
            public int compare(CalibrationItem io1, CalibrationItem io2) {
                return io1.getOriginalValue().compareTo(io2.getOriginalValue());
            }
        };
    }

    private int getNearElement(double chartX, XYPlot plot, int indexDataSet) {
        int l = 0;
        int r = plot.getDataset().getItemCount(indexDataSet) - 1;
        int t = (l + r) / 2;
        while (r - l > 1) {
            double d = plot.getDataset().getXValue(indexDataSet, t);
            if (d < chartX) {
                l = t;
            } else if (d > chartX) {
                r = t;
            }
            t = (l + r) / 2;
        }
        if (l == r) {
            return l;
        }
        double dl = plot.getDataset().getXValue(indexDataSet, l);
        double dr = plot.getDataset().getXValue(indexDataSet, r);
        if (Math.abs(chartX - dl) > Math.abs(chartX - dr)) {
            return r;
        }
        return l;
    }

    public void updateFuel() {
        TrackAll tt = (TrackAll)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject());
        tt.setFuel(this.fuel);
        tt.setFuelConsumption(this.fuelMessage);
        tt.setWorkTime(this.workTime);
        ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("fuelConsumption");
        ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("fuelOn100Kilometers");
    }

    public void setState(int i) {
        TrackAll tt = (TrackAll)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject());
        tt.setState(i, true);
    }

    private Paint getColorParameter(String name) {
        Integer color;
        if (name.indexOf("(1)") > 0) {
            name = name.substring(0, name.indexOf("(1)")).trim();
        }
        if (name.indexOf("(2)") > 0) {
            name = name.substring(0, name.indexOf("(2)")).trim();
        }
        DirectoriesSearchCriteria dsc = new DirectoriesSearchCriteria();
        dsc.setDescription("*" + name + "*");
        DeviceParameterNamesWSProxy.SearchResultListDeviceParameterNames sr = this.deviceParameterNamesWSProxy.getList(InitializedVariable.context, dsc);
        if (!sr.isEmpty() && (color = ((DeviceParameterNames)sr.getObjList()[0]).getColor()) != null) {
            return new Color(color);
        }
        return Color.BLACK;
    }

    private Number calibrationData(Integer val, CalibrationItem[] cabI) {
        if (cabI == null || cabI.length == 0) {
            return val;
        }
        return GraphicsViewer.calibrationData(new Double(val.intValue()), cabI);
    }

    public static Number calibrationData(Double val, CalibrationItem[] cabI) {
        return GraphicsViewer.positiveData(val);
    }

    public static Number positiveData(Number val) {
        if (val == null || val.doubleValue() < Double.valueOf(0.0)) {
            return 0;
        }
        return val;
    }

    public Object getValue() {
        return null;
    }

    public void setChangeValueAction(BeanViewerAction<ViewerContext> changeAction) {
    }

    public void setEditable(boolean editable) {
    }

    public void setValue(Object object) {
        Object[] o = (Object[])object;
        this.parameters = (List)o[0];
        this.datas = (List)o[1];
        if (o.length > 2) {
            this.parametersAll = (List)o[2];
        }
        this.init();
    }

    public static void main(String[] args) {
        double[] mas = new double[]{212.0, 213.0, 214.0, 215.0, 216.0, 32.0, 118.0, 119.0, 120.0, 121.0, 122.0};
        int mid = 5;
        int cp = 5;
        int i = 0;
        while (i < 200) {
            mas[mid] = i;
            double znPrev = 0.0;
            int cnPrev = 0;
            int j = mid - cp;
            while (j < mid + cp + 1) {
                double znC = mas[j];
                znPrev += znC;
                ++cnPrev;
                ++j;
            }
            double zn1 = znPrev / (double)cnPrev;
            double zn0 = (znPrev - mas[mid]) / (double)(cnPrev - 1);
            double pr1 = zn0 * 100.0 / zn1;
            System.out.println(" i=" + i + " c=" + cnPrev + " ave1=" + zn1 + " ave2=" + zn0 + " %=" + pr1);
            ++i;
        }
    }
}

