/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks;

import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.text.MaskFormatter;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public class HourWithMinuteViewer
extends FieldViewer<JComponent>
implements SwingItem {
    JPanel panel = (JPanel)this.getFactory().getPanel();
    JButton button;
    SwingFactory.JUIFormattedTextField field;
    boolean editable = false;

    public HourWithMinuteViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.initField("##:##");
    }

    public void setFocus() {
        this.getFactory().setFocusOnComponent((Object)this.field);
        this.field.getCaret().setDot(0);
    }

    private void initField(String format) {
        try {
            String ff = format.replaceAll("H|h|m|s|S", "#");
            MaskFormatter f = new MaskFormatter(ff);
            f.setPlaceholderCharacter('_');
            this.field = new SwingFactory.JUIFormattedTextField((JFormattedTextField.AbstractFormatter)f);
            this.setEditable(this.editable);
            this.panel.removeAll();
            this.getFactory().setPropertyToComponent("minsize", "40x22", (Object)this.field);
            this.getFactory().setPropertyToComponent("background", "#FFFFFF", (Object)this.field);
            this.getFactory().putObjectToContainer((Object)this.field, (Object)this.panel, (Object)"growx");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public JComponent getComponent(boolean isSelected, boolean hasFocus) {
        return this.panel;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.getFactory().setComponentEditable((Object)this.field, editable);
        this.getFactory().setComponentEditable((Object)this.button, editable);
    }

    public void setChangeValueAction(BeanViewerAction<ViewerContext> changeAction) {
        this.getFactory().addActionToComponent((Object)this.getComponent(false, false), changeAction);
    }

    public void setChangeValueActionOnEnter(BeanViewerAction<ViewerContext> changeAction) {
        this.getFactory().addActionToComponentOnEnter((Object)this.field, changeAction);
    }

    public void setValue(Object object) {
        if (object == null) {
            this.getFactory().setTextToComponent((Object)this.field, "");
        } else {
            Integer[] hm = (Integer[])object;
            StringBuilder st = new StringBuilder("").append(hm[0] < 10 ? "0" : "").append(hm[0]).append(":").append(hm[1] < 10 ? "0" : "").append(hm[1]);
            this.getFactory().setTextToComponent((Object)this.field, st.toString());
        }
    }

    public Class<? extends FieldViewer<JComponent>> getTableCellViewerClass() {
        return HourWithMinuteViewerTable.class;
    }

    public Object getValue() {
        String s = this.getFactory().getTextFromComponent((Object)this.field);
        if (s == null || "".equals(s)) {
            return null;
        }
        try {
            String[] hm = s.split(":");
            if (hm.length == 2) {
                Integer h = Integer.parseInt(hm[0]);
                Integer m = Integer.parseInt(hm[1]);
                return new Integer[]{h, m};
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class HourWithMinuteViewerTable
    extends DefaultTableCellViewer<JComponent> {
        public HourWithMinuteViewerTable(UIFactory<JComponent> factory) {
            super(factory);
        }

        public void setValue(Object object) {
            if (object == null) {
                super.setValue((Object)"");
            } else {
                Integer[] hm = (Integer[])object;
                StringBuilder st = new StringBuilder("").append(hm[0] < 10 ? "0" : "").append(hm[0]).append(":").append(hm[1] < 10 ? "0" : "").append(hm[1]);
                super.setValue((Object)st.toString());
            }
        }
    }
}

