/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.postgis.Geometry;
import org.postgis.MultiPolygon;
import org.postgis.Polygon;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.core.ResourceStrings;
import ru.blok.common.ui.popup.PopupMenuManager;
import ru.blok.vms.ui.tracks.TrackAll;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.UISetter;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.AbstractContext;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.client.soap.proxy.vms.BuildingWSProxy;
import ru.infor.client.soap.proxy.vms.CheckPointWSProxy;
import ru.infor.client.soap.proxy.vms.ControlFunctionsListWSProxy;
import ru.infor.client.soap.proxy.vms.ControlFunctionsWSProxy;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.events.ControlFunctionsListSearchCriteria;
import ru.infor.ws.objects.events.entities.ControlFunctions;
import ru.infor.ws.objects.events.entities.ControlFunctionsList;
import ru.infor.ws.objects.events.entities.EventTuningValue;
import ru.infor.ws.objects.events.entities.ext.ControlFunctionsListExt;
import ru.infor.ws.objects.vms.NavigationPoint;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.Building;
import ru.infor.ws.objects.vms.entities.CheckPoint;
import ru.infor.ws.objects.vms.entities.Route;

@ListView(views={@View(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0432\u0441\u0435\u0433\u043e \u043f\u0443\u0442\u0438", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class TrackAllWithControlFunction
extends TrackAll {
    boolean select = false;
    private List<PeriodCT> listPeriod = new ArrayList<PeriodCT>();
    HashMap<Date, NavigationPoint> mapStop = new HashMap();
    SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    BuildingWSProxy buildingWSProxy = (BuildingWSProxy)CurrentProxyFactory.getProxy(Building.class);
    CheckPointWSProxy checkPointWSProxy = (CheckPointWSProxy)CurrentProxyFactory.getProxy(CheckPoint.class);
    HashMap<ControlFunctionsList, List<Geometry>> mapg = new HashMap();

    public Double[] getMinMax(int i1, int i2) {
        Double minLat = ((AbstractNDData)this.list.get(i1)).getLat();
        Double maxLat = ((AbstractNDData)this.list.get(i1)).getLat();
        Double minLon = ((AbstractNDData)this.list.get(i1)).getLon();
        Double maxLon = ((AbstractNDData)this.list.get(i1)).getLon();
        int i = i1 + 1;
        while (i <= i2) {
            AbstractNDData d = (AbstractNDData)this.list.get(i);
            if (d.getLat() < minLat) {
                minLat = d.getLat();
            }
            if (d.getLat() > maxLat) {
                maxLat = d.getLat();
            }
            if (d.getLon() < minLon) {
                minLon = d.getLon();
            }
            if (d.getLon() > maxLon) {
                maxLon = d.getLon();
            }
            ++i;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @ListField(fields={@Field(title="\u041f\u0435\u0440\u0438\u043e\u0434\u044b \u0440\u0430\u0431\u043e\u0442\u044b", viewer={ListViewerT.class}, content=PeriodCT.class, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041f\u0435\u0440\u0438\u043e\u0434\u044b \u0440\u0430\u0431\u043e\u0442\u044b:0/fill#span, growy#wrap, growy 0", order=500)})
    public List<PeriodCT> getListPeriod() {
        return this.listPeriod;
    }

    public void setListPeriod(List<PeriodCT> listPeriod) {
        this.listPeriod = listPeriod;
    }

    public List<BeanViewerAction<ViewerContext>> popupListPeriod() {
        ArrayList<BeanViewerAction<ViewerContext>> l = new ArrayList<BeanViewerAction<ViewerContext>>();
        l.add(PopupMenuManager.getActionForString((String)ResourceStrings.UPLOADDATANAME));
        return l;
    }

    public TrackAllWithControlFunction(String keyPage) {
        super(keyPage);
    }

    @Override
    public void beforeShow(PanelContext pc) {
        super.beforeShow(pc);
        this.setVisibleToTab(pc.getPanel());
    }

    public void setVisibleToTab(UISetter<?> panel) {
    }

    @Override
    public synchronized void reload(List<AbstractNDData> list1) {
        this.setListPeriod(null);
        ((PanelContext)((ViewerContext)this.fieldButtonLoadData.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("listPeriod");
        super.reload(list1);
        ((PanelContext)((ViewerContext)this.fieldButtonLoadData.getContext()).getParentContext()).getPanel().getFactory().setCursor(1, ((ViewerContext)this.fieldButtonLoadData.getContext()).getKeyPage());
        this.setPeriods();
        ((PanelContext)((ViewerContext)this.fieldButtonLoadData.getContext()).getParentContext()).getPanel().getFactory().setCursor(0, ((ViewerContext)this.fieldButtonLoadData.getContext()).getKeyPage());
    }

    private Geometry parsegeom(String geom) {
        if (geom != null) {
            try {
                Object currentPolygon = null;
                currentPolygon = geom.contains("MULTIPOLYGON") ? new MultiPolygon(geom) : new Polygon(geom);
                return currentPolygon;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private void setPeriods() {
        ArrayList<ControlFunctionsListExt> items = new ArrayList<ControlFunctionsListExt>();
        ControlFunctionsWSProxy proxyCF = (ControlFunctionsWSProxy)CurrentProxyFactory.getProxy(ControlFunctions.class);
        ControlFunctionsListWSProxy proxyCFL = (ControlFunctionsListWSProxy)CurrentProxyFactory.getProxy(ControlFunctionsList.class);
        RouteWSProxy routeWSProxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);
        CheckPointWSProxy checkPointWSProxy = (CheckPointWSProxy)CurrentProxyFactory.getProxy(CheckPoint.class);
        ControlFunctionsListSearchCriteria scCLF = new ControlFunctionsListSearchCriteria();
        scCLF.setCount(Integer.valueOf(Integer.MAX_VALUE));
        scCLF.appendSorting(SortObject.getInstance((String)"dateStart", (String)SortObject.DIRECTION_ASC));
        scCLF.setEndsAfter(this.getDateFrom());
        scCLF.setStartsBefore(this.getDateTill());
        scCLF.setTransportIdList(new Long[]{this.getTransport().getId()});
        ControlFunctionsListWSProxy.SearchResultListControlFunctionsList srCFL = proxyCFL.getList(InitializedVariable.context, scCLF);
        this.mapg.clear();
        if (srCFL.getObjList() != null) {
            int j = 0;
            while (j < srCFL.getObjList().length) {
                ControlFunctionsList cfl = (ControlFunctionsList)srCFL.getObjList()[j];
                cfl = proxyCFL.getCurrentObject(InitializedVariable.context, cfl.getId());
                items.add((ControlFunctionsListExt)cfl);
                HashMap<String, Geometry> mapKT = new HashMap<String, Geometry>();
                ArrayList<Geometry> list = new ArrayList<Geometry>();
                int k = 0;
                while (k < cfl.getFunctions().length) {
                    ControlFunctions cf;
                    cfl.getFunctions()[k] = cf = proxyCF.getCurrentObject(InitializedVariable.context, cfl.getFunctions()[k].getId());
                    EventTuningValue[] etvArr = cf.getValues();
                    if (etvArr != null) {
                        int k1 = 0;
                        while (k1 < etvArr.length) {
                            Geometry g;
                            Geometry g2;
                            Long id;
                            if (etvArr[k1].getTypeVar() == 105) {
                                id = Long.valueOf(etvArr[k1].getValueParam());
                                Route r = routeWSProxy.getCurrentObject(InitializedVariable.context, id);
                                g2 = this.parsegeom(r.getAreaRouteGeom());
                                mapKT.put(etvArr[k1].getParamToScreen(), g2);
                                list.add(g2);
                            }
                            if (etvArr[k1].getTypeVar() == 109) {
                                id = Long.valueOf(etvArr[k1].getValueParam());
                                CheckPoint p = checkPointWSProxy.getCurrentObject(InitializedVariable.context, id);
                                g2 = this.parsegeom(p.getGeom());
                                mapKT.put(etvArr[k1].getParamToScreen(), g2);
                                list.add(g2);
                            }
                            if (etvArr[k1].getTypeVar() == 123) {
                                g = this.parsegeom(etvArr[k1].getValueParam());
                                mapKT.put("\u041e\u0431\u043b\u0430\u0441\u0442\u044c \u0432\u043e\u043a\u0440\u0443\u0433 \u0442\u043e\u0447\u043a\u0438 \u043d\u0430 \u043a\u0430\u0440\u0442\u0435 id=" + etvArr[k1].getId(), g);
                                list.add(g);
                            }
                            if (etvArr[k1].getTypeVar() == 124) {
                                g = this.parsegeom(etvArr[k1].getValueParam());
                                mapKT.put("\u041e\u0431\u043b\u0430\u0441\u0442\u044c \u0432\u043e\u043a\u0440\u0443\u0433 \u043b\u0438\u043d\u0438\u0438 id=" + etvArr[k1].getId(), g);
                                list.add(g);
                            }
                            ++k1;
                        }
                    }
                    ++k;
                }
                this.mapg.put(cfl, list);
                ++j;
            }
        }
        Calendar c = Calendar.getInstance();
        c.setTime(this.getDateFrom());
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        int i = 0;
        Calendar c2 = Calendar.getInstance();
        this.listPeriod = new ArrayList<PeriodCT>();
        while (c.getTime().before(this.getDateTill()) || c.getTime().equals(this.getDateTill())) {
            int b = i;
            c2.setTime(c.getTime());
            c2.add(5, 1);
            while (i < this.list.size() - 1 && ((AbstractNDData)this.list.get(i)).getCreatedDateTime().before(c2.getTime())) {
                ++i;
            }
            for (ControlFunctionsListExt cl : items) {
                if (cl.getDateStart() != null && !cl.getDateStart().before(c.getTime()) && !cl.getDateStart().equals(c.getTime()) || cl.getDateFinish() != null && !cl.getDateFinish().after(c.getTime()) && !cl.getDateFinish().equals(c.getTime())) continue;
                PeriodCT clf = new PeriodCT(c.getTime(), cl, b, i);
                this.listPeriod.add(clf);
            }
            if (i < this.list.size() - 1) {
                ++i;
            }
            c.setTime(c2.getTime());
        }
        ((PanelContext)((ViewerContext)this.fieldButtonLoadData.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("listPeriod");
    }

    public void createStatusList() {
    }

    public static class ListViewerT<T>
    extends ListViewer<T> {
        public ListViewerT(UIFactory<T> factory) {
            super(factory);
            this.addActionOnSelectionListener(new BeanViewerAction<AbstractContext<?>>(){

                public void actionPerformed(Object message) {
                    this.actionOnSelect();
                }
            });
        }

        protected void actionOnSelect() {
            super.actionOnSelect();
            TrackAllWithControlFunction t = (TrackAllWithControlFunction)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject());
            if (!t.showAll && t.list != null && t.list.size() > 0) {
                t.showAll = true;
                t.viewAll();
            }
            List l = this.getSelectedItems();
            if (!t.select && t.getListPeriod() != null) {
                for (PeriodCT p : t.getListPeriod()) {
                    p.setSelect(false);
                }
            }
            if (l != null && l.size() > 0 && t.getValue().getTracksNDData().size() > 0) {
                Object o = l.get(0);
                PeriodCT p = (PeriodCT)o;
                int beg = p.getBegin() - 1;
                if (beg < 0) {
                    beg = 0;
                }
                t.getValue().getTracksNDData().get(0).setSelected(new Integer[]{beg, p.getEnd()});
                t.getValue().getTracksNDData().get(0).setOnlyCurrent(true);
                t.getValue().getTracksNDData().get(0).setListGeometry(t.mapg.get((Object)p.getFunction()));
                ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("value");
                t.getValue().mapViewerWithTrack.zoomToTracks(t.getMinMax(p.begin, p.end));
            } else if (t.getValue().getTracksNDData().size() > 0) {
                t.getValue().getTracksNDData().get(0).setSelected(null);
                t.getValue().getTracksNDData().get(0).setOnlyCurrent(false);
                t.getValue().getTracksNDData().get(0).setListGeometry(null);
                ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("value");
                t.getValue().mapViewerWithTrack.zoomToTracks();
            } else {
                ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("value");
            }
        }
    }

    @ListView(views={@View(title="")})
    public static class PeriodCT {
        private Date date;
        private ControlFunctionsListExt function;
        private int begin;
        private int end;
        private boolean select = false;

        public boolean isSelect() {
            return this.select;
        }

        public void setSelect(boolean select) {
            this.select = select;
        }

        public PeriodCT(Date date, ControlFunctionsListExt function, int begin, int end) {
            this.date = date;
            this.function = function;
            this.begin = begin;
            this.end = end;
        }

        @ListField(fields={@Field(title="\u0414\u0430\u0442\u0430", order=100)})
        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        @ListField(fields={@Field(title="\u041d\u0430\u0431\u043e\u0440 \u043f\u0440\u0430\u0432\u0438\u043b", order=200)})
        public String getFunctionName() {
            return this.function.getName();
        }

        public ControlFunctionsListExt getFunction() {
            return this.function;
        }

        public void setFunction(ControlFunctionsListExt function) {
            this.function = function;
        }

        public int getBegin() {
            return this.begin;
        }

        public void setBegin(int begin) {
            this.begin = begin;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }
    }
}

