/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.core.ResourceStrings;
import ru.blok.common.ui.popup.PopupMenuManager;
import ru.blok.vms.ui.josm.zone.WatchAreaDirectoryViewer;
import ru.blok.vms.ui.mapviewer.imap.IMapViewerWithOneTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapPropertiesUItrack;
import ru.blok.vms.ui.mapviewer.ui.ProviderInfo;
import ru.blok.vms.ui.tracks.TrackAll;
import ru.blok.vms.ui.tracks.json.LoaderFromNominatim;
import ru.blok.vms.ui.transport.TransportDirectoryViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.UISetter;
import ru.infor.beanviewer.swing.viewers.TimeFormatViewer;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.action.AbstractContext;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.beanviewer.viewer.simple.date.DateWithoutButton;
import ru.infor.client.soap.proxy.vms.BuildingWSProxy;
import ru.infor.client.soap.proxy.vms.CheckPointWSProxy;
import ru.infor.client.soap.proxy.vms.NDDataWSProxy;
import ru.infor.gpx.Trkpt;
import ru.infor.ws.objects.vms.AdressNearPointParam;
import ru.infor.ws.objects.vms.MileageSearchCriteria;
import ru.infor.ws.objects.vms.NavigationPoint;
import ru.infor.ws.objects.vms.NearestAddress;
import ru.infor.ws.objects.vms.PeriodTrk;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.Building;
import ru.infor.ws.objects.vms.entities.CheckPoint;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.Transport;
import ru.infor.ws.objects.vms.entities.Transport2DeviceLink;
import ru.infor.ws.objects.vms.entities.WatchArea;

@ListView(views={@View(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0432\u0441\u0435\u0433\u043e \u043f\u0443\u0442\u0438", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class TrackAllWithPeriods
extends TrackAll {
    boolean select = false;
    private List<Period> listPeriod = new ArrayList<Period>();
    private List<RefuelingVolume> listRefuelingVolumes = new ArrayList<RefuelingVolume>();
    HashMap<Date, NavigationPoint> mapStop = new HashMap();
    SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    HashMap<String, String> sp = null;
    double min_speed = 5.4;
    long time_stop = 90000L;
    long time_move = 30000L;
    BuildingWSProxy buildingWSProxy = (BuildingWSProxy)CurrentProxyFactory.getProxy(Building.class, (String)this.getKeyPage());
    CheckPointWSProxy checkPointWSProxy = (CheckPointWSProxy)CurrentProxyFactory.getProxy(CheckPoint.class, (String)this.getKeyPage());

    public void setStop(Trkpt trkpt, PanelContext pc) {
        this.select = true;
        for (Period p : this.listPeriod) {
            if (trkpt.equals(p.getTrkpt()) || trkpt.equals(p.getTrkptstatus())) {
                p.getTrkpt().setSelect(!p.getTrkpt().isSelect());
                ((ListViewer)pc.getPanel().getPresentatorForName("listPeriod").getViewer()).getTM().setSelectedRows(new int[]{this.listPeriod.indexOf((Object)p)});
            } else if (p.getTrkpt() != null) {
                p.getTrkpt().setSelect(false);
            }
            this.select = false;
        }
    }

    public Double[] getMinMax(int i1, int i2) {
        Double minLat = ((AbstractNDData)this.list.get(i1)).getLat();
        Double maxLat = ((AbstractNDData)this.list.get(i1)).getLat();
        Double minLon = ((AbstractNDData)this.list.get(i1)).getLon();
        Double maxLon = ((AbstractNDData)this.list.get(i1)).getLon();
        int i = i1 + 1;
        while (i <= i2) {
            AbstractNDData d = (AbstractNDData)this.list.get(i);
            if (d.getLat() < minLat) {
                minLat = d.getLat();
            }
            if (d.getLat() > maxLat) {
                maxLat = d.getLat();
            }
            if (d.getLon() < minLon) {
                minLon = d.getLon();
            }
            if (d.getLon() > maxLon) {
                maxLon = d.getLon();
            }
            ++i;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @ListField(fields={@Field(title="\u0414\u0432\u0438\u0436\u0435\u043d\u0438\u0435", viewer={ListViewerT.class}, content=Period.class, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0414\u0432\u0438\u0436\u0435\u043d\u0438\u0435:0/fill#span, growy#wrap, growy 0", order=500)})
    public List<Period> getListPeriod() {
        return this.listPeriod;
    }

    public void setListPeriod(List<Period> listPeriod) {
        this.listPeriod = listPeriod;
    }

    public List<BeanViewerAction<ViewerContext>> popupListPeriod() {
        ArrayList<BeanViewerAction<ViewerContext>> l = new ArrayList<BeanViewerAction<ViewerContext>>();
        l.add(PopupMenuManager.getActionForString((String)ResourceStrings.UPLOADDATANAME));
        return l;
    }

    @Override
    public void updateUICopy() {
        this.pc.getPanel().updateUIForPresentatorName("dateFrom1");
        this.pc.getPanel().updateUIForPresentatorName("timeFrom2");
        this.pc.getPanel().updateUIForPresentatorName("dateTill1");
        this.pc.getPanel().updateUIForPresentatorName("timeTill2");
        this.pc.getPanel().updateUIForPresentatorName("transport1");
        this.pc.getPanel().updateUIForPresentatorName("listZoneID1");
    }

    @ListField(fields={@Field(title="\u0421  ", readOnly=true, order=510, viewer={DateWithoutButton.class}, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0414\u0432\u0438\u0436\u0435\u043d\u0438\u0435:m:0/fillx/n/wrap,spanx 2", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDateFrom1() {
        return this.dateFrom;
    }

    @ListField(fields={@Field(title="", order=520, readOnly=true, viewer={TimeFormatViewer.class}, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0414\u0432\u0438\u0436\u0435\u043d\u0438\u0435:m:0# w 105, wrap", propertiesUI={"format=HH:mm:ss"})})
    public Date getTimeFrom2() {
        return this.dateFrom;
    }

    @ListField(fields={@Field(title="\u043f\u043e ", readOnly=true, order=530, viewer={DateWithoutButton.class}, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0414\u0432\u0438\u0436\u0435\u043d\u0438\u0435:m:0# w 100,", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDateTill1() {
        return this.dateTill;
    }

    @ListField(fields={@Field(title="", readOnly=true, order=540, viewer={TimeFormatViewer.class}, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0414\u0432\u0438\u0436\u0435\u043d\u0438\u0435:m:0# w 105,wrap", propertiesUI={"format=HH:mm:ss"})})
    public Date getTimeTill2() {
        return this.dateTill;
    }

    @ListField(fields={@Field(title="\u0422\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442 ", readOnly=true, content=Transport.class, order=550, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0414\u0432\u0438\u0436\u0435\u043d\u0438\u0435:m#w 300, wrap", propertiesField={"setKeyView=withoutROA"}, viewer={TransportDirectoryViewer.class})})
    public Transport getTransport1() {
        return super.getTransport();
    }

    @ListField(fields={@Field(title="\u041e\u0431\u043b\u0430\u0441\u0442\u0438 ", readOnly=true, content=WatchArea.class, order=560, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0414\u0432\u0438\u0436\u0435\u043d\u0438\u0435:m#w 300, wrap", viewer={WatchAreaDirectoryViewer.class})})
    public Long[] getListZoneID1() {
        return this.listZoneID;
    }

    @ListField(fields={@Field(title="\u0422\u043e\u043f\u043b\u0438\u0432\u043e", viewer={ListViewerT.class}, content=RefuelingVolume.class, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0422\u043e\u043f\u043b\u0438\u0432\u043e", order=600)})
    public List<RefuelingVolume> getListRefuelingVolumes() {
        return this.listRefuelingVolumes;
    }

    public void setListRefuelingVolumes(List<RefuelingVolume> listRefuelingVolumes) {
        this.listRefuelingVolumes = listRefuelingVolumes;
    }

    public TrackAllWithPeriods(String keyPage) {
        super(keyPage);
        if (InitializedVariable.getWorkplaceId((String)keyPage) != null) {
            this.sp = InitializedVariable.runtimeParameters((String)keyPage, (Long)InitializedVariable.getWorkplaceId((String)keyPage));
            if (this.sp.get("MinSpeedForPeriods") != null) {
                try {
                    this.min_speed = Double.valueOf(this.sp.get("MinSpeedForPeriods"));
                }
                catch (Exception exception) {}
            }
            if (this.sp.get("MinTimeStopForPeriods") != null) {
                try {
                    this.time_stop = Integer.valueOf(this.sp.get("MinTimeStopForPeriods")) * 1000;
                }
                catch (Exception exception) {}
            }
            if (this.sp.get("MinTimeMoveForPeriods") != null) {
                try {
                    this.time_move = Integer.valueOf(this.sp.get("MinTimeMoveForPeriods")) * 1000;
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void beforeShow(PanelContext pc) {
        super.beforeShow(pc);
        this.setVisibleToTab(pc.getPanel());
    }

    public void setVisibleToTab(UISetter<?> panel) {
    }

    @Override
    public synchronized void reload(List<AbstractNDData> list1) {
        this.setListPeriod(null);
        ((PanelContext)((ViewerContext)this.fieldButtonLoadData.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("listPeriod");
        super.reload(list1);
        ((PanelContext)((ViewerContext)this.fieldButtonLoadData.getContext()).getParentContext()).getPanel().getFactory().setCursor(1, ((ViewerContext)this.fieldButtonLoadData.getContext()).getKeyPage());
        this.setPeriods();
        ((PanelContext)((ViewerContext)this.fieldButtonLoadData.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("listRefuelingVolumes");
        ((PanelContext)((ViewerContext)this.fieldButtonLoadData.getContext()).getParentContext()).getPanel().getFactory().setCursor(0, ((ViewerContext)this.fieldButtonLoadData.getContext()).getKeyPage());
    }

    private void setPeriods() {
        this.listPeriod = new ArrayList<Period>();
        Period curPeriod = null;
        ((IMapViewerWithOneTrack)this.value.mapViewerWithTrack).clearMisc();
        int i = 0;
        while (i < this.list.size()) {
            NDData d = (NDData)this.list.get(i);
            if (d.getSpeed() == null || d.getSpeed() < this.min_speed) {
                if (i > 0) {
                    d.setLat(((AbstractNDData)this.list.get(i - 1)).getLat());
                    d.setLon(((AbstractNDData)this.list.get(i - 1)).getLon());
                }
                if (curPeriod == null || curPeriod.getType() != PeriodTrk.STOP) {
                    if (curPeriod != null) {
                        curPeriod.setDateTill(d.getCreatedDateTime());
                        curPeriod.setEnd(i);
                        curPeriod.setLongDate(curPeriod.getDateTill().getTime() - curPeriod.getDateFrom().getTime());
                    }
                    if (curPeriod != null && curPeriod.getLongDate() < this.time_move) {
                        if (this.listPeriod.size() > 1) {
                            curPeriod = this.listPeriod.get(this.listPeriod.size() - 2);
                            this.listPeriod.remove(this.listPeriod.size() - 1);
                        } else {
                            curPeriod.setType(PeriodTrk.STOP);
                        }
                    } else {
                        curPeriod = new Period(d.getDeviceId());
                        curPeriod.setNum(this.listPeriod.size() + 1);
                        curPeriod.setDateFrom(d.getCreatedDateTime());
                        curPeriod.setBegin(i);
                        curPeriod.setType(PeriodTrk.STOP);
                        this.listPeriod.add(curPeriod);
                    }
                }
            } else if (curPeriod == null || curPeriod.getType() != PeriodTrk.SPEED) {
                if (curPeriod != null) {
                    curPeriod.setDateTill(d.getCreatedDateTime());
                    curPeriod.setEnd(i);
                    curPeriod.setLongDate(curPeriod.getDateTill().getTime() - curPeriod.getDateFrom().getTime());
                    this.setCoordFromStop(curPeriod.getDateFrom(), ((AbstractNDData)this.list.get(curPeriod.getEnd())).getLat(), ((AbstractNDData)this.list.get(curPeriod.getEnd())).getLon());
                }
                if (curPeriod != null && curPeriod.getLongDate() < this.time_stop) {
                    if (this.listPeriod.size() > 1) {
                        curPeriod = this.listPeriod.get(this.listPeriod.size() - 2);
                        this.listPeriod.remove(this.listPeriod.size() - 1);
                    } else {
                        curPeriod.setType(PeriodTrk.SPEED);
                    }
                } else {
                    curPeriod = new Period(d.getDeviceId());
                    curPeriod.setNum(this.listPeriod.size() + 1);
                    curPeriod.setDateFrom(d.getCreatedDateTime());
                    curPeriod.setBegin(i);
                    curPeriod.setType(PeriodTrk.SPEED);
                    this.listPeriod.add(curPeriod);
                }
            }
            ++i;
        }
        if (curPeriod != null) {
            curPeriod.setDateTill(((AbstractNDData)this.list.get(this.list.size() - 1)).getCreatedDateTime());
            curPeriod.setEnd(this.list.size() - 1);
            curPeriod.setLongDate(curPeriod.getDateTill().getTime() - curPeriod.getDateFrom().getTime());
        }
        this.createStatusList();
        NDDataWSProxy ndDataWSProxy = (NDDataWSProxy)CurrentProxyFactory.getProxy(NDData.class, (String)this.getKeyPage());
        AdressNearPointParam an = new AdressNearPointParam();
        an.setRadius(Integer.valueOf(500));
        an.setLimit(Integer.valueOf(1));
        ArrayList<MileageSearchCriteria> scList = new ArrayList<MileageSearchCriteria>();
        ArrayList<Trkpt> parkingPoints = new ArrayList<Trkpt>();
        int j = 0;
        while (j < this.listPeriod.size()) {
            Period curP = this.listPeriod.get(j);
            if (PeriodTrk.SPEED == curP.getType()) {
                MileageSearchCriteria sc1 = new MileageSearchCriteria();
                sc1.setDeviceId(this.findDeviceId(curP.getDateFrom(), curP.getDateTill()));
                sc1.setCreatedDateTimeFrom(curP.getDateFrom());
                sc1.setCreatedDateTimeTill(curP.getDateTill());
                scList.add(sc1);
            }
            ++j;
        }
        Double[] rez = null;
        if (scList != null && scList.size() > 0) {
            rez = ndDataWSProxy.getListMileage(InitializedVariable.getContext((String)this.getKeyPage()), scList.toArray(new MileageSearchCriteria[scList.size()]));
        }
        int jj = 0;
        int j2 = 0;
        while (j2 < this.listPeriod.size()) {
            Trkpt p2d;
            Period curP = this.listPeriod.get(j2);
            if (PeriodTrk.SPEED == curP.getType() && rez != null && rez.length > 0) {
                curP.setAddr(String.valueOf(new DecimalFormat("###0.##").format(rez[jj] / 1000.0)) + " \u043a\u043c  ( " + new DecimalFormat("###0").format(rez[jj] * 3600.0 / (double)curP.getLongDate()) + " \u043a\u043c/\u0447 )");
                ++jj;
            } else {
                String ss;
                String mm;
                an.setLat(((AbstractNDData)this.list.get(curP.getBegin())).getLat());
                an.setLon(((AbstractNDData)this.list.get(curP.getBegin())).getLon());
                p2d = new Trkpt();
                p2d.setLat(an.getLat());
                p2d.setLon(an.getLon());
                p2d.setType(0);
                Long l = (((AbstractNDData)this.list.get(curP.getEnd())).getCreatedDateTime().getTime() - ((AbstractNDData)this.list.get(curP.getBegin())).getCreatedDateTime().getTime()) / 1000L;
                long h = l / 3600L;
                l = l - h * 60L * 60L;
                long m = l / 60L;
                l = l - m * 60L;
                String hh = Long.toString(h);
                if (hh.length() < 2) {
                    hh = "0" + hh;
                }
                if ((mm = Long.toString(m)).length() < 2) {
                    mm = "0" + mm;
                }
                if ((ss = Long.toString(l)).length() < 2) {
                    ss = "0" + ss;
                }
                String state = String.valueOf(hh) + ":" + mm + ":" + ss;
                p2d.setHint(new String[]{"\u041d\u0430\u0447\u0430\u043b\u043e: " + this.df.format(((AbstractNDData)this.list.get(curP.getBegin())).getCreatedDateTime()), "\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435: " + this.df.format(((AbstractNDData)this.list.get(curP.getEnd())).getCreatedDateTime()), "\u0412\u0440\u0435\u043c\u044f: " + state});
                parkingPoints.add(p2d);
                curP.setTrkpt(p2d);
                NearestAddress[] ad = null;
                ad = this.checkPointWSProxy.getListNearCheckPoint(InitializedVariable.getContext((String)this.getKeyPage()), an);
                if (ad != null && ad.length > 0) {
                    curP.setAddr(ad[0].getAddress());
                } else {
                    try {
                        ad = this.buildingWSProxy.getListNearAdress(InitializedVariable.getContext((String)this.getKeyPage()), an);
                        if (ad != null && ad.length > 0) {
                            curP.setAddr(ad[0].getAddress());
                        } else if (this.lookUpAddress) {
                            curP.setAddr(LoaderFromNominatim.getNearAdress(((AbstractNDData)this.list.get(curP.getEnd())).getLat(), ((AbstractNDData)this.list.get(curP.getEnd())).getLon()));
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (curP.getStatus() != null) {
                p2d = new Trkpt();
                p2d.setLat(((AbstractNDData)this.list.get(curP.getEnd())).getLat());
                p2d.setLon(((AbstractNDData)this.list.get(curP.getEnd())).getLon());
                parkingPoints.add(p2d);
                p2d.setType(1);
                curP.setTrkptstatus(p2d);
            }
            ++j2;
        }
        ((IMapViewerWithOneTrack)this.value.mapViewerWithTrack).setParkingPoints(this.listPeriod);
        ((IMapViewerWithOneTrack)this.value.mapViewerWithTrack).setViewParking(1);
        ((PanelContext)((ViewerContext)this.fieldButtonLoadData.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("listPeriod");
    }

    public void createStatusList() {
    }

    private void setCoordFromStop(Date dateFrom, Double lat, Double lon) {
        NavigationPoint np = new NavigationPoint();
        if (this.mapStop.get(dateFrom) != null) {
            np = this.mapStop.get(dateFrom);
        }
        np.setLat(lat);
        np.setLon(lon);
        this.mapStop.put(dateFrom, np);
    }

    private Long findDeviceId(Date dateFrom, Date dateTill) {
        Long deviceId = this.getDevice().getId();
        Object[] obj = this.getLinkT2D().getObjList();
        int i = 0;
        while (i < obj.length) {
            Transport2DeviceLink link = (Transport2DeviceLink)obj[i];
            if (link.getDevice() != null && link.getDevice().getId() != null) {
                Date dBeginLink = link.getBeginDate();
                Date dEndLink = link.getEndDate();
                if (dateFrom.after(dBeginLink) && (dEndLink == null || dateTill.before(dEndLink))) {
                    return link.getDevice().getId();
                }
            }
            ++i;
        }
        return deviceId;
    }

    public static class ListViewerT<T>
    extends ListViewer<T> {
        public ListViewerT(UIFactory<T> factory) {
            super(factory);
            this.addActionOnSelectionListener(new BeanViewerAction<AbstractContext<?>>(){

                public void actionPerformed(Object message) {
                    this.actionOnSelect();
                }
            });
        }

        protected void actionOnSelect() {
            super.actionOnSelect();
            List l = this.getSelectedItems();
            TrackAllWithPeriods t = (TrackAllWithPeriods)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject());
            if (!t.select && t.getListPeriod() != null) {
                for (Period p : t.getListPeriod()) {
                    if (p.getTrkpt() == null) continue;
                    p.getTrkpt().setSelect(false);
                }
            }
            if (l != null && l.size() > 0 && t.getValue().getTracksNDData().size() > 0) {
                Object p;
                Object o = l.get(0);
                if (o instanceof Period) {
                    p = (Period)((Object)o);
                    if (p.getType() == PeriodTrk.STOP) {
                        t.getValue().getTracksNDData().get(0).setSelectedPoint(new Integer[]{p.getBegin()});
                        t.setState(p.getBegin(), false);
                    } else {
                        int beg = p.getBegin() - 1;
                        if (beg < 0) {
                            beg = 0;
                        }
                        t.getValue().getTracksNDData().get(0).setSelected(new Integer[]{beg, p.getEnd()});
                        t.setState(beg, false);
                    }
                    if (p.getTrkpt() != null && !t.select) {
                        p.getTrkpt().setSelect(true);
                    }
                    ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("value");
                    if (p.getType() == PeriodTrk.STOP) {
                        AbstractNDData d = t.getValue().getTracksNDData().get(0).getNodes().get(p.getBegin());
                        t.getValue().mapViewerWithTrack.setCenterPosition(new double[]{d.getLat(), d.getLon()});
                        ProviderInfo p1 = ((MapPropertiesUItrack)t.getValue().mapViewerWithTrack.getUIProperties()).getProvidersInfo();
                        int z = (int)((double)p1.getMinLevel() + (double)(p1.getMaxLevel() - p1.getMinLevel()) * 0.2);
                        if (z < ((MapPropertiesUItrack)t.getValue().mapViewerWithTrack.getUIProperties()).getMaxzoom()) {
                            z = ((MapPropertiesUItrack)t.getValue().mapViewerWithTrack.getUIProperties()).getMaxzoom();
                        }
                        t.getValue().setZoomValue(z);
                    } else {
                        int z = t.getValue().mapViewerWithTrack.getZoom(t.getMinMax(p.getBegin(), p.getEnd()));
                        if (z < ((MapPropertiesUItrack)t.getValue().mapViewerWithTrack.getUIProperties()).getMaxzoom()) {
                            z = ((MapPropertiesUItrack)t.getValue().mapViewerWithTrack.getUIProperties()).getMaxzoom();
                        }
                        AbstractNDData d0 = t.getValue().getTracksNDData().get(0).getNodes().get(p.getBegin());
                        AbstractNDData d1 = t.getValue().getTracksNDData().get(0).getNodes().get(p.getEnd());
                        t.getValue().mapViewerWithTrack.setCenterPosition(new double[]{(d0.getLat() + d1.getLat()) / 2.0, (d0.getLon() + d1.getLon()) / 2.0});
                        t.getValue().setZoomValue(z);
                    }
                } else {
                    p = (RefuelingVolume)o;
                    t.getValue().getTracksNDData().get(0).setSelected(new Integer[]{((RefuelingVolume)p).begin, ((RefuelingVolume)p).end}, new Integer[]{((RefuelingVolume)p).begin, ((RefuelingVolume)p).end});
                    t.setState(((RefuelingVolume)p).begin, false);
                    ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("value");
                    t.getValue().mapViewerWithTrack.zoomToTracks(t.getMinMax(((RefuelingVolume)p).begin, ((RefuelingVolume)p).end));
                }
            }
        }
    }

    @ListView(views={@View(title="")})
    public static class Period
    extends PeriodTrk {
        private static final long serialVersionUID = -3763955842246069373L;
        private Trkpt trkpt;
        private Trkpt trkptstatus;
        private String status;

        public Trkpt getTrkptstatus() {
            return this.trkptstatus;
        }

        public void setTrkptstatus(Trkpt trkptstatus) {
            this.trkptstatus = trkptstatus;
        }

        @ListField(fields={@Field(title="\u0418\u043d\u0444\u043e", order=700)})
        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Period(Long deviceId) {
            super(deviceId);
        }

        public Trkpt getTrkpt() {
            return this.trkpt;
        }

        public void setTrkpt(Trkpt trkpt) {
            this.trkpt = trkpt;
        }

        @ListField(fields={@Field(title="\u0422\u0438\u043f", order=500)})
        public String getTypeString() {
            return super.getTypeString();
        }

        @ListField(fields={@Field(title="\u0412\u0440\u0435\u043c\u044f", order=400)})
        public String getLongString() {
            return super.getLongString();
        }

        @ListField(fields={@Field(title="\u2116 \u043f\u043f", order=100)})
        public int getNum() {
            return super.getNum();
        }

        @ListField(fields={@Field(title="\u0421", order=200)})
        public Date getDateFrom() {
            return super.getDateFrom();
        }

        @ListField(fields={@Field(title="\u041f\u043e", order=300)})
        public Date getDateTill() {
            return super.getDateTill();
        }

        @ListField(fields={@Field(title="\u0410\u0434\u0440\u0435\u0441", order=600)})
        public String getAddr() {
            return super.getAddr();
        }
    }

    @ListView(views={@View(title="")})
    public static class RefuelingVolume {
        private Date date;
        private Double volume;
        private int num;
        private int begin;
        private int end;

        public int getBegin() {
            return this.begin;
        }

        public void setBegin(int begin) {
            this.begin = begin;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        @ListField(fields={@Field(title="\u0412\u0440\u0435\u043c\u044f", order=100)})
        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        @ListField(fields={@Field(title="\u041e\u0431\u044a\u0435\u043c", order=200, viewer={ViewerDoubleFormat.class})})
        public Double getVolume() {
            return this.volume;
        }

        public void setVolume(Double volume) {
            this.volume = volume;
        }

        public int getNum() {
            return this.num;
        }

        public void setNum(int num) {
            this.num = num;
        }
    }

    public static class ViewerDoubleFormat<T>
    extends DefaultTableCellViewer<T> {
        DecimalFormat df = new DecimalFormat("###0.##");

        public ViewerDoubleFormat(UIFactory<T> factory) {
            super(factory);
        }

        public Class<? extends FieldViewer<T>> getTableCellViewerClass() {
            return ViewerDoubleFormat.class;
        }

        public void setValue(Object object) {
            if (object == null) {
                super.setValue(object);
            } else {
                String s = String.valueOf(this.df.format(object)) + " \u043b";
                super.setValue((Object)s);
            }
        }
    }

    public static class ViewerType<T>
    extends DefaultTableCellViewer<T> {
        public ViewerType(UIFactory<T> factory) {
            super(factory);
        }

        public Class<? extends FieldViewer<T>> getTableCellViewerClass() {
            return ViewerType.class;
        }

        public void setValue(Object object) {
            if (object == null) {
                super.setValue(object);
            } else if ((Integer)object == PeriodTrk.STOP) {
                super.setValue((Object)"P");
            } else if ((Integer)object == PeriodTrk.SPEED) {
                super.setValue((Object)">");
            }
        }
    }
}

