/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.core.ResourceStrings;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapViewerWithOneTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.NodeType;
import ru.blok.vms.ui.tracks.OneTrack;
import ru.blok.vms.ui.transport.TransportDirectoryToDeviceViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.swing.viewers.ListActionViewer;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.vms.NDDataWSProxy;
import ru.infor.client.soap.proxy.vms.NavigationDeviceWSProxy;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.vms.AdvancedSearchItem;
import ru.infor.ws.objects.vms.NDDataSearchCriteria;
import ru.infor.ws.objects.vms.NDDataThin;
import ru.infor.ws.objects.vms.NavigationDeviceSearchCriteria;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.NavigationDevice;

public class TrackInRealTimeCommon
extends CommonObjectWithKey {
    Long[] listID = null;
    Object[] listLastPoint;
    MapValueWithTrack value;
    boolean showHint = false;
    String infoOnGPSDevice = "0100000";
    String apiKeyForCloudmade = null;
    String apiKeyForMapQuest = null;
    boolean newMap = true;
    long waitSec = 3L;
    int state = 0;
    List<OneTrack> list = new ArrayList<OneTrack>();
    int currentLoad = 0;
    int currentView = 0;
    List<BeanViewerAction<ViewerContext>> listEasyBt = new ArrayList<BeanViewerAction<ViewerContext>>();
    List<BeanViewerAction<ViewerContext>> listGroup1Bt = new ArrayList<BeanViewerAction<ViewerContext>>();
    List<BeanViewerAction<ViewerContext>> listGroup2Bt = new ArrayList<BeanViewerAction<ViewerContext>>();
    HashMap<String, String> sp = null;
    BeanViewerAction<ViewerContext> btPlay = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            TrackInRealTimeCommon.this.playAndRefreshMap((ViewerContext)this.getContext());
        }

        public String getIcon() {
            return ResourceStrings.btPlayBlue;
        }
    };
    BeanViewerAction<ViewerContext> btStop = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            TrackInRealTimeCommon.this.stop((ViewerContext)this.getContext());
            TrackInRealTimeCommon.this.refreshMap((ViewerContext)this.getContext());
        }

        public String getIcon() {
            return ResourceStrings.btStopBlue;
        }
    };

    public TrackInRealTimeCommon(String keyPage) {
        super(keyPage);
        if (InitializedVariable.getWorkplaceId((String)keyPage) != null) {
            this.sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.getWorkplaceId((String)keyPage));
            if (this.sp.get("InfoOnGPSDevice") != null) {
                this.setInfoOnGPSDevice(this.sp.get("InfoOnGPSDevice"));
            }
            if (this.sp.get("ApiKeyForCloudmade") != null) {
                this.setApiKeyForCloudmade(this.sp.get("ApiKeyForCloudmade"));
            }
        }
        this.state = 0;
        this.value = new MapValueWithTrack();
        if (this.list != null) {
            this.list.clear();
        }
    }

    @ListField(fields={@Field(title="", order=500, viewer={MapViewerWithOneTrack.class}, propertiesLayout="Split1/h/r/0.25")})
    public MapValueWithTrack getValue() {
        return this.value;
    }

    @ListField(fields={@Field(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u043d\u0430\u0434\u043f\u0438\u0441\u0438", order=30, propertiesLayout="Split1/h/l/0.25:0///#w 300")})
    public boolean isShowHint() {
        return this.showHint;
    }

    public void setShowHint(boolean showHint) {
        this.showHint = showHint;
    }

    @ListField(fields={@Field(title="", propertiesUI={"onlyOnePressed=false"}, order=40, propertiesLayout="Split1/h/l/0.25:1", viewer={ListActionViewer.class})})
    public List<BeanViewerAction<ViewerContext>> getListEasyBt() {
        return this.listEasyBt;
    }

    public void addListEasyBt(BeanViewerAction<ViewerContext> newA) {
        this.listEasyBt.add(newA);
    }

    @ListField(fields={@Field(title="", propertiesUI={"onlyOnePressed=true"}, order=45, propertiesLayout="Split1/h/l/0.25:1", viewer={ListActionViewer.class})})
    public List<BeanViewerAction<ViewerContext>> getListGroup1Bt() {
        return this.listGroup1Bt;
    }

    public void addListGroup1Bt(BeanViewerAction<ViewerContext> newA) {
        this.listGroup1Bt.add(newA);
    }

    @ListField(fields={@Field(title="", propertiesUI={"onlyOnePressed=true"}, order=50, propertiesLayout="Split1/h/l/0.25:1", viewer={ListActionViewer.class})})
    public List<BeanViewerAction<ViewerContext>> getListGroup2Bt() {
        return this.listGroup2Bt;
    }

    public void addListGroup2Bt(BeanViewerAction<ViewerContext> newA) {
        this.listGroup2Bt.add(newA);
    }

    @ListField(fields={@Field(title="\u0422\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442 ", content=AdvancedSearchItem.class, order=50, propertiesLayout="Split1/h/l/0.25:2///#w 300", viewer={TransportDirectoryToDeviceViewer.class}, propertiesField={"clazz=ru.blok.vms.ui.VMSAsyncDirectoryViewerForID"})})
    public Long[] getListID() {
        return this.listID;
    }

    public Long[] getFullListID() {
        if (this.getListID() == null) {
            NavigationDeviceSearchCriteria scND = new NavigationDeviceSearchCriteria();
            scND.setCount(Integer.valueOf(Integer.MAX_VALUE));
            NavigationDeviceWSProxy.SearchResultListNavigationDevice sr = ((NavigationDeviceWSProxy)CurrentProxyFactory.getProxy(NavigationDevice.class)).getList(InitializedVariable.context, scND);
            if (sr.isEmpty()) {
                return null;
            }
            ArrayList<Long> deviceIdList = new ArrayList<Long>();
            int i = 0;
            while (i < sr.getObjList().length) {
                deviceIdList.add(((NavigationDevice)sr.getObjList()[i]).getId());
                ++i;
            }
            return deviceIdList.toArray(new Long[deviceIdList.size()]);
        }
        return this.listID;
    }

    public void setListID(Long[] listID) {
        this.listID = listID;
    }

    public void loadListLastPoint() {
        NDDataWSProxy proxy = (NDDataWSProxy)CurrentProxyFactory.getProxy(NDData.class);
        NDDataSearchCriteria sc = new NDDataSearchCriteria();
        sc = (NDDataSearchCriteria)proxy._getSearchCriteriaTemplate();
        sc.setDeviceIdList(this.getFullListID());
        sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        sc.appendSorting(SortObject.getInstance((String)"createdDateTime", (String)SortObject.DIRECTION_ASC));
        this.listLastPoint = proxy.getLastDataThin(InitializedVariable.context, sc);
        System.out.println(this.listLastPoint.length);
    }

    public void loadData() {
        this.loadListLastPoint();
        if (this.listLastPoint != null) {
            int i = 0;
            while (i < this.listLastPoint.length) {
                OneTrack track = new OneTrack(((NDDataThin)this.listLastPoint[i]).getDeviceId(), new ArrayList<NDData>(), null);
                this.list.add(track);
                NDData data = new NDData();
                data.setCreatedDateTime(((NDDataThin)this.listLastPoint[i]).getCreatedDateTime());
                data.setDeviceId(((NDDataThin)this.listLastPoint[i]).getDeviceId());
                data.setLat(((NDDataThin)this.listLastPoint[i]).getLat());
                data.setLon(((NDDataThin)this.listLastPoint[i]).getLon());
                data.setId(((NDDataThin)this.listLastPoint[i]).getId());
                this.list.get(i).pushNDData(data);
                new Thread(new Runnable(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        NDDataWSProxy proxy = (NDDataWSProxy)CurrentProxyFactory.getProxy(NDData.class);
                        int cur = TrackInRealTimeCommon.this.incCurrentLoad();
                        NDDataSearchCriteria sc = new NDDataSearchCriteria();
                        sc = (NDDataSearchCriteria)proxy._getSearchCriteriaTemplate();
                        sc.appendSorting(SortObject.getInstance((String)"createdDateTime", (String)SortObject.DIRECTION_ASC));
                        sc.setDeviceIdList(new Long[]{TrackInRealTimeCommon.this.list.get(cur).getDeviceId()});
                        Date dateS = null;
                        Date dateE = null;
                        int curState = TrackInRealTimeCommon.this.getState();
                        while (curState == 1) {
                            try {
                                if (dateS == null) {
                                    dateS = TrackInRealTimeCommon.this.list.get((int)cur).list != null && TrackInRealTimeCommon.this.list.get((int)cur).list.size() > 0 ? TrackInRealTimeCommon.this.list.get((int)cur).list.get(0).getCreatedDateTime() : new Date();
                                } else {
                                    dateE = new Date();
                                    sc.setCreatedDateTimeFrom(dateS);
                                    sc.setCreatedDateTimeTill(dateE);
                                    Object[] tl = proxy.getList(InitializedVariable.context, sc).getObjList();
                                    if (tl != null) {
                                        Object[] objectArray = tl;
                                        int n = tl.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            Object d = objectArray[n2];
                                            TrackInRealTimeCommon.this.list.get(cur).pushNDData((NDData)d);
                                            dateS = ((NDData)d).getCreatedDateTime();
                                            ++n2;
                                        }
                                    }
                                }
                                try {
                                    long i = 0L;
                                    curState = TrackInRealTimeCommon.this.getState();
                                    while (i < TrackInRealTimeCommon.this.waitSec && curState == 1) {
                                        Thread.sleep(1000L);
                                        curState = TrackInRealTimeCommon.this.getState();
                                        ++i;
                                    }
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            catch (Exception exception) {
                                return;
                            }
                        }
                    }
                }).start();
                ++i;
            }
        }
    }

    public synchronized Double getAngle(NDData prev, NDData last) {
        Double angle = null;
        Double len = Math.sqrt((last.getLon() - prev.getLon()) * (last.getLon() - prev.getLon()) + (last.getLat() - prev.getLat()) * (last.getLat() - prev.getLat()));
        if (len > 1.0E-10) {
            angle = Math.asin((last.getLat() - prev.getLat()) / len);
            angle = 90.0 - 180.0 * angle / Math.PI;
            if (last.getLon() - prev.getLon() > 0.0) {
                angle = 360.0 - angle;
            }
            angle = 360.0 - angle;
        }
        return angle;
    }

    public synchronized void viewPoint(int cur, NDData data, boolean curOnly, Double angle) {
        this.value.event((long)data.getDeviceId(), (AbstractNDData)data, curOnly, angle, this.getInfoOnGPSDevice(), NodeType.DEFAULT, null, curOnly);
    }

    public void runView() {
        if (this.value != null) {
            if (this.newMap) {
                double[] latlon = this.value.getCenterPosition();
                this.value = new MapValueWithTrack(latlon[0], latlon[1], this.value.getZoomValue(), this.value.getTypeMapObject());
            }
        } else {
            this.value = new MapValueWithTrack();
        }
        int i = 0;
        while (i < this.list.size()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    int cur = TrackInRealTimeCommon.this.getCurrentView();
                    NDData data = null;
                    long sl = 0L;
                    NDData prev = null;
                    Double angle = null;
                    int curState = TrackInRealTimeCommon.this.getState();
                    while (curState == 1) {
                        sl = 2000L;
                        try {
                            data = TrackInRealTimeCommon.this.list.get(cur).popNDData();
                            prev = TrackInRealTimeCommon.this.list.get(cur).getPrev();
                            if (data != null) {
                                if (prev != null) {
                                    angle = TrackInRealTimeCommon.this.getAngle(prev, data);
                                }
                                TrackInRealTimeCommon.this.viewPoint(cur, data, true, angle);
                                if (prev != null) {
                                    sl = data.getCreatedDateTime().getTime() - prev.getCreatedDateTime().getTime();
                                }
                                TrackInRealTimeCommon.this.list.get(cur).setPrev(data);
                            }
                            try {
                                Thread.sleep(Math.abs(sl));
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            curState = TrackInRealTimeCommon.this.getState();
                        }
                        catch (Exception exception) {
                            curState = 0;
                        }
                    }
                }
            }).start();
            ++i;
        }
    }

    synchronized int incCurrentLoad() {
        int temp = this.currentLoad++;
        return temp;
    }

    synchronized int getCurrentLoad() {
        return this.currentLoad;
    }

    synchronized int getCurrentView() {
        int temp = this.currentView++;
        return temp;
    }

    public synchronized void play(ViewerContext context) {
        this.currentView = 0;
        this.currentLoad = 0;
        if (this.list != null) {
            this.list.clear();
        }
        this.setPlayStopButton(context, false, true);
        this.state = 1;
        this.loadData();
        this.runView();
    }

    public synchronized void stop(ViewerContext context) {
        if (this.state == 1) {
            this.state = 0;
        }
        this.setPlayStopButton(context, true, false);
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setPlayStopButton(ViewerContext context, boolean playe, boolean pausee) {
        FieldPresentation fPause;
        FieldPresentation fPlay = ((PanelContext)context.getParentContext()).getPanel().getPresentatorForName("btPlay");
        if (fPlay != null) {
            fPlay.getViewer().setEditable(playe);
        }
        if ((fPause = ((PanelContext)context.getParentContext()).getPanel().getPresentatorForName("btStop")) != null) {
            fPause.getViewer().setEditable(pausee);
        }
    }

    public void refreshMap(ViewerContext context) {
        if (this.value.mapViewerWithTrack != null) {
            int zoom = this.value.getZoomValue();
            double[] gp = this.value.getCenterPosition();
            ((PanelContext)context.getParentContext()).getPanel().updateUI();
            this.value.setZoomValue(zoom);
            this.value.setCenterPosition(gp);
        } else {
            ((PanelContext)context.getParentContext()).getPanel().updateUI();
        }
    }

    public BeanViewerAction<ViewerContext> getBtPlay() {
        return this.btPlay;
    }

    public void playAndRefreshMap(ViewerContext context) {
        ((PanelContext)context.getParentContext()).getPanel().updateMainObject();
        this.play(context);
        this.refreshMap(context);
    }

    public BeanViewerAction<ViewerContext> getBtStop() {
        return this.btStop;
    }

    public String getInfoOnGPSDevice() {
        return this.infoOnGPSDevice;
    }

    public void setInfoOnGPSDevice(String infoOnGPSDevice) {
        this.infoOnGPSDevice = infoOnGPSDevice;
    }

    public String getApiKeyForCloudmade() {
        return this.apiKeyForCloudmade;
    }

    public void setApiKeyForCloudmade(String apiKeyForCloudmade) {
        this.apiKeyForCloudmade = apiKeyForCloudmade;
    }

    public String getApiKeyForMapQuest() {
        return this.apiKeyForMapQuest;
    }

    public void setApiKeyForMapQuest(String apiKeyForMapQuest) {
        this.apiKeyForMapQuest = apiKeyForMapQuest;
    }
}

