/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.text.DateFormatter;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.tracks.cache.ClassToCache;
import ru.infor.beanviewer.dialog.ErrorMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.common.SysProperties;
import ru.infor.ws.objects.vms.NDDataCachePeriod;
import ru.infor.ws.objects.vms.entities.AbstractNDData;

public class CacheBase {
    private static String cachePrefix = "";
    private static DateFormatter dateFormat3;
    private static DateFormatter dateFormat2;
    private static DateFormatter dateFormat1;
    List<AbstractNDData> list;
    Integer countAll;

    static {
        String cacheDataFolder = SysProperties.getProperty((String)"cache.data.folder", (String)"");
        if (!cacheDataFolder.trim().equals("")) {
            cacheDataFolder = String.valueOf(cacheDataFolder) + File.separator;
        }
        cachePrefix = String.valueOf(cacheDataFolder) + "data" + File.separator + "NDdata" + File.separator;
        dateFormat3 = new DateFormatter(new SimpleDateFormat("yyyyMMddHH"));
        dateFormat2 = new DateFormatter(new SimpleDateFormat("yyyyMMdd"));
        dateFormat1 = new DateFormatter(new SimpleDateFormat("yyyyMM"));
    }

    public static void clearCache(final Date datefrom, final Date datetill, final Long deviceId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Calendar datef = Calendar.getInstance();
                datef.setTime(datefrom);
                Calendar datee = Calendar.getInstance();
                datee.setTime(datetill);
                Calendar df = Calendar.getInstance();
                df.setTime(datefrom);
                df.set(12, 0);
                df.set(13, 0);
                df.set(14, 0);
                Calendar ed = Calendar.getInstance();
                ed.setTime(datetill);
                ed.set(12, 59);
                ed.set(13, 59);
                ed.set(14, 999);
                Calendar c = Calendar.getInstance();
                String pref = String.valueOf(cachePrefix) + deviceId + File.separator;
                boolean error = false;
                while (df.before(ed) && !error) {
                    try {
                        File bf = new File(String.valueOf(pref) + dateFormat1.valueToString(df.getTime()) + File.separator + dateFormat2.valueToString(df.getTime()) + File.separator + dateFormat3.valueToString(df.getTime()) + ".data");
                        if (bf.exists()) {
                            bf.delete();
                        }
                        df.add(11, 1);
                        c.setTime(df.getTime());
                        c.add(14, -1);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    public List<Object[]> getDataFromCache(Date datefrom, Date datetill, Long deviceId) {
        ArrayList<Object[]> cache = new ArrayList<Object[]>();
        this.list = new ArrayList<AbstractNDData>();
        Calendar datef = Calendar.getInstance();
        datef.setTime(datefrom);
        Calendar datee = Calendar.getInstance();
        datee.setTime(datetill);
        Calendar df = Calendar.getInstance();
        df.setTime(datefrom);
        df.set(12, 0);
        df.set(13, 0);
        df.set(14, 0);
        Calendar ed = Calendar.getInstance();
        ed.setTime(datetill);
        ed.set(12, 59);
        ed.set(13, 59);
        ed.set(14, 999);
        Calendar c = Calendar.getInstance();
        String pref = String.valueOf(cachePrefix) + deviceId + File.separator;
        this.countAll = 0;
        boolean error = false;
        while (df.before(ed) && !error) {
            NDDataCachePeriod p = new NDDataCachePeriod();
            p.setStartAt(df.getTime());
            p.setCount(Integer.valueOf(0));
            try {
                File bf = new File(String.valueOf(pref) + dateFormat1.valueToString(df.getTime()) + File.separator + dateFormat2.valueToString(df.getTime()) + File.separator + dateFormat3.valueToString(df.getTime()) + ".data");
                if (bf.exists()) {
                    Object[] o = this.getDataFromFile(bf, datef, datee);
                    if ((Integer)o[0] == 0) {
                        List ll = (List)o[1];
                        p.setCount(Integer.valueOf(ll.size()));
                        this.countAll = this.countAll + p.getCount();
                        this.list.addAll(ll);
                    } else if ((Integer)o[0] == 1) {
                        int cc = cache.size() - cache.size() / 2;
                        int i = cache.size() - 1;
                        while (i > cc) {
                            Object[] o1 = (Object[])cache.get(i);
                            this.countAll = this.countAll - ((NDDataCachePeriod)o1[0]).getCount();
                            while (this.list.size() > this.countAll) {
                                this.list.remove(this.list.size() - 1);
                            }
                            cache.remove(cache.size() - 1);
                            --i;
                        }
                        error = true;
                        InitializedVariable.factory.runMessageEx((Object)new ErrorMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0432\u0441\u0435 \u0434\u0430\u043d\u043d\u044b\u0435. \n \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0435\u0440\u0438\u043e\u0434 \u043c\u0435\u043d\u044c\u0448\u0435"), new BeanViewerAction[]{new MessageOKButton()});
                    }
                }
                if (error) continue;
                df.add(11, 1);
                c.setTime(df.getTime());
                c.add(14, -1);
                p.setEndAt(c.getTime());
                cache.add(new Object[]{p, bf});
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return cache;
    }

    private Object[] getDataFromFile(File f, Calendar dateFrom, Calendar dateTill) {
        List<Object> list = new ArrayList();
        ClassToCache ctc = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            ObjectInputStream serial = new ObjectInputStream(fis);
            ctc = (ClassToCache)serial.readObject();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ctc = null;
            Object[] objectArray = new Object[2];
            objectArray[0] = 1;
            return objectArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ctc != null) {
            Calendar c1 = Calendar.getInstance();
            c1.setTime(ctc.getDateFrom());
            Calendar c2 = Calendar.getInstance();
            c2.setTime(ctc.getDateTill());
            boolean notFilterBegin = false;
            boolean notFilterEnd = false;
            if (dateFrom.before(c1)) {
                notFilterBegin = true;
            }
            if (dateTill.after(c2)) {
                notFilterEnd = true;
            }
            Calendar c = Calendar.getInstance();
            if (notFilterBegin && notFilterEnd) {
                list = ctc.getList();
            } else if (notFilterBegin) {
                for (AbstractNDData n : ctc.getList()) {
                    c.setTime(n.getCreatedDateTime());
                    if (!c.before(dateTill)) continue;
                    list.add(n);
                }
            } else if (notFilterEnd) {
                for (AbstractNDData n : ctc.getList()) {
                    c.setTime(n.getCreatedDateTime());
                    if (!c.after(dateFrom)) continue;
                    list.add(n);
                }
            } else {
                for (AbstractNDData n : ctc.getList()) {
                    c.setTime(n.getCreatedDateTime());
                    if (!c.before(dateTill) || !c.after(dateFrom)) continue;
                    list.add(n);
                }
            }
        }
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Object[]{0, list};
    }
}

