/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.tracks.TrackAll;
import ru.blok.vms.ui.tracks.cache.CacheBase;
import ru.blok.vms.ui.tracks.cache.CacheData;
import ru.blok.vms.ui.tracks.cache.ClassToCache;
import ru.infor.client.soap.proxy.vms.NDDataWSProxy;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.vms.NDDataCachePeriod;
import ru.infor.ws.objects.vms.NDDataSearchCriteria;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.NDData;

public class CacheForStatusDevice
extends CacheBase
implements CacheData {
    Double mileage;

    @Override
    public List<AbstractNDData> getData(Date datefrom, Date datetill, Object[] obj, TrackAll trackAll) {
        this.list = null;
        Long deviceId = ((Long[])obj)[0];
        List<Object[]> o = this.getDataFromCache(datefrom, datetill, deviceId);
        this.putToCacheReload(deviceId, o, datefrom, datetill);
        return this.list;
    }

    private void putToCacheReload(Long deviceId, List<Object[]> cache, Date datefrom, Date datetill) {
        int c = this.realoadCacheFromServer(deviceId, cache, datefrom, datetill);
        if (c != 0) {
            this.list = null;
            this.getDataFromCache(datefrom, datetill, deviceId);
        }
    }

    private void putToFile(Long deviceId, Object[] ll, File f, NDDataCachePeriod p) {
        ClassToCache ct = new ClassToCache();
        ct.setDateFrom(p.getStartAt());
        ct.setDateTill(p.getEndAt());
        ArrayList<AbstractNDData> d = new ArrayList<AbstractNDData>();
        Object[] objectArray = ll;
        int n = ll.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            d.add((AbstractNDData)o);
            ++n2;
        }
        ct.setList(d);
        File ff = new File(f.getPath().substring(0, f.getPath().lastIndexOf(File.separator)));
        if (!ff.exists()) {
            ff.mkdirs();
        }
        try {
            FileOutputStream fos = new FileOutputStream(f);
            ObjectOutputStream serial = new ObjectOutputStream(fos);
            serial.writeObject(ct);
            serial.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Integer realoadCacheFromServer(Long deviceID, List<Object[]> cache, Date datefrom, Date datetill) {
        NDDataWSProxy ndDataWSProxy = (NDDataWSProxy)CurrentProxyFactory.getProxy(NDData.class);
        int count = 0;
        NDDataSearchCriteria sc = (NDDataSearchCriteria)ndDataWSProxy._getSearchCriteriaTemplate();
        sc.setDeviceIdList(new Long[]{deviceID});
        sc.setCreatedDateTimeFrom(datefrom);
        sc.setCreatedDateTimeTill(datetill);
        Integer ca = ndDataWSProxy.getCount(InitializedVariable.context, sc);
        if (this.list.size() == ca.intValue()) {
            return count;
        }
        for (Object[] oo : cache) {
            NDDataCachePeriod p = (NDDataCachePeriod)oo[0];
            sc.setCachePeriod(new NDDataCachePeriod[]{p});
            sc.setCreatedDateTimeFrom(p.getStartAt());
            sc.setCreatedDateTimeTill(p.getEndAt());
            sc.appendSorting(SortObject.getInstance((String)"createdDateTime", (String)SortObject.DIRECTION_ASC));
            Integer c = ndDataWSProxy.getCount(InitializedVariable.context, sc);
            sc.setCount(c);
            NDDataWSProxy.SearchResultListNDData ll = ndDataWSProxy.getList(InitializedVariable.context, sc);
            if (ll.isEmpty()) continue;
            count += ll.getObjList().length;
            this.putToFile(deviceID, ll.getObjList(), (File)oo[1], p);
        }
        return count;
    }

    @Override
    public void getWayLong(Date dateFrom, Date dateTill, Object[] obj, TrackAll trackAll) {
    }

    public Double getMileage() {
        if (this.mileage == null) {
            return 0.0;
        }
        return this.mileage;
    }

    public void setMileage(Double mileage) {
        this.mileage = mileage;
    }

    @Override
    public List<AbstractNDData> getDataSimple(Date datefrom, Date datetill, Object[] obj, TrackAll trackAll) {
        return null;
    }
}

