/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.longTask.StateTask;
import ru.blok.vms.ui.tracks.TrackAll;
import ru.blok.vms.ui.tracks.cache.CacheBase;
import ru.blok.vms.ui.tracks.cache.CacheData;
import ru.blok.vms.ui.tracks.cache.ClassToCache;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.vms.NDDataWSProxy;
import ru.infor.common.SysProperties;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.vms.MileageSearchCriteria;
import ru.infor.ws.objects.vms.NDDataCachePeriod;
import ru.infor.ws.objects.vms.NDDataSearchCriteria;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.Transport2DeviceLink;

public class CacheForTrackAll
extends CacheBase
implements CacheData {
    static List<Long> devIds = new ArrayList<Long>();
    String keyPage;
    NDDataWSProxy ndDataWSProxy;

    static {
        String di = SysProperties.getProperty((String)"loadAllDataToTrackAll", (String)"");
        if (di != null && di.length() > 0) {
            String[] dd;
            String[] stringArray = dd = di.split(",");
            int n = dd.length;
            int n2 = 0;
            while (n2 < n) {
                String d = stringArray[n2];
                try {
                    Long dl = Long.parseLong(d);
                    devIds.add(dl);
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
    }

    public String getKeyPage() {
        return this.keyPage;
    }

    public CacheForTrackAll(String keyPage) {
        this.keyPage = keyPage;
        this.ndDataWSProxy = (NDDataWSProxy)CurrentProxyFactory.getProxy(NDData.class, (String)keyPage);
    }

    @Override
    public List<AbstractNDData> getData(final Date datefrom, final Date datetill, final Object[] obj, final TrackAll trackAll) {
        this.list = null;
        if (obj.length > 0) {
            final HashMap<Long, List<Object[]>> o = this.getAllDataFromCache(datefrom, datetill, obj);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    CacheForTrackAll.this.putToAllCacheReload(obj, trackAll, o, datefrom, datetill);
                }
            }).start();
        }
        return this.list;
    }

    protected void putToAllCacheReload(Object[] obj, TrackAll trackAll, HashMap<Long, List<Object[]>> o, Date datefrom, Date datetill) {
        this.realoadCacheFromServer(obj, o, datefrom, datetill, trackAll, true).intValue();
        this.getAllDataFromCache(datefrom, datetill, obj);
        trackAll.reload(this.list);
    }

    @Override
    public List<AbstractNDData> getDataSimple(Date datefrom, Date datetill, Object[] obj, TrackAll trackAll) {
        if (obj.length > 0) {
            HashMap<Long, List<Object[]>> o = this.getAllDataFromCache(datefrom, datetill, obj);
            this.realoadCacheFromServer(obj, o, datefrom, datetill, trackAll, false).intValue();
            this.getAllDataFromCache(datefrom, datetill, obj);
            return this.list;
        }
        return null;
    }

    private Integer realoadCacheFromServer(Object[] obj, HashMap<Long, List<Object[]>> o, Date datefrom, Date datetill, TrackAll trackAll, boolean log) {
        Transport2DeviceLink link;
        int i;
        int count = 0;
        Integer ca = 0;
        NDDataSearchCriteria sc = (NDDataSearchCriteria)this.ndDataWSProxy._getSearchCriteriaTemplate();
        if (!trackAll.isReadingFromCassandra()) {
            i = 0;
            while (i < obj.length) {
                link = (Transport2DeviceLink)obj[i];
                if (link.getDevice() != null && link.getDevice().getId() != null) {
                    Date dStart = datefrom;
                    Date dFinish = datetill;
                    Date dBeginLink = link.getBeginDate();
                    Date dEndLink = link.getEndDate();
                    if (!(dEndLink != null && dStart.compareTo(dEndLink) > 0 || dBeginLink != null && dFinish.compareTo(dBeginLink) < 0)) {
                        if (dBeginLink != null && dBeginLink.compareTo(dStart) > 0) {
                            dStart = dBeginLink;
                        }
                        if (dEndLink != null && dEndLink.compareTo(dFinish) < 0) {
                            dFinish = dEndLink;
                        }
                        sc.setDeviceIdList(new Long[]{link.getDevice().getId()});
                        sc.setCreatedDateTimeFrom(dStart);
                        sc.setCreatedDateTimeTill(dFinish);
                        ca = ca + this.ndDataWSProxy.getCount(InitializedVariable.getContext((String)this.getKeyPage()), sc);
                    }
                }
                ++i;
            }
            if (this.list.size() == ca.intValue()) {
                return count;
            }
        }
        if (log) {
            trackAll.MessageWithProgress(ca);
            trackAll.beginrun();
            trackAll.getStateTask().setCurrent(Integer.valueOf(this.list.size()));
        }
        sc.appendSorting(SortObject.getInstance((String)"createdDateTime", (String)SortObject.DIRECTION_ASC));
        i = 0;
        while (i < obj.length) {
            block20: {
                NDDataWSProxy.SearchResultListNDData ll;
                List<Object[]> cache;
                block19: {
                    link = (Transport2DeviceLink)obj[i];
                    cache = o.get(link.getDevice().getId());
                    if (!devIds.contains(link.getDevice().getId())) break block19;
                    if (cache == null || cache.size() <= 0) break block20;
                    if (log) {
                        trackAll.getStateTask().setMaxProgress(null);
                        ((PanelContext)((ViewerContext)trackAll.getShowGraphics().getContext()).getParentContext()).getPanel().updateUIForPresentatorName("stateTask");
                    }
                    HashMap madListData = new HashMap();
                    Date b = ((NDDataCachePeriod)cache.get(0)[0]).getStartAt();
                    Date e = ((NDDataCachePeriod)cache.get(0)[0]).getEndAt();
                    sc.setDeviceIdList(new Long[]{link.getDevice().getId()});
                    for (Object[] oo : cache) {
                        NDDataCachePeriod p = (NDDataCachePeriod)oo[0];
                        ArrayList d = new ArrayList();
                        madListData.put(p, d);
                        if (p.getStartAt().before(b)) {
                            b = p.getStartAt();
                        }
                        if (!p.getEndAt().after(e)) continue;
                        e = p.getEndAt();
                    }
                    sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
                    sc.setWithCalibration(Integer.valueOf(1));
                    sc.setCreatedDateTimeFrom(b);
                    sc.setCreatedDateTimeTill(e);
                    ll = this.ndDataWSProxy.getList(InitializedVariable.getContext((String)this.getKeyPage()), sc);
                    if (!ll.isEmpty()) {
                        count += ll.getObjList().length;
                        Object[] objectArray = ll.getObjList();
                        int d = objectArray.length;
                        int n = 0;
                        while (n < d) {
                            Object o1 = objectArray[n];
                            AbstractNDData d2 = (AbstractNDData)o1;
                            NDDataCachePeriod r = null;
                            for (Object[] oo : cache) {
                                NDDataCachePeriod p = (NDDataCachePeriod)oo[0];
                                if (!d2.getCreatedDateTime().after(p.getStartAt()) && !d2.getCreatedDateTime().equals(p.getStartAt()) || !d2.getCreatedDateTime().before(p.getEndAt())) continue;
                                r = p;
                                break;
                            }
                            if (r != null) {
                                ((List)madListData.get(r)).add(d2);
                            }
                            ++n;
                        }
                        for (Object[] oo : cache) {
                            NDDataCachePeriod p = (NDDataCachePeriod)oo[0];
                            this.putToFile(link.getDevice().getId(), ((List)madListData.get(p)).toArray(new AbstractNDData[0]), (File)oo[1], p, trackAll, log);
                        }
                    }
                    if (!log) break block20;
                    trackAll.getStateTask().setMaxProgress(Integer.valueOf(this.list.size()));
                    trackAll.getStateTask().setCurrent(Integer.valueOf(0));
                    trackAll.getStateTask().setState(StateTask.stop);
                    ((PanelContext)((ViewerContext)trackAll.getShowGraphics().getContext()).getParentContext()).getPanel().updateUIForPresentatorName("stateTask");
                    break block20;
                }
                if (cache != null && cache.size() > 0) {
                    for (Object[] oo : cache) {
                        NDDataCachePeriod p = (NDDataCachePeriod)oo[0];
                        sc.setCachePeriod(new NDDataCachePeriod[]{p});
                        sc.setDeviceIdList(new Long[]{link.getDevice().getId()});
                        sc.setCreatedDateTimeFrom(p.getStartAt());
                        sc.setCreatedDateTimeTill(p.getEndAt());
                        sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
                        sc.setWithCalibration(Integer.valueOf(1));
                        ll = this.ndDataWSProxy.getList(InitializedVariable.getContext((String)this.getKeyPage()), sc);
                        if (ll.isEmpty()) continue;
                        count += ll.getObjList().length;
                        this.putToFile(link.getDevice().getId(), ll.getObjList(), (File)oo[1], p, trackAll, log);
                    }
                }
            }
            ++i;
        }
        return count;
    }

    private void putToFile(Long deviceId, Object[] ll, File f, NDDataCachePeriod p, TrackAll trackAll, boolean log) {
        ClassToCache ct = new ClassToCache();
        ct.setDateFrom(p.getStartAt());
        ct.setDateTill(p.getEndAt());
        ArrayList<AbstractNDData> d = new ArrayList<AbstractNDData>();
        Object[] objectArray = ll;
        int n = ll.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            d.add((AbstractNDData)o);
            if (log) {
                trackAll.incProgres();
            }
            ++n2;
        }
        ct.setList(d);
        File ff = new File(f.getPath().substring(0, f.getPath().lastIndexOf(File.separator)));
        if (!ff.exists()) {
            ff.mkdirs();
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(f);
                ObjectOutputStream serial = new ObjectOutputStream(fos);
                serial.writeObject(ct);
                serial.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (fos == null) {
                    return;
                }
                try {
                    fos.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            if (fos == null) {
                return;
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected HashMap<Long, List<Object[]>> getAllDataFromCache(Date datefrom, Date datetill, Object[] obj) {
        ArrayList list_ = new ArrayList();
        HashMap<Long, List<Object[]>> cache = new HashMap<Long, List<Object[]>>();
        int i = 0;
        while (i < obj.length) {
            Transport2DeviceLink link = (Transport2DeviceLink)obj[i];
            if (link.getDevice() != null && link.getDevice().getId() != null) {
                Date dStart = datefrom;
                Date dFinish = datetill;
                Date dBeginLink = link.getBeginDate();
                Date dEndLink = link.getEndDate();
                if (!(dEndLink != null && dStart.compareTo(dEndLink) > 0 || dBeginLink != null && dFinish.compareTo(dBeginLink) < 0)) {
                    if (dBeginLink != null && dBeginLink.compareTo(dStart) > 0) {
                        dStart = dBeginLink;
                    }
                    if (dEndLink != null && dEndLink.compareTo(dFinish) < 0) {
                        dFinish = dEndLink;
                    }
                    List<Object[]> o = this.getDataFromCache(dStart, dFinish, link.getDevice().getId());
                    list_.addAll(this.list);
                    cache.put(link.getDevice().getId(), o);
                }
            }
            ++i;
        }
        this.list = list_;
        return cache;
    }

    @Override
    public void getWayLong(final Date dateFrom, final Date dateTill, final Object[] obj, final TrackAll trackAll) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                MileageSearchCriteria sc = new MileageSearchCriteria();
                Double d = 0.0;
                if (obj.length > 0) {
                    int i = 0;
                    while (i < obj.length) {
                        Transport2DeviceLink link = (Transport2DeviceLink)obj[i];
                        if (link.getDevice() != null && link.getDevice().getId() != null) {
                            Date dStart = dateFrom;
                            Date dFinish = dateTill;
                            Date dBeginLink = link.getBeginDate();
                            Date dEndLink = link.getEndDate();
                            if (!(dEndLink != null && dStart.compareTo(dEndLink) > 0 || dBeginLink != null && dFinish.compareTo(dBeginLink) < 0)) {
                                if (dBeginLink != null && dBeginLink.compareTo(dStart) > 0) {
                                    dStart = dBeginLink;
                                }
                                if (dEndLink != null && dEndLink.compareTo(dFinish) < 0) {
                                    dFinish = dEndLink;
                                }
                                sc.setCreatedDateTimeFrom(dStart);
                                sc.setCreatedDateTimeTill(dFinish);
                                sc.setDeviceId(link.getDevice().getId());
                                Double dd = CacheForTrackAll.this.ndDataWSProxy.getMileage(InitializedVariable.getContext((String)CacheForTrackAll.this.getKeyPage()), sc);
                                if (dd != null) {
                                    d = d + dd;
                                }
                            }
                        }
                        ++i;
                    }
                }
                trackAll.setWayLong(d);
            }
        }).start();
    }
}

