/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks.editortrack;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.newmapviewer.NewPainterData;
import ru.blok.vms.ui.tracks.editortrack.MapValueEditor;
import ru.infor.ws.objects.vms.entities.ext.NDDataExt;

public class PainterDataEditor<T extends JXMapViewer>
extends NewPainterData<T> {
    private HashMap<NDDataExt, Polygon> mapV = new HashMap();
    private HashMap<NDDataExt, Point2D> mapP = new HashMap();

    @Override
    protected void paintTracks(Graphics2D g, T map, Rectangle2D vp2, Rectangle2D vp3) {
        MapValueEditor value = (MapValueEditor)this.mapValueWithTrackNew;
        if (value != null && value.getNodes() != null) {
            this.paintTrack(value.getNodes(), map, g, vp2, vp3, value.getColor());
        }
        this.paintSelectedNodesTrack(g, vp2, vp3);
        if (value.getSelectNode() != null) {
            Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(value.getSelectNode().getLat().doubleValue(), value.getSelectNode().getLon().doubleValue()), map.getZoom());
            if (vp2.contains(point)) {
                g.setColor(Color.BLUE);
                g.fillOval((int)(point.getX() - vp2.getX()) - 3, (int)(point.getY() - vp2.getY()) - 3, 7, 7);
            }
            if (vp3.contains(point)) {
                g.setColor(Color.BLUE);
                g.fillOval((int)(point.getX() - vp3.getX()) - 3, (int)(point.getY() - vp3.getY()) - 3, 7, 7);
            }
        }
    }

    public List<NDDataExt> getNDData(Point2D pClick1, Point2D pClick2) {
        Polygon p1 = new Polygon();
        p1.addPoint((int)pClick1.getX(), (int)pClick1.getY());
        p1.addPoint((int)pClick2.getX(), (int)pClick1.getY());
        p1.addPoint((int)pClick2.getX(), (int)pClick2.getY());
        p1.addPoint((int)pClick1.getX(), (int)pClick2.getY());
        ArrayList<NDDataExt> ld = new ArrayList<NDDataExt>();
        for (NDDataExt p : this.mapP.keySet()) {
            if (!p1.contains(this.mapP.get((Object)p))) continue;
            ld.add(p);
        }
        return ld;
    }

    public NDDataExt includeNode(Point2D pClick) {
        for (NDDataExt p : this.mapV.keySet()) {
            if (!this.mapV.get((Object)p).contains(pClick)) continue;
            return p;
        }
        return null;
    }

    private void paintTrack(Object[] nodes, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c) {
        this.mapV.clear();
        this.mapP.clear();
        if (nodes != null && nodes.length > 0) {
            int s = nodes.length;
            int from = 0;
            Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(((NDDataExt)((Object)nodes[from])).getLat().doubleValue(), ((NDDataExt)((Object)nodes[from])).getLon().doubleValue()), map.getZoom());
            g.fillOval((int)(pointFrom.getX() - vp3.getX()) - 2, (int)(pointFrom.getY() - vp3.getY()) - 2, 5, 5);
            Polygon p1 = new Polygon();
            p1.addPoint((int)pointFrom.getX() - 10, (int)pointFrom.getY() - 10);
            p1.addPoint((int)pointFrom.getX() + 10, (int)pointFrom.getY() - 10);
            p1.addPoint((int)pointFrom.getX() + 10, (int)pointFrom.getY() + 10);
            p1.addPoint((int)pointFrom.getX() - 10, (int)pointFrom.getY() + 10);
            this.mapV.put((NDDataExt)((Object)nodes[from]), p1);
            this.mapP.put((NDDataExt)((Object)nodes[from]), pointFrom);
            int i = 1;
            while (i < s) {
                Point2D pointTo = map.getTileFactory().geoToPixel(new GeoPosition(((NDDataExt)((Object)nodes[i])).getLat().doubleValue(), ((NDDataExt)((Object)nodes[i])).getLon().doubleValue()), map.getZoom());
                g.fillOval((int)(pointTo.getX() - vp3.getX()) - 2, (int)(pointTo.getY() - vp3.getY()) - 2, 5, 5);
                p1 = new Polygon();
                p1.addPoint((int)pointTo.getX() - 10, (int)pointTo.getY() - 10);
                p1.addPoint((int)pointTo.getX() + 10, (int)pointTo.getY() - 10);
                p1.addPoint((int)pointTo.getX() + 10, (int)pointTo.getY() + 10);
                p1.addPoint((int)pointTo.getX() - 10, (int)pointTo.getY() + 10);
                this.mapV.put((NDDataExt)((Object)nodes[i]), p1);
                this.mapP.put((NDDataExt)((Object)nodes[i]), pointTo);
                this.paint(pointFrom, pointTo, map, g, vp2, vp3, c, null);
                from = i++;
                pointFrom = pointTo;
            }
        }
    }

    private void paintSelectedNodesTrack(Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        MapValueEditor value = (MapValueEditor)this.mapValueWithTrackNew;
        if (value != null) {
            for (NDDataExt p : this.mapP.keySet()) {
                Point2D point = this.mapP.get((Object)p);
                if (!value.getSelected().contains(p.getId())) continue;
                if (vp2.contains(point)) {
                    g.setColor(Color.GREEN);
                    g.fillOval((int)(point.getX() - vp2.getX()) - 2, (int)(point.getY() - vp2.getY()) - 2, 5, 5);
                }
                if (!vp3.contains(point)) continue;
                g.setColor(Color.GREEN);
                g.fillOval((int)(point.getX() - vp3.getX()) - 2, (int)(point.getY() - vp3.getY()) - 2, 5, 5);
            }
        }
    }
}

