/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks.json;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.tracks.json.KeyFinder;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.vms.NavigationPoint;
import ru.infor.ws.objects.vms.RouteNavigationParam;

public class LoaderFromCloudmade {
    static DecimalFormat coordFormat = new DecimalFormat("#0.############");

    public static NavigationPoint[] getRoute(InvocationContext context, RouteNavigationParam param, String api_key) {
        return LoaderFromCloudmade.getRouteWithPoints(context, param, api_key, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NavigationPoint[] getRouteWithPoints(InvocationContext context, RouteNavigationParam param, String api_key, NavigationPoint[] points) {
        Double fitness = 0.0;
        try {
            File tempFile = File.createTempFile("route", ".js");
            String pathTempFile = tempFile.getAbsolutePath();
            LoaderFromCloudmade.loadFileFromInternet(param, pathTempFile, api_key, points);
            String rez = LoaderFromCloudmade.readFromFile(pathTempFile);
            JSONParser parser = new JSONParser();
            try {
                KeyFinder finder = new KeyFinder();
                finder.setMatchKey("total_distance");
                parser.parse(rez, (ContentHandler)finder, true);
                if (finder.isFound()) {
                    finder.setFound(false);
                    fitness = ((Long)finder.getValue()).doubleValue();
                }
                if (param.getLimitRange() != null && fitness >= param.getLimitRange()) {
                    return null;
                }
                int p1 = rez.indexOf("\"route_geometry\":[[") + 18;
                int p2 = rez.indexOf("],\"route_instructions\"");
                if (p1 < 0) return null;
                if (p2 < 0) {
                    return null;
                }
                String rz = rez.substring(p1, p2);
                int i = 0;
                int j = rz.indexOf("]");
                while (j > 0) {
                    j = rz.indexOf("]", j + 1);
                    ++i;
                }
                NavigationPoint[] np = new NavigationPoint[i];
                i = 0;
                int ii = 0;
                j = rz.indexOf("]", 0);
                while (j > 0) {
                    String pr = rz.substring(i + 1, j);
                    int k = pr.indexOf(",");
                    NavigationPoint n = new NavigationPoint();
                    n.setLat(Double.valueOf(pr.substring(0, k)));
                    n.setLon(Double.valueOf(pr.substring(k + 1)));
                    n.setFitness(fitness);
                    np[ii] = n;
                    ++ii;
                    i = j + 2;
                    j = rz.indexOf("]", j + 1);
                }
                try {
                    tempFile.delete();
                    return np;
                }
                catch (Exception exception) {}
                return np;
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void loadFileFromInternet(RouteNavigationParam param, String pathTempFile, String api_key, NavigationPoint[] points) {
        String arg0 = "http://routes.cloudmade.com/" + api_key + "/api/0.3/";
        arg0 = String.valueOf(arg0) + coordFormat.format(param.getFrom().getLat()).replaceAll(",", ".") + ",";
        arg0 = String.valueOf(arg0) + coordFormat.format(param.getFrom().getLon()).replaceAll(",", ".") + ",";
        if (points != null && points.length > 0) {
            arg0 = String.valueOf(arg0) + "[";
            int i = 0;
            while (i < points.length) {
                arg0 = String.valueOf(arg0) + coordFormat.format(points[i].getLat()).replaceAll(",", ".") + ",";
                arg0 = String.valueOf(arg0) + coordFormat.format(points[i].getLon()).replaceAll(",", ".");
                if (i < points.length - 1) {
                    arg0 = String.valueOf(arg0) + ",";
                }
                ++i;
            }
            arg0 = String.valueOf(arg0) + "],";
        }
        arg0 = String.valueOf(arg0) + coordFormat.format(param.getTo().getLat()).replaceAll(",", ".") + ",";
        arg0 = String.valueOf(arg0) + coordFormat.format(param.getTo().getLon()).replaceAll(",", ".");
        arg0 = String.valueOf(arg0) + "/car/" + (param.getFintessID() == 1L ? "shortest" : "fastest") + ".js?lang=ru";
        LoaderFromCloudmade.loadFromInet(pathTempFile, arg0);
    }

    public static void loadFromInet(String pathTempFile, String arg0) {
        FilterInputStream in = null;
        OutputStream fOut = null;
        try {
            try {
                int data;
                URL remoteFile = new URL(arg0);
                URLConnection fileStream = InitializedVariable.getCurrentConnection((URL)remoteFile);
                fOut = new FileOutputStream(pathTempFile);
                new DataOutputStream(fOut);
                in = new DataInputStream(fileStream.getInputStream());
                while ((data = in.read()) != -1) {
                    ((FileOutputStream)fOut).write(data);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    in.close();
                    fOut.flush();
                    ((FileOutputStream)fOut).close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
                fOut.flush();
                ((FileOutputStream)fOut).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String readFromFile(String fileName) {
        String dataLine = "";
        try {
            File inFile = new File(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(inFile)));
            dataLine = br.readLine();
            br.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return dataLine;
    }
}

