/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks.json;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.log4j.Logger;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.vms.ui.tracks.json.LoaderFromCloudmade;
import ru.infor.client.soap.proxy.vms.AddressTranslationWSProxy;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.vms.AddressTranslationSearchCriteria;
import ru.infor.ws.objects.vms.NavigationPoint;
import ru.infor.ws.objects.vms.RouteNavigationParam;
import ru.infor.ws.objects.vms.entities.AddressTranslation;
import ru.infor.ws.objects.vms.entities.ViewAddressADIS;

public class LoaderFromMapQuest {
    static DecimalFormat coordFormat = new DecimalFormat("#0.############");
    static Map<String, String> transMap = new HashMap<String, String>(128);
    static AddressTranslationWSProxy adresWSProxy = (AddressTranslationWSProxy)CurrentProxyFactory.getProxy(AddressTranslation.class);
    private static Logger logger = Logger.getLogger(LoaderFromMapQuest.class);

    public static NavigationPoint[] getRoute(InvocationContext context, RouteNavigationParam param, String api_key) {
        return LoaderFromMapQuest.getRouteWithPoints(context, param, api_key, null);
    }

    public static CompletableFuture<NavigationPoint[]> getFutureRouteWithPoints(InvocationContext context, RouteNavigationParam param, String api_key, NavigationPoint[] points) {
        return CompletableFuture.supplyAsync(() -> LoaderFromMapQuest.getRouteWithPoints(context, param, api_key, points));
    }

    public static NavigationPoint[] getRouteWithPoints(InvocationContext context, RouteNavigationParam param, String api_key, NavigationPoint[] points) {
        String rz;
        int p2;
        int p1;
        String rez;
        Double fitness;
        block9: {
            long b2;
            long b1;
            block8: {
                fitness = 0.0;
                File tempFile = File.createTempFile("route", ".js");
                String pathTempFile = tempFile.getAbsolutePath();
                b1 = System.currentTimeMillis();
                LoaderFromMapQuest.loadFileFromInternet(param, pathTempFile, api_key, points);
                b2 = System.currentTimeMillis();
                rez = LoaderFromCloudmade.readFromFile(pathTempFile);
                if (rez != null) break block8;
                return null;
            }
            long b3 = System.currentTimeMillis();
            logger.debug((Object)String.format("Loader takes %d ms for loading and %d ms for reading from file", b2 - b1, b3 - b2));
            p1 = rez.indexOf("\"distance\":");
            if (p1 > 0 && (p2 = (rz = rez.substring(p1, rez.length() - 1)).indexOf(",")) > 0) {
                fitness = Double.valueOf(rz.substring(11, p2));
            }
            if (param.getLimitRange() == null || !(fitness >= param.getLimitRange())) break block9;
            return null;
        }
        try {
            p1 = rez.indexOf("\"shapePoints\":");
            rz = rez.substring(p1, rez.length() - 1);
            p2 = rz.indexOf("]");
            if (p2 > 0) {
                rz = rz.substring(15, p2);
            }
            String[] st = rz.split(",");
            ArrayList<NavigationPoint> listnp = new ArrayList<NavigationPoint>();
            int k = 0;
            while (k < st.length - 1) {
                NavigationPoint n = new NavigationPoint();
                n.setLat(Double.valueOf(st[k]));
                n.setLon(Double.valueOf(st[k + 1]));
                n.setFitness(fitness);
                if (listnp.size() > 0 && (!n.getLat().equals(((NavigationPoint)listnp.get(listnp.size() - 1)).getLat()) || !n.getLon().equals(((NavigationPoint)listnp.get(listnp.size() - 1)).getLon())) || listnp.size() == 0) {
                    listnp.add(n);
                }
                k += 2;
            }
            return listnp.toArray(new NavigationPoint[listnp.size()]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void loadFileFromInternet(RouteNavigationParam param, String pathTempFile, String api_key, NavigationPoint[] points) {
        String arg0 = "http://open.mapquestapi.com/directions/v2/route?key=" + api_key + "&routeType=" + (param.getFintessID() == 1L ? "shortest" : "fastest") + "&timeType=1" + "&enhancedNarrative=false" + "&shapeFormat=raw" + "&generalize=0" + "&locale=ru_Ru" + "&unit=k" + "&from=";
        arg0 = String.valueOf(arg0) + coordFormat.format(param.getFrom().getLat()).replaceAll(",", ".") + ",";
        arg0 = String.valueOf(arg0) + coordFormat.format(param.getFrom().getLon()).replaceAll(",", ".") + "&to=";
        if (points != null && points.length > 0) {
            int i = 0;
            while (i < points.length) {
                arg0 = String.valueOf(arg0) + coordFormat.format(points[i].getLat()).replaceAll(",", ".") + ",";
                arg0 = String.valueOf(arg0) + coordFormat.format(points[i].getLon()).replaceAll(",", ".") + "&to=";
                ++i;
            }
        }
        arg0 = String.valueOf(arg0) + coordFormat.format(param.getTo().getLat()).replaceAll(",", ".") + ",";
        arg0 = String.valueOf(arg0) + coordFormat.format(param.getTo().getLon()).replaceAll(",", ".");
        LoaderFromCloudmade.loadFromInet(pathTempFile, arg0);
    }

    public static ViewAddressADIS[] getAddress(InvocationContext ctx, Double lat, Double lon, String api_key) {
        if (api_key == null) {
            return null;
        }
        try {
            File tempFile = File.createTempFile("address", ".js");
            String pathTempFile = tempFile.getAbsolutePath();
            String urlStr = LoaderFromMapQuest.createUrl4AddresCalculation(lat, lon, api_key);
            LoaderFromCloudmade.loadFromInet(pathTempFile, urlStr);
            String rez = LoaderFromCloudmade.readFromFile(pathTempFile);
            ViewAddressADIS np = new ViewAddressADIS();
            np.setCountryName(LoaderFromMapQuest.findField(rez, "adminArea1"));
            np.setStateName(LoaderFromMapQuest.getTransName(ctx, LoaderFromMapQuest.findField(rez, "adminArea3")));
            np.setRegionName(LoaderFromMapQuest.findField(rez, "adminArea4"));
            np.setTownName(LoaderFromMapQuest.findField(rez, "adminArea5"));
            np.setStreetName(LoaderFromMapQuest.getTransName(ctx, LoaderFromMapQuest.findField(rez, "street")));
            np.setPostalCode(LoaderFromMapQuest.findField(rez, "postalCode"));
            Double latC = null;
            Double lonC = null;
            try {
                latC = Double.valueOf(LoaderFromMapQuest.findField(rez, "lat"));
            }
            catch (Exception exception) {}
            try {
                lonC = Double.valueOf(LoaderFromMapQuest.findField(rez, "lng"));
            }
            catch (Exception exception) {}
            np.setLat(latC);
            np.setLon(lonC);
            return new ViewAddressADIS[]{np};
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String findField(String rez, String st) {
        int p1 = rez.indexOf("\"" + st + "\":");
        String stRez = "";
        if (p1 < 0) {
            return stRez;
        }
        try {
            stRez = rez.substring(p1 + st.length() + 4, rez.indexOf(",", p1 + st.length() + 4) - 1);
        }
        catch (Exception exception) {}
        return stRez;
    }

    private static String createUrl4AddresCalculation(Double lat, Double lon, String api_key) {
        String arg0 = "http://open.mapquestapi.com/geocoding/v1/reverse?key=" + api_key + "&callback=renderReverse&location=";
        arg0 = String.valueOf(arg0) + coordFormat.format(lat).replaceAll(",", ".") + ",";
        arg0 = String.valueOf(arg0) + coordFormat.format(lon).replaceAll(",", ".");
        return arg0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTransName(InvocationContext context, String name) {
        if (name == null || name.trim().equals("")) {
            return null;
        }
        if (!name.matches("[a-zA-Z0-9\\s]+")) {
            return name;
        }
        String res = null;
        Map<String, String> map = transMap;
        synchronized (map) {
            res = transMap.get(name);
        }
        if (res != null) {
            return res;
        }
        AddressTranslationSearchCriteria dSC = new AddressTranslationSearchCriteria();
        dSC.setCode("*" + name + "*");
        dSC.setCount(Integer.valueOf(1));
        AddressTranslationWSProxy.SearchResultListAddressTranslation list = adresWSProxy.getList(context, dSC);
        if (list.isEmpty()) {
            return null;
        }
        AddressTranslation atObj = (AddressTranslation)list.getObjList()[0];
        res = atObj == null ? name : atObj.getDescription();
        Map<String, String> map2 = transMap;
        synchronized (map2) {
            if (!transMap.containsKey(name) && atObj != null) {
                transMap.put(name, res);
            }
        }
        return res;
    }
}

