/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks.json;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import ru.blok.vms.ui.tracks.json.LoaderFromCloudmade;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.vms.NavigationPoint;

public class LoaderTimeZoneFromGeonames {
    static DecimalFormat coordFormat = new DecimalFormat("#0.############");

    public static String getTimeZoneByCoordinates(InvocationContext context, NavigationPoint point, String username) {
        String rezult = " - ";
        try {
            File tempFile = File.createTempFile("route", ".js");
            String pathTempFile = tempFile.getAbsolutePath();
            LoaderTimeZoneFromGeonames.loadFileFromInternet(pathTempFile, point, username);
            String rez = LoaderFromCloudmade.readFromFile(pathTempFile);
            if (rez.indexOf("timezoneId") < 0) {
                return rezult;
            }
            rezult = rez.substring(rez.indexOf("timezoneId") + 13, rez.indexOf(",", rez.indexOf("timezoneId") + 1) - 1);
            if (rez.indexOf("gmtOffset") < 0) {
                return rezult.concat(" (UTC+0)");
            }
            Integer ho = 0;
            try {
                ho = Integer.valueOf(rez.substring(rez.indexOf("gmtOffset") + 11, rez.indexOf(",", rez.indexOf("gmtOffset") + 1)));
            }
            catch (Exception exception) {}
            rezult = rezult.concat(" (UTC").concat(ho < 0 ? "" : "+").concat(String.valueOf(ho).trim()).concat(")");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rezult;
    }

    public static void loadFileFromInternet(String pathTempFile, NavigationPoint point, String username) {
        String arg0 = "http://api.geonames.org/timezoneJSON?lat=";
        arg0 = String.valueOf(arg0) + coordFormat.format(point.getLat()).replaceAll(",", ".") + "&lng=";
        arg0 = String.valueOf(arg0) + coordFormat.format(point.getLon()).replaceAll(",", ".") + "&username=".concat(username);
        LoaderFromCloudmade.loadFromInet(pathTempFile, arg0);
    }

    public static void main(String[] args) {
        NavigationPoint point = new NavigationPoint();
        point.setLat(Double.valueOf(58.35));
        point.setLon(Double.valueOf(38.85));
        System.out.println(LoaderTimeZoneFromGeonames.getTimeZoneByCoordinates(null, point, "demo"));
    }
}

