/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks.trackforroute;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.Primitive;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.PrimitiveForView;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.TrackNDData;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.NodePainterDataTraclAll;
import ru.blok.vms.ui.pointsui.viewers.Utils;
import ru.blok.vms.ui.tracks.TrackInRealTime2;
import ru.blok.vms.ui.tracks.trackforroute.TrackAllRoute;
import ru.infor.ws.objects.draw.entities.AbstractCondition;
import ru.infor.ws.objects.draw.entities.ColorCondition;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.DeviceParameterNames;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.RouteElement;
import ru.infor.ws.objects.vms.entities.ext.RouteElementExt;
import ru.infor.ws.objects.vms.entities.ext.WayBillSimpleExt;

public class NodePainterDataRoute<T extends JXMapViewer>
extends NodePainterDataTraclAll<T> {
    private Color defaultColor = Color.GREEN;
    private Color notInRoute = Color.RED;
    GeometryFactory f = new GeometryFactory();
    static List<ColorCondition> conditions = new ArrayList<ColorCondition>();
    MapValueWithTrack value;

    static {
        conditions.add(NodePainterDataRoute.getNewCondition(5, "speed", "p<20", Color.YELLOW.getRGB()));
        conditions.add(NodePainterDataRoute.getNewCondition(4, "dspeed", "p>10", Color.BLUE.getRGB()));
        conditions.add(NodePainterDataRoute.getNewCondition(3, "dspeed", "p>20", Color.CYAN.getRGB()));
        conditions.add(NodePainterDataRoute.getNewCondition(2, "dspeed", "p>30", Color.ORANGE.getRGB()));
        conditions.add(NodePainterDataRoute.getNewCondition(1, "dspeed", "p>40", Color.PINK.getRGB()));
        conditions.add(NodePainterDataRoute.getNewCondition(0, "dspeed", "p>50", Color.MAGENTA.getRGB()));
    }

    static ColorCondition getNewCondition(int index, String name, String condition, Integer color) {
        ColorCondition cc = new ColorCondition();
        cc.setOrderIndex(Integer.valueOf(index));
        DeviceParameterNames n = new DeviceParameterNames();
        n.setCode(name);
        cc.setParameterName(n);
        cc.setCondition(condition);
        cc.setColor(color);
        return cc;
    }

    public static Object getParameterValue(NDData data, AbstractCondition c, RouteElementExt el) {
        if ("speed".equals(c.getParameterName().getCode())) {
            return data.getSpeed();
        }
        if ("dspeed".equals(c.getParameterName().getCode())) {
            return data.getSpeed() - (el.getSpeed() == null ? 0.0 : el.getSpeed());
        }
        return null;
    }

    public static Integer getColorWithConditions(NDData data, ColorCondition[] conditions, Integer defaultValue, RouteElementExt el) {
        Integer color = defaultValue;
        if (conditions != null) {
            Arrays.sort((Object[])conditions);
            ColorCondition[] colorConditionArray = conditions;
            int n = conditions.length;
            int n2 = 0;
            while (n2 < n) {
                ColorCondition cc = colorConditionArray[n2];
                if (Utils.isTrue(NodePainterDataRoute.getParameterValue(data, (AbstractCondition)cc, el), (AbstractCondition)cc)) {
                    return cc.getColor();
                }
                ++n2;
            }
        }
        return color;
    }

    private Color getColorNDData(AbstractNDData from, AbstractNDData to, WayBillSimpleExt w) {
        Polygon pp;
        Polygonal p = w.getRouteArea();
        Point pFrom = this.f.createPoint(new Coordinate(from.getLon().doubleValue(), from.getLat().doubleValue()));
        Point pTo = this.f.createPoint(new Coordinate(to.getLon().doubleValue(), to.getLat().doubleValue()));
        if (p == null) {
            return this.notInRoute;
        }
        if (!(!(p instanceof Polygon) || (pp = (Polygon)p).contains((Geometry)pTo) && pp.contains((Geometry)pFrom))) {
            return this.notInRoute;
        }
        boolean inRoute = false;
        RouteElement[] routeElementArray = w.getRe();
        int n = routeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            RouteElement e = routeElementArray[n2];
            if (((RouteElementExt)e).getElementArea() != null && ((RouteElementExt)e).getElementArea().contains((Geometry)pFrom)) {
                inRoute = true;
                Color c = new Color(NodePainterDataRoute.getColorWithConditions((NDData)from, w.getListConditions() == null ? conditions.toArray(new ColorCondition[0]) : w.getListConditions().toArray(new ColorCondition[0]), this.defaultColor.getRGB(), (RouteElementExt)e));
                return c;
            }
            ++n2;
        }
        if (!inRoute) {
            return this.notInRoute;
        }
        return this.defaultColor;
    }

    @Override
    protected void paintTrack(TrackNDData t, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        HashMap<Integer, java.awt.Polygon> lp = new HashMap<Integer, java.awt.Polygon>();
        if (!t.getNodes().isEmpty()) {
            int s = t.getNodes().size();
            PrimitiveForView view = t.TunedNode(t.getNodes().get(0), false, false);
            PrimitiveForView viewSelect = t.TunedNode(t.getNodes().get(0), false, false);
            Integer[] sel = t.getSelectedPath();
            int selb = -1;
            int sele = -1;
            if (sel != null) {
                selb = sel[0];
                sele = sel[1];
            }
            int from = 0;
            Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(t.getNodes().get(from).getLat().doubleValue(), t.getNodes().get(from).getLon().doubleValue()), map.getZoom());
            WayBillSimpleExt w = ((TrackAllRoute)((Object)this.value.getTrackInRealTime2())).getSelect();
            int k = 5;
            int i = 1;
            while (i < s) {
                boolean selEnd;
                Point2D pointTo = map.getTileFactory().geoToPixel(new GeoPosition(t.getNodes().get(i).getLat().doubleValue(), t.getNodes().get(i).getLon().doubleValue()), map.getZoom());
                double d = pointFrom.distance(pointTo);
                boolean selFrom = from >= selb && from < sele;
                boolean bl = selEnd = i >= selb && i < sele;
                if (d > accuracyOfPaint || selFrom != selEnd) {
                    if (selFrom) {
                        Color c = this.getColorNDData(t.getNodes().get(from), t.getNodes().get(i), w);
                        viewSelect.setColorLine(c);
                        lp.put(i - 1, this.paint(pointFrom, pointTo, map, g, vp2, vp3, viewSelect));
                    } else {
                        lp.put(i - 1, this.paint(pointFrom, pointTo, map, g, vp2, vp3, view));
                    }
                    from = i;
                    pointFrom = pointTo;
                    if (++k % 7 == 0) {
                        Double angle = TrackInRealTime2.getAngle((AbstractNDData)((NDData)t.getNodes().get(i - 1)), (AbstractNDData)((NDData)t.getNodes().get(i)));
                        this.paintS(g, vp2, vp3, selFrom ? viewSelect : view, t.getNodes().get(i), pointTo, angle);
                    }
                }
                ++i;
            }
            from = s - 1;
            g.setStroke(Primitive.defaultStroke);
            if (t.getCurrent() != null && t.getNodes().size() > t.getCurrent()) {
                this.paintFlag(t.getNodes().get(t.getCurrent()), map, g, vp2, vp3);
            }
        }
        this.mapV.put(t, lp);
    }

    protected java.awt.Polygon paint(Point2D pointFrom, Point2D point, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, PrimitiveForView view) {
        if (vp2.contains(point) || vp2.contains(pointFrom)) {
            g.setStroke(view.getStroke());
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color w = new Color(view.getColorLine().getRed(), view.getColorLine().getGreen(), view.getColorLine().getBlue(), view.getColorLine().getAlpha());
            g.setColor(w);
            g.drawLine((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()), (int)(pointFrom.getX() - vp2.getX()), (int)(pointFrom.getY() - vp2.getY()));
            java.awt.Polygon p1 = new java.awt.Polygon();
            p1.addPoint((int)(point.getX() - 5.0), (int)(point.getY() + 5.0));
            p1.addPoint((int)(point.getX() + 5.0), (int)(point.getY() - 5.0));
            p1.addPoint((int)(pointFrom.getX() + 5.0), (int)(pointFrom.getY() - 5.0));
            p1.addPoint((int)(pointFrom.getX() - 5.0), (int)(pointFrom.getY() + 5.0));
            return p1;
        }
        if (vp3.contains(point) || vp3.contains(pointFrom)) {
            g.setStroke(view.getStroke());
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color w = new Color(view.getColorLine().getRed(), view.getColorLine().getGreen(), view.getColorLine().getBlue(), view.getColorLine().getAlpha());
            g.setColor(w);
            g.drawLine((int)(point.getX() - vp3.getX()), (int)(point.getY() - vp3.getY()), (int)(pointFrom.getX() - vp3.getX()), (int)(pointFrom.getY() - vp3.getY()));
            java.awt.Polygon p1 = new java.awt.Polygon();
            p1.addPoint((int)(point.getX() - 5.0), (int)(point.getY() + 5.0));
            p1.addPoint((int)(point.getX() + 5.0), (int)(point.getY() - 5.0));
            p1.addPoint((int)(pointFrom.getX() + 5.0), (int)(pointFrom.getY() - 5.0));
            p1.addPoint((int)(pointFrom.getX() - 5.0), (int)(pointFrom.getY() + 5.0));
            return p1;
        }
        return null;
    }

    protected void paintS(Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, PrimitiveForView view, AbstractNDData point, Point2D point2, Double angle) {
        if (angle != null && angle > 0.0) {
            if (vp2.contains(point2)) {
                int x = (int)(point2.getX() - vp2.getX());
                int y = (int)(point2.getY() - vp2.getY());
                g.translate(x, y);
                g.rotate(Math.toRadians(angle + 180.0));
                java.awt.Polygon p = new java.awt.Polygon();
                p.addPoint(0, 8);
                p.addPoint(-3, 0);
                p.addPoint(0, 2);
                p.addPoint(3, 0);
                p.addPoint(0, 8);
                Color c = view.getColorPixel();
                Color c2 = c.brighter().brighter();
                g.setColor(c2);
                g.drawPolygon(p);
                g.setColor(this.getColorPoint(view, point));
                g.fillPolygon(p);
                g.rotate(-Math.toRadians(angle + 180.0));
                g.translate(-x, -y);
            } else if (vp3.contains(point2)) {
                int x = (int)(point2.getX() - vp3.getX());
                int y = (int)(point2.getY() - vp3.getY());
                g.translate(x, y);
                g.rotate(Math.toRadians(angle + 180.0));
                java.awt.Polygon p = new java.awt.Polygon();
                p.addPoint(0, 8);
                p.addPoint(-3, 0);
                p.addPoint(0, 2);
                p.addPoint(3, 0);
                p.addPoint(0, 8);
                g.setColor(view.getColorPixel());
                g.drawPolygon(p);
                g.setColor(this.getColorPoint(view, point));
                g.fillPolygon(p);
                g.rotate(-Math.toRadians(angle + 180.0));
                g.translate(-x, -y);
            }
        }
    }

    protected Color getColorPoint(PrimitiveForView view, AbstractNDData point) {
        return view.getColorLine();
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        super.setValue(mapValueWithTrack);
        this.value = (MapValueWithTrack)mapValueWithTrack;
    }
}

