/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks.trackinrealtimelite;

import edu.emory.mathcs.backport.java.util.Arrays;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.core.ResourceStrings;
import ru.blok.common.ui.directories.FRCBaseDirectoryViewer;
import ru.blok.vms.calltransport.actions.CallButton;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.NodeType;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.TrackNDData;
import ru.blok.vms.ui.tracks.OneTrack;
import ru.blok.vms.ui.tracks.PathInfo;
import ru.blok.vms.ui.tracks.trackinrealtimelite.TransportTreeNode;
import ru.blok.vms.ui.tracks.trackinrealtimelite.TransportTreeNodeCrew;
import ru.blok.vms.ui.tracks.trackinrealtimelite.TransportTreeNodeGroup;
import ru.blok.vms.ui.tracks.tracksmp.MapViewerWithOneTrackInRealTimeSMP;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.ClassView;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.ActionCalculatedObject;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.dialog.CommonMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.swing.viewers.tree.TreeNode;
import ru.infor.beanviewer.swing.viewers.tree.TreeViewer;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.client.soap.proxy.core.SecurityWSProxy;
import ru.infor.client.soap.proxy.vms.NDDataWSProxy;
import ru.infor.client.soap.proxy.vms.Transport2DeviceLinkWSProxy;
import ru.infor.client.soap.proxy.vms.Transport2MobileDeviceLinkWSProxy;
import ru.infor.client.soap.proxy.vms.TransportWSProxy;
import ru.infor.websocket.client.SocketClientFactory;
import ru.infor.websocket.transport.SubscribingOptions;
import ru.infor.websocket.transport.UnsubscribingOptions;
import ru.infor.ws.business.vms.websocket.NDDataSocketIntf;
import ru.infor.ws.business.vms.websocket.Transport2GPSPointSocketIntf;
import ru.infor.ws.business.vms.websocket.TransportStatusSocketIntf;
import ru.infor.ws.business.vms.websocket.objects.SubscribingOptions_SendListNDData;
import ru.infor.ws.business.vms.websocket.objects.SubscribingOptions_SendTransport2GPSPoint;
import ru.infor.ws.business.vms.websocket.objects.SubscribingOptions_SendTransportStatus;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.core.entities.Directories;
import ru.infor.ws.objects.vms.NDDataSearchCriteria;
import ru.infor.ws.objects.vms.Transport2DeviceLinkSearchCriteria;
import ru.infor.ws.objects.vms.Transport2GPSPointSearchCriteria;
import ru.infor.ws.objects.vms.Transport2GPSPointUI;
import ru.infor.ws.objects.vms.TransportSearchCriteria;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.Crew;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.NavigationDevice;
import ru.infor.ws.objects.vms.entities.Transport;
import ru.infor.ws.objects.vms.entities.Transport2DeviceLink;
import ru.infor.ws.objects.vms.entities.Transport2GPSPoint;
import ru.infor.ws.objects.vms.entities.Transport2MobileDeviceLink;
import ru.infor.ws.objects.vms.entities.Transport2StatusLink;
import ru.infor.ws.objects.vms.entities.TransportKind;
import ru.infor.ws.objects.vms.entities.TransportStatus;
import ru.infor.ws.objects.vms.entities.ext.TransportExt;

@ListView(views={@View(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u0438", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class TrackInRealTimeLite
extends CommonObjectWithKey
implements NDDataSocketIntf,
TransportStatusSocketIntf,
Transport2GPSPointSocketIntf {
    Long[] listID = null;
    Object[] listLastPoint;
    MapValueWithTrack value;
    int state = 0;
    public static String parking = "/data/icons/parking.png";
    public static String nodata = "/data/icons/nodata.png";
    public static String runing = "/data/icons/runing.png";
    public static String parking_long = "/data/icons/parking_long.png";
    boolean transportWithoutMobileDevice = false;
    protected static SimpleDateFormat dateWithTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    String infoOnGPSDevice = "0100000";
    String templConvertLatLon = "De.99";
    long waitSec = 3L;
    protected List<OneTrack> list = new ArrayList<OneTrack>();
    int currentLoad = 0;
    int currentView = 0;
    HashMap<String, String> sp = null;
    protected Long selectDeviceId;
    private Integer minUpdate = 1800;
    protected static double minSpeed = 5.0;
    List<BeanViewerAction<ViewerContext>> listGroup1Bt = new ArrayList<BeanViewerAction<ViewerContext>>();
    List<BeanViewerAction<ViewerContext>> listEasyBt = new ArrayList<BeanViewerAction<ViewerContext>>();
    protected long timeNoData = 1200000L;
    protected long timeParking = 300000L;
    protected long timeUpdate = 10000L;
    protected long timeLongParking = 1200000L;
    protected int timeIntervalGeoPoint = 5;
    private long periodOutside = 1200000L;
    public TransportTreeNode node;
    public TransportTreeNode node2;
    protected static SimpleDateFormat dateTimeFormat = new SimpleDateFormat("mm \u043c ss \u0441");
    protected StructureDevice devices = new StructureDevice(this, this.getKeyPage());
    static SecurityWSProxy proxy2 = new SecurityWSProxy(CurrentProxyFactory.getCurrentSOAPConnection());
    private HashMap<String, Image> mapIcons = new HashMap();
    TransportWSProxy pTransportWSProxy = (TransportWSProxy)CurrentProxyFactory.getProxy(Transport.class, (String)this.getKeyPage());
    HashMap<Long, TransportStatus> mapSt = new HashMap();
    public HashMap<Long, Transport2GPSPointUI> mapGeopCurrent = new HashMap();
    private BeanViewerAction<ViewerContext> applyFilter = new BeanViewerAction<ViewerContext>(){

        public String getName() {
            return "\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u0444\u0438\u043b\u044c\u0442\u0440";
        }

        public void actionPerformed(Object message) {
            this.apply(message);
        }

        public void apply(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            TrackInRealTimeLite t = (TrackInRealTimeLite)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject());
            t.getValue().getTracksNDData().clear();
            t.initFullListIDFromTree();
            List tt = ((TreeNodeViewer)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("node").getViewer()).getSelectedItems();
            Object s = null;
            if (tt != null && tt.size() > 0) {
                s = tt.get(0);
            }
            t.refresh((PanelContext)((ViewerContext)this.getContext()).getParentContext());
            if (s != null && ((TransportTreeNode)s).getType() == TransportTreeNode.Transport) {
                TrackInRealTimeLite.this.showInfo(((TransportTreeNode)s).getTransport().getId(), false, (PanelContext)((ViewerContext)this.getContext()).getParentContext());
                t.positionOnselect();
            } else {
                TrackInRealTimeLite.this.showInfo(null, false, (PanelContext)((ViewerContext)this.getContext()).getParentContext());
                t.positionOnselect();
            }
        }
    };
    Transport2DeviceLinkWSProxy t2deviceProxy = (Transport2DeviceLinkWSProxy)CurrentProxyFactory.getProxy(Transport2DeviceLink.class, (String)this.getKeyPage());
    Transport2DeviceLinkSearchCriteria t2delSC = new Transport2DeviceLinkSearchCriteria();
    private long idLoad;
    NDDataWSProxy proxy = (NDDataWSProxy)CurrentProxyFactory.getProxy(NDData.class, (String)this.getKeyPage());
    String sid = null;
    String sidTransportSt = null;
    String sidPoint = null;
    public boolean select = false;
    Transport selectTransport = null;
    TransportKind transportKind;
    BeanViewerAction<ViewerContext> btSetKind = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            FieldPresentation fp = ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("transportKind");
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateField(fp);
            FieldPresentation fp1 = ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("node");
            TreeNodeViewer v = (TreeNodeViewer)fp1.getViewer();
            List l = v.getSelectedItems();
            for (Object o : l) {
                TransportTreeNode t = (TransportTreeNode)((Object)o);
                TrackInRealTimeLite.this.setTransportKind(t, TrackInRealTimeLite.this.transportKind);
            }
            TrackInRealTimeLite.this.getApplyFilter().actionPerformed(null);
        }

        public String getHint() {
            return "\u0421\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0438\u043f \u0443 \u0422\u0421";
        }

        public String getIcon() {
            return ResourceStrings.btArrowRight;
        }
    };
    TransportStatus transportStatus;
    Crew crew;
    Transport2MobileDeviceLinkWSProxy proxy3 = (Transport2MobileDeviceLinkWSProxy)CurrentProxyFactory.getProxy(Transport2MobileDeviceLink.class, (String)this.getKeyPage());
    Transport2DeviceLinkSearchCriteria transportsc2 = (Transport2DeviceLinkSearchCriteria)this.proxy3._getSearchCriteriaTemplate();
    BeanViewerAction<ViewerContext> btSetStatus = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            FieldPresentation fp = ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("transportStatus");
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateField(fp);
            TransportWSProxy proxy = (TransportWSProxy)CurrentProxyFactory.getProxy(Transport.class, (String)TrackInRealTimeLite.this.getKeyPage());
            TransportExt t = TrackInRealTimeLite.this.devices.getTransportByDeviceId(TrackInRealTimeLite.this.selectDeviceId);
            if (TrackInRealTimeLite.this.selectDeviceId != null && t != null) {
                TrackInRealTimeLite.this.transportsc2.setTransportIdList(new Long[]{t.getId()});
                TrackInRealTimeLite.this.transportsc2.setActiveOnDate(new Date());
                Transport2MobileDeviceLinkWSProxy.SearchResultListTransport2MobileDeviceLink l = TrackInRealTimeLite.this.proxy3.getList(InitializedVariable.getContext((String)TrackInRealTimeLite.this.getKeyPage()), TrackInRealTimeLite.this.transportsc2);
                if (!l.isEmpty() && l.getObjList().length > 0) {
                    Transport2MobileDeviceLink lm = (Transport2MobileDeviceLink)l.getObjList()[0];
                    proxy.updateTransportStatusByCode(InitializedVariable.getContext((String)TrackInRealTimeLite.this.getKeyPage()), lm.getDevice().getCode(), TrackInRealTimeLite.this.getTransportStatus().getId());
                    TransportSearchCriteria sc = (TransportSearchCriteria)proxy._getSearchCriteriaTemplate();
                    sc.setIdList(new Long[]{t.getId()});
                    TransportWSProxy.SearchResultListTransport r = proxy.getList(InitializedVariable.getContext((String)TrackInRealTimeLite.this.getKeyPage()), sc);
                    if (!r.isEmpty()) {
                        TransportExt t2 = (TransportExt)((Object)r.getObjList()[0]);
                        TrackInRealTimeLite.this.mapSt.put(t.getId(), t2.getTransportStatus());
                        t.setTransportStatus(t2.getTransportStatus());
                    }
                    ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("listTransport");
                    TrackInRealTimeLite.this.showInfo(TrackInRealTimeLite.this.selectDeviceId, true, (PanelContext)((ViewerContext)this.getContext()).getParentContext());
                } else if (TrackInRealTimeLite.this.transportWithoutMobileDevice) {
                    proxy.updateTransportStatusOne(InitializedVariable.getContext((String)TrackInRealTimeLite.this.getKeyPage()), (Transport)t, TrackInRealTimeLite.this.getTransportStatus(), new Date(), new Date());
                } else {
                    ((ViewerContext)this.getContext()).getPresentator().getViewer().getFactory().runMessageEx((Object)new WarningMessage("\u041a \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u043c\u0443 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0443 \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043e \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u043e\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e "), new BeanViewerAction[]{new MessageOKButton()});
                }
            } else {
                ((ViewerContext)this.getContext()).getPresentator().getViewer().getFactory().runMessageEx((Object)new WarningMessage("\u041d\u0435\u0442 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430"), new BeanViewerAction[]{new MessageOKButton()});
            }
        }

        public String getIcon() {
            return ResourceStrings.btArrowRight;
        }

        public String getHint() {
            return "\u0421\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u0443 \u0422\u0421";
        }
    };
    BeanViewerAction<ViewerContext> btSetCrew = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            FieldPresentation fp = ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("crew");
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateField(fp);
            TransportExt t = TrackInRealTimeLite.this.devices.getTransportByDeviceId(TrackInRealTimeLite.this.selectDeviceId);
            if (TrackInRealTimeLite.this.selectDeviceId != null && t != null) {
                Transport t2 = TrackInRealTimeLite.this.pTransportWSProxy.getCurrentObject(InitializedVariable.getContext((String)TrackInRealTimeLite.this.getKeyPage()), t.getId());
                t2.setCrew(TrackInRealTimeLite.this.getCrew());
                t2 = TrackInRealTimeLite.this.pTransportWSProxy.save(InitializedVariable.getContext((String)TrackInRealTimeLite.this.getKeyPage()), t2);
                TrackInRealTimeLite.this.devices.updateTransport((TransportExt)t2);
                t.setCrew(TrackInRealTimeLite.this.crew);
                long d = TrackInRealTimeLite.this.selectDeviceId;
                TrackInRealTimeLite.this.updateIcons(TrackInRealTimeLite.this.selectDeviceId, t2);
                TransportTreeNodeCrew.changeCrewTransport(t2, (TransportTreeNodeCrew)TrackInRealTimeLite.this.node2);
                ((ListViewerT)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("listTransport").getViewer()).updateTransportTable(t);
                TrackInRealTimeLite.this.showInfo(d, true, (PanelContext)((ViewerContext)this.getContext()).getParentContext());
            } else {
                ((ViewerContext)this.getContext()).getPresentator().getViewer().getFactory().runMessageEx((Object)new WarningMessage("\u041d\u0435\u0442 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430"), new BeanViewerAction[]{new MessageOKButton()});
            }
        }

        public String getIcon() {
            return ResourceStrings.btArrowRight;
        }

        public String getHint() {
            return "\u041d\u0430\u0437\u043d\u0430\u0447\u0438\u0442\u044c \u0431\u0440\u0438\u0433\u0430\u0434\u0443 \u0443 \u0422\u0421";
        }
    };

    public synchronized int getState() {
        return this.state;
    }

    public synchronized void setState(int state) {
        this.state = state;
    }

    public Long getSelectDeviceId() {
        return this.selectDeviceId;
    }

    public StructureDevice getDevices() {
        return this.devices;
    }

    protected void initAddTrees() {
        this.node2 = new TransportTreeNodeCrew(TransportTreeNode.AllGroup, this);
    }

    protected void initTree() {
        this.node = new TransportTreeNodeGroup(TransportTreeNode.AllGroup, this);
        this.initAddTrees();
        this.setSelectNode(null);
    }

    public TrackInRealTimeLite(String keyPage) {
        super(keyPage);
        this.initTree();
        if (InitializedVariable.getWorkplaceId((String)keyPage) != null) {
            this.sp = InitializedVariable.runtimeParameters((String)keyPage, (Long)InitializedVariable.getWorkplaceId((String)keyPage));
            if (this.sp.get("InfoOnGPSDevice") != null) {
                this.setInfoOnGPSDevice(this.sp.get("InfoOnGPSDevice"));
            }
            if (this.sp.get("TimeRequeryToRealTime") != null) {
                this.minUpdate = Integer.parseInt(this.sp.get("TimeRequeryToRealTime"));
            }
            if (this.sp.get("MinSpeedForPeriods") != null) {
                minSpeed = Double.parseDouble(this.sp.get("MinSpeedForPeriods"));
            }
            if (this.sp.get("TimeNoData") != null) {
                this.timeNoData = (long)(Integer.parseInt(this.sp.get("TimeNoData")) * 60) * 1000L;
            }
            if (this.sp.get("TimeParking") != null) {
                this.timeParking = (long)(Integer.parseInt(this.sp.get("TimeParking")) * 60) * 1000L;
            }
            if (this.sp.get("TimeLongParking") != null) {
                this.timeLongParking = (long)(Integer.parseInt(this.sp.get("TimeLongParking")) * 60) * 1000L;
            }
            if (this.sp.get("TimeUpdateRealTime") != null) {
                this.timeUpdate = (long)Integer.parseInt(this.sp.get("TimeUpdateRealTime")) * 1000L;
            }
            if (this.sp.get("TimeIntervalGeoPoint") != null) {
                this.timeIntervalGeoPoint = Integer.parseInt(this.sp.get("TimeIntervalGeoPoint"));
            }
            if (this.sp.get("TimePeriodOutsideSMP") != null) {
                this.periodOutside = (long)(Integer.parseInt(this.sp.get("TimePeriodOutsideSMP")) * 60) * 1000L;
            }
            if (this.sp.get("VehiclesWithoutMobileDevice") != null) {
                this.transportWithoutMobileDevice = true;
            }
        }
        this.value = new MapValueWithTrack();
        this.value.setTrackInRealTime2((Object)this);
        if (this.list != null) {
            this.list.clear();
        }
    }

    private Image getImageIcon(String name) {
        if (this.mapIcons.get(name) == null) {
            this.loadDataFromServer(name);
        }
        return this.mapIcons.get(name);
    }

    private Image loadDataFromServer(String name) {
        if (name != null && !"".equals(name)) {
            try {
                String urlStr = proxy2.getURLForDownload(InitializedVariable.getContext((String)this.getKeyPage()), name);
                URL url = new URL(urlStr);
                BufferedImage img1 = ImageIO.read(url);
                this.mapIcons.put(name, img1);
                return img1;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void beforeDestroy(PanelContext pc) {
        UnsubscribingOptions optionsU;
        this.stop();
        if (this.sid != null) {
            optionsU = new UnsubscribingOptions();
            optionsU.setContext(InitializedVariable.getContext((String)this.getKeyPage()));
            optionsU.setServiceName("NDDataWS");
            optionsU.setMethodName("sendList");
            optionsU.setSid(this.sid);
            try {
                SocketClientFactory.unsubscribe((UnsubscribingOptions)optionsU, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.sidTransportSt != null) {
            optionsU = new UnsubscribingOptions();
            optionsU.setContext(InitializedVariable.getContext((String)this.getKeyPage()));
            optionsU.setServiceName("TransportStatusWS");
            optionsU.setMethodName("sendTransportStatus");
            optionsU.setSid(this.sidTransportSt);
            try {
                SocketClientFactory.unsubscribe((UnsubscribingOptions)optionsU, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.sidPoint != null) {
            optionsU = new UnsubscribingOptions();
            optionsU.setContext(InitializedVariable.getContext((String)this.getKeyPage()));
            optionsU.setServiceName("Transport2GPSPointWS");
            optionsU.setMethodName("sendTransport2GPSPoint");
            optionsU.setSid(this.sidPoint);
            try {
                SocketClientFactory.unsubscribe((UnsubscribingOptions)optionsU, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void setSelectAddNode(PanelContext pc) {
        this.node2.selecting = true;
        if (this.node2.getChildrenFromPersistence().size() == 0) {
            this.node2.init();
        }
        boolean set = true;
        for (TreeNode tt : this.node2.getChildrenFromPersistence()) {
            boolean sett = true;
            if (tt.getChildrenFromPersistence().size() == 0) {
                sett = false;
            }
            ((TransportTreeNode)tt).setSelect(sett);
            if (sett) continue;
            set = false;
        }
        this.node2.setSelectWithoutChildren(set);
        if (pc != null) {
            pc.getPanel().updateUIForPresentatorName("node2");
        }
        this.node2.selecting = false;
    }

    public void setSelectNode(final PanelContext pc) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                TrackInRealTimeLite.this.setSelectAddNode(pc);
                TrackInRealTimeLite.this.node.selecting = true;
                if (TrackInRealTimeLite.this.node.getChildrenFromPersistence().size() == 0) {
                    TrackInRealTimeLite.this.node.init();
                }
                boolean set = true;
                for (TreeNode tt : TrackInRealTimeLite.this.node.getChildrenFromPersistence()) {
                    boolean sett = true;
                    for (TreeNode t : tt.getChildrenFromPersistence()) {
                        boolean show = TrackInRealTimeLite.this.isShowObjectOnCrew((TransportTreeNode)t);
                        ((TransportTreeNode)t).setSelectWithoutChildren(show);
                        if (show) continue;
                        sett = false;
                    }
                    if (tt.getChildrenFromPersistence().size() == 0) {
                        sett = false;
                    }
                    ((TransportTreeNode)tt).setSelectWithoutChildren(sett);
                    if (sett) continue;
                    set = false;
                }
                TrackInRealTimeLite.this.node.setSelectWithoutChildren(set);
                if (pc != null) {
                    pc.getPanel().updateUIForPresentatorName("node");
                }
                TrackInRealTimeLite.this.node.selecting = false;
            }
        }).start();
    }

    private List<Transport> getTransportList() {
        this.devices.setListTransport(new ArrayList<Transport>());
        if (this.node != null) {
            for (TreeNode n1 : this.node.getChildrenFromPersistence()) {
                for (TreeNode n2 : n1.getChildrenFromPersistence()) {
                    if (!((TransportTreeNode)n2).isSelect()) continue;
                    this.devices.getListTransport().add(((TransportTreeNode)n2).getTransport());
                    this.devices.getTransportIdList().add(((TransportTreeNode)n2).getTransport().getId());
                }
            }
        }
        return this.devices.getListTransport();
    }

    private void stop() {
        this.setState(0);
        for (OneTrack t : this.list) {
            t.setState(0);
        }
        this.list.clear();
        this.currentView = 0;
        this.currentLoad = 0;
    }

    protected void getTransportStatusFromServer() {
        this.getTransportStatusFromServer(this.devices.getFullListTransportId(), true);
    }

    protected void updateGP(Long[] devicesFullListTransportId, boolean clear) {
        Transport2GPSPointSearchCriteria sc2 = new Transport2GPSPointSearchCriteria();
        sc2.setCount(Integer.valueOf(Integer.MAX_VALUE));
        sc2.setTransportIdList(devicesFullListTransportId);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(12, -this.timeIntervalGeoPoint);
        sc2.setDateFrom(c.getTime());
        c.add(12, this.timeIntervalGeoPoint * 2);
        sc2.setDateTill(c.getTime());
        Transport2GPSPoint[] pp = this.pTransportWSProxy.getNextPointByTransportListId(InitializedVariable.getContext((String)this.getKeyPage()), sc2);
        if (clear) {
            this.mapGeopCurrent.clear();
        }
        if (pp != null) {
            Transport2GPSPoint[] transport2GPSPointArray = pp;
            int n = pp.length;
            int n2 = 0;
            while (n2 < n) {
                Transport2GPSPoint p = transport2GPSPointArray[n2];
                Transport2GPSPointUI t = new Transport2GPSPointUI();
                t.setAdress(p.getAdress());
                t.setId(p.getId());
                t.setLat(p.getLat());
                t.setLon(p.getLon());
                t.setMessage(p.getMessage());
                t.setTransportId(p.getTransport().getId());
                this.mapGeopCurrent.put(p.getTransport().getId(), t);
                ++n2;
            }
        }
    }

    protected void getTransportStatusFromServer(Long[] devicesFullListTransportId, boolean clear) {
        TransportSearchCriteria sc = (TransportSearchCriteria)this.pTransportWSProxy._getSearchCriteriaTemplate();
        sc.setIdList(devicesFullListTransportId);
        sc.setCount(Integer.valueOf(devicesFullListTransportId.length));
        Object[] oo = this.pTransportWSProxy.getList(InitializedVariable.getContext((String)this.getKeyPage()), sc).getObjList();
        if (oo != null && oo.length > 0) {
            Object[] objectArray = oo;
            int n = oo.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.mapSt.put(((Transport)o).getId(), ((Transport)o).getTransportStatus());
                ++n2;
            }
        }
        this.updateGP(devicesFullListTransportId, clear);
    }

    public void refresh(PanelContext pc) {
        this.stop();
        this.getTransportStatusFromServer();
        this.value.getTracksNDData().clear();
        this.loadData(new Date().getTime());
        this.refreshView(pc);
    }

    protected void refreshAddNode(PanelContext pc) {
        pc.getPanel().updateUIForPresentatorName("node2");
    }

    public void beforeShow(final PanelContext pc) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                pc.getPanel().updateUIForPresentatorName("node");
                TrackInRealTimeLite.this.initFullListIDFromTree();
                List tt = ((TreeNodeViewer)pc.getPanel().getPresentatorForName("node").getViewer()).getSelectedItems();
                Object s = null;
                if (tt != null && tt.size() > 0) {
                    s = tt.get(0);
                }
                TrackInRealTimeLite.this.refresh(pc);
                TrackInRealTimeLite.this.refreshAddNode(pc);
                if (s != null && ((TransportTreeNode)s).getType() == TransportTreeNode.Transport) {
                    TrackInRealTimeLite.this.showInfo(((TransportTreeNode)s).getTransport().getId(), false, pc);
                    TrackInRealTimeLite.this.positionOnselect();
                } else {
                    TrackInRealTimeLite.this.showInfo(null, false, pc);
                    TrackInRealTimeLite.this.positionOnselect();
                }
            }
        }).start();
    }

    protected void refreshViewAddNode(PanelContext pc) {
        pc.getPanel().updateUIForPresentatorName("node2");
    }

    public void refreshView2(PanelContext pc) {
        pc.getPanel().updateUIForPresentatorName("listTransport");
        pc.getPanel().updateUIForPresentatorName("value");
        ((TreeNodeViewer)pc.getPanel().getPresentatorForName("node").getViewer()).repaint();
        this.refreshViewAddNode(pc);
    }

    public void refreshView(final PanelContext pc) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                pc.getPanel().updateUIForPresentatorName("listTransport");
                pc.getPanel().updateUIForPresentatorName("value");
                pc.getPanel().updateUIForPresentatorName("node");
                TrackInRealTimeLite.this.refreshViewAddNode(pc);
            }
        }).start();
    }

    public void positionOnselect() {
        this.value.init(this.selectDeviceId);
    }

    public void positionOnFullList() {
        ((MapViewerWithOneTrackInRealTimeSMP)this.value.mapViewerWithTrack).zoomToTracks();
        this.positionOnselectGroup(this.getNode());
    }

    public void positionOnselectGroup(TransportTreeNode node) {
        ArrayList<Transport> lists = new ArrayList<Transport>();
        if (node.getType() == TransportTreeNode.AllGroup) {
            for (TreeNode n1 : node.getChildrenFromPersistence()) {
                for (TreeNode n2 : n1.getChildrenFromPersistence()) {
                    if (!((TransportTreeNode)n2).isSelect()) continue;
                    lists.add(((TransportTreeNode)n2).getTransport());
                }
            }
        } else {
            for (TreeNode n2 : node.getChildrenFromPersistence()) {
                if (!((TransportTreeNode)n2).isSelect()) continue;
                lists.add(((TransportTreeNode)n2).getTransport());
            }
        }
        ArrayList<Long> idS = new ArrayList<Long>();
        for (Transport t : lists) {
            NavigationDevice d = this.devices.getDID(t.getId(), false);
            if (d == null) continue;
            idS.add(d.getId());
        }
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (idS.size() > 0) {
            int i = 0;
            while (i < this.list.size()) {
                NDData d;
                OneTrack tt = this.list.get(i);
                if (idS.contains(tt.getDeviceId()) && (d = tt.getPrev()) != null) {
                    if (minLat == null || d.getLat() < minLat) {
                        minLat = d.getLat();
                    }
                    if (maxLat == null || d.getLat() > maxLat) {
                        maxLat = d.getLat();
                    }
                    if (minLon == null || d.getLon() < minLon) {
                        minLon = d.getLon();
                    }
                    if (maxLon == null || d.getLon() > maxLon) {
                        maxLon = d.getLon();
                    }
                }
                ++i;
            }
        }
        if (minLat != null) {
            ((MapViewerWithOneTrackInRealTimeSMP)this.value.mapViewerWithTrack).zoomToTracks(new Double[]{minLat, maxLat, minLon, maxLon});
        }
        this.value.setSelected(idS);
    }

    public boolean isShowObjectOnCrew(TransportTreeNode node) {
        Crew tk = node.getTransport().getCrew();
        return tk != null;
    }

    protected void initListTransport() {
    }

    public void initFullListIDFromTree() {
        this.devices.clear();
        this.getTransportList();
        ArrayList<Long> ll = new ArrayList<Long>();
        if (this.devices.getListTransport() != null && this.devices.getListTransport().size() > 0) {
            for (Transport o : this.devices.getListTransport()) {
                ll.add(o.getId());
            }
            this.t2delSC.setTransportIdList(ll.toArray(new Long[0]));
            this.t2delSC.setActiveOnDate(new Date());
            this.t2delSC.setCount(this.t2deviceProxy.getCount(InitializedVariable.getContext((String)this.getKeyPage()), this.t2delSC));
            Transport2DeviceLinkWSProxy.SearchResultListTransport2DeviceLink sr = this.t2deviceProxy.getList(InitializedVariable.getContext((String)this.getKeyPage()), this.t2delSC);
            if (!sr.isEmpty()) {
                Object[] objectArray = sr.getObjList();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    this.devices.addLink((Transport2DeviceLink)o);
                    ++n2;
                }
            }
        }
        this.devices.setFullList();
    }

    public Object[] loadListLastPoint() {
        return this.loadListLastPoint(this.devices.getFullListId());
    }

    public Object[] loadListLastPoint(Long[] listId) {
        NDDataSearchCriteria sc = new NDDataSearchCriteria();
        sc = (NDDataSearchCriteria)this.proxy._getSearchCriteriaTemplate();
        sc.setCount(Integer.valueOf(listId.length));
        sc.setDeviceIdList(listId);
        sc.appendSorting(SortObject.getInstance((String)"createdDateTime", (String)SortObject.DIRECTION_ASC));
        Object[] listLastPoint = this.proxy.getLastCachedData(InitializedVariable.getContext((String)this.getKeyPage()), sc);
        ArrayList<NDData> llp = new ArrayList<NDData>();
        Object[] objectArray = listLastPoint;
        int n = listLastPoint.length;
        int n2 = 0;
        while (n2 < n) {
            NDData d = objectArray[n2];
            Transport2DeviceLink l = this.devices.getLinkByDeviceId(d.getDeviceId());
            if (l != null) {
                if (l.getBeginDate() == null && l.getEndDate() == null) {
                    llp.add(d);
                } else if (l.getBeginDate() != null && l.getEndDate() == null && l.getBeginDate().before(d.getCreatedDateTime())) {
                    llp.add(d);
                } else if (l.getBeginDate() == null && l.getEndDate() != null && l.getEndDate().after(d.getCreatedDateTime())) {
                    llp.add(d);
                } else if (l.getBeginDate() != null && l.getEndDate() != null && l.getBeginDate().before(d.getCreatedDateTime()) && l.getEndDate().after(d.getCreatedDateTime())) {
                    llp.add(d);
                }
            }
            ++n2;
        }
        listLastPoint = llp.toArray(new NDData[0]);
        return listLastPoint;
    }

    public void addLoadData(Long[] newDevIds) {
        Object[] listLastPoint = this.loadListLastPoint(newDevIds);
        if (listLastPoint != null) {
            int i = 0;
            while (i < listLastPoint.length) {
                OneTrack track = new OneTrack(((NDData)listLastPoint[i]).getDeviceId(), new ArrayList<NDData>(), null);
                TransportExt tt = this.devices.getTransportByDeviceId(track.getDeviceId());
                this.setColorTrack(track, tt);
                track.setState(1);
                track.setDateS(null);
                track.setDateE(null);
                track.setSc((NDDataSearchCriteria)this.proxy._getSearchCriteriaTemplate());
                track.getSc().appendSorting(SortObject.getInstance((String)"createdDateTime", (String)SortObject.DIRECTION_ASC));
                track.getSc().setDeviceIdList(new Long[]{track.getDeviceId()});
                track.pushNDData((NDData)listLastPoint[i]);
                track.setDateS(((NDData)listLastPoint[i]).getCreatedDateTime());
                this.list.add(track);
                ++i;
            }
        }
        this.reconnect();
    }

    private OneTrack getTrack(long deviceId) {
        for (OneTrack t : this.list) {
            if (t.getDeviceId() != deviceId) continue;
            return t;
        }
        return null;
    }

    protected void setImage(OneTrack track, Transport t) {
        if (t.getCrew() != null) {
            track.setImage(this.getImageIcon(t.getCrew().getName()));
        } else {
            track.setImage(null);
        }
    }

    protected void setColorTrack(OneTrack track, Transport t) {
        Color color = Color.RED;
        track.setColor(null);
        if (t != null && t.getTransportStatus() != null && t.getTransportStatus().getColor() != null) {
            color = new Color(t.getTransportStatus().getColor());
            track.setColor(color);
        }
        this.setImage(track, t);
        TrackNDData tt = this.value.getTrackNDData(track.getDeviceId());
        if (tt != null) {
            tt.setImage(track.getImage());
            tt.setParameter("color", track.getColor());
        }
    }

    public void reconnect() {
        SubscribingOptions_SendListNDData options = new SubscribingOptions_SendListNDData();
        options.setContext(InitializedVariable.getContext((String)this.getKeyPage()));
        options.setServiceName("NDDataWS");
        options.setMethodName("sendList");
        options.setDeviceIdList(Arrays.asList((Object[])this.devices.getFullListId()));
        options.setSid(this.sid);
        try {
            this.sid = SocketClientFactory.subscribe((Object)((Object)this), (SubscribingOptions)options, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SubscribingOptions_SendTransportStatus optionss = new SubscribingOptions_SendTransportStatus();
        optionss.setContext(InitializedVariable.getContext((String)this.getKeyPage()));
        optionss.setServiceName("TransportStatusWS");
        optionss.setMethodName("sendTransportStatus");
        optionss.setTransportIdList(Arrays.asList((Object[])this.devices.getFullListTransportId()));
        optionss.setSid(this.sidTransportSt);
        try {
            this.sidTransportSt = SocketClientFactory.subscribe((Object)((Object)this), (SubscribingOptions)optionss, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.connectGP();
    }

    protected void connectGP() {
        SubscribingOptions_SendTransport2GPSPoint optionp = new SubscribingOptions_SendTransport2GPSPoint();
        optionp.setContext(InitializedVariable.getContext((String)this.getKeyPage()));
        optionp.setServiceName("Transport2GPSPointWS");
        optionp.setMethodName("sendTransport2GPSPoint");
        optionp.setTransportIdList(Arrays.asList((Object[])this.devices.getFullListTransportId()));
        optionp.setSid(this.sidPoint);
        try {
            this.sidPoint = SocketClientFactory.subscribe((Object)((Object)this), (SubscribingOptions)optionp, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendTransport2GPSPoint(List<Transport2GPSPointUI> list) {
        for (Transport2GPSPointUI p2 : list) {
            boolean neeupdGP = false;
            boolean neeupd = false;
            Transport2GPSPointUI p1 = this.mapGeopCurrent.get(p2.getTransportId());
            if (p1 == null && p2 != null || p1 != null && p2 == null || p1 != null && !p1.equals(p2)) {
                this.mapGeopCurrent.put(p2.getTransportId(), p2);
                neeupdGP = true;
            }
            int newstate = TransportExt.TargetDisable;
            if (p2.getLat() != null && p2.getAdress() != null) {
                newstate = TransportExt.TargetYes;
            } else if (p2.getLat() == null && p2.getAdress() != null) {
                newstate = TransportExt.TargetNo;
            }
            TransportExt t = (TransportExt)this.devices.getListTransport().stream().filter(tt -> tt.getId().equals(p2.getTransportId())).findFirst().get();
            if (t.getStateGP().getState() != newstate) {
                t.getStateGP().setState(newstate);
                neeupd = true;
            }
            if (neeupd) {
                this.getValue().mapViewerWithTrack.change();
                ((ListViewerT)((PanelContext)this.getValue().mapViewerWithTrack.getViewerContext().getParentContext()).getPanel().getPresentatorForName("listTransport").getViewer()).updateTransportTable(t);
            }
            if (!neeupdGP) continue;
            this.getValue().mapViewerWithTrack.change();
        }
    }

    public void sendTransportStatus(List<Transport2StatusLink> list) {
        for (Transport2StatusLink l : list) {
            this.mapSt.put(l.getTransport().getId(), l.getTransport().getTransportStatus());
        }
    }

    public void sendList(List<NDData> list) {
        Collections.sort(list, (Comparator)new Comparator<NDData>(){

            @Override
            public int compare(NDData o1, NDData o2) {
                return o1.getCreatedDateTime().compareTo(o2.getCreatedDateTime());
            }
        });
        for (NDData d : list) {
            OneTrack t = this.getTrack(d.getDeviceId());
            if (t == null || !t.getDateS().before(d.getCreatedDateTime())) continue;
            t.pushNDData(d);
            t.setDateS(d.getCreatedDateTime());
            Double angle = null;
            NDData data = t.popNDData();
            NDData prev = t.getPrev();
            if (data != null) {
                if (prev != null) {
                    angle = TrackInRealTimeLite.getAngle(prev, data);
                }
                this.viewPoint(data, true, angle, t);
                t.setPrev(data);
            }
            this.updateStateTS(t, data != null ? data : prev);
        }
    }

    public void loadData(long idLoad) {
        this.idLoad = idLoad;
        this.listLastPoint = this.loadListLastPoint();
        if (this.listLastPoint != null) {
            this.setState(1);
            int i = 0;
            while (i < this.listLastPoint.length) {
                OneTrack track = new OneTrack(((NDData)this.listLastPoint[i]).getDeviceId(), new ArrayList<NDData>(), null);
                TransportExt tt = this.devices.getTransportByDeviceId(track.getDeviceId());
                this.setColorTrack(track, tt);
                track.setState(1);
                track.setDateS(null);
                track.setDateE(null);
                track.setSc((NDDataSearchCriteria)this.proxy._getSearchCriteriaTemplate());
                track.getSc().appendSorting(SortObject.getInstance((String)"createdDateTime", (String)SortObject.DIRECTION_ASC));
                track.getSc().setDeviceIdList(new Long[]{track.getDeviceId()});
                track.setDateS(((NDData)this.listLastPoint[i]).getCreatedDateTime());
                track.pushNDData((NDData)this.listLastPoint[i]);
                track.setPrev((NDData)this.listLastPoint[i]);
                this.list.add(track);
                NDData prev = track.getPrev();
                Double angle = null;
                this.viewPoint(prev, true, angle, track);
                this.updateStateTS(track, prev);
                ++i;
            }
            this.reconnect();
        }
    }

    public String getTransportToString(Transport t) {
        if (t == null) {
            return "\u041d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d";
        }
        return ((TransportExt)t).getNameSMP();
    }

    synchronized int getCurrentView() {
        int temp = this.currentView++;
        return temp;
    }

    public static synchronized Double getAngle(NDData prev, NDData last) {
        Double angle = null;
        if (last.getSpeed() == null || last.getSpeed() == 0.0) {
            return angle;
        }
        Double len = Math.sqrt((last.getLon() - prev.getLon()) * (last.getLon() - prev.getLon()) + (last.getLat() - prev.getLat()) * (last.getLat() - prev.getLat()));
        if (len > 1.0E-10) {
            angle = Math.asin((last.getLat() - prev.getLat()) / len);
            angle = 90.0 - 180.0 * angle / Math.PI;
            if (last.getLon() - prev.getLon() > 0.0) {
                angle = 360.0 - angle;
            }
            angle = 360.0 - angle;
        }
        return angle;
    }

    private void updateIcons(Long deviceId, Transport t) {
        for (OneTrack tt : this.list) {
            if (tt.getDeviceId() != deviceId.longValue()) continue;
            this.setColorTrack(tt, t);
            return;
        }
    }

    protected void updateStateTS(OneTrack track, NDData data) {
        TransportExt t = this.devices.getTransportByDeviceId(track.getDeviceId());
        boolean neeupd = false;
        if (t != null && (t.getTransportStatus() == null && this.mapSt.get(t.getId()) != null || t.getTransportStatus() != null && !t.getTransportStatus().equals((Object)this.mapSt.get(t.getId())))) {
            neeupd = true;
            t.setTransportStatus(this.mapSt.get(t.getId()));
            this.setColorTrack(track, t);
        }
        if (track != null && t != null) {
            String newState = nodata;
            String rez = "\u043d\u0435\u0442 \u0441\u0432\u044f\u0437\u0438";
            if (data != null) {
                long current = System.currentTimeMillis();
                if ((current -= data.getCreatedDateTime().getTime()) > this.timeNoData) {
                    newState = nodata;
                } else if (data.getLastStopStartedAt() == null) {
                    newState = runing;
                } else {
                    current = data.getCreatedDateTime().getTime();
                    newState = (current -= data.getLastStopStartedAt().getTime()) > this.timeLongParking ? parking_long : (current > this.timeParking ? parking : runing);
                }
                rez = current < this.periodOutside ? "\u043d\u0430 \u0441\u0432\u044f\u0437\u0438" : (current < 2L * this.periodOutside ? "\u043d\u0435\u0442 \u0441\u0432\u044f\u0437\u0438" : "\u043d\u0435\u0442 \u0441\u0432\u044f\u0437\u0438");
                if (!rez.equals(t.getStatusLink())) {
                    t.setStatusLink(rez);
                    neeupd = true;
                }
                if (!newState.equals(t.getStateIcon())) {
                    t.getStateIcon().setIcon(newState);
                    if (nodata.equals(newState)) {
                        t.getStateIcon().setHint("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
                    } else if (parking.equals(newState)) {
                        t.getStateIcon().setHint("\u0421\u0442\u043e\u044f\u043d\u043a\u0430");
                    } else if (parking_long.equals(newState)) {
                        t.getStateIcon().setHint("\u0414\u043b\u0438\u0442.\u0441\u0442\u043e\u044f\u043d\u043a\u0430");
                    } else {
                        t.getStateIcon().setHint("\u0414\u0432\u0438\u0436\u0435\u043d\u0438\u0435");
                    }
                    neeupd = true;
                }
            }
        }
        if (neeupd) {
            this.getValue().mapViewerWithTrack.change();
            ((ListViewerT)((PanelContext)this.getValue().mapViewerWithTrack.getViewerContext().getParentContext()).getPanel().getPresentatorForName("listTransport").getViewer()).updateTransportTable(t);
        }
    }

    public String getInfoOnGPSDevice() {
        return this.infoOnGPSDevice;
    }

    public void setInfoOnGPSDevice(String infoOnGPSDevice) {
        this.infoOnGPSDevice = infoOnGPSDevice;
    }

    public synchronized void viewPoint(NDData data, boolean curOnly, Double angle, OneTrack t) {
        TrackNDData tt = this.value.getTrackNDDataCreate(data.getDeviceId(), true, angle, this.getInfoOnGPSDevice(), NodeType.DEFAULT, t.getColor(), true);
        tt.setImage(t.getImage());
        this.value.event(tt, (AbstractNDData)data);
        this.selectData(data);
    }

    protected void selectData(NDData data) {
        if (data.getDeviceId().equals(this.selectDeviceId)) {
            this.showInfo(this.selectDeviceId, true, (PanelContext)this.value.mapViewerWithTrack.getViewerContext().getParentContext());
        }
    }

    protected void selectTransportOnAddNode(Transport t, PanelContext pc) {
        TransportTreeNode tt2 = null;
        for (TreeNode n : this.node2.getChildrenFromPersistence()) {
            for (TreeNode n1 : n.getChildrenFromPersistence()) {
                if (!((TransportTreeNode)n1).getTransport().equals((Object)t)) continue;
                tt2 = (TransportTreeNode)n1;
                break;
            }
            if (tt2 != null) break;
        }
        ((TreeNodeViewer)pc.getPanel().getPresentatorForName("node2").getViewer()).setSelection((Object)tt2);
    }

    public Transport getSelectTransport() {
        return this.selectTransport;
    }

    public void setSelectTransport(Transport selectTransport) {
        this.selectTransport = selectTransport;
    }

    private void selectTrancport(NavigationDevice d, PanelContext pc) {
        this.select = true;
        TransportExt t = this.devices.getTransportByDeviceId(d.getId());
        int i = ((ListViewer)pc.getPanel().getPresentatorForName((String)"listTransport").getViewer()).getTM().list.indexOf((Object)t);
        try {
            ((ListViewer)pc.getPanel().getPresentatorForName("listTransport").getViewer()).getTM().setSelectedRows(new int[]{i});
        }
        catch (Exception exception) {}
        TransportTreeNode tt = null;
        for (TreeNode n : this.node.getChildrenFromPersistence()) {
            for (TreeNode n1 : n.getChildrenFromPersistence()) {
                if (!((TransportTreeNode)n1).getTransport().equals((Object)t)) continue;
                tt = (TransportTreeNode)n1;
                break;
            }
            if (tt != null) break;
        }
        this.selectTransportOnAddNode(t, pc);
        ((TreeNodeViewer)pc.getPanel().getPresentatorForName("node").getViewer()).setSelection((Object)tt);
        if (tt.getTransport() != null) {
            this.setSelectTransport(tt.getTransport());
        }
        this.select = false;
    }

    public void showInfo(Long id, boolean dev, PanelContext pc) {
        if (!this.select) {
            NavigationDevice device;
            this.select = true;
            this.selectDeviceId = null;
            if (id != null && (device = this.devices.getDID(id, dev)) != null) {
                this.selectDeviceId = device.getId();
                this.selectTrancport(device, pc);
            }
            this.select = false;
        }
    }

    @ListField(fields={@Field(title="", order=500, viewer={MapViewerWithOneTrackInRealTimeSMP.class}, propertiesLayout="Split1/h/r/0.25")})
    public MapValueWithTrack getValue() {
        return this.value;
    }

    @ListField(fields={@Field(title="", order=15, propertiesLayout="Split1/h/l/0.25:Split1/v/l/0.7:Tab1/\u0413\u0440\u0443\u043f\u043f\u044b:0/hidemode 1,filly# cell 0 1 2, growy 0# cell 0 1 2, growy 0", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getApplyFilter() {
        return this.applyFilter;
    }

    @ListField(fields={@Field(title="\u0422\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442", order=0, propertiesLayout="Split1/h/l/0.25:Split1/v/l/0.7:Tab1/\u041e\u0431\u0449\u0438\u0439 \u0441\u043f\u0438\u0441\u043e\u043a:0/hidemode 1, fill# cell 0 1 4, span, growy # cell 0 0 4, growy 0", content=TransportExt.class, viewer={ListViewerT.class}, propertiesField={"keyContentView=inRealTimeSMP"}, panels={@PanelField(actions={@ActionField(clazz=CallButton.class, order=0)}, classView={@ClassView(clazz=ControlTransport.class, keyView="2", name="control", order=10)})})})
    public List<Transport> getListTransport() {
        return this.devices.getListTransport();
    }

    @ListField(fields={@Field(title="", order=10, propertiesLayout="Split1/h/l/0.25:Split1/v/l/0.7:Tab1/\u0413\u0440\u0443\u043f\u043f\u044b:0/hidemode 1, fill# cell 0 0 5, spanx, growy# cell 0 0 5", viewer={TreeNodeViewer.class})})
    public TransportTreeNode getNode() {
        return this.node;
    }

    @ListField(fields={@Field(title="", order=20, propertiesLayout="Split1/h/l/0.25:Split1/v/l/0.7:Tab1/\u0411\u0440\u0438\u0433\u0430\u0434\u044b:0/hidemode 1, fill# cell 0 0 5, spanx, growy# cell 0 0 5", viewer={TreeNodeViewer.class})})
    public TransportTreeNode getNode2() {
        return this.node2;
    }

    @ListField(fields={@Field(title="\u0422\u0438\u043f \u0422\u0421", showInManagerPanel=true, content=TransportKind.class, order=31, viewer={FRCBaseDirectoryViewer.class}, propertiesLayout="Split1/h/l/0.25:Split1/v/l/0.7:Tab1/\u0413\u0440\u0443\u043f\u043f\u044b:0/hidemode 1# cell 1 2# cell 1 2")})
    public TransportKind getTransportKind() {
        return this.transportKind;
    }

    public void setTransportKind(TransportKind transportKind) {
        this.transportKind = transportKind;
    }

    @ListField(fields={@Field(title="", showInManagerPanel=true, order=32, propertiesLayout="Split1/h/l/0.25:Split1/v/l/0.7:Tab1/\u0413\u0440\u0443\u043f\u043f\u044b:0/hidemode 1# cell 1 2# cell 1 2", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getBtSetKind() {
        return this.btSetKind;
    }

    public void setTransportKind(TransportTreeNode t, TransportKind transportKind) {
        if (TransportTreeNode.AllGroup == t.getType() || TransportTreeNode.Group == t.getType()) {
            for (TreeNode tt : t.getChildrenFromPersistence()) {
                this.setTransportKind((TransportTreeNode)tt, transportKind);
            }
        } else if (TransportTreeNode.Transport == t.getType()) {
            Transport tt = t.getTransport();
            tt.setTransportKind(transportKind);
            this.pTransportWSProxy.save(InitializedVariable.getContext((String)this.getKeyPage()), tt);
        }
    }

    @ListField(fields={@Field(title="\u0421\u0442\u0430\u0442\u0443\u0441", content=TransportStatus.class, order=50, viewer={StatusViewer.class}, propertiesLayout="Split1/h/l/0.25:Split1/v/l/0.7:Tab1/\u041e\u0431\u0449\u0438\u0439 \u0441\u043f\u0438\u0441\u043e\u043a:0:1/fillx//spanx# cell 1 3, growx, w 300 # cell 0 3, growpriox 0, growx 0")})
    public TransportStatus getTransportStatus() {
        return this.transportStatus;
    }

    public void setTransportStatus(TransportStatus transportStatus) {
        this.transportStatus = transportStatus;
    }

    @ListField(fields={@Field(title="", order=51, propertiesLayout="Split1/h/l/0.25:Split1/v/l/0.7:Tab1/\u041e\u0431\u0449\u0438\u0439 \u0441\u043f\u0438\u0441\u043e\u043a:0:1# cell 3 3, growx 0# cell 2 3, growx 0", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getBtSetStatus() {
        return this.btSetStatus;
    }

    @ListField(fields={@Field(title="\u0411\u0440\u0438\u0433\u0430\u0434\u0430", content=Crew.class, order=60, viewer={FRCBaseDirectoryViewer.class}, propertiesLayout="Split1/h/l/0.25:Split1/v/l/0.7:Tab1/\u041e\u0431\u0449\u0438\u0439 \u0441\u043f\u0438\u0441\u043e\u043a:0:1# cell 1 4, growx, w 300 # cell 0 4, growpriox 0, growx 0")})
    public Crew getCrew() {
        return this.crew;
    }

    public void setCrew(Crew crew) {
        this.crew = crew;
    }

    @ListField(fields={@Field(title="", order=51, propertiesLayout="Split1/h/l/0.25:Split1/v/l/0.7:Tab1/\u041e\u0431\u0449\u0438\u0439 \u0441\u043f\u0438\u0441\u043e\u043a:0:1# cell 3 4, growx 0 # cell 2 4, growx 0", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getBtSetCrew() {
        return this.btSetCrew;
    }

    public static class ChangeAllTSFromTree
    extends ActionCalculatedObject {
        public void actionPerformed(Object message) {
            if (!initializing) {
                FieldPresentation fp = ((ViewerContext)this.getContext()).getPresentator();
                ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateField(fp);
                ControlTransport ct = (ControlTransport)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject();
                TrackInRealTimeLite t = (TrackInRealTimeLite)((Object)((PanelContext)((ViewerContext)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getParentContext()).getParentContext()).getObject());
                t.initListTransport();
                if (ct.isShowAllt()) {
                    t.getValue().getTracksNDData().clear();
                    t.getNode().setSelectWithoutChildren(true);
                    for (TreeNode tt : t.getNode().getChildrenFromPersistence()) {
                        ((TransportTreeNode)tt).setSelectWithoutChildren(true);
                        for (TreeNode t1 : tt.getChildrenFromPersistence()) {
                            ((TransportTreeNode)t1).setSelectWithoutChildren(true);
                        }
                    }
                } else {
                    boolean set = true;
                    for (TreeNode tt : t.getNode().getChildrenFromPersistence()) {
                        boolean sett = true;
                        for (TreeNode tr : tt.getChildrenFromPersistence()) {
                            boolean show = t.isShowObjectOnCrew((TransportTreeNode)tr);
                            ((TransportTreeNode)tr).setSelectWithoutChildren(show);
                            if (show) continue;
                            sett = false;
                        }
                        if (tt.getChildrenFromPersistence().size() == 0) {
                            sett = false;
                        }
                        ((TransportTreeNode)tt).setSelectWithoutChildren(sett);
                        if (sett) continue;
                        set = false;
                    }
                    t.getNode().setSelectWithoutChildren(set);
                }
                t.initFullListIDFromTree();
                t.refresh((PanelContext)((ViewerContext)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getParentContext()).getParentContext());
            }
        }
    }

    public static class CheckRenderer
    extends JPanel
    implements TreeCellRenderer {
        private static final long serialVersionUID = 7199225866735224272L;
        protected JCheckBox check;
        protected TreeLabel label;

        public CheckRenderer() {
            this.setLayout(null);
            this.check = new JCheckBox();
            this.add(this.check);
            this.label = new TreeLabel();
            this.add(this.label);
            this.check.setBackground(UIManager.getColor("Tree.textBackground"));
            this.label.setForeground(UIManager.getColor("Tree.textForeground"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
            this.setEnabled(tree.isEnabled());
            if (value instanceof TransportTreeNode) {
                boolean select = ((TransportTreeNode)((Object)value)).isSelect();
                this.check.setSelected(select);
            }
            this.label.setFont(tree.getFont());
            this.label.setText(stringValue);
            this.label.setSelected(isSelected);
            this.label.setFocus(hasFocus);
            if (leaf) {
                this.label.setIcon(UIManager.getIcon("Tree.leafIcon"));
            } else if (expanded) {
                this.label.setIcon(UIManager.getIcon("Tree.openIcon"));
            } else {
                this.label.setIcon(UIManager.getIcon("Tree.closedIcon"));
            }
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d_check = this.check.getPreferredSize();
            Dimension d_label = this.label.getPreferredSize();
            return new Dimension(d_check.width + d_label.width, d_check.height < d_label.height ? d_label.height : d_check.height);
        }

        @Override
        public void doLayout() {
            Dimension d_check = this.check.getPreferredSize();
            Dimension d_label = this.label.getPreferredSize();
            int y_check = 0;
            int y_label = 0;
            if (d_check.height < d_label.height) {
                y_check = (d_label.height - d_check.height) / 2;
            } else {
                y_label = (d_check.height - d_label.height) / 2;
            }
            this.check.setLocation(0, y_check);
            this.check.setBounds(0, y_check, d_check.width, d_check.height);
            this.label.setLocation(d_check.width, y_label);
            this.label.setBounds(d_check.width, y_label, d_label.width, d_label.height);
        }

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        @Override
        public void setForeground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setForeground(color);
        }

        public class TreeLabel
        extends JLabel {
            private static final long serialVersionUID = 4529894209364732567L;
            boolean isSelected;
            boolean hasFocus;

            @Override
            public void setBackground(Color color) {
                if (color instanceof ColorUIResource) {
                    color = null;
                }
                super.setBackground(color);
            }

            @Override
            public void paint(Graphics g) {
                String str = this.getText();
                if (str != null && str.length() > 0) {
                    if (this.isSelected) {
                        this.setForeground(UIManager.getColor("Tree.selectionForeground"));
                        g.setColor(UIManager.getColor("Tree.selectionBackground"));
                    } else {
                        this.setForeground(UIManager.getColor("Tree.textForeground"));
                        g.setColor(UIManager.getColor("Tree.textBackground"));
                    }
                    Dimension d = this.getPreferredSize();
                    int imageOffset = 0;
                    Icon currentI = this.getIcon();
                    if (currentI != null) {
                        imageOffset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                    }
                    g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
                    if (this.hasFocus) {
                        g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                        g.drawRect(imageOffset, 0, d.width - 1 - imageOffset, d.height - 1);
                    }
                }
                super.paint(g);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension retDimension = super.getPreferredSize();
                if (retDimension != null) {
                    retDimension = new Dimension(retDimension.width + 3, retDimension.height);
                }
                return retDimension;
            }

            public void setSelected(boolean isSelected) {
                this.isSelected = isSelected;
            }

            public void setFocus(boolean hasFocus) {
                this.hasFocus = hasFocus;
            }
        }
    }

    @ListView(views={@View(title=""), @View(title="", keyView="2"), @View(title="", keyView="3")})
    public static class ControlTransport {
        private boolean showAll;
        private Tracking tracking = new Tracking();
        private Tracking ntracking = new Tracking(){

            @Override
            protected boolean isTracking() {
                return false;
            }

            @Override
            public String getHint() {
                return "\u0423 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u0443\u0431\u0440\u0430\u0442\u044c \u043f\u0440\u0438\u0437\u043d\u0430\u043a \u0441\u043b\u0435\u0436\u0435\u043d\u0438\u044f";
            }

            @Override
            public String getIcon() {
                return ResourceStrings.btFieldNoVisible;
            }
        };

        @ListField(fields={@Field(title="\u0412\u0441\u0435 \u0422\u0421/\u0421\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0441 \u0431\u0440\u0438\u0433\u0430\u0434\u043e\u0439 \u0422\u0421", keyView="2", order=50, propertiesLayout="", showInManagerPanel=true, propertiesUI={"hint=\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0432\u0441\u0435 \u0422\u0421"}, changeAction={ChangeAllTSFromTree.class}), @Field(title="\u0412\u0441\u0435 \u0422\u0421/\u0421\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 c \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u043e\u043c \u0422\u0421", keyView="3", order=50, propertiesLayout="", showInManagerPanel=true, propertiesUI={"hint=\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0432\u0441\u0435 \u0422\u0421"}, changeAction={ChangeAllTSFromTree.class})})
        public boolean isShowAllt() {
            return this.showAll;
        }

        public void setShowAllt(boolean showAll) {
            this.showAll = showAll;
        }

        @ListField(fields={@Field(title="", order=10, viewer={ActionButton.class}, showInManagerPanel=true), @Field(title="", keyView="2", order=10, viewer={ActionButton.class}, showInManagerPanel=true), @Field(title="", keyView="3", order=10, viewer={ActionButton.class}, showInManagerPanel=true)})
        public Tracking getTracking() {
            return this.tracking;
        }

        @ListField(fields={@Field(title="", order=20, viewer={ActionButton.class}, showInManagerPanel=true), @Field(title="", keyView="2", order=20, viewer={ActionButton.class}, showInManagerPanel=true), @Field(title="", keyView="3", order=20, viewer={ActionButton.class}, showInManagerPanel=true)})
        public Tracking getNtracking() {
            return this.ntracking;
        }
    }

    public static class ListViewerT<T>
    extends ListViewer<T> {
        public void updateTransportTable(Transport t) {
            if (t != null) {
                JTable table = (JTable)this.getTM().getTableComponent();
                int k = this.getTM().list.indexOf(t);
                if (k >= 0 && k < ((DefaultTableModel)table.getModel()).getRowCount()) {
                    int i = table.getRowSorter().convertRowIndexToView(k);
                    ((DefaultTableModel)table.getModel()).fireTableRowsUpdated(i, i);
                }
            }
        }

        public ListViewerT(UIFactory<T> factory) {
            super(factory);
            this.addActionOnSelect();
        }

        protected void actionOnSelect() {
            super.actionOnSelect();
            List l = this.getSelectedItems();
            TrackInRealTimeLite t = (TrackInRealTimeLite)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject());
            if (!t.select) {
                if (l != null && l.size() > 0) {
                    Long id = null;
                    boolean de = false;
                    if (l.get(0) instanceof TransportExt) {
                        de = false;
                        for (Object o : l) {
                            id = ((TransportExt)((Object)o)).getId();
                            ((TransportExt)((Object)o)).setTracking(true);
                            this.updateTransportTable((TransportExt)((Object)o));
                            t.setSelectTransport((TransportExt)((Object)o));
                        }
                    }
                    if (l.get(0) instanceof PathInfo) {
                        id = ((PathInfo)l.get(0)).getId();
                        de = true;
                    }
                    t.showInfo(id, de, (PanelContext)this.getViewerContext().getParentContext());
                } else {
                    t.showInfo(null, false, (PanelContext)this.getViewerContext().getParentContext());
                }
                t.positionOnselect();
            }
        }
    }

    public static class StatusViewer<T>
    extends FRCBaseDirectoryViewer<T> {
        public StatusViewer(UIFactory<T> factory) {
            super(factory);
        }

        protected void addInMap(Object[] list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Object[] objectArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof TransportStatus && ((TransportStatus)object).getCode() != null && ((TransportStatus)object).getCode().startsWith("002")) {
                    String sDesc = ((Directories)object).getDescription();
                    map.put(sDesc != null ? sDesc : "", object);
                }
                ++n2;
            }
            String key = String.valueOf(this.getContentClass().getName()) + this.getKey();
            itemsObjectMap.put(key, map);
        }
    }

    public static class StructureDevice {
        private HashMap<Long, Transport> devices = new HashMap();
        private HashMap<Long, Transport2DeviceLink> devicesLink = new HashMap();
        private Long[] fullListId = null;
        private Long[] fullListTransportId = null;
        List<Transport> listTransport = new ArrayList<Transport>();
        List<Long> transportIdList;
        TrackInRealTimeLite realTimeLite;
        String keyPage;
        Transport2DeviceLinkWSProxy t2deviceProxy = (Transport2DeviceLinkWSProxy)CurrentProxyFactory.getProxy(Transport2DeviceLink.class);
        Transport2DeviceLinkSearchCriteria t2delSC = new Transport2DeviceLinkSearchCriteria();
        private HashMap<Long, TransportExt> mapCommonTransport = new HashMap();

        public StructureDevice(TrackInRealTimeLite realTimeLite, String keyPage) {
            this.realTimeLite = realTimeLite;
        }

        public List<Transport> getListTransport() {
            return this.listTransport;
        }

        public void setListTransport(List<Transport> listTransport) {
            this.listTransport = listTransport;
        }

        public Transport2DeviceLink getLinkByDeviceId(Long deviceId) {
            return this.devicesLink.get(deviceId);
        }

        public TransportExt getTransportByDeviceId(Long deviceId) {
            return (TransportExt)this.devices.get(deviceId);
        }

        public int size() {
            return this.devices.size();
        }

        public void clear() {
            this.devices.clear();
            this.devicesLink.clear();
            this.listTransport.clear();
            this.transportIdList = new ArrayList<Long>();
        }

        public NavigationDevice getDID(Long Id, boolean dev) {
            if (dev) {
                Transport2DeviceLink l = this.devicesLink.get(Id);
                return l.getDevice();
            }
            for (Long dId : this.devices.keySet()) {
                if (!this.devices.get(dId).getId().equals(Id)) continue;
                Transport2DeviceLink l = this.devicesLink.get(dId);
                return l.getDevice();
            }
            return null;
        }

        public void addToTransportList(Object[] tt) {
            Object[] objectArray = tt;
            int n = tt.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.listTransport.add((TransportExt)((Object)o));
                this.transportIdList.add(((Transport)o).getId());
                ++n2;
            }
        }

        public void addLink(Transport2DeviceLink link) {
            this.devices.put(link.getDevice().getId(), this.listTransport.get(this.listTransport.indexOf(link.getTransport())));
            this.devicesLink.put(link.getDevice().getId(), link);
        }

        public void setFullList() {
            if (this.devices.size() == 0) {
                this.fullListId = new Long[]{-1L};
                this.fullListTransportId = new Long[]{-1L};
            } else {
                this.fullListId = this.devices.keySet().toArray(new Long[0]);
                this.fullListTransportId = this.transportIdList.toArray(new Long[0]);
            }
        }

        public void setFullListAll() {
            this.fullListId = null;
            this.fullListTransportId = null;
        }

        public Long[] getFullListId() {
            return this.fullListId;
        }

        public Long[] getFullListTransportId() {
            return this.fullListTransportId;
        }

        public List<Long> getTransportIdList() {
            return this.transportIdList;
        }

        private void addNodeTransport(TransportTreeNode node, List<Transport> newTransport, List<Long> newIds) {
            if (!node.isSelect()) {
                node.setSelect(true);
                newTransport.add(node.getTransport());
                newIds.add(node.getTransport().getId());
            }
        }

        private void addGroupTransport(TransportTreeNode node, List<Transport> newTransport, List<Long> newIds, boolean withMessage) {
            if (node.getChildCount() == 0) {
                if (withMessage) {
                    final CommonMessage m = new CommonMessage();
                    m.setTitle("\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435...");
                    m.setMessage(new String[]{"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435..."});
                    m.setCloseEnable(false);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            InitializedVariable.getFactory((String)keyPage).runMessageEx((Object)m, new BeanViewerAction[0]);
                        }
                    }).start();
                    node.initTransport();
                    if (m.getDialog() == null || !((JDialog)m.getDialog()).isVisible()) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                while (m.getDialog() == null || !((JDialog)m.getDialog()).isVisible()) {
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                InitializedVariable.getFactory((String)keyPage).CloseDialog(m.getDialog());
                            }
                        }).start();
                    } else {
                        InitializedVariable.getFactory((String)this.keyPage).CloseDialog(m.getDialog());
                    }
                } else {
                    node.initTransport();
                }
            }
            node.setSelectWithoutChildren(true);
            for (TreeNode n2 : node.getChildrenFromPersistence()) {
                this.addNodeTransport((TransportTreeNode)n2, newTransport, newIds);
            }
        }

        protected void addAllTransport(TransportTreeNode node, List<Transport> newTransport, List<Long> newIds) {
            final CommonMessage m = new CommonMessage();
            m.setTitle("\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435...");
            m.setMessage(new String[]{"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435..."});
            m.setCloseEnable(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    InitializedVariable.getFactory((String)keyPage).runMessageEx((Object)m, new BeanViewerAction[0]);
                }
            }).start();
            node.setSelectWithoutChildren(true);
            for (TreeNode n1 : node.getChildrenFromPersistence()) {
                this.addGroupTransport((TransportTreeNode)n1, newTransport, newIds, false);
            }
            if (m.getDialog() == null || !((JDialog)m.getDialog()).isVisible()) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (m.getDialog() == null || !((JDialog)m.getDialog()).isVisible()) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        InitializedVariable.getFactory((String)keyPage).CloseDialog(m.getDialog());
                    }
                }).start();
            } else {
                InitializedVariable.getFactory((String)this.keyPage).CloseDialog(m.getDialog());
            }
        }

        public void addTransport(TransportTreeNode node, PanelContext pc) {
            ArrayList<Transport> newTransport = new ArrayList<Transport>();
            ArrayList<Long> newIds = new ArrayList<Long>();
            if (node.getType() == TransportTreeNode.AllGroup) {
                this.addAllTransport(node, newTransport, newIds);
            } else if (node.getType() == TransportTreeNode.Group) {
                this.addGroupTransport(node, newTransport, newIds, true);
            } else {
                this.addNodeTransport(node, newTransport, newIds);
            }
            ArrayList<Long> deviceIdList = new ArrayList<Long>();
            if (newTransport.size() > 0) {
                for (Transport o : newTransport) {
                    this.listTransport.add((TransportExt)o);
                    this.transportIdList.add(o.getId());
                }
                this.t2delSC.setTransportIdList(newIds.toArray(new Long[0]));
                this.t2delSC.setActiveOnDate(new Date());
                this.t2delSC.setCount(this.t2deviceProxy.getCount(InitializedVariable.getContext((String)this.keyPage), this.t2delSC));
                Transport2DeviceLinkWSProxy.SearchResultListTransport2DeviceLink sr = this.t2deviceProxy.getList(InitializedVariable.getContext((String)this.keyPage), this.t2delSC);
                if (!sr.isEmpty()) {
                    Object[] objectArray = sr.getObjList();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        this.addLink((Transport2DeviceLink)o);
                        deviceIdList.add(((Transport2DeviceLink)o).getDevice().getId());
                        ++n2;
                    }
                }
            }
            this.setFullList();
            this.realTimeLite.stop();
            this.realTimeLite.getTransportStatusFromServer();
            this.realTimeLite.value.getTracksNDData().clear();
            this.realTimeLite.loadData(new Date().getTime());
            this.realTimeLite.select = true;
            this.realTimeLite.refreshView2(pc);
            this.realTimeLite.select = false;
        }

        public void removeTransport(TransportTreeNode node, PanelContext pc) {
            ArrayList<Transport> newTransport = new ArrayList<Transport>();
            ArrayList<Long> newIds = new ArrayList<Long>();
            if (node.getType() == TransportTreeNode.AllGroup) {
                node.setSelectWithoutChildren(false);
                for (TreeNode n1 : node.getChildrenFromPersistence()) {
                    ((TransportTreeNode)n1).setSelectWithoutChildren(false);
                    for (TreeNode n2 : n1.getChildrenFromPersistence()) {
                        if (!((TransportTreeNode)n2).isSelect()) continue;
                        ((TransportTreeNode)n2).setSelect(false);
                        newTransport.add(((TransportTreeNode)n2).getTransport());
                        newIds.add(((TransportTreeNode)n2).getTransport().getId());
                    }
                }
            } else if (node.getType() == TransportTreeNode.Group) {
                node.setSelectWithoutChildren(false);
                for (TreeNode n2 : node.getChildrenFromPersistence()) {
                    if (!((TransportTreeNode)n2).isSelect()) continue;
                    ((TransportTreeNode)n2).setSelectWithoutChildren(false);
                    newTransport.add(((TransportTreeNode)n2).getTransport());
                    newIds.add(((TransportTreeNode)n2).getTransport().getId());
                }
            } else if (node.isSelect()) {
                node.setSelectWithoutChildren(false);
                newTransport.add(node.getTransport());
                newIds.add(node.getTransport().getId());
            }
            for (Transport t : newTransport) {
                NavigationDevice d = this.getDID(t.getId(), false);
                if (d != null) {
                    this.devices.remove(d.getId());
                    this.devicesLink.remove(d.getId());
                }
                this.transportIdList.remove(t.getId());
                this.listTransport.remove(t);
            }
            this.setFullList();
            this.realTimeLite.stop();
            this.realTimeLite.getTransportStatusFromServer();
            this.realTimeLite.value.getTracksNDData().clear();
            this.realTimeLite.loadData(new Date().getTime());
            this.realTimeLite.select = true;
            this.realTimeLite.refreshView2(pc);
            this.realTimeLite.select = false;
        }

        public TransportExt getTransport(Transport transport) {
            if (!this.mapCommonTransport.containsKey(transport.getId())) {
                this.mapCommonTransport.put(transport.getId(), (TransportExt)transport);
            }
            return this.mapCommonTransport.get(transport.getId());
        }

        public void updateTransport(TransportExt transport) {
            this.mapCommonTransport.put(transport.getId(), transport);
        }
    }

    public static class Tracking
    extends BeanViewerAction<ViewerContext> {
        public void actionPerformed(Object message) {
            List listFields = ((ViewerContext)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getParentContext()).getPresentator().getSelectedItems();
            if (listFields == null) {
                return;
            }
            boolean tt = this.isTracking();
            for (Object t : listFields) {
                ((TransportExt)((Object)t)).setTracking(tt);
                ((ListViewerT)((ViewerContext)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getParentContext()).getPresentator().getViewer()).updateTransportTable((TransportExt)((Object)t));
            }
        }

        protected boolean isTracking() {
            return true;
        }

        public String getHint() {
            return "\u0423 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0440\u0438\u0437\u043d\u0430\u043a \u0441\u043b\u0435\u0436\u0435\u043d\u0438\u044f";
        }

        public String getIcon() {
            return ResourceStrings.btFieldVisible;
        }
    }

    public static class TreeKeyListener
    implements KeyListener {
        JTree tree;

        public TreeKeyListener(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TreePath path;
            if (e.getKeyCode() == 32 && (path = this.tree.getSelectionPath()) != null) {
                TransportTreeNode node = (TransportTreeNode)((Object)path.getLastPathComponent());
                boolean isSelected = !node.isSelect();
                node.setSelect(isSelected);
                this.tree.repaint();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    public static class TreeNodeViewer
    extends TreeViewer {
        protected void setKL() {
            ((JTree)this.tree.getTreeComponent()).addKeyListener(new TreeKeyListener((JTree)this.tree.getTreeComponent()));
        }

        public void repaint() {
            ((JTree)this.tree.getTreeComponent()).repaint();
        }

        public TreeNodeViewer(UIFactory<JComponent> factory) {
            super(factory);
            this.dndEnable(false);
            ((JTree)this.tree.getTreeComponent()).setCellRenderer(new CheckRenderer());
            this.setKL();
            this.addActionOnSelect();
        }

        public void setBValue(final Object value) {
            if (((TransportTreeNode)((Object)value)).selecting) {
                TreeNodeViewer.super.setBValue((Object)((TransportTreeNode)((Object)value)).getNewNode(TransportTreeNode.AllGroup, ((TransportTreeNode)((Object)value)).getTrackInRealTime2()));
            }
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = value;
                    synchronized (object) {
                        TreeNodeViewer.super.setBValue(value);
                    }
                }
            }).start();
        }

        private void setTracking(TransportTreeNode node, boolean track) {
            block4: {
                block3: {
                    if (node.getType() != TransportTreeNode.Group) break block3;
                    for (TreeNode n : node.getChildrenFromPersistence()) {
                        if (!((TransportTreeNode)n).isSelect()) continue;
                        ((TransportExt)((TransportTreeNode)n).getTransport()).setTracking(track);
                    }
                    break block4;
                }
                if (node.getType() != TransportTreeNode.AllGroup) break block4;
                for (TreeNode n2 : node.getChildrenFromPersistence()) {
                    for (TreeNode n : n2.getChildrenFromPersistence()) {
                        if (!((TransportTreeNode)n).isSelect()) continue;
                        ((TransportExt)((TransportTreeNode)n).getTransport()).setTracking(track);
                    }
                }
            }
        }

        protected void actionOnSelect() {
            super.actionOnSelect();
            List l = this.getSelectedItems();
            TrackInRealTimeLite t = (TrackInRealTimeLite)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject());
            if (!t.select) {
                if (l != null && l.size() > 0) {
                    TransportTreeNode n = (TransportTreeNode)((Object)l.get(0));
                    if (n.getType() == TransportTreeNode.Transport) {
                        ((TransportExt)n.getTransport()).setTracking(true);
                        if (n.isSelect()) {
                            t.showInfo(n.getTransport().getId(), false, (PanelContext)this.getViewerContext().getParentContext());
                            t.positionOnselect();
                        }
                    } else {
                        this.setTracking(n, true);
                        t.positionOnselectGroup(n);
                        t.showInfo(null, false, (PanelContext)this.getViewerContext().getParentContext());
                    }
                } else {
                    t.showInfo(null, false, (PanelContext)this.getViewerContext().getParentContext());
                    t.positionOnselect();
                }
            }
        }
    }
}

