/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks.tracksmp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.jxmapviewer.viewer.GeoPosition;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import ru.blok.vms.ui.geo.GeoUtils;
import ru.blok.vms.ui.police.operationalinformation.Routes;
import ru.blok.vms.ui.tracks.OneTrack;
import ru.blok.vms.ui.tracks.tracksmp.TrackInRealTimeSMP;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.ws.objects.vms.AdvancedSearchItem;
import ru.infor.ws.objects.vms.NavigationPoint;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.Transport;
import ru.infor.ws.objects.vms.entities.ext.TransportExt;

@ListView(views={@View(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u0438 3", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class TrackInRealTimeSMP3
extends TrackInRealTimeSMP {
    public TrackInRealTimeSMP3(String keyPage) {
        super(keyPage);
    }

    @Override
    protected void setNewAlarmPoint(Double lat, Double lon, AdvancedSearchItem item) {
        super.setNewAlarmPoint(lat, lon, item);
        this.calclPath(lat, lon);
    }

    public void calclPath(final Double lat, final Double lon) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int i = 0;
                    while (i < TrackInRealTimeSMP3.this.list.size()) {
                        OneTrack t = (OneTrack)TrackInRealTimeSMP3.this.list.get(i);
                        NDData d = t.getPrev();
                        if (d != null) {
                            TransportExt w = TrackInRealTimeSMP3.this.getDevices().getTransportByDeviceId(d.getDeviceId());
                            w.setDist(null);
                        }
                        ++i;
                    }
                    ListViewer v = (ListViewer)TrackInRealTimeSMP3.this.pc.getPanel().getPresentatorForName("listTransport").getViewer();
                    int[] ii = v.getSelectedRows();
                    ArrayList<Transport> sel = new ArrayList<Transport>();
                    if (ii != null) {
                        int[] nArray = ii;
                        int n = ii.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int i2 = nArray[n2];
                            sel.add(TrackInRealTimeSMP3.this.getListTransport().get(i2));
                            ++n2;
                        }
                    }
                    TrackInRealTimeSMP3.this.pc.getPanel().updateUIForPresentatorName("listTransport");
                    int[] kk = new int[sel.size()];
                    int i3 = 0;
                    while (i3 < sel.size()) {
                        kk[i3] = TrackInRealTimeSMP3.this.getListTransport().indexOf(sel.get(i3));
                        ++i3;
                    }
                    v.getTM().setSelectedRows(kk);
                    GeoPosition to = new GeoPosition(lat.doubleValue(), lon.doubleValue());
                    int i4 = 0;
                    while (i4 < TrackInRealTimeSMP3.this.list.size()) {
                        OneTrack t = (OneTrack)TrackInRealTimeSMP3.this.list.get(i4);
                        NDData d = t.getPrev();
                        if (d != null) {
                            TransportExt w = TrackInRealTimeSMP3.this.getDevices().getTransportByDeviceId(d.getDeviceId());
                            GeoPosition from = new GeoPosition(d.getLat().doubleValue(), d.getLon().doubleValue());
                            Double r = TrackInRealTimeSMP3.this.getDist(from, to);
                            w.setDist(r);
                        }
                        ++i4;
                    }
                    Collections.sort(TrackInRealTimeSMP3.this.getListTransport(), (Comparator)new Comparator<TransportExt>(){

                        @Override
                        public int compare(TransportExt o1, TransportExt o2) {
                            if (o1.getDist() == null && o2.getDist() == null) {
                                return 0;
                            }
                            if (o1.getDist() != null && o2.getDist() == null) {
                                return -1;
                            }
                            if (o1.getDist() == null && o2.getDist() != null) {
                                return 1;
                            }
                            if (o1.getStateGP().getState() != TransportExt.TargetYes && o2.getStateGP().getState() == TransportExt.TargetYes) {
                                return -1;
                            }
                            if (o1.getStateGP().getState() == TransportExt.TargetYes && o2.getStateGP().getState() != TransportExt.TargetYes) {
                                return 1;
                            }
                            return o1.getDist().compareTo(o2.getDist());
                        }
                    });
                    TrackInRealTimeSMP3.this.pc.getPanel().updateUIForPresentatorName("listTransport");
                    kk = new int[sel.size()];
                    i4 = 0;
                    while (i4 < sel.size()) {
                        kk[i4] = TrackInRealTimeSMP3.this.getListTransport().indexOf(sel.get(i4));
                        ++i4;
                    }
                    v.getTM().setSelectedRows(kk);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public Double getDist(GeoPosition from, GeoPosition to) {
        try {
            CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)GeoUtils.wkt4326);
            CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)GeoUtils.wkt3395);
            MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            GeometryFactory f = new GeometryFactory();
            Double r = 0.0;
            NavigationPoint[] p = Routes.caclPath(from, to, this.isInnerRoute(), this.getTransportType4CalcPathKey());
            if (p != null && p.length > 1) {
                GeneralDirectPosition pt1 = new GeneralDirectPosition(p[0].getLon().doubleValue(), p[0].getLat().doubleValue());
                DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
                Coordinate c = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                Point pp = f.createPoint(c);
                int i = 1;
                while (i < p.length) {
                    pt1 = new GeneralDirectPosition(p[i].getLon().doubleValue(), p[i].getLat().doubleValue());
                    pt2 = math.transform((DirectPosition)pt1, null);
                    Coordinate c_n = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                    Point p2 = f.createPoint(c_n);
                    Double d = p2.distance((Geometry)pp) / 1000.0 / 2.0;
                    r = r + d;
                    pp = p2;
                    ++i;
                }
            }
            return r;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

