/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.tracks.viewadis;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.tracks.viewadis.MapValueADIS;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.ViewAddressADIS;
import ru.infor.ws.objects.vms.entities.ViewCarADIS;

public class PainterData<T extends JXMapViewer>
extends MapViewPainter<T> {
    MapValueADIS mapValueADIS;

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Object o;
        int n;
        int n2;
        Object[] objectArray;
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.mapValueADIS.getAddrs() != null) {
            objectArray = this.mapValueADIS.getAddrs();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                o = objectArray[n];
                this.paintAdr((ViewAddressADIS)o, map, g, vp2, vp3);
                ++n;
            }
        }
        if (this.mapValueADIS.getCars() != null) {
            objectArray = this.mapValueADIS.getCars();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                o = objectArray[n];
                this.paintCar((ViewCarADIS)o, this.mapValueADIS.getData(((ViewCarADIS)o).getDeviceId()), map, g, vp2, vp3);
                ++n;
            }
        }
    }

    private void paintCar(ViewCarADIS viewCarADIS, NDData data, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        if (data != null) {
            Color c = Color.RED;
            int r = 5;
            Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(data.getLat().doubleValue(), data.getLon().doubleValue()), map.getZoom());
            int x = (int)(pointFrom.getX() - vp2.getX());
            int y = (int)(pointFrom.getY() - vp2.getY());
            g.translate(x, y);
            g.setColor(c.darker().darker());
            g.drawOval(-r, -r, r * 2, r * 2);
            g.setColor(c);
            g.fillOval(-r, -r, r * 2, r * 2);
            String hint = viewCarADIS.getRegnum();
            this.paintHint(g, hint, c);
            g.translate(-x, -y);
        }
    }

    private void paintAdr(ViewAddressADIS viewAddressADIS, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        Color c = Color.GREEN;
        Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(viewAddressADIS.getLat().doubleValue(), viewAddressADIS.getLon().doubleValue()), map.getZoom());
        int x = (int)(pointFrom.getX() - vp2.getX());
        int y = (int)(pointFrom.getY() - vp2.getY());
        g.translate(x, y);
        Polygon p = new Polygon();
        p.addPoint(5, 3);
        p.addPoint(-5, 3);
        p.addPoint(-5, -3);
        p.addPoint(5, -3);
        p.addPoint(1, 0);
        g.setColor(c.darker().darker());
        g.drawPolygon(p);
        g.setColor(c);
        g.fillPolygon(p);
        String hint = String.valueOf(viewAddressADIS.getRegionName()) + " " + viewAddressADIS.getTownName() + " " + viewAddressADIS.getStreetName() + " " + viewAddressADIS.getHouseNum();
        this.paintHint(g, hint, c);
        g.translate(-x, -y);
    }

    private void paintHint(Graphics2D g, String hints, Color c) {
        String[] hint = new String[]{hints};
        FontMetrics f = g.getFontMetrics();
        int h = f.getHeight();
        int l = hint.length;
        int w = 0;
        int i = 0;
        while (i < l) {
            int w1 = f.stringWidth(hint[i]);
            if (w1 > w) {
                w = w1;
            }
            ++i;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(-w + w / 2, -h * l - 20, w + 10, h * l + 3);
        Polygon p = new Polygon();
        p.addPoint((int)bounds.getMinX(), (int)bounds.getMinY());
        p.addPoint((int)bounds.getMinX(), (int)bounds.getMaxY());
        p.addPoint((int)(bounds.getMinX() + ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
        p.addPoint(0, 0);
        p.addPoint((int)(bounds.getMinX() + 2.0 * ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
        p.addPoint((int)bounds.getMaxX(), (int)bounds.getMaxY());
        p.addPoint((int)bounds.getMaxX(), (int)bounds.getMinY());
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 80));
        g.fillPolygon(p);
        g.setColor(c.brighter().brighter());
        g.drawPolygon(p);
        g.setColor(Color.BLACK);
        int i2 = 0;
        while (i2 < l) {
            g.drawString(hint[i2], (int)bounds.getMinX() + 5, (int)bounds.getMinY() + h + i2 * h);
            ++i2;
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.mapValueADIS = (MapValueADIS)mapValueWithTrack;
    }
}

