/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.trackwithaccessoryarea;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.MultiPolygon;
import org.postgis.PGgeometry;
import org.postgis.Point;
import org.postgis.Polygon;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.common.SysProperties;
import ru.infor.ws.objects.vms.RouteSearchCriteria;
import ru.infor.ws.objects.vms.RouteWatchArea;
import ru.infor.ws.objects.vms.entities.Route;

public class MapValueWithAccessoryArea
extends MapValueWithTrack {
    private Integer pp;
    private Geometry geometry;
    private MultiLineString lineString;
    private MultiLineString lineStringForPaint;
    private String num;
    RouteWSProxy proxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);
    static Connection connection = null;

    public MultiLineString getLineStringForPaint() {
        return this.lineStringForPaint;
    }

    public void setLineStringForPaint(MultiLineString lineStringForPaint) {
        this.lineStringForPaint = lineStringForPaint;
    }

    public MultiLineString getLineString() {
        return this.lineString;
    }

    public void setLineString(MultiLineString lineString) {
        this.lineString = lineString;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public Integer getPp() {
        return this.pp;
    }

    public void setPp(Integer pp) {
        this.pp = pp;
    }

    public String getNum() {
        return this.num;
    }

    public void setNum(String num) {
        this.num = num;
        try {
            MapValueWithAccessoryArea.getConnection();
            this.getBusRoute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getBusRoute() throws SQLException {
        RouteSearchCriteria rs = (RouteSearchCriteria)this.proxy._getSearchCriteriaTemplate();
        rs.setNum("*" + this.num + "*");
        Object[] oo = this.proxy.getList(InitializedVariable.context, rs).getObjList();
        if (oo != null && oo.length > 0) {
            Route r = (Route)oo[0];
            r = this.proxy.getCurrentObject(InitializedVariable.context, r.getId());
            MultiLineString ms = new MultiLineString(r.getRouteGeom());
            ms.setSrid(4326);
            this.setLineString(ms);
            this.setLineStringForPaint(ms);
            RouteWatchArea a = this.proxy.getWatchArea(InitializedVariable.context, r.getId());
            if (a != null) {
                MultiPolygon mp = new MultiPolygon(new Polygon[]{new Polygon("POLYGON((38.85646 58.03443,38.8546 58.03435,38.85417 58.03498,38.85389 58.03555,38.85455 58.03612,38.85577 58.03613,38.85633 58.03553,38.85646 58.03443))"), new Polygon("POLYGON((38.85502 58.03864,38.86262 58.03824,38.86186 58.03624,38.85784 58.03611,38.85424 58.03699,38.85502 58.03864))")});
                mp.setSrid(4326);
                this.setGeometry((Geometry)mp);
            }
        }
    }

    private static void getConnection() throws Exception {
        String url = SysProperties.getProperty((String)"connectionosm.url", (String)"");
        String user = SysProperties.getProperty((String)"connectionosm.USER", (String)"");
        String password = SysProperties.getProperty((String)"connectionosm.PASSWORD", (String)"");
        Class.forName(SysProperties.getProperty((String)"connectionosm.driver", (String)"org.postgresql.Driver"));
        connection = DriverManager.getConnection(url, user, password);
    }

    private void importBusRoute() throws SQLException {
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery(" select * from relations r join relation_tags rt on r.id = rt.relation_id   where r.id in (select relation_id from relation_tags where k = 'operator' and v like '\u041f\u0410\u0422\u041f \u21161')  and rt.k= 'name' and rt.v='" + this.num + "'");
        while (rs.next()) {
            long rel_id = rs.getLong("id");
            Statement stmt1 = connection.createStatement();
            ResultSet rs1 = stmt1.executeQuery(" select w.linestring as l from relations r  join relation_members rm on rm.relation_id = r.id join ways w  on rm.member_id= w.id where rm.member_type='W'  and r.id =  " + rel_id);
            ArrayList<LineString> ll = new ArrayList<LineString>();
            while (rs1.next()) {
                PGgeometry g = (PGgeometry)rs1.getObject("l");
                if (!(g.getGeometry() instanceof LineString)) continue;
                ll.add((LineString)g.getGeometry());
            }
            ArrayList<LineString> ll2 = new ArrayList<LineString>();
            for (LineString ls : ll) {
                boolean f = true;
                Point[] pointArray = ls.getPoints();
                int n = pointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Point p = pointArray[n2];
                    StringBuilder ss = new StringBuilder().append(p.getX()).append("/").append(p.getY());
                    if ("38.8062235/58.0640361".equals(ss.toString())) {
                        f = false;
                    }
                    if ("38.8166384/58.0562773".equals(ss.toString())) {
                        f = false;
                    }
                    ++n2;
                }
                if (!f) continue;
                ll2.add(ls);
            }
            MultiLineString ms = new MultiLineString(ll.toArray(new LineString[0]));
            ms.setSrid(4326);
            this.setLineString(ms);
            ms = new MultiLineString(ll2.toArray(new LineString[0]));
            ms.setSrid(4326);
            this.setLineStringForPaint(ms);
        }
    }

    public Geometry getGeometry(int r) {
        try {
            Statement stmt2 = connection.createStatement();
            ResultSet rs2 = stmt2.executeQuery("select ST_transform (ST_Buffer(ST_transform( '" + this.lineStringForPaint + "', 3576 ), " + r + "), 4326) as t ");
            if (rs2.next()) {
                PGgeometry geom = (PGgeometry)rs2.getObject("t");
                return geom.getGeometry();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean Contains(Double[] gp) {
        if (this.getGeometry() == null) {
            return false;
        }
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs2 = stmt.executeQuery("select ST_Contains('" + this.getGeometry() + "' , 'SRID=4326;POINT(" + gp[0] + " " + gp[1] + ")') as t ");
            if (rs2.next()) {
                boolean t = rs2.getBoolean("t");
                return t;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }
}

