/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.trackwithaccessoryarea;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.Node;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.PrimitiveForView;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.NodePainter;
import ru.blok.vms.ui.trackwithaccessoryarea.MapValueWithAccessoryArea;

public class RoutePainter<T extends JXMapViewer>
extends NodePainter<T> {
    private MapValueWithAccessoryArea routeValue;

    public MapValueWithAccessoryArea getRouteValue() {
        return this.routeValue;
    }

    public void setRouteValue(MapValueWithAccessoryArea routeValue) {
        this.routeValue = routeValue;
    }

    public RoutePainter() {
        this.setAntialiasing(true);
        this.setCacheable(false);
    }

    @Override
    protected Color getColorPoint(PrimitiveForView view, Node point) {
        boolean f = this.routeValue.Contains(new Double[]{point.getLat(), point.getLon()});
        Color c = f ? Color.BLUE : Color.RED;
        return c;
    }

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.routeValue != null && this.routeValue.getLineString() != null) {
            LineString[] lineStringArray = this.routeValue.getLineString().getLines();
            int n = lineStringArray.length;
            int n2 = 0;
            while (n2 < n) {
                LineString ls = lineStringArray[n2];
                int i = 1;
                while (i < ls.numPoints()) {
                    this.paint(ls.getPoint(i - 1), ls.getPoint(i), map, g, vp2, vp3, false, Color.RED);
                    ++i;
                }
                ++n2;
            }
            Geometry p = this.routeValue.getGeometry();
            if (p != null) {
                this.paint(p, map, g, vp2, vp3);
            }
        }
        super.doPaint(g, map, width, height);
    }

    protected void paintPolygon(org.postgis.Polygon polygon, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        Path2D path = null;
        int ii = 0;
        while (ii < polygon.numRings()) {
            Polygon pp = new Polygon();
            int i = 0;
            while (i < polygon.getRing(ii).numPoints()) {
                Point p1 = polygon.getRing(ii).getPoint(i);
                Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(p1.getY(), p1.getX()), map.getZoom());
                int x = (int)(point.getX() - vp2.getX());
                int y = (int)(point.getY() - vp2.getY());
                pp.addPoint(x, y);
                ++i;
            }
            if (path == null) {
                path = new GeneralPath(pp);
            } else {
                path.append(pp, true);
            }
            ++ii;
        }
        g.fill(path);
    }

    protected void paint(Geometry geometry, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        Color w = new Color(Color.GREEN.getRed(), Color.GREEN.getGreen(), Color.GREEN.getBlue(), 80);
        g.setColor(w);
        if (geometry instanceof org.postgis.Polygon) {
            this.paintPolygon((org.postgis.Polygon)geometry, map, g, vp2, vp3);
        } else if (geometry instanceof MultiPolygon) {
            org.postgis.Polygon[] polygonArray = ((MultiPolygon)geometry).getPolygons();
            int n = polygonArray.length;
            int n2 = 0;
            while (n2 < n) {
                org.postgis.Polygon polygon = polygonArray[n2];
                this.paintPolygon(polygon, map, g, vp2, vp3);
                ++n2;
            }
        }
    }

    protected void paint(Point from, Point to, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, boolean test, Color c) {
        if (from == null || to == null) {
            return;
        }
        Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(from.getY(), from.getX()), map.getZoom());
        if (to != null) {
            Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(to.getY(), to.getX()), map.getZoom());
            if (vp2.contains(point) || vp2.contains(pointFrom)) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(c);
                int fx = (int)(pointFrom.getX() - vp2.getX());
                int fy = (int)(pointFrom.getY() - vp2.getY());
                int x = (int)(point.getX() - vp2.getX());
                int y = (int)(point.getY() - vp2.getY());
                g.drawLine(fx, fy, x, y);
            }
            if (vp3.contains(point) || vp3.contains(pointFrom)) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Color w = test ? Color.green : Color.RED;
                g.setColor(w);
                int fx = (int)(pointFrom.getX() - vp3.getX());
                int fy = (int)(pointFrom.getY() - vp3.getY());
                int x = (int)(point.getX() - vp3.getX());
                int y = (int)(point.getY() - vp3.getY());
                g.drawLine(fx, fy, x, y);
            }
        }
    }
}

