/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.transport;

import java.io.File;
import java.math.BigDecimal;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.dbf.ReaderDBaseFile;
import ru.blok.vms.core.ResourceStrings;
import ru.blok.vms.ui.buttons.DataExchangeButton;
import ru.blok.vms.ui.messagewithprogress.RunMessageProgressBar;
import ru.blok.vms.ui.transport.TransportList;
import ru.infor.beanviewer.dialog.ErrorMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.vms.TransportTypeWSProxy;
import ru.infor.client.soap.proxy.vms.TransportWSProxy;
import ru.infor.ws.objects.core.DirectoriesSearchCriteria;
import ru.infor.ws.objects.vms.TransportSearchCriteria;
import ru.infor.ws.objects.vms.entities.Transport;
import ru.infor.ws.objects.vms.entities.TransportType;

public class ImportTransportFromTechnicalDepartment
extends DataExchangeButton {
    TransportWSProxy proxy = (TransportWSProxy)CurrentProxyFactory.getProxy(Transport.class);
    TransportSearchCriteria sc = new TransportSearchCriteria();

    @Override
    public void actionPerformed(Object arg0) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String path = ((TransportList)((Object)((PanelContext)((ViewerContext)ImportTransportFromTechnicalDepartment.this.getContext()).getParentContext()).getObject())).getPathToTechnicalDepartment();
                if (path == null) {
                    String st = "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 'PathToTechnicalDepartment'\n - '\u041f\u0443\u0442\u044c \u043a \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435 \u043e\u0442\u0434\u0435\u043b\u0430 \u043a\u0430\u0434\u0440\u043e\u0432 \u0434\u043b\u044f \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f\u0445).";
                    InitializedVariable.factory.runMessageEx((Object)new ErrorMessage(st), new BeanViewerAction[]{new MessageOKButton()});
                    return;
                }
                String fileName = String.valueOf(path) + File.separator + "PASP_AV.DBF";
                ReaderDBaseFile reader = new ReaderDBaseFile(fileName);
                if (reader.getRezMessage().equals("")) {
                    RunMessageProgressBar r = new RunMessageProgressBar(new String[]{"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u044b\u043d\u043d\u044b\u0445 \u0438\u0437 \u0442\u0435\u0445 \u043e\u0442\u0434\u0435\u043b\u0430.", "\u0412\u0441\u0435\u0433\u043e - " + reader.getReader().getRecordCount() + " \u0437\u0430\u043f."}, reader.getReader().getRecordCount());
                    r.beginShow();
                    Object[] line = null;
                    int i = 0;
                    while (i < reader.getReader().getRecordCount()) {
                        r.incState();
                        try {
                            line = reader.getNextRecord();
                            if (line != null) {
                                ImportTransportFromTechnicalDepartment.this.checkRecord(line, reader);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                    r.close();
                    ((PanelContext)((ViewerContext)ImportTransportFromTechnicalDepartment.this.getContext()).getParentContext()).getPanel().updateUI();
                } else {
                    InitializedVariable.factory.runMessageEx((Object)new ErrorMessage("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435", new String[]{reader.getRezMessage()}), new BeanViewerAction[]{new MessageOKButton()});
                }
                reader.destroy();
            }
        }).start();
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
    }

    private void checkRecord(Object[] line, ReaderDBaseFile reader) {
        String garageNum = ((String)(line = ImportTransportFromTechnicalDepartment.updateNull(line, reader.getFieldsList()))[reader.indexOfName("GARN")]).trim();
        if (garageNum == null || garageNum.isEmpty()) {
            return;
        }
        Transport transport = null;
        this.sc.setGarageNum("*" + garageNum + "*");
        TransportWSProxy.SearchResultListTransport transportSR = this.proxy.getList(InitializedVariable.context, this.sc);
        if (transportSR != null && transportSR.getObjList() != null && transportSR.getObjList().length > 0) {
            transport = (Transport)transportSR.getObjList()[0];
        }
        if (transport == null) {
            transport = new Transport();
            transport.setGarageNum(garageNum);
        }
        transport.setRegNum(((String)line[reader.indexOfName("GOSN")]).trim());
        transport.setCodeM(((String)line[reader.indexOfName("KODM")]).trim());
        String marka = ((String)line[reader.indexOfName("MARKA")]).trim();
        TransportType tt = null;
        TransportTypeWSProxy ttProxy = (TransportTypeWSProxy)CurrentProxyFactory.getProxy(TransportType.class);
        DirectoriesSearchCriteria ttsc = new DirectoriesSearchCriteria();
        ttsc.setDescription(marka);
        TransportTypeWSProxy.SearchResultListTransportType srl = ttProxy.getList(InitializedVariable.context, ttsc);
        if (srl != null && srl.getObjList() != null && srl.getObjList().length > 0) {
            tt = (TransportType)srl.getObjList()[0];
        } else {
            tt = new TransportType();
            tt.setCode(transport.getCodeM());
            tt.setDescription(marka);
            tt = ttProxy.save(InitializedVariable.context, tt);
        }
        transport.setTransportType(tt);
        transport.setRateFuel100(new BigDecimal((Double)line[reader.indexOfName("NORMA")]));
        transport = this.proxy.save(InitializedVariable.context, transport);
    }

    @Override
    public String getHint() {
        return "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 \u0442\u0435\u0445 \u043e\u0442\u0434\u0435\u043b\u0430";
    }

    @Override
    public String getIcon() {
        return ResourceStrings.btImportDriver;
    }
}

