/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.transport.calibration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import ru.blok.vms.core.ResourceStrings;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.ws.objects.vms.entities.CalibrationItem;
import ru.infor.ws.objects.vms.entities.ext.CalibrationItemExt;
import ru.infor.ws.objects.vms.entities.ext.DeviceParameterCalibrationExt;

public class ImportFromFileButton
extends BeanViewerAction<ViewerContext> {
    public void actionPerformed(Object message) {
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (f.getName().endsWith(".xls")) {
                    return true;
                }
                return f.getName().endsWith(".xlsx");
            }

            @Override
            public String getDescription() {
                return null;
            }
        };
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
        int type = 0;
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(type);
        jfc.setFileFilter(ff);
        int i = jfc.showDialog(null, "\u0412\u044b\u0431\u043e\u0440 \u0444\u0430\u0439\u043b\u0430");
        if (i == 0) {
            CalibrationItem[] newList;
            File f = jfc.getSelectedFile();
            if (f != null && (newList = this.loadFromFile(f)) != null) {
                ((DeviceParameterCalibrationExt)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getObject())).setItems(newList);
            }
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
        }
    }

    private CalibrationItemExt[] loadFromFile(File f) {
        try {
            if (f.getName().endsWith(".xlsx")) {
                return this.readXLSXFile(f.getAbsolutePath());
            }
            if (f.getName().endsWith(".xls")) {
                return this.readXLSFile(f.getAbsolutePath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public CalibrationItemExt[] readXLSXFile(String fullname) throws IOException {
        XSSFCell c0;
        XSSFRow r1;
        FileInputStream ExcelFileToRead = new FileInputStream(fullname);
        XSSFWorkbook wb = new XSSFWorkbook((InputStream)ExcelFileToRead);
        XSSFSheet sheet = wb.getSheetAt(0);
        ArrayList<CalibrationItemExt> items = new ArrayList<CalibrationItemExt>();
        boolean exit = true;
        int i = 0;
        while ((r1 = sheet.getRow(i)) != null && (c0 = r1.getCell(0)) != null) {
            block15: {
                XSSFCell c1 = r1.getCell(1);
                Double orig = 0.0;
                Double show = 0.0;
                try {
                    try {
                        if (c0.getCellType() == 0) {
                            show = c0.getNumericCellValue();
                        } else if (c0.getCellType() == 1) {
                            show = Double.valueOf(c0.getStringCellValue().trim().replaceAll(",", "."));
                        }
                        if (c1.getCellType() == 0) {
                            orig = c1.getNumericCellValue();
                        } else if (c1.getCellType() == 1) {
                            orig = Double.valueOf(c1.getStringCellValue().trim().replaceAll(",", "."));
                        }
                        CalibrationItemExt ci = new CalibrationItemExt();
                        ci.setOriginalValue(orig);
                        ci.setShownValue(show);
                        items.add(ci);
                    }
                    catch (Exception exception) {
                        if (wb != null) {
                            wb.close();
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (wb != null) {
                        wb.close();
                    }
                    throw throwable;
                }
                if (wb != null) {
                    wb.close();
                }
            }
            ++i;
            if (exit) continue;
        }
        return items.toArray(new CalibrationItemExt[items.size()]);
    }

    public CalibrationItemExt[] readXLSFile(String fullname) throws IOException {
        HSSFRow r1;
        HSSFCell c0;
        FileInputStream ExcelFileToRead = new FileInputStream(fullname);
        HSSFWorkbook wb = new HSSFWorkbook((InputStream)ExcelFileToRead);
        HSSFSheet sheet = wb.getSheetAt(0);
        ArrayList<CalibrationItemExt> items = new ArrayList<CalibrationItemExt>();
        boolean exit = true;
        int i = 0;
        while ((c0 = (r1 = sheet.getRow(i)).getCell(0)) != null) {
            block15: {
                HSSFCell c1 = r1.getCell(1);
                Double orig = 0.0;
                Double show = 0.0;
                try {
                    try {
                        if (c0.getCellType() == 0) {
                            show = c0.getNumericCellValue();
                        } else if (c0.getCellType() == 1) {
                            show = Double.valueOf(c0.getStringCellValue().trim().replaceAll(",", "."));
                        }
                        if (c1.getCellType() == 0) {
                            orig = c1.getNumericCellValue();
                        } else if (c1.getCellType() == 1) {
                            orig = Double.valueOf(c1.getStringCellValue().trim().replaceAll(",", "."));
                        }
                        CalibrationItemExt ci = new CalibrationItemExt();
                        ci.setOriginalValue(orig);
                        ci.setShownValue(show);
                        items.add(ci);
                    }
                    catch (Exception exception) {
                        if (wb != null) {
                            wb.close();
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (wb != null) {
                        wb.close();
                    }
                    throw throwable;
                }
                if (wb != null) {
                    wb.close();
                }
            }
            ++i;
            if (exit) continue;
        }
        return items.toArray(new CalibrationItemExt[items.size()]);
    }

    public String getHint() {
        return "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043e\u0447\u043d\u0443\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430";
    }

    public String getIcon() {
        return ResourceStrings.btImportTrack;
    }
}

