/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.transport.rnisimport;

import java.awt.Cursor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.importutils.ImportUtils;
import ru.blok.vms.core.ResourceStrings;
import ru.blok.vms.ui.transport.rnisimport.RnisImportForm;
import ru.blok.vms.ui.transport.rnisimport.Transport4Import;
import ru.infor.beanviewer.core.BeanPanel;
import ru.infor.beanviewer.dialog.InfoMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.vms.CellularOperatorWSProxy;
import ru.infor.client.soap.proxy.vms.NavigationDeviceTypeWSProxy;
import ru.infor.client.soap.proxy.vms.NavigationDeviceWSProxy;
import ru.infor.client.soap.proxy.vms.TransportCategoryWSProxy;
import ru.infor.client.soap.proxy.vms.TransportWSProxy;
import ru.infor.ws.objects.core.DirectoriesSearchCriteria;
import ru.infor.ws.objects.vms.NavigationDeviceSearchCriteria;
import ru.infor.ws.objects.vms.NavigationDeviceTypeSearchCriteria;
import ru.infor.ws.objects.vms.TransportSearchCriteria;
import ru.infor.ws.objects.vms.entities.CellularOperator;
import ru.infor.ws.objects.vms.entities.NavigationDevice;
import ru.infor.ws.objects.vms.entities.NavigationDeviceType;
import ru.infor.ws.objects.vms.entities.Transport;
import ru.infor.ws.objects.vms.entities.TransportCategory;

public class PreImportRnis
extends BeanViewerAction<ViewerContext> {
    private ArrayList<Transport4Import> tcItems;
    private final int cellCount = 21;
    private final SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");

    public void actionPerformed(Object message) {
        File file;
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (f.getName().endsWith(".xls")) {
                    return true;
                }
                return f.getName().endsWith(".xlsx");
            }

            @Override
            public String getDescription() {
                return null;
            }
        };
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
        int type = 0;
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(type);
        jfc.setFileFilter(ff);
        int i = jfc.showDialog(null, "\u0412\u044b\u0431\u043e\u0440 \u0444\u0430\u0439\u043b\u0430");
        if (i == 0 && (file = jfc.getSelectedFile()) != null) {
            JPanel panel = (JPanel)((BeanPanel)InitializedVariable.getFactory((String)((ViewerContext)this.getContext()).getKeyPage()).getCurrentPanel(((ViewerContext)this.getContext()).getKeyPage())).getPanel();
            panel.setCursor(Cursor.getPredefinedCursor(3));
            ((RnisImportForm)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject())).setImportFileName(file.getAbsolutePath());
            int recCount = 0;
            try {
                this.tcItems = ((RnisImportForm)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject())).getTcImpItems();
                this.tcItems.clear();
                recCount = this.processFileExcel(file.getAbsolutePath());
                if (recCount > 0) {
                    this.checkDoubleData();
                    this.checkExistsNavigationDeviceType();
                    this.checkExistsRegistrationNumber();
                    this.checkExistsAttCode();
                    this.checkCategoryTC();
                    this.checkExistsOperator();
                    this.checkPhoneNumbers();
                    ((RnisImportForm)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject())).setStatAllRec();
                }
            }
            finally {
                panel.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (recCount == 0) {
                InitializedVariable.factory.runMessageEx((Object)new InfoMessage(" Info ", new String[]{" \u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0430 \u043f\u0435\u0440\u0432\u043e\u043c \u043b\u0438\u0441\u0442\u0435 \u0432 \u0444\u0430\u0439\u043b\u0435 " + file.getAbsolutePath()}), new BeanViewerAction[]{new MessageOKButton()});
            }
        }
    }

    protected int processFileExcel(String fileNameExcell) {
        int rCnt = 0;
        int index = fileNameExcell.lastIndexOf(46);
        String fileExt = index > 0 ? fileNameExcell.substring(index) : "";
        try {
            if (".xls".equalsIgnoreCase(fileExt)) {
                rCnt = this.processFileXLS(fileNameExcell);
            }
            if (".xlsx".equalsIgnoreCase(fileExt)) {
                rCnt = this.processFileXLSX(fileNameExcell);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rCnt;
    }

    protected int processFileXLS(String fileNameXLS) throws IOException {
        FileInputStream in = new FileInputStream(fileNameXLS);
        HSSFWorkbook wb = new HSSFWorkbook((InputStream)in);
        HSSFSheet sheet = wb.getSheetAt(0);
        boolean exit = true;
        int j = 1;
        int rowCount = 0;
        try {
            do {
                ImportUtils.CellType cellType = ImportUtils.CellType.ctNone;
                HSSFRow row = sheet.getRow(j);
                if (row == null) {
                    break;
                }
                HSSFCell c0 = row.getCell(1);
                if (c0 == null || c0.toString() == null) break;
                if (c0.toString().isEmpty()) {
                    break;
                }
                Transport4Import tc = new Transport4Import();
                int i = 0;
                while (i < 21) {
                    HSSFCell cell = row.getCell(i);
                    if (cell != null) {
                        String stringCellValue;
                        try {
                            switch (cell.getCellType()) {
                                case 0: {
                                    int intNumber;
                                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                        try {
                                            stringCellValue = this.format.format(cell.getDateCellValue());
                                        }
                                        catch (Exception exception) {
                                            stringCellValue = null;
                                        }
                                        cellType = ImportUtils.CellType.ctDate;
                                        break;
                                    }
                                    double dblNumber = cell.getNumericCellValue();
                                    stringCellValue = Math.abs(dblNumber - (double)(intNumber = (int)dblNumber)) < 1.0E-5 ? Integer.toString(intNumber) : Double.toString(dblNumber);
                                    cellType = ImportUtils.CellType.ctNumeric;
                                    break;
                                }
                                case 1: {
                                    stringCellValue = cell.getStringCellValue();
                                    cellType = ImportUtils.CellType.ctString;
                                    break;
                                }
                                default: {
                                    stringCellValue = "";
                                    break;
                                }
                            }
                        }
                        catch (Exception exception) {
                            stringCellValue = "";
                        }
                        this.tcFieldFill(tc, i, stringCellValue, cellType);
                    }
                    ++i;
                }
                tc.setStrNumber(j);
                this.tcItems.add(tc);
                ++rowCount;
                ++j;
            } while (exit);
        }
        finally {
            if (wb != null) {
                wb.close();
            }
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        return rowCount;
    }

    protected int processFileXLSX(String fileNameXLS) throws IOException {
        FileInputStream in = new FileInputStream(fileNameXLS);
        XSSFWorkbook wb = new XSSFWorkbook((InputStream)in);
        XSSFSheet sheet = wb.getSheetAt(0);
        boolean exit = true;
        int j = 1;
        int rowCount = 0;
        try {
            do {
                ImportUtils.CellType cellType = ImportUtils.CellType.ctNone;
                XSSFRow row = sheet.getRow(j);
                if (row == null) {
                    break;
                }
                XSSFCell c0 = row.getCell(1);
                if (c0 == null || c0.getStringCellValue() == null) break;
                if (c0.getStringCellValue().isEmpty()) {
                    break;
                }
                Transport4Import tc = new Transport4Import();
                int i = 0;
                while (i < 21) {
                    XSSFCell cell = row.getCell(i);
                    if (cell != null) {
                        String stringCellValue;
                        try {
                            switch (cell.getCellType()) {
                                case 0: {
                                    int intNumber;
                                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                        try {
                                            stringCellValue = this.format.format(cell.getDateCellValue());
                                        }
                                        catch (Exception exception) {
                                            stringCellValue = null;
                                        }
                                        cellType = ImportUtils.CellType.ctDate;
                                        break;
                                    }
                                    double dblNumber = cell.getNumericCellValue();
                                    stringCellValue = Math.abs(dblNumber - (double)(intNumber = (int)dblNumber)) < 1.0E-5 ? Integer.toString(intNumber) : Double.toString(dblNumber);
                                    cellType = ImportUtils.CellType.ctNumeric;
                                    break;
                                }
                                case 1: {
                                    stringCellValue = cell.getStringCellValue();
                                    cellType = ImportUtils.CellType.ctString;
                                    break;
                                }
                                default: {
                                    stringCellValue = "";
                                    break;
                                }
                            }
                        }
                        catch (Exception exception) {
                            stringCellValue = "";
                        }
                        this.tcFieldFill(tc, i, stringCellValue, cellType);
                    }
                    ++i;
                }
                this.tcItems.add(tc);
                ++rowCount;
                ++j;
            } while (exit);
        }
        finally {
            if (wb != null) {
                wb.close();
            }
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        return rowCount;
    }

    public void tcFieldFill(Transport4Import tc1, int numField, String valueField, ImportUtils.CellType cellType) {
        try {
            switch (numField) {
                case 0: {
                    tc1.setCarBrand(valueField);
                    break;
                }
                case 1: {
                    tc1.setStateRegSign(valueField);
                    break;
                }
                case 2: {
                    tc1.getTransport().setYearOfCar(valueField);
                    break;
                }
                case 3: {
                    tc1.setCarCategory(valueField);
                    break;
                }
                case 4: {
                    tc1.getTransport().setVinNumber(valueField);
                    break;
                }
                case 5: {
                    tc1.getTransport().setPtsNumber(valueField);
                    break;
                }
                case 6: {
                    if (valueField != null && !valueField.isEmpty()) {
                        Date pts_date = null;
                        if (cellType == ImportUtils.CellType.ctString || cellType == ImportUtils.CellType.ctDate) {
                            pts_date = this.format.parse(valueField);
                        } else if (cellType == ImportUtils.CellType.ctNumeric) {
                            pts_date = ImportUtils.excelDateNum2Date((String)valueField);
                        }
                        tc1.getTransport().setPtsDate(pts_date);
                    }
                    break;
                }
                case 7: {
                    tc1.getTransport().setRegistrationNumber(valueField);
                    break;
                }
                case 8: {
                    if (valueField != null && !valueField.isEmpty()) {
                        Date reg_date = null;
                        if (cellType == ImportUtils.CellType.ctString || cellType == ImportUtils.CellType.ctDate) {
                            reg_date = this.format.parse(valueField);
                        } else if (cellType == ImportUtils.CellType.ctNumeric) {
                            reg_date = ImportUtils.excelDateNum2Date((String)valueField);
                        }
                        tc1.getTransport().setRegistrationDate(reg_date);
                    }
                    break;
                }
                case 9: {
                    tc1.setSim1Operator(valueField);
                    break;
                }
                case 10: {
                    tc1.setPhone1Number(valueField);
                    break;
                }
                case 11: {
                    tc1.getNavigationDevice().setIcc_id1(valueField);
                    break;
                }
                case 12: {
                    tc1.setSim2Operator(valueField);
                    break;
                }
                case 13: {
                    tc1.setPhone2Number(valueField);
                    break;
                }
                case 14: {
                    tc1.getNavigationDevice().setIcc_id2(valueField);
                    break;
                }
                case 15: {
                    tc1.setAttType(valueField);
                    break;
                }
                case 16: {
                    tc1.getNavigationDevice().setImei(valueField);
                    break;
                }
                case 17: {
                    tc1.setAttNumber(valueField);
                    break;
                }
                case 18: {
                    if (valueField != null && !valueField.isEmpty()) {
                        tc1.getTransport().setGarageNum(valueField);
                        break;
                    }
                    tc1.getTransport().setGarageNum(tc1.getTransport().getRegNum());
                    break;
                }
                case 19: {
                    tc1.setTransportKind(valueField);
                    break;
                }
                case 20: {
                    tc1.setSubdivision(valueField);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int checkDoubleData() {
        int cnt = 0;
        int i = 0;
        while (i < this.tcItems.size()) {
            Transport4Import tc2;
            int j;
            Transport4Import tc = this.tcItems.get(i);
            if (tc.getStateRegSign() != null && !tc.getStateRegSign().isEmpty()) {
                j = i + 1;
                while (j < this.tcItems.size()) {
                    tc2 = this.tcItems.get(j);
                    if (tc2 != null && tc.getStateRegSign().equals(tc2.getStateRegSign())) {
                        tc.addErrors("\"\u0413\u043e\u0441. \u043d\u043e\u043c\u0435\u0440\" \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u0435\u0442\u0441\u044f \u0432 \u0444\u0430\u0439\u043b\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0432 \u0441\u0442\u0440. " + (j + 1) + ". \u0418\u043c\u043f\u043e\u0440\u0442 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
                        ++cnt;
                        tc.setStatusRec("\u043d\u0435\u0442");
                        break;
                    }
                    ++j;
                }
            }
            if (tc.getAttCode() != null && !tc.getAttCode().isEmpty()) {
                j = i + 1;
                while (j < this.tcItems.size()) {
                    tc2 = this.tcItems.get(j);
                    if (tc2 != null && tc.getAttCode().equals(tc2.getAttCode()) && tc.getAttType().equals(tc2.getAttType())) {
                        tc.addErrors("\"\u041a\u043e\u0434 \u043f\u0440\u0438\u0431\u043e\u0440\u0430\" \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u0435\u0442\u0441\u044f \u0432 \u0444\u0430\u0439\u043b\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0432 \u0441\u0442\u0440. " + (j + 1) + ". \u0418\u043c\u043f\u043e\u0440\u0442 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
                        ++cnt;
                        tc.setStatusRec("\u043d\u0435\u0442");
                        break;
                    }
                    ++j;
                }
            }
            if (tc.getImei() != null && !tc.getImei().isEmpty()) {
                j = i + 1;
                while (j < this.tcItems.size()) {
                    tc2 = this.tcItems.get(j);
                    if (tc2 != null && tc.getImei().equals(tc2.getImei())) {
                        tc.addErrors("\"\u041a\u043e\u0434 IMEI\" \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u0435\u0442\u0441\u044f \u0432 \u0444\u0430\u0439\u043b\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0432 \u0441\u0442\u0440. " + (j + 1) + ". \u0418\u043c\u043f\u043e\u0440\u0442 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
                        ++cnt;
                        tc.setStatusRec("\u043d\u0435\u0442");
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return cnt;
    }

    protected int checkExistsNavigationDeviceType() {
        int cnt = 0;
        if (this.tcItems.size() > 0) {
            NavigationDeviceTypeSearchCriteria dSc = new NavigationDeviceTypeSearchCriteria();
            NavigationDeviceTypeWSProxy coProxy = (NavigationDeviceTypeWSProxy)CurrentProxyFactory.getProxy(NavigationDeviceType.class);
            dSc.setCount(Integer.valueOf(1));
            NavigationDeviceTypeWSProxy.SearchResultListNavigationDeviceType srList = null;
            int i = 0;
            while (i < this.tcItems.size()) {
                Transport4Import tc = this.tcItems.get(i);
                if (!tc.getStatusRec().contains("\u043d\u0435\u0442")) {
                    if (tc.getAttType() != null && !tc.getAttType().isEmpty()) {
                        dSc.setDescription("*" + tc.getAttType() + "*");
                        srList = coProxy.getList(InitializedVariable.context, dSc);
                        if (srList.isEmpty()) {
                            tc.addErrors("\"\u0422\u0438\u043f \u0410\u0422\u0422\" \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u0418\u043c\u043f\u043e\u0440\u0442 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
                            ++cnt;
                            tc.setStatusRec("\u043d\u0435\u0442");
                        } else {
                            tc.setNdType((NavigationDeviceType)srList.getObjList()[0]);
                        }
                    } else {
                        tc.addErrors("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0444\u0430\u0439\u043b\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0430: \"\u0422\u0438\u043f \u0410\u0422\u0422\". \u0418\u043c\u043f\u043e\u0440\u0442 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
                        ++cnt;
                        tc.setStatusRec("\u043d\u0435\u0442");
                    }
                }
                ++i;
            }
        }
        return cnt;
    }

    protected int checkExistsRegistrationNumber() {
        int cnt = 0;
        if (this.tcItems.size() > 0) {
            TransportWSProxy proxy = (TransportWSProxy)CurrentProxyFactory.getProxy(Transport.class);
            TransportSearchCriteria sc = new TransportSearchCriteria();
            sc.setCount(Integer.valueOf(1));
            int i = 0;
            while (i < this.tcItems.size()) {
                Transport4Import tc = this.tcItems.get(i);
                if (!tc.getStatusRec().contains("\u043d\u0435\u0442")) {
                    if (tc.getStateRegSign() != null && !tc.getStateRegSign().isEmpty()) {
                        sc.setGarageNum(null);
                        sc.setRegNum("*" + tc.getStateRegSign() + "*");
                        TransportWSProxy.SearchResultListTransport transportSR = proxy.getList(InitializedVariable.context, sc);
                        boolean equalRegNum = false;
                        if (!transportSR.isEmpty()) {
                            tc.addErrors("\"\u0413\u043e\u0441. \u043d\u043e\u043c\u0435\u0440\" \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u0418\u043c\u043f\u043e\u0440\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u043f\u0440\u0438 \u043e\u0442\u043c\u0435\u0442\u043a\u0435 \"\u0417\u0430\u043c\u0435\u043d\u044f\u0442\u044c \u0422\u0421, \u0435\u0441\u043b\u0438 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442\".");
                            ++cnt;
                            Transport existTC = (Transport)transportSR.getObjList()[0];
                            existTC.setYearOfCar(tc.getTransport().getYearOfCar());
                            existTC.setVinNumber(tc.getTransport().getVinNumber());
                            existTC.setPtsNumber(tc.getTransport().getPtsNumber());
                            existTC.setPtsDate(tc.getTransport().getPtsDate());
                            existTC.setRegistrationNumber(tc.getTransport().getRegistrationNumber());
                            existTC.setRegistrationDate(tc.getTransport().getRegistrationDate());
                            equalRegNum = existTC.getGarageNum().equals(tc.getTransport().getGarageNum());
                            existTC.setGarageNum(tc.getTransport().getGarageNum());
                            tc.setTransport(existTC);
                        }
                        tc.getTransport().setRegNum(tc.getStateRegSign());
                        if (!equalRegNum) {
                            sc.setRegNum(null);
                            sc.setGarageNum("*" + tc.getTransport().getGarageNum() + "*");
                            transportSR = proxy.getList(InitializedVariable.context, sc);
                            if (!transportSR.isEmpty()) {
                                tc.addErrors("\"\u0413\u0430\u0440\u0430\u0436\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440\" \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0443 \u0434\u0440\u0443\u0433\u043e\u0433\u043e \u0422\u0421. \u0418\u043c\u043f\u043e\u0440\u0442 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
                                ++cnt;
                            }
                        }
                    } else {
                        tc.addErrors("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0444\u0430\u0439\u043b\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0430: \"\u0413\u043e\u0441. \u043d\u043e\u043c\u0435\u0440\". \u0418\u043c\u043f\u043e\u0440\u0442 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
                        ++cnt;
                        tc.setStatusRec("\u043d\u0435\u0442");
                    }
                }
                ++i;
            }
        }
        return cnt;
    }

    protected int checkExistsAttCode() {
        int cnt = 0;
        if (this.tcItems.size() > 0) {
            NavigationDeviceWSProxy proxy = (NavigationDeviceWSProxy)CurrentProxyFactory.getProxy(NavigationDevice.class);
            NavigationDeviceSearchCriteria sc = new NavigationDeviceSearchCriteria();
            sc.setCount(Integer.valueOf(1));
            NavigationDeviceWSProxy.SearchResultListNavigationDevice attSR = null;
            int i = 0;
            while (i < this.tcItems.size()) {
                Transport4Import tc = this.tcItems.get(i);
                if (!tc.getStatusRec().contains("\u043d\u0435\u0442")) {
                    if (tc.getAttCode() != null && !tc.getAttCode().isEmpty()) {
                        if (tc.getNdType() != null) {
                            sc.setDeviceTypeIdList(new Long[]{tc.getNdType().getId()});
                        }
                        sc.setImei(null);
                        sc.setCode("*" + tc.getAttCode() + "*");
                        attSR = proxy.getList(InitializedVariable.context, sc);
                        if (!attSR.isEmpty()) {
                            tc.addErrors("\"\u041a\u043e\u0434 \u0410\u0422\u0422\" \u0441 \u0442\u0430\u043a\u0438\u043c \u0442\u0438\u043f\u043e\u043c \u043f\u0440\u0438\u0431\u043e\u0440\u0430 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u0418\u043c\u043f\u043e\u0440\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u043f\u0440\u0438 \u043e\u0442\u043c\u0435\u0442\u043a\u0435 \"\u0417\u0430\u043c\u0435\u043d\u044f\u0442\u044c \u0410\u0422\u0422, \u0435\u0441\u043b\u0438 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442\".");
                            ++cnt;
                            NavigationDevice existND = (NavigationDevice)attSR.getObjList()[0];
                            existND.setIcc_id1(tc.getNavigationDevice().getIcc_id1());
                            existND.setIcc_id2(tc.getNavigationDevice().getIcc_id2());
                            existND.setImei(tc.getNavigationDevice().getImei());
                            existND.setPhone(tc.getNavigationDevice().getPhone());
                            existND.setPhone2(tc.getNavigationDevice().getPhone2());
                            tc.setNavigationDevice(existND);
                        }
                        tc.getNavigationDevice().setCode(tc.getAttCode());
                    } else {
                        tc.addErrors("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0444\u0430\u0439\u043b\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0430: \"\u041a\u043e\u0434 \u0410\u0422\u0422\". \u0418\u043c\u043f\u043e\u0440\u0442 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
                        ++cnt;
                        tc.setStatusRec("\u043d\u0435\u0442");
                    }
                }
                if (!tc.getStatusRec().contains("\u043d\u0435\u0442") && tc.getNavigationDevice() != null && tc.getNavigationDevice().getImei() != null && !tc.getNavigationDevice().getImei().isEmpty()) {
                    sc.setCode(null);
                    sc.setDeviceTypeIdList(null);
                    sc.setImei("*" + tc.getNavigationDevice().getImei() + "*");
                    attSR = proxy.getList(InitializedVariable.context, sc);
                    if (attSR != null && attSR.getObjList() != null && attSR.getObjList().length > 0) {
                        if (attSR.getObjList().length > 1 || attSR.getObjList().length == 1 && !((NavigationDevice)attSR.getObjList()[0]).getCode().equals(tc.getNavigationDevice().getCode())) {
                            tc.addErrors("\"IMEI\" \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u0418\u043c\u043f\u043e\u0440\u0442 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
                        }
                        ++cnt;
                    }
                }
                ++i;
            }
        }
        return cnt;
    }

    protected int checkCategoryTC() {
        int cnt = 0;
        TransportCategoryWSProxy proxy = (TransportCategoryWSProxy)CurrentProxyFactory.getProxy(TransportCategory.class);
        DirectoriesSearchCriteria sc = new DirectoriesSearchCriteria();
        sc.setCount(Integer.valueOf(1));
        int i = 0;
        while (i < this.tcItems.size()) {
            Transport4Import tc = this.tcItems.get(i);
            if (!tc.getStatusRec().contains("\u043d\u0435\u0442")) {
                if (tc.getCarCategory() != null && !tc.getCarCategory().isEmpty()) {
                    sc.setCode("*" + tc.getCarCategory() + "*");
                    TransportCategoryWSProxy.SearchResultListTransportCategory transportSR = proxy.getList(InitializedVariable.context, sc);
                    if (transportSR.isEmpty()) {
                        tc.addErrors("\"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0422\u0421\" \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u0418\u043c\u043f\u043e\u0440\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
                        ++cnt;
                    } else {
                        tc.getTransport().setCategory((TransportCategory)transportSR.getObjList()[0]);
                    }
                } else {
                    tc.addErrors("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0444\u0430\u0439\u043b\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0430: \"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0422\u0421\". \u0418\u043c\u043f\u043e\u0440\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
                    ++cnt;
                }
            }
            ++i;
        }
        return cnt;
    }

    protected int checkExistsOperator() {
        int cnt = 0;
        if (this.tcItems.size() > 0) {
            HashSet<String> operatorsNoExists = new HashSet<String>();
            HashMap<String, CellularOperator> operators = new HashMap<String, CellularOperator>();
            DirectoriesSearchCriteria dSc = new DirectoriesSearchCriteria();
            CellularOperatorWSProxy coProxy = (CellularOperatorWSProxy)CurrentProxyFactory.getProxy(CellularOperator.class);
            dSc.setCount(Integer.valueOf(1));
            int i = 0;
            while (i < this.tcItems.size()) {
                Transport4Import tc = this.tcItems.get(i);
                if (!tc.getStatusRec().contains("\u043d\u0435\u0442")) {
                    CellularOperator co;
                    CellularOperatorWSProxy.SearchResultListCellularOperator srList;
                    if (tc.getSim1Operator() != null && !tc.getSim1Operator().isEmpty()) {
                        if (operatorsNoExists.contains(tc.getSim1Operator())) {
                            tc.addErrors("\"\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u04401\" \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u0418\u043c\u043f\u043e\u0440\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u043f\u0440\u0438 \u043e\u0442\u043c\u0435\u0442\u043a\u0435 \"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u0441\u043e\u0442\u043e\u0432\u044b\u0445 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u043e\u0432\".");
                            ++cnt;
                            tc.getNavigationDevice().setOperator1(null);
                        } else if (operators.containsKey(tc.getSim1Operator())) {
                            tc.getNavigationDevice().setOperator1((CellularOperator)operators.get(tc.getSim1Operator()));
                        } else {
                            dSc.setCode("*" + tc.getSim1Operator() + "*");
                            srList = coProxy.getList(InitializedVariable.context, dSc);
                            if (srList.isEmpty()) {
                                tc.addErrors("\"\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u04401\" \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u0418\u043c\u043f\u043e\u0440\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u043f\u0440\u0438 \u043e\u0442\u043c\u0435\u0442\u043a\u0435 \"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u0441\u043e\u0442\u043e\u0432\u044b\u0445 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u043e\u0432\".");
                                ++cnt;
                                tc.getNavigationDevice().setOperator1(null);
                                operatorsNoExists.add(tc.getSim1Operator());
                            } else {
                                co = (CellularOperator)srList.getObjList()[0];
                                tc.getNavigationDevice().setOperator1(co);
                                operators.put(tc.getSim1Operator(), co);
                            }
                        }
                    } else {
                        tc.addErrors("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0444\u0430\u0439\u043b\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0430: \"\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u04401\". \u0418\u043c\u043f\u043e\u0440\u0442 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
                        ++cnt;
                    }
                    if (tc.getSim2Operator() != null && !tc.getSim2Operator().isEmpty()) {
                        if (operatorsNoExists.contains(tc.getSim2Operator())) {
                            tc.addErrors("\"\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u04402\" \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u0418\u043c\u043f\u043e\u0440\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u043f\u0440\u0438 \u043e\u0442\u043c\u0435\u0442\u043a\u0435 \"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u0441\u043e\u0442\u043e\u0432\u044b\u0445 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u043e\u0432\".");
                            ++cnt;
                            tc.getNavigationDevice().setOperator2(null);
                        } else if (operators.containsKey(tc.getSim2Operator())) {
                            tc.getNavigationDevice().setOperator2((CellularOperator)operators.get(tc.getSim2Operator()));
                        } else {
                            dSc.setCode("*" + tc.getSim2Operator() + "*");
                            srList = coProxy.getList(InitializedVariable.context, dSc);
                            if (srList.isEmpty()) {
                                tc.addErrors("\"\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u04402\" \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u0418\u043c\u043f\u043e\u0440\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u043f\u0440\u0438 \u043e\u0442\u043c\u0435\u0442\u043a\u0435 \"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u0441\u043e\u0442\u043e\u0432\u044b\u0445 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u043e\u0432\".");
                                ++cnt;
                                tc.getNavigationDevice().setOperator2(null);
                                operatorsNoExists.add(tc.getSim2Operator());
                            } else {
                                co = (CellularOperator)srList.getObjList()[0];
                                tc.getNavigationDevice().setOperator2(co);
                                operators.put(tc.getSim2Operator(), co);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        return cnt;
    }

    protected int checkPhoneNumbers() {
        int cnt = 0;
        if (this.tcItems.size() > 0) {
            int i = 0;
            while (i < this.tcItems.size()) {
                Transport4Import tc = this.tcItems.get(i);
                if (!tc.getStatusRec().contains("\u043d\u0435\u0442")) {
                    String pnum;
                    if (tc.getPhone1Number() != null && !tc.getPhone1Number().isEmpty()) {
                        pnum = this.checkPhoneNumber(tc.getPhone1Number());
                        if (pnum == null || pnum.isEmpty()) {
                            tc.addErrors("\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435. \u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442: \"\u0422\u0435\u043b. \u043d\u043e\u043c\u0435\u04401\". \u0418\u043c\u043f\u043e\u0440\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
                            ++cnt;
                        } else {
                            tc.setPhone1Number(pnum);
                        }
                    }
                    if (tc.getPhone2Number() != null && !tc.getPhone2Number().isEmpty() && !tc.getSim2Operator().isEmpty()) {
                        pnum = this.checkPhoneNumber(tc.getPhone2Number());
                        if (pnum == null || pnum.isEmpty()) {
                            tc.addErrors("\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435. \u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442: \"\u0422\u0435\u043b. \u043d\u043e\u043c\u0435\u04402\". \u0418\u043c\u043f\u043e\u0440\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
                            ++cnt;
                        } else {
                            tc.setPhone2Number(pnum);
                        }
                    }
                }
                ++i;
            }
        }
        return cnt;
    }

    protected String checkPhoneNumber(String phoneNumber) {
        if (phoneNumber != null && !phoneNumber.isEmpty()) {
            phoneNumber = phoneNumber.replaceAll(" ", "");
            phoneNumber = phoneNumber.replaceAll("-", "");
            phoneNumber = phoneNumber.replaceAll("_", "");
            phoneNumber = phoneNumber.replaceAll("\\(", "");
            phoneNumber = phoneNumber.replaceAll("\\)", "");
            Pattern p1 = Pattern.compile("8\\d{10}");
            Matcher m1 = p1.matcher(phoneNumber);
            if (m1.matches()) {
                return phoneNumber;
            }
            p1 = Pattern.compile("\\+7\\d{10}");
            m1 = p1.matcher(phoneNumber);
            if (m1.matches()) {
                return phoneNumber;
            }
            p1 = Pattern.compile("7\\d{10}");
            m1 = p1.matcher(phoneNumber);
            if (m1.matches()) {
                return "+" + phoneNumber;
            }
            p1 = Pattern.compile("\\d{10}");
            m1 = p1.matcher(phoneNumber);
            if (m1.matches()) {
                return "8" + phoneNumber;
            }
        }
        return null;
    }

    public String getHint() {
        return "\u041f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0444\u0430\u0439\u043b";
    }

    public String getName() {
        return "\u041f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0444\u0430\u0439\u043b";
    }

    public String getIcon() {
        return ResourceStrings.btPageExcel;
    }
}

