/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.transport.status;

import java.text.SimpleDateFormat;
import java.util.logging.Logger;
import ru.blok.common.ui.directories.FRCAsyncDirectoryViewer;
import ru.blok.common.ui.list.ObjectUIList;
import ru.blok.vms.ui.transport.status.Transport2StatusLinkList;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.simple.ExtendedDirectoryViewer;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.vms.entities.Transport2StatusLink;

public class Transport2StatusLinkDirectoryViewer<T>
extends FRCAsyncDirectoryViewer<T> {
    static SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    Transport2StatusLinkList list;

    public Class getTableCellViewerClass() {
        return Transport2StatusLinkDirectoryCellViewer.class;
    }

    public static String showLinkInfo(Transport2StatusLink t2s) {
        return "\u0422\u0421: ".concat(t2s.getTransport().getRegNum()).concat(" -> ").concat(t2s.getStatus().getDescription()).concat(" \u0441 ").concat(t2s.getBeginDate() == null ? " - " : df.format(t2s.getBeginDate())).concat(" \u043f\u043e ").concat(t2s.getEndDate() == null ? " - " : df.format(t2s.getEndDate()));
    }

    public Transport2StatusLinkDirectoryViewer(UIFactory<T> factory) {
        super(factory);
    }

    public String objectToString(Object o) {
        if (o == null) {
            return super.objectToString(o);
        }
        return Transport2StatusLinkDirectoryViewer.showLinkInfo((Transport2StatusLink)o);
    }

    public String valueToString(Object o) {
        if (o == null) {
            return super.objectToString(o);
        }
        return Transport2StatusLinkDirectoryViewer.showLinkInfo((Transport2StatusLink)o);
    }

    public void setContentClass(Class<?> cls) {
        super.setContentClass(Transport2StatusLink.class);
    }

    public CommonSearchCriteria updateSearchCriteria(CommonSearchCriteria sc, String value) {
        return sc;
    }

    public void buttonActionPerfomed() {
        try {
            if (this.list == null) {
                this.list = new Transport2StatusLinkList(this.getViewerContext().getKeyPage());
            }
            this.getFactory().newPage(Transport2StatusLink.class, Transport2StatusLinkList.class, (Object)this.list, this.getViewerContext(), "filterInList");
            Object o = this.getValue();
            ((ObjectUIList)this.list.getItems()).setSelection(o);
        }
        catch (Exception exception) {
            Logger.getLogger(ExtendedDirectoryViewer.class.getName()).severe("Can't create directory presentation " + this.getPresentationClass().getName());
        }
    }

    public static class Transport2StatusLinkDirectoryCellViewer<T>
    extends DefaultTableCellViewer<T> {
        public Transport2StatusLinkDirectoryCellViewer(UIFactory<T> factory) {
            super(factory);
        }

        public void setValue(Object object) {
            super.setValue((Object)(object == null ? "" : Transport2StatusLinkDirectoryViewer.showLinkInfo((Transport2StatusLink)object)));
        }
    }
}

