/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.transport.traffic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.report.RunReport;
import ru.blok.common.ui.UniversalSearchCriteraViewer;
import ru.blok.common.ui.directories.FRCAsyncViewerForIdSingle;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.swing.viewers.TimeFormatViewer;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.beanviewer.viewer.simple.date.DateWithoutButton;
import ru.infor.client.soap.proxy.vms.TransportWSProxy;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.vms.TransportSearchCriteria;
import ru.infor.ws.objects.vms.entities.PassengerTraffic4TS;
import ru.infor.ws.objects.vms.entities.Transport;
import ru.infor.ws.objects.vms.entities.TransportGroup;

@ListView(views={@View(title="\u041f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u043f\u043e\u0442\u043e\u043a", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class PassengerTrafficList
extends CommonObjectWithKey {
    private Date dateFrom;
    private Date dateTill;
    private Long[] groupIdList;
    private Long primaryGroupId;
    private boolean hideEmpty;
    private CalcButton btn = new CalcButton();
    private List<PassengerTraffic4TS> items = new ArrayList<PassengerTraffic4TS>();
    private List<PassengerTraffic4TS> itemsAll = new ArrayList<PassengerTraffic4TS>();
    private static TransportWSProxy proxy = (TransportWSProxy)CurrentProxyFactory.getProxy(Transport.class);
    private static TransportSearchCriteria sc = new TransportSearchCriteria();

    public PassengerTrafficList(String keyPage) {
        super(keyPage);
        Calendar c1 = Calendar.getInstance();
        c1.setTime(new Date());
        c1.add(6, -1);
        Date dd = c1.getTime();
        this.dateFrom = CommonSearchCriteria.beginOfDay((Date)dd);
        this.dateTill = CommonSearchCriteria.endOfDay((Date)dd);
    }

    public List<PassengerTraffic4TS> getItemsAll() {
        return this.itemsAll;
    }

    public void setItemsAll(List<PassengerTraffic4TS> itemsAll) {
        this.itemsAll = itemsAll;
    }

    @ListField(fields={@Field(title="\u041d\u0430\u0447\u0430\u043b\u043e", order=100, propertiesField={"keyView = list"}, viewer={DateWithoutButton.class}, propertiesUI={"format=dd.MM.yyyy"}, propertiesLayout="00/wrap 1, fill:3/wrap 1/\u0424\u0438\u043b\u044c\u0442\u0440/:31/wrap 8 # w 150")})
    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    @ListField(fields={@Field(title="", order=200, propertiesField={"keyView = list"}, viewer={TimeFormatViewer.class}, propertiesUI={"format=HH:mm:ss"}, propertiesLayout="00/:3/:31/# w 150, gap right 20, spanx 1")})
    public Date getTimeFrom() {
        return this.dateFrom;
    }

    public void setTimeFrom(Date dateFrom) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDateFrom());
        c2.setTime(dateFrom);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.dateFrom = c1.getTime();
    }

    @ListField(fields={@Field(title="\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435", order=300, propertiesField={"keyView = list"}, viewer={DateWithoutButton.class}, propertiesUI={"format=dd.MM.yyyy"}, propertiesLayout="00/:3/:31/# w 150 ")})
    public Date getDateTill() {
        return this.dateTill;
    }

    public void setDateTill(Date dateTill) {
        this.dateTill = dateTill;
    }

    @ListField(fields={@Field(title="", order=400, propertiesField={"keyView = list"}, viewer={TimeFormatViewer.class}, propertiesUI={"format=HH:mm:ss"}, propertiesLayout="00/:3/:31/# w 150, gap right 20")})
    public Date getTimeTill() {
        return this.dateTill;
    }

    public void setTimeTill(Date dateTill) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDateTill());
        c2.setTime(dateTill);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.dateTill = c1.getTime();
    }

    @ListField(fields={@Field(title="\u0413\u0440\u0443\u043f\u043f\u0430 \u0422\u0421", order=420, content=TransportGroup.class, viewer={UniversalSearchCriteraViewer.class}, propertiesField={"clazz=ru.blok.vms.ui.VMSAsyncDirectoryViewerForID", "keyView = list", "select=true"}, propertiesLayout="00/:3/:32//# w 250, gap right 20")})
    public Long[] getGroupIdList() {
        return this.groupIdList;
    }

    public void setGroupIdList(Long[] groupIdList) {
        this.groupIdList = groupIdList;
    }

    @ListField(fields={@Field(title="\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442\u043d\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430", order=430, viewer={FRCAsyncViewerForIdSingle.class}, propertiesField={"contentclazz=ru.infor.ws.objects.core.entities.UsersGroup", "keyView = list", "select=true"}, propertiesLayout="00/:3/:32/# w 250, gap right 20")})
    public Long getPrimaryGroupId() {
        return this.primaryGroupId;
    }

    public void setPrimaryGroupId(Long primaryGroupId) {
        this.primaryGroupId = primaryGroupId;
    }

    @ListField(fields={@Field(title="", order=450, viewer={ActionButton.class}, propertiesLayout="00/:3/:32/# gap right 40")})
    public CalcButton getCalcButton() {
        return this.btn;
    }

    @ListField(fields={@Field(title="\u0421\u043a\u0440\u044b\u0432\u0430\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u043f\u043e\u0442\u043e\u043a", order=490, propertiesField={"keyView = list"}, changeAction={HideEmptyChangeAction.class}, propertiesLayout="00/:3/:32/")})
    public boolean isHideEmpty() {
        return this.hideEmpty;
    }

    public void setHideEmpty(boolean hideEmpty) {
        this.hideEmpty = hideEmpty;
    }

    @ListField(fields={@Field(title="", order=1100, propertiesField={"keyView = list"}, viewer={ListViewer.class}, content=PassengerTraffic4TS.class, propertiesLayout="00/:0/fill, wrap1/n/ growy # spany, growy #", panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=RunReport.class)})})})
    public List<PassengerTraffic4TS> getItems() {
        return this.items;
    }

    public void setItems(List<PassengerTraffic4TS> items) {
        this.items = items;
    }

    static List<PassengerTraffic4TS> getShortList(List<PassengerTraffic4TS> listAll) {
        ArrayList<PassengerTraffic4TS> list = new ArrayList<PassengerTraffic4TS>();
        int i = 0;
        while (i < listAll.size()) {
            PassengerTraffic4TS pt = listAll.get(i);
            if (pt.getTraffic() != 0L) {
                list.add(pt);
            }
            ++i;
        }
        return list;
    }

    public static class CalcButton
    extends BeanViewerAction<ViewerContext> {
        public String getHint() {
            return "\u0412\u044b\u0447\u0438\u0441\u043b\u0438\u0442\u044c";
        }

        public String getName() {
            return "\u0412\u044b\u0447\u0438\u0441\u043b\u0438\u0442\u044c";
        }

        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            PassengerTrafficList form = (PassengerTrafficList)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject());
            if (form.getDateFrom() != null && form.getDateTill() != null && form.getDateFrom().before(form.getDateTill())) {
                sc.setDateFrom(form.getDateFrom());
                sc.setDateTill(form.getDateTill());
                sc.setPrimaryGroupId(form.getPrimaryGroupId());
                sc.setGroupIdList(form.getGroupIdList());
                PassengerTraffic4TS[] pass = proxy.getPassengerTraffic4TS(InitializedVariable.context, sc);
                if (pass != null) {
                    form.setItemsAll(new ArrayList<PassengerTraffic4TS>(Arrays.asList(pass)));
                    if (form.isHideEmpty()) {
                        form.setItems(PassengerTrafficList.getShortList(form.getItemsAll()));
                    } else {
                        form.setItems(form.getItemsAll());
                    }
                    ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("items");
                }
            } else {
                InitializedVariable.factory.runMessageEx((Object)new WarningMessage(" \u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0435\u0440\u0438\u043e\u0434 "), new BeanViewerAction[]{new MessageOKButton()});
            }
        }
    }

    public static class HideEmptyChangeAction
    extends BeanViewerAction<ViewerContext> {
        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            PassengerTrafficList form = (PassengerTrafficList)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject());
            if (form.isHideEmpty()) {
                form.setItems(PassengerTrafficList.getShortList(form.getItemsAll()));
            } else {
                form.setItems(form.getItemsAll());
            }
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("items");
        }
    }
}

