/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.voiting;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFileChooser;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.tracks.TrackAllWithPeriods;
import ru.blok.vms.ui.tracks.json.LoaderFromNominatim;
import ru.blok.vms.ui.voiting.MapViewer;
import ru.blok.vms.ui.voiting.Msg;
import ru.blok.vms.ui.voiting.VoitingStep;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.ResourceString;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.client.soap.proxy.vms.BuildingWSProxy;
import ru.infor.client.soap.proxy.vms.CheckPointWSProxy;
import ru.infor.ws.objects.vms.AdressNearPointParam;
import ru.infor.ws.objects.vms.NearestAddress;
import ru.infor.ws.objects.vms.PeriodTrk;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.Building;
import ru.infor.ws.objects.vms.entities.CheckPoint;
import ru.infor.ws.objects.vms.entities.NDData;

@ListView(views={@View(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u044f \u0443\u0440\u043d\u044b \u0434\u043b\u044f \u0433\u043e\u043b\u043e\u0441\u043e\u0432\u0430\u043d\u0438\u044f", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class TrackOfVoting
extends CommonObjectWithKey {
    MapValueWithTrack value;
    List<AbstractNDData> list = new ArrayList<AbstractNDData>();
    private List<TrackAllWithPeriods.Period> listPeriod = new ArrayList<TrackAllWithPeriods.Period>();
    BuildingWSProxy buildingWSProxy = (BuildingWSProxy)CurrentProxyFactory.getProxy(Building.class);
    CheckPointWSProxy checkPointWSProxy = (CheckPointWSProxy)CurrentProxyFactory.getProxy(CheckPoint.class);
    HashMap<String, String> sp = null;
    boolean lookUpAddress = false;
    private String name_urn;
    private String name_own;
    private String datb_date;
    BeanViewerAction<ViewerContext> btLoadData = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            VoitingStep vrd = null;
            JFileChooser jfc = new JFileChooser();
            jfc.setFileSelectionMode(2);
            int j = jfc.showOpenDialog(null);
            if (j != 0) {
                return;
            }
            String filename = jfc.getSelectedFile().getAbsolutePath();
            try {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{VoitingStep.class});
                Unmarshaller u = jc.createUnmarshaller();
                vrd = (VoitingStep)u.unmarshal(new File(filename));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (vrd != null && vrd.getMsg() != null) {
                TrackOfVoting.this.setName_urn((vrd.getName() == null ? "" : vrd.getName()).concat(" ").concat(vrd.getObj() == null || vrd.getObj().getId() == null ? "" : "(" + vrd.getObj().getId() + ")"));
                TrackOfVoting.this.setName_own(vrd.getName_own() == null ? "" : vrd.getName_own());
                TrackOfVoting.this.setDatb_date((vrd.getDate_start() == null ? "" : vrd.getDate_start()).concat(" - ").concat(vrd.getDate_end() == null ? "" : vrd.getDate_end()));
                List<Msg> listMsg = vrd.getMsg();
                Double lat0 = 0.0;
                Double lon0 = 0.0;
                int i = 0;
                while (i < listMsg.size()) {
                    Msg msg = listMsg.get(i);
                    try {
                        msg.setNavDatetime(df.parse(msg.getNav_datetime()));
                    }
                    catch (ParseException parseException) {
                        msg.setNavDatetime(new Date(new Date().getTime() - 31536000000L));
                    }
                    ++i;
                }
                Collections.sort(listMsg, TrackOfVoting.this.compareNDData());
                TrackAllWithPeriods.Period curPeriod = null;
                TrackOfVoting.this.listPeriod.clear();
                int i2 = 0;
                while (i2 < listMsg.size()) {
                    Msg msg = listMsg.get(i2);
                    NDData ndd = new NDData();
                    ndd.setDeviceId(Long.valueOf(1L));
                    ndd.setCreatedDateTime(msg.getNavDatetime());
                    ndd.setLat(Double.valueOf(TrackOfVoting.this.stringToDouble(msg.getNav_lat())));
                    ndd.setLon(Double.valueOf(TrackOfVoting.this.stringToDouble(msg.getNav_lon())));
                    ndd.setSpeed(Double.valueOf(msg.getNav_speed()));
                    ndd.setDirection(Double.valueOf((double)msg.getNav_course().intValue() * 1.0));
                    if (ndd.getLon() < 1.0 || ndd.getLat() < 1.0) {
                        ndd.setLat(lat0);
                        ndd.setLon(lon0);
                    } else {
                        lat0 = ndd.getLat();
                        lon0 = ndd.getLon();
                    }
                    if (msg.getSensor0() != null || msg.getSensor1() != null || msg.getSensor2() != null || msg.getSensor3() != null) {
                        if (curPeriod == null || curPeriod.getType() != PeriodTrk.OPENING && curPeriod.getType() != PeriodTrk.LOWERING) {
                            if (curPeriod != null) {
                                curPeriod.setDateTill(listMsg.get(i2 - 1).getNavDatetime());
                                curPeriod.setEnd(i2 - 1);
                                curPeriod.setLongDate(curPeriod.getDateTill().getTime() - curPeriod.getDateFrom().getTime());
                            }
                            curPeriod = new TrackAllWithPeriods.Period(null);
                            curPeriod.setNum(TrackOfVoting.this.listPeriod.size() + 1);
                            curPeriod.setDateFrom(msg.getNavDatetime());
                            curPeriod.setBegin(i2);
                            curPeriod.setType(msg.getSensor1() != null ? PeriodTrk.LOWERING : PeriodTrk.OPENING);
                            TrackOfVoting.this.listPeriod.add(curPeriod);
                        }
                    } else if (curPeriod == null || curPeriod.getType() != PeriodTrk.SPEED) {
                        if (curPeriod != null) {
                            curPeriod.setDateTill(listMsg.get(i2 - 1).getNavDatetime());
                            curPeriod.setEnd(i2 - 1);
                            curPeriod.setLongDate(curPeriod.getDateTill().getTime() - curPeriod.getDateFrom().getTime());
                        }
                        curPeriod = new TrackAllWithPeriods.Period(null);
                        curPeriod.setNum(TrackOfVoting.this.listPeriod.size() + 1);
                        curPeriod.setDateFrom(msg.getNavDatetime());
                        curPeriod.setBegin(i2);
                        curPeriod.setType(PeriodTrk.SPEED);
                        TrackOfVoting.this.listPeriod.add(curPeriod);
                    }
                    TrackOfVoting.this.list.add((AbstractNDData)ndd);
                    ++i2;
                }
                if (curPeriod != null && curPeriod.getDateTill() == null) {
                    curPeriod.setDateTill(listMsg.get(listMsg.size() - 1).getNavDatetime());
                    curPeriod.setEnd(listMsg.size() - 1);
                    curPeriod.setLongDate(curPeriod.getDateTill().getTime() - curPeriod.getDateFrom().getTime());
                    AdressNearPointParam an = new AdressNearPointParam();
                    an.setRadius(Integer.valueOf(500));
                    an.setLimit(Integer.valueOf(1));
                    int k = 0;
                    while (k < TrackOfVoting.this.listPeriod.size()) {
                        TrackAllWithPeriods.Period curP = (TrackAllWithPeriods.Period)((Object)TrackOfVoting.this.listPeriod.get(k));
                        if (PeriodTrk.OPENING == curP.getType() || PeriodTrk.LOWERING == curP.getType()) {
                            an.setLat(Double.valueOf(TrackOfVoting.this.stringToDouble(listMsg.get(curP.getEnd()).getNav_lat())));
                            an.setLon(Double.valueOf(TrackOfVoting.this.stringToDouble(listMsg.get(curP.getEnd()).getNav_lon())));
                            NearestAddress[] ad = null;
                            ad = TrackOfVoting.this.checkPointWSProxy.getListNearCheckPoint(InitializedVariable.context, an);
                            if (ad != null && ad.length > 0) {
                                curP.setAddr(ad[0].getAddress());
                            } else {
                                ad = TrackOfVoting.this.buildingWSProxy.getListNearAdress(InitializedVariable.context, an);
                                if (ad != null && ad.length > 0) {
                                    curP.setAddr(ad[0].getAddress());
                                } else if (TrackOfVoting.this.lookUpAddress) {
                                    curP.setAddr(LoaderFromNominatim.getNearAdress(TrackOfVoting.this.stringToDouble(listMsg.get(curP.getEnd()).getNav_lat()), TrackOfVoting.this.stringToDouble(listMsg.get(curP.getEnd()).getNav_lon())));
                                }
                            }
                        }
                        ++k;
                    }
                }
                TrackOfVoting.this.viewPart(TrackOfVoting.this.list.size());
                ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("listPeriod");
            }
        }

        public String getIcon() {
            return ResourceString.btLoadfromDBImage;
        }

        public String getHint() {
            return "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0444\u0430\u0439\u043b \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438";
        }

        public String getName() {
            return "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0444\u0430\u0439\u043b \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438";
        }
    };

    public TrackOfVoting(String keyPage) {
        super(keyPage);
        if (InitializedVariable.getWorkplaceId((String)keyPage) != null) {
            this.sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.getWorkplaceId((String)keyPage));
            if (this.sp.get("LookUpAddressInNominatim") != null) {
                this.lookUpAddress = true;
            }
        }
        this.value = new MapValueWithTrack();
    }

    public Double[] getMinMax(int i1, int i2) {
        Double minLat = Math.min(this.list.get(i1).getLat(), this.list.get(i2).getLat());
        Double maxLat = Math.max(this.list.get(i1).getLat(), this.list.get(i2).getLat());
        Double minLon = Math.min(this.list.get(i1).getLon(), this.list.get(i2).getLon());
        Double maxLon = Math.max(this.list.get(i1).getLon(), this.list.get(i2).getLon());
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @ListField(fields={@Field(title="", order=100, propertiesLayout="Split1/h/l/0.2:2/fillx", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getBtLoadData() {
        return this.btLoadData;
    }

    @ListField(fields={@Field(title="\u041e\u0431\u044a\u0435\u043a\u0442:", order=120, readOnly=true, propertiesLayout="Split1/h/l/0.2:3/fillx", propertiesUI={"background=#d4d0c8"})})
    public String getName_urn() {
        return this.name_urn;
    }

    public void setName_urn(String name_urn) {
        this.name_urn = name_urn;
    }

    @ListField(fields={@Field(title="\u0412\u043b\u0430\u0434\u0435\u043b\u0435\u0446:", order=140, readOnly=true, propertiesLayout="Split1/h/l/0.2:4/fillx", propertiesUI={"background=#d4d0c8"})})
    public String getName_own() {
        return this.name_own;
    }

    public void setName_own(String name_own) {
        this.name_own = name_own;
    }

    @ListField(fields={@Field(title="\u041f\u0435\u0440\u0438\u043e\u0434:", order=160, readOnly=true, propertiesLayout="Split1/h/l/0.2:5/fillx", propertiesUI={"background=#d4d0c8"})})
    public String getDatb_date() {
        return this.datb_date;
    }

    public void setDatb_date(String datb_date) {
        this.datb_date = datb_date;
    }

    @ListField(fields={@Field(title="", order=500, viewer={MapViewer.class}, propertiesLayout="Split1/h/r/0.2")})
    public MapValueWithTrack getValue() {
        return this.value;
    }

    @ListField(fields={@Field(title="\u0421\u043e\u0431\u044b\u0442\u0438\u044f", order=500, viewer={ListViewerT.class}, content=TrackAllWithPeriods.Period.class, propertiesLayout="Split1/h/l/0.2:7#cell 0 7, span# cell 0 6")})
    public List<TrackAllWithPeriods.Period> getListPeriod() {
        return this.listPeriod;
    }

    public void setListPeriod(List<TrackAllWithPeriods.Period> listPeriod) {
        this.listPeriod = listPeriod;
    }

    protected Comparator<? super Msg> compareNDData() {
        return new Comparator<Msg>(){

            @Override
            public int compare(Msg a1, Msg a2) {
                return a1.getNavDatetime().compareTo(a2.getNavDatetime());
            }
        };
    }

    protected double stringToDouble(String nav_lon) {
        nav_lon = nav_lon.replaceAll(",", ".");
        try {
            return Double.valueOf(nav_lon);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    private void viewPart(Integer count) {
        if (this.list != null && this.list.size() > 0) {
            int i = 0;
            this.value.getTracksNDData().clear();
            this.value.eventAll(this.list.get(i).getDeviceId(), this.list, i, i + count - 1, false, null);
        }
        this.updateUI();
    }

    public void updateUI() {
        ((PanelContext)((ViewerContext)this.btLoadData.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("name_urn");
        ((PanelContext)((ViewerContext)this.btLoadData.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("name_own");
        ((PanelContext)((ViewerContext)this.btLoadData.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("datb_date");
    }

    public static class ListViewerT<T>
    extends ListViewer<T> {
        public ListViewerT(UIFactory<T> factory) {
            super(factory);
            this.addActionOnSelect();
        }

        protected void actionOnSelect() {
            super.actionOnSelect();
            List l = this.getSelectedItems();
            TrackOfVoting t = (TrackOfVoting)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject());
            if (l != null && l.size() > 0 && t.getValue().getTracksNDData().size() > 0) {
                TrackAllWithPeriods.Period p = (TrackAllWithPeriods.Period)((Object)l.get(0));
                if (p.getType() == PeriodTrk.STOP) {
                    t.getValue().getTracksNDData().get(0).setSelectedPoint(new Integer[]{p.getBegin()});
                } else {
                    t.getValue().getTracksNDData().get(0).setSelected(new Integer[]{p.getBegin(), p.getEnd()});
                }
                ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("value");
                t.getValue().mapViewerWithTrack.zoomToTracks(t.getMinMax(p.getBegin(), p.getEnd()));
            }
        }
    }
}

