/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.warrant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.ExceptionInConstructor;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.core.PeriodDateClass;
import ru.blok.common.report.RunReport;
import ru.blok.common.ui.ExtractorSearchCrteria;
import ru.blok.common.ui.ManagerBD;
import ru.blok.common.ui.buttons.AdderButtonInAsyncList;
import ru.blok.common.ui.buttons.EditorButtonInAsyncList;
import ru.blok.common.ui.buttons.OKDirectoryListFilter;
import ru.blok.common.ui.buttons.SearchButton;
import ru.blok.common.ui.list.ObjectUIList;
import ru.blok.vms.previous.PathToPreviousVersion;
import ru.blok.vms.ui.driver.TabNumViewer;
import ru.blok.vms.ui.warrant.CreateWarrantButton;
import ru.blok.vms.ui.warrant.EnterWarrantButton;
import ru.blok.vms.ui.warrant.FillingWarrantFrom;
import ru.blok.vms.ui.warrant.MovingWarrantButton;
import ru.blok.vms.ui.warrant.OkWarrantDirectoryList;
import ru.blok.vms.ui.warrant.RemoveWarrantButton;
import ru.blok.vms.ui.warrant.TransportDirectoryViewerForWarrantPATP;
import ru.blok.vms.ui.warrant.WarrantBuildingErrorInterpretation;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Check;
import ru.infor.beanviewer.annotation.ClassView;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.UISetter;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.client.soap.SOAPException;
import ru.infor.client.soap.proxy.vms.DriverWSProxy;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.client.soap.proxy.vms.RunRegularityWSProxy;
import ru.infor.client.soap.proxy.vms.RunScheduleTypeWSProxy;
import ru.infor.client.soap.proxy.vms.ShiftTypeWSProxy;
import ru.infor.client.soap.proxy.vms.SubdivisionWSProxy;
import ru.infor.client.soap.proxy.vms.TransportWSProxy;
import ru.infor.client.soap.proxy.vms.WarrantWSProxy;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.core.DirectoriesSearchCriteria;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.vms.DriverSearchCriteria;
import ru.infor.ws.objects.vms.RouteSearchCriteria;
import ru.infor.ws.objects.vms.RunRegularitySearchCriteria;
import ru.infor.ws.objects.vms.TransportSearchCriteria;
import ru.infor.ws.objects.vms.WarrantBuildingError;
import ru.infor.ws.objects.vms.WarrantSearchCriteria;
import ru.infor.ws.objects.vms.WarrantUI;
import ru.infor.ws.objects.vms.entities.Driver;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.RunRegularity;
import ru.infor.ws.objects.vms.entities.RunScheduleType;
import ru.infor.ws.objects.vms.entities.ShiftType;
import ru.infor.ws.objects.vms.entities.Subdivision;
import ru.infor.ws.objects.vms.entities.Transport;
import ru.infor.ws.objects.vms.entities.Warrant;
import ru.infor.ws.objects.vms.entities.ext.WarrantExt;
import ru.infor.ws.proxy.UniversalProxy;
import ru.infor.ws.proxy.interfaces.InvocationContext;

@ListView(views={@View(title="\u041d\u0430\u0440\u044f\u0434\u044b", transitionEnter=true, actions={}, layoutKeys={"tabSplitPercentLayoutManager"}, properties={"minsize=1050x600"}), @View(title="\u041d\u0430\u0440\u044f\u0434\u044b", keyView="filterInList", actions={@ActionViewer(clazz=OkWarrantDirectoryList.class), @ActionViewer(clazz=PanelContext.CancelButton.class)}, layoutKeys={"tabSplitPercentLayoutManager"}, properties={"minsize=1050x600"}), @View(title="\u041d\u0430\u0440\u044f\u0434\u044b", keyView="filterInListForId", actions={@ActionViewer(clazz=OKDirectoryListFilter.class), @ActionViewer(clazz=PanelContext.CancelButton.class)}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class WarrantList
extends PathToPreviousVersion {
    static Logger logger = Logger.getLogger(WarrantList.class);
    private List<WarrantUI> items;
    WarrantWSProxy proxy = (WarrantWSProxy)CurrentProxyFactory.getProxy(Warrant.class);
    WarrantSearchCriteria searchCriteria = new WarrantSearchCriteria();
    static HashMap<String, String> sp = null;
    private Long idSubdivision = null;
    Driver driver;
    Transport transport;
    private BufferedReader reader;
    RouteWSProxy rProxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);
    TransportWSProxy tProxy = (TransportWSProxy)CurrentProxyFactory.getProxy(Transport.class);
    DriverWSProxy dProxy = (DriverWSProxy)CurrentProxyFactory.getProxy(Driver.class);
    RunScheduleTypeWSProxy rstProxy = (RunScheduleTypeWSProxy)CurrentProxyFactory.getProxy(RunScheduleType.class);
    ShiftTypeWSProxy stProxy = (ShiftTypeWSProxy)CurrentProxyFactory.getProxy(ShiftType.class);
    static HashMap<String, RunScheduleType> rstHash = new HashMap();
    static HashMap<String, ShiftType> stHash = new HashMap();
    static HashMap<String, Route> routeHash = new HashMap();
    EnterWarrantButton enterWarrantButton = new EnterWarrantButton();

    @ListField(fields={@Field(readOnly=false, title="\u0413\u0430\u0440\u0430\u0436\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 ", order=20, viewer={TransportDirectoryViewerForWarrantPATP.class}, propertiesLayout="0/fill/\u0412\u0432\u043e\u0434 \u043d\u0430\u0440\u044f\u0434\u0430/")})
    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    @ListField(fields={@Field(readOnly=false, title="\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 ", order=25, viewer={TabNumViewer.class}, propertiesLayout="0")})
    public Driver getDriver() {
        return this.driver;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    @ListField(fields={@Field(title="", order=40, viewer={ActionButton.class}, propertiesLayout="0")})
    public EnterWarrantButton getEnterWarrantButton() {
        return this.enterWarrantButton;
    }

    public WarrantList(String keyPage) throws ExceptionInConstructor {
        super(keyPage);
        if (InitializedVariable.getWorkplaceId((String)this.getKeyPage()) != null) {
            sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.getWorkplaceId((String)this.getKeyPage()));
            if (sp.get("PathToPreviousVersionNar") != null) {
                this.setPathToPreviousVersionNar(sp.get("PathToPreviousVersionNar"));
            }
            if (sp.get("CodeCurrentSubdivision") != null) {
                SubdivisionWSProxy subProxy = (SubdivisionWSProxy)CurrentProxyFactory.getProxy(Subdivision.class);
                DirectoriesSearchCriteria dsc = new DirectoriesSearchCriteria();
                dsc.setCode(sp.get("CodeCurrentSubdivision"));
                SubdivisionWSProxy.SearchResultListSubdivision srl = subProxy.getList(InitializedVariable.context, dsc);
                if (srl != null && srl.getObjList() != null && srl.getObjList().length > 0) {
                    this.idSubdivision = ((Subdivision)srl.getObjList()[0]).getId();
                }
            }
        }
        this.items = new ObjectUIList(WarrantUI.class);
        this.searchCriteria = (WarrantSearchCriteria)((ObjectUIList)this.items).getSearchCriteria();
        SortObject so1 = new SortObject();
        so1.setDirection(SortObject.DIRECTION_ASC);
        so1.setName("routeNum");
        SortObject so2 = new SortObject();
        so2.setDirection(SortObject.DIRECTION_ASC);
        so2.setName("rsTypeCodeInt");
        SortObject so3 = new SortObject();
        so3.setDirection(SortObject.DIRECTION_ASC);
        so3.setName("shiftTypeDescription");
        this.searchCriteria.setListSort(new SortObject[]{so1, so2, so3});
        if (this.idSubdivision != null) {
            this.searchCriteria.setSubdivisionIdList(new Long[]{this.idSubdivision});
        }
        PeriodDateClass pd = new PeriodDateClass(sp);
        this.searchCriteria.setWarrantDateFrom(pd.getFirstDate());
        this.searchCriteria.setWarrantDateTill(pd.getLastDate());
        ((ObjectUIList)this.items).setTotalFill(true);
    }

    @ListField(fields={@Field(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043d\u0430\u0440\u044f\u0434\u043e\u0432", order=10, propertiesField={"className=ru.infor.ws.objects.vms.Warrant"}, viewer={ListViewer.class}, propertiesLayout="Split1/v/l/0.8", panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=RunReport.class), @ActionField(clazz=Adder.class, checks={@Check(checkId="WarrantWS:save")}), @ActionField(clazz=Editor.class, doubleclick=true, checks={@Check(checkId="WarrantWS:save")}), @ActionField(clazz=RemoveWarrantButton.class, checks={@Check(checkId="WarrantWS:delete")}), @ActionField(clazz=SearchButton.class), @ActionField(clazz=CreateWarrantButton.class, checks={@Check(checkId="WarrantWS:save")}), @ActionField(clazz=FillingWarrantFrom.class, checks={@Check(checkId="WarrantWS:save")}), @ActionField(clazz=MovingWarrantButton.class, checks={@Check(checkId="WarrantWS:save")})}), @PanelField(name="\u0424\u0438\u043b\u044c\u0442\u0440", order=30, classView={@ClassView(name="sc", clazz=WarrantSearchCriteria.class, extractor=ExtractorSearchCrteria.class)})}, content=WarrantUI.class), @Field(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043d\u0430\u0440\u044f\u0434\u043e\u0432", keyView="filterInList", order=10, propertiesField={"className=ru.infor.ws.objects.vms.Warrant"}, viewer={ListViewer.class}, propertiesLayout="Split1/v/l/0.8", panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=Adder.class, checks={@Check(checkId="WarrantWS:save")}), @ActionField(clazz=Editor.class, doubleclick=true, checks={@Check(checkId="WarrantWS:save")}), @ActionField(clazz=RemoveWarrantButton.class, checks={@Check(checkId="WarrantWS:delete")}), @ActionField(clazz=SearchButton.class)}), @PanelField(name="\u0424\u0438\u043b\u044c\u0442\u0440", order=30, classView={@ClassView(name="sc", clazz=WarrantSearchCriteria.class, extractor=ExtractorSearchCrteria.class)})}, content=WarrantUI.class), @Field(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043d\u0430\u0440\u044f\u0434\u043e\u0432", keyView="filterInListForId", order=10, propertiesField={"className=ru.infor.ws.objects.vms.Warrant"}, viewer={ListViewer.class}, propertiesLayout="Split1/v/l/0.8", panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=Adder.class, checks={@Check(checkId="WarrantWS:save")}), @ActionField(clazz=Editor.class, doubleclick=true, checks={@Check(checkId="WarrantWS:save")}), @ActionField(clazz=RemoveWarrantButton.class, checks={@Check(checkId="WarrantWS:delete")}), @ActionField(clazz=SearchButton.class)}), @PanelField(name="\u0424\u0438\u043b\u044c\u0442\u0440", order=30, classView={@ClassView(name="sc", clazz=WarrantSearchCriteria.class, extractor=ExtractorSearchCrteria.class)})}, content=WarrantUI.class)})
    public List<WarrantUI> getItems() {
        return this.items;
    }

    public void setItems(List<WarrantUI> items) {
        this.items = items;
    }

    public WarrantExt createItems() {
        WarrantExt w = new WarrantExt();
        return w;
    }

    public WarrantExt editItemsInt(Long id) {
        WarrantExt warrantExt = (WarrantExt)this.proxy._universalGetCurrentObject((InvocationContext)InitializedVariable.context, id);
        return warrantExt;
    }

    public WarrantExt editItems(Object o) {
        return this.editItemsInt(((WarrantUI)o).getId());
    }

    public void removeItems(Object o) {
        RunRegularityWSProxy proxyRR = (RunRegularityWSProxy)CurrentProxyFactory.getProxy(RunRegularity.class);
        RunRegularitySearchCriteria rrsc = new RunRegularitySearchCriteria();
        rrsc.setWarrantIdList(new Long[]{((WarrantUI)o).getId()});
        RunRegularityWSProxy.SearchResultListRunRegularity list = proxyRR.getList(InitializedVariable.context, rrsc);
        Object[] listRunRegularity = list.getObjList();
        if (listRunRegularity != null && listRunRegularity.length > 0) {
            Object[] objectArray = listRunRegularity;
            int n = listRunRegularity.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                RunRegularity rr = (RunRegularity)object;
                rr.setIsDeleted(1);
                proxyRR._universalSave((InvocationContext)InitializedVariable.context, (Object)rr);
                ++n2;
            }
        }
        ManagerBD.universalRemove((UniversalProxy)this.proxy, (Long)((WarrantUI)o).getId());
    }

    public WarrantSearchCriteria getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(WarrantSearchCriteria searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public void fillingWarrantFromFile(File file) {
        try {
            String s;
            DirectoriesSearchCriteria dSc = new DirectoriesSearchCriteria();
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.getAbsolutePath()), "Cp1251"));
            int count = 0;
            Date date = null;
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy", Locale.US);
            while ((s = this.reader.readLine()) != null) {
                RouteWSProxy.SearchResultListRoute srList;
                Warrant warrant = null;
                WarrantSearchCriteria wSc = new WarrantSearchCriteria();
                String[] params = s.split(";");
                if (params == null || params.length < 6) continue;
                try {
                    date = format.parse(params[0]);
                }
                catch (ParseException e) {
                    logger.info((Object)("Error: WarrantDate " + params[0] + " ( " + s + "): " + e.getMessage()));
                }
                if (date == null) continue;
                wSc.setWarrantDateFrom(CommonSearchCriteria.beginOfDay((Date)date));
                wSc.setWarrantDateTill(CommonSearchCriteria.endOfDay((Date)date));
                Route route = routeHash.get(params[1]);
                if (route == null) {
                    RouteSearchCriteria rSc = new RouteSearchCriteria();
                    rSc.setCount(Integer.valueOf(1));
                    rSc.setNum("*" + params[1] + "*");
                    try {
                        srList = this.rProxy.getList(InitializedVariable.context, rSc);
                        if (srList != null && !srList.isEmpty()) {
                            route = (Route)srList.getObjList()[0];
                            routeHash.put(params[1], route);
                        }
                    }
                    catch (Exception e) {
                        logger.info((Object)("Error: Route " + params[1] + " ( " + s + "): " + e.getMessage()));
                    }
                }
                if (route == null) {
                    logger.info((Object)("Error: Route " + params[1] + " ( " + s + "): not found"));
                    continue;
                }
                wSc.setRouteIdList(new Long[]{route.getId()});
                RunScheduleType rsType = rstHash.get(params[2]);
                if (rsType == null) {
                    dSc = new DirectoriesSearchCriteria();
                    dSc.setCount(Integer.valueOf(1));
                    dSc.setDescription("*" + params[2] + "*");
                    try {
                        srList = this.rstProxy.getList(InitializedVariable.context, dSc);
                        if (srList != null && !srList.isEmpty()) {
                            rsType = (RunScheduleType)srList.getObjList()[0];
                            rstHash.put(params[2], rsType);
                        }
                    }
                    catch (Exception e) {
                        logger.info((Object)("Error: RsType" + params[2] + " ( " + s + "): " + e.getMessage()));
                    }
                }
                if (rsType == null) {
                    logger.info((Object)("Error: RsType" + params[2] + " ( " + s + "): not found"));
                    continue;
                }
                wSc.setRsTypeIdList(new Long[]{rsType.getId()});
                ShiftType shiftType = stHash.get(params[3]);
                if (shiftType == null) {
                    dSc = new DirectoriesSearchCriteria();
                    dSc.setCount(Integer.valueOf(1));
                    dSc.setDescription("*" + params[3] + "*");
                    try {
                        srList = this.stProxy.getList(InitializedVariable.context, dSc);
                        if (srList != null && !srList.isEmpty()) {
                            shiftType = (ShiftType)srList.getObjList()[0];
                            stHash.put(params[3], shiftType);
                        }
                    }
                    catch (Exception e) {
                        logger.info((Object)("Error: ShiftType" + params[3] + " ( " + s + "): " + e.getMessage()));
                    }
                }
                if (shiftType == null) {
                    logger.info((Object)("Error: ShiftType" + params[3] + " ( " + s + "): not found"));
                    continue;
                }
                wSc.setShiftTypeIdList(new Long[]{shiftType.getId()});
                wSc.setCount(new Integer(1));
                srList = this.proxy.getList(InitializedVariable.context, wSc);
                if (srList == null || srList.isEmpty()) {
                    logger.info((Object)("Error: warrant ( " + s + "): not found"));
                    continue;
                }
                warrant = (Warrant)srList.getObjList()[0];
                if (warrant == null) continue;
                if (warrant.getTransport() != null || warrant.getDriver() != null) {
                    logger.info((Object)("Error: warrant ( " + s + "): already exists"));
                    continue;
                }
                TransportSearchCriteria tSc = new TransportSearchCriteria();
                tSc.setCount(Integer.valueOf(1));
                tSc.setGarageNum("*" + params[4] + "*");
                Transport t = null;
                try {
                    srList = this.tProxy.getList(InitializedVariable.context, tSc);
                    if (srList != null && !srList.isEmpty()) {
                        t = (Transport)srList.getObjList()[0];
                    }
                }
                catch (Exception e) {
                    logger.info((Object)("Error: Transport ( " + s + "): " + e.getMessage()));
                }
                if (t == null) {
                    logger.info((Object)("Error: Transport ( " + s + "): not found"));
                    continue;
                }
                warrant.setTransport(t);
                DriverSearchCriteria driverSc = new DriverSearchCriteria();
                driverSc.setCount(Integer.valueOf(1));
                driverSc.setTabNum("*" + params[5] + "*");
                Driver d = null;
                try {
                    srList = this.dProxy.getList(InitializedVariable.context, driverSc);
                    if (srList != null && !srList.isEmpty()) {
                        d = (Driver)srList.getObjList()[0];
                    }
                }
                catch (Exception e) {
                    logger.info((Object)("Error: Driver ( " + s + "): " + e.getMessage()));
                }
                if (d == null) {
                    logger.info((Object)("Error: Driver ( " + s + "): not found"));
                    continue;
                }
                warrant.setDriver(d);
                try {
                    warrant = this.proxy.save(InitializedVariable.context, warrant);
                }
                catch (Exception e) {
                    logger.info((Object)("Error: save warrant: " + warrant + " ( " + s + "): " + e.getMessage()));
                }
                ++count;
            }
            logger.info((Object)("Filling " + count + " warrant's."));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadOnServerWarrantFromFile(File file) {
        try {
            String inputLine;
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.getAbsolutePath()), "Cp1251"));
            StringBuilder response = new StringBuilder();
            while ((inputLine = this.reader.readLine()) != null) {
                int index = inputLine.indexOf(35);
                if (index > -1) {
                    if (index <= 0) continue;
                    response.append(inputLine.substring(0, index));
                    response.append("\n");
                    continue;
                }
                response.append(inputLine);
                response.append("\n");
            }
            this.reader.close();
            String rez = StringEscapeUtils.unescapeJava((String)response.toString());
            WarrantBuildingError[] list = null;
            try {
                list = this.proxy.fillWarrantsFromFile(InitializedVariable.context, rez);
            }
            catch (SOAPException se) {
                se.printStackTrace();
                return;
            }
            if (list != null && list.length > 0) {
                String fileName = new String("warrant_" + new Date().getTime() + ".txt");
                System.out.println("\u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0430\u0440\u044f\u0434\u044b \u043d\u0435 \u0431\u044b\u043b\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u044b. \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u0435\u0435 \u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0432 " + fileName);
                WarrantBuildingErrorInterpretation wbei = new WarrantBuildingErrorInterpretation(list, fileName);
                wbei.printList();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Adder
    extends AdderButtonInAsyncList {
        public void actionPerformed(Object arg0) {
            super.actionPerformed(arg0);
            UISetter panel = InitializedVariable.factory.getCurrentPanel(((ViewerContext)this.getContext()).getKeyPage());
            panel.getLayout().setFocusOnComponent(panel.getPresentatorForName("routeSchedule"));
            WarrantExt w = (WarrantExt)((Object)panel.getObject());
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(5, 1);
            w.setWarrantDate(c.getTime());
            panel.setObject((Object)w);
            panel.updateUI();
        }
    }

    public static class Editor
    extends EditorButtonInAsyncList {
        public void actionPerformed(Object arg0) {
            super.actionPerformed(arg0);
            UISetter panel = InitializedVariable.factory.getCurrentPanel(((ViewerContext)this.getContext()).getKeyPage());
            panel.getLayout().setFocusOnComponent(panel.getPresentatorForName("transport"));
            panel.updateUI();
        }
    }
}

