/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.waybill.currentday;

import java.math.BigDecimal;
import java.util.Date;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.BooleanFRCViewer;
import ru.blok.common.ui.buttons.Cancel;
import ru.blok.common.ui.directories.FRCBaseDirectoryViewer;
import ru.blok.vms.ui.HelpUtils;
import ru.blok.vms.ui.driver.TabNumViewer;
import ru.blok.vms.ui.route.TransportStopDirectoryViewer;
import ru.blok.vms.ui.routeschedule.TransportStopOfRouteViewer;
import ru.blok.vms.ui.transport.GarageNumDirectoryViewer;
import ru.blok.vms.ui.waybill.currentday.ChangeNewTransport;
import ru.blok.vms.ui.waybill.currentday.ChangeTransportStop;
import ru.blok.vms.ui.waybill.currentday.OKReplaceWaybillTransport;
import ru.blok.vms.ui.waybill.currentday.common.WaybillCommonActions;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.swing.viewers.TimeFormatViewer;
import ru.infor.client.soap.proxy.vms.WayBillWSProxy;
import ru.infor.ws.objects.core.entities.UsersGroup;
import ru.infor.ws.objects.vms.entities.Driver;
import ru.infor.ws.objects.vms.entities.ReplaceReason;
import ru.infor.ws.objects.vms.entities.Transport;
import ru.infor.ws.objects.vms.entities.TransportStop;
import ru.infor.ws.objects.vms.entities.WayBill;
import ru.infor.ws.objects.vms.ext.WaybillRealTimeExt;

@ListView(views={@View(title="\u0417\u0430\u043c\u0435\u043d\u0430 \u0422\u0421", transitionEnter=true, actions={@ActionViewer(clazz=OKReplaceWaybillTransport.class), @ActionViewer(clazz=Cancel.class)}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class ReplaceWaybillTransportForm {
    WayBillWSProxy wbProxy = (WayBillWSProxy)CurrentProxyFactory.getProxy(WayBill.class);
    WaybillRealTimeExt wbrt;
    Transport transport;
    Date date;
    ReplaceReason reason;
    TransportStop baseStation;
    Long waybillId;
    Long warrantId;
    Long primaryGroupId = null;
    Driver driver;
    Integer run1;
    TransportStop stop1;
    Integer duration1;
    BigDecimal mealage1;
    String name1;
    Integer run2;
    TransportStop stop2;
    Integer duration2;
    BigDecimal mealage2;
    String name2;

    public ReplaceWaybillTransportForm(WaybillRealTimeExt wbrt) {
        this.initReplaceWaybillTransportForm(wbrt, null, null);
    }

    public ReplaceWaybillTransportForm(WaybillRealTimeExt wbrt, Date curDate) {
        this.initReplaceWaybillTransportForm(wbrt, curDate, null);
    }

    public ReplaceWaybillTransportForm(WaybillRealTimeExt wbrt, Date curDate, TransportStop stop) {
        this.initReplaceWaybillTransportForm(wbrt, curDate, stop);
    }

    private void initReplaceWaybillTransportForm(WaybillRealTimeExt wbrt, Date curDate, TransportStop stop) {
        this.wbrt = wbrt;
        if (curDate == null) {
            curDate = new Date();
        }
        if (stop != null) {
            this.baseStation = stop;
        }
        this.date = curDate;
        this.warrantId = wbrt.getWarrantId();
        if (wbrt != null && wbrt.getTransportId() != null) {
            WayBill wb = null;
            if (wbrt.getWaybillId() != null) {
                wb = this.wbProxy.getCurrentObject(InitializedVariable.context, wbrt.getWaybillId());
            } else {
                WaybillCommonActions wbca = new WaybillCommonActions(InitializedVariable.context);
                wb = wbca.getWaybillFromTransportDateTime(wbrt.getTransportId(), curDate);
            }
            if (wb != null) {
                this.waybillId = wb.getId();
                UsersGroup userGroup = HelpUtils.getPrimaryGroup(wb.getCreatedBy_id());
                if (userGroup != null) {
                    this.primaryGroupId = userGroup.getId();
                }
            }
        }
    }

    @ListField(fields={@Field(title="\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u043c\u0435\u043d\u044b ", order=10, viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"}, propertiesLayout="0#cell 1 0# cell 0 0")})
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @ListField(fields={@Field(title="\u041d\u043e\u0432\u043e\u0435 \u0422\u0421 ", order=20, viewer={GarageNumDirectoryViewer.class}, propertiesLayout="0#cell 1 1# cell 0 1", changeAction={ChangeNewTransport.class}, validators={"\u041d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435:\u0422\u0421 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e:IsNull"})})
    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    @ListField(fields={@Field(title="\u0412\u043e\u0434\u0438\u0442\u0435\u043b\u044c ", order=25, viewer={TabNumViewer.class}, propertiesLayout="0#cell 1 2# cell 0 2")})
    public Driver getDriver() {
        return this.driver;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    @ListField(fields={@Field(title="\u041f\u0440\u0438\u0447\u0438\u043d\u0430 ", order=30, content=ReplaceReason.class, viewer={FRCBaseDirectoryViewer.class}, propertiesLayout="0#cell 1 3# cell 0 3", validators={"\u041d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435:\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430:IsNull"})})
    public ReplaceReason getReason() {
        return this.reason;
    }

    public void setReason(ReplaceReason reason) {
        this.reason = reason;
    }

    @ListField(fields={@Field(title="\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0441\u0445\u043e\u0434\u0430", order=40, content=TransportStop.class, viewer={TransportStopOfRouteViewer.class}, propertiesLayout="0#cell 1 4# cell 0 4", changeAction={ChangeTransportStop.class}, validators={"\u041d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435:\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0441\u0445\u043e\u0434\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430:IsNull"})})
    public TransportStop getBaseStation() {
        return this.baseStation;
    }

    public void setBaseStation(TransportStop baseStation) {
        this.baseStation = baseStation;
    }

    @ListField(fields={@Field(title="\u041f\u0435\u0440\u0435\u0433\u043e\u043d \u043d\u043e\u0432\u043e\u0433\u043e \u0422\u0421", order=45, viewer={BooleanFRCViewer.class}, propertiesLayout="0:1/fill/\u041f\u0435\u0440\u0435\u0433\u043e\u043d \u043d\u043e\u0432\u043e\u0433\u043e \u0422\u0421/cell 0 5, spanx 4#cell 1 0#cell 0 0")})
    public Integer getRun1() {
        return this.run1;
    }

    public void setRun1(Integer run1) {
        this.run1 = run1;
    }

    @ListField(fields={@Field(title="\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 1", order=50, content=TransportStop.class, viewer={TransportStopDirectoryViewer.class}, propertiesLayout="0:1/fill/\u041f\u0435\u0440\u0435\u0433\u043e\u043d \u043d\u043e\u0432\u043e\u0433\u043e \u0422\u0421/cell 0 6, spanx 4#cell 1 1#cell 0 1", changeAction={ChangeTransportStop.class})})
    public TransportStop getStop11() {
        return this.stop1;
    }

    public void setStop11(TransportStop stop1) {
        this.stop1 = stop1;
    }

    @ListField(fields={@Field(title="\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 2", order=60, readOnly=true, content=TransportStop.class, viewer={TransportStopOfRouteViewer.class}, propertiesLayout="0:1#cell 1 2#cell 0 2", changeAction={ChangeTransportStop.class})})
    public TransportStop getStop12() {
        return this.baseStation;
    }

    public void setStop12(TransportStop baseStation) {
        this.baseStation = baseStation;
    }

    @ListField(fields={@Field(title="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u0433\u043e\u043d\u0430", order=70, propertiesLayout="0:1#cell 1 3#cell 0 3")})
    public String getName1() {
        return this.name1;
    }

    public void setName1(String name1) {
        this.name1 = name1;
    }

    @ListField(fields={@Field(title="\u0412\u0440\u0435\u043c\u044f \u043f\u0435\u0440\u0435\u0433\u043e\u043d\u0430 \u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445", order=80, propertiesLayout="0:1#cell 1 4#cell 0 4")})
    public Integer getDuration1() {
        return this.duration1;
    }

    public void setDuration1(Integer duration1) {
        this.duration1 = duration1;
    }

    @ListField(fields={@Field(title="\u041a\u0438\u043b\u043e\u043c\u0435\u0442\u0440\u0430\u0436 \u043f\u0435\u0440\u0435\u0433\u043e\u043d\u0430 ", order=90, propertiesLayout="0:1#cell 1 5#cell 0 5")})
    public BigDecimal getMealage1() {
        return this.mealage1;
    }

    public void setMealage1(BigDecimal mealage1) {
        this.mealage1 = mealage1;
    }

    @ListField(fields={@Field(title="\u041f\u0435\u0440\u0435\u0433\u043e\u043d \u0441\u043e\u0448\u0435\u0434\u0448\u0435\u0433\u043e \u0422\u0421", order=45, viewer={BooleanFRCViewer.class}, propertiesLayout="0:2/fill/\u041f\u0435\u0440\u0435\u0433\u043e\u043d \u0441\u043e\u0448\u0435\u0434\u0448\u0435\u0433\u043e \u0422\u0421/cell 0 7, spanx 4#cell 1 0#cell 0 0")})
    public Integer getRun2() {
        return this.run2;
    }

    public void setRun2(Integer run2) {
        this.run2 = run2;
    }

    @ListField(fields={@Field(title="\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 1", order=120, readOnly=true, content=TransportStop.class, viewer={TransportStopOfRouteViewer.class}, propertiesLayout="0:2/fill/\u041f\u0435\u0440\u0435\u0433\u043e\u043d \u0434\u043b\u044f \u0441\u043e\u0448\u0435\u0434\u0448\u0435\u0433\u043e \u0422\u0421/cell 0 7, spanx 4#cell 1 1#cell 0 1", changeAction={ChangeTransportStop.class})})
    public TransportStop getStop21() {
        return this.baseStation;
    }

    public void setStop21(TransportStop baseStation) {
        this.baseStation = baseStation;
    }

    @ListField(fields={@Field(title="\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 2", order=130, content=TransportStop.class, viewer={TransportStopDirectoryViewer.class}, propertiesLayout="0:2#cell 1 2#cell 0 2", changeAction={ChangeTransportStop.class})})
    public TransportStop getStop22() {
        return this.stop2;
    }

    public void setStop22(TransportStop stop2) {
        this.stop2 = stop2;
    }

    @ListField(fields={@Field(title="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u0433\u043e\u043d\u0430", order=140, propertiesLayout="0:2#cell 1 3#cell 0 3")})
    public String getName2() {
        return this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    @ListField(fields={@Field(title="\u0412\u0440\u0435\u043c\u044f \u043f\u0435\u0440\u0435\u0433\u043e\u043d\u0430 \u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445", order=150, propertiesLayout="0:2#cell 1 4#cell 0 4")})
    public Integer getDuration2() {
        return this.duration2;
    }

    public void setDuration2(Integer duration2) {
        this.duration2 = duration2;
    }

    @ListField(fields={@Field(title="\u041a\u0438\u043b\u043e\u043c\u0435\u0442\u0440\u0430\u0436 \u043f\u0435\u0440\u0435\u0433\u043e\u043d\u0430 ", order=160, propertiesLayout="0:2#cell 1 5#cell 0 5")})
    public BigDecimal getMealage2() {
        return this.mealage2;
    }

    public void setMealage2(BigDecimal mealage2) {
        this.mealage2 = mealage2;
    }

    public Long getWaybillId() {
        return this.waybillId;
    }

    public Long getWarrantId() {
        return this.warrantId;
    }

    public Long getRouteId() {
        return this.wbrt == null ? null : this.wbrt.getRouteId();
    }

    public Long getScheduleTypeId() {
        return this.wbrt == null ? null : this.wbrt.getScheduleTypeId();
    }

    public Long getShiftTypeId() {
        return this.wbrt == null ? null : this.wbrt.getShiftTypeId();
    }

    public WaybillRealTimeExt getWaybillRealTimeExt() {
        return this.wbrt;
    }

    public Long getPrimaryGroupId() {
        return this.primaryGroupId;
    }
}

