/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.waybill.currentday.common;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.HelpUtils;
import ru.infor.client.soap.SOAPException;
import ru.infor.client.soap.proxy.core.UserWSProxy;
import ru.infor.client.soap.proxy.core.UsersGroupWSProxy;
import ru.infor.client.soap.proxy.vms.CheckPointTypeWSProxy;
import ru.infor.client.soap.proxy.vms.CheckPointWSProxy;
import ru.infor.client.soap.proxy.vms.JournalDispatcherYOTKWSProxy;
import ru.infor.client.soap.proxy.vms.Route2CheckPointLinkWSProxy;
import ru.infor.client.soap.proxy.vms.RouteScheduleRunWSProxy;
import ru.infor.client.soap.proxy.vms.RouteScheduleWSProxy;
import ru.infor.client.soap.proxy.vms.RouteTypeWSProxy;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.client.soap.proxy.vms.RunScheduleTypeWSProxy;
import ru.infor.client.soap.proxy.vms.ShiftTypeWSProxy;
import ru.infor.client.soap.proxy.vms.TransportStopWSProxy;
import ru.infor.client.soap.proxy.vms.WarrantWSProxy;
import ru.infor.client.soap.proxy.vms.WayBillWSProxy;
import ru.infor.client.soap.proxy.vms.WaybillRunWSProxy;
import ru.infor.client.soap.proxy.vms.WaybillStatisticWSProxy;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.core.DirectoriesSearchCriteria;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.core.entities.User;
import ru.infor.ws.objects.core.entities.UsersGroup;
import ru.infor.ws.objects.vms.CheckPointSearchCriteria;
import ru.infor.ws.objects.vms.ReplaceWaybillTransport;
import ru.infor.ws.objects.vms.Route2CheckPointLinkSearchCriteria;
import ru.infor.ws.objects.vms.RouteScheduleSearchCriteria;
import ru.infor.ws.objects.vms.RouteSearchCriteria;
import ru.infor.ws.objects.vms.WayBillSearchCriteria;
import ru.infor.ws.objects.vms.WaybillAction;
import ru.infor.ws.objects.vms.WaybillRunSearchCriteria;
import ru.infor.ws.objects.vms.WaybillStatisticSearchCriteria;
import ru.infor.ws.objects.vms.entities.CheckPoint;
import ru.infor.ws.objects.vms.entities.CheckPointType;
import ru.infor.ws.objects.vms.entities.Driver;
import ru.infor.ws.objects.vms.entities.JournalDispatcherYOTK;
import ru.infor.ws.objects.vms.entities.ReplaceReason;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.Route2CheckPointLink;
import ru.infor.ws.objects.vms.entities.RouteSchedule;
import ru.infor.ws.objects.vms.entities.RouteScheduleRun;
import ru.infor.ws.objects.vms.entities.RouteType;
import ru.infor.ws.objects.vms.entities.RunScheduleType;
import ru.infor.ws.objects.vms.entities.ShiftType;
import ru.infor.ws.objects.vms.entities.Transport;
import ru.infor.ws.objects.vms.entities.TransportStop;
import ru.infor.ws.objects.vms.entities.Warrant;
import ru.infor.ws.objects.vms.entities.WayBill;
import ru.infor.ws.objects.vms.entities.WaybillRun;
import ru.infor.ws.objects.vms.entities.WaybillStatistic;
import ru.infor.ws.objects.vms.entities.ext.Route2CheckPointLinkExt;
import ru.infor.ws.objects.vms.entities.ext.RouteExt;
import ru.infor.ws.objects.vms.entities.ext.RouteScheduleRunExt;
import ru.infor.ws.objects.vms.entities.ext.WayBillExt;
import ru.infor.ws.objects.vms.entities.ext.WaybillRunExt;

public class WaybillCommonActions {
    static DateFormat df_date = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    static DateFormat df_date_only = new SimpleDateFormat("dd.MM.yyyy");
    static DateFormat df_time_only = new SimpleDateFormat("HH:mm");
    WayBillWSProxy proxy = (WayBillWSProxy)CurrentProxyFactory.getProxy(WayBill.class);
    RouteWSProxy routeProxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);
    RunScheduleTypeWSProxy runScheduleTypeProxy = (RunScheduleTypeWSProxy)CurrentProxyFactory.getProxy(RunScheduleType.class);
    ShiftTypeWSProxy shiftTypeProxy = (ShiftTypeWSProxy)CurrentProxyFactory.getProxy(ShiftType.class);
    RouteScheduleRunWSProxy routeScheduleRunProxy = (RouteScheduleRunWSProxy)CurrentProxyFactory.getProxy(RouteScheduleRun.class);
    RouteScheduleWSProxy routeScheduleProxy = (RouteScheduleWSProxy)CurrentProxyFactory.getProxy(RouteSchedule.class);
    Route2CheckPointLinkWSProxy route2CheckPointLinkProxy = (Route2CheckPointLinkWSProxy)CurrentProxyFactory.getProxy(Route2CheckPointLink.class);
    CheckPointWSProxy checkPointProxy = (CheckPointWSProxy)CurrentProxyFactory.getProxy(CheckPoint.class);
    RouteTypeWSProxy routeTypeWSProxy = (RouteTypeWSProxy)CurrentProxyFactory.getProxy(RouteType.class);
    JournalDispatcherYOTKWSProxy JDYproxy = (JournalDispatcherYOTKWSProxy)CurrentProxyFactory.getProxy(JournalDispatcherYOTK.class);
    WarrantWSProxy warrantProxy = (WarrantWSProxy)CurrentProxyFactory.getProxy(Warrant.class);
    WaybillRunWSProxy waybillRunProxy = (WaybillRunWSProxy)CurrentProxyFactory.getProxy(WaybillRun.class);
    CheckPointTypeWSProxy checkPointTypeWSProxy = (CheckPointTypeWSProxy)CurrentProxyFactory.getProxy(CheckPointType.class);
    TransportStopWSProxy transportStopProxy = (TransportStopWSProxy)CurrentProxyFactory.getProxy(TransportStop.class);
    UsersGroupWSProxy usersGroupProxy = (UsersGroupWSProxy)CurrentProxyFactory.getProxy(UsersGroup.class);
    UserWSProxy userWSProxy = (UserWSProxy)CurrentProxyFactory.getProxy(User.class);
    Logger logger = Logger.getLogger(WaybillCommonActions.class);
    private ShiftType firstShiftType;
    private ShiftType longShiftType;
    private ShiftType secondShiftType;
    public static int TwoFlight = 0;
    public static int Flight = 1;
    public static int RoundFlight = 2;
    public static int PartTimeFlight = 3;
    public static int Stage = 4;
    public static int Empty = 5;
    private InvocationContext context = null;
    static int NO_ERROR = 0;
    static int WAYBILL_ID_IS_NULL = 1;
    static int TRANSPORT_IS_NULL = 2;
    static int DATE_IS_NULL = 3;
    static int REASON_IS_NULL = 4;
    static int BASE_STATION_IS_NULL = 5;
    static int ROUTE_ID_IS_NULL = 6;
    static int SCHEDULE_TYPE_ID_IS_NULL = 7;
    static int SHIFT_TYPE_ID_IS_NULL = 8;
    static int INTERNAL_ERROR = 9;
    static int CONTEXT_IS_NOT_INITIALIZED = 10;
    static int GARAGE_NUM_IS_NULL = 11;
    static int TAB_NUM_IS_NULL = 12;
    static int DRIVER_IS_NULL = 13;
    static int RUN_AT_IS_NULL = 14;
    static int RETURN_AT_IS_NULL = 15;
    static int WAYBILL_OR_WARRANT_NOT_FOUND = 16;
    static int TRANSPORT_STOP_BEGIN_IS_NULL = 17;
    static int TRANSPORT_STOP_END_IS_NULL = 18;
    static int LENGTH_IS_NULL = 19;
    static int SHIFT_TYPE_IS_NULL = 20;
    static int RUN_SCHEDULE_TYPE_IS_NULL = 21;
    static int ROUTE_SCHEDULE_IS_NULL = 22;
    static int WAYBILL_IS_NULL = 23;
    static int ROUTE_IS_NULL = 24;
    Integer SizeRecordInJournalDispatcherYOTK = 240;

    public WaybillCommonActions(InvocationContext context) {
        this.context = context;
        this.firstShiftType = this.getShiftType("1", "1", "1");
        this.longShiftType = this.getShiftType("\u0414", "\u0414", "\u0414");
        this.secondShiftType = this.getShiftType("2", "2", "2");
    }

    public ShiftType getFirstShiftType() {
        return this.firstShiftType;
    }

    public ShiftType getLongShiftType() {
        return this.longShiftType;
    }

    public ShiftType getSecondShiftType() {
        return this.secondShiftType;
    }

    public String DescriptionErrorOnCode(Integer code) {
        String res = "UNCNOWN ERROR CODE";
        if (code == NO_ERROR) {
            res = "NO ERROR";
        }
        if (code == WAYBILL_ID_IS_NULL) {
            res = "WAYBILL ID IS NULL";
        }
        if (code == TRANSPORT_IS_NULL) {
            res = "TRANSPORT IS NULL";
        }
        if (code == DATE_IS_NULL) {
            res = "DATE IS NULL";
        }
        if (code == REASON_IS_NULL) {
            res = "REASON IS NULL";
        }
        if (code == BASE_STATION_IS_NULL) {
            res = "BASE STATION IS NULL";
        }
        if (code == ROUTE_ID_IS_NULL) {
            res = "ROUTE ID IS NULL";
        }
        if (code == SCHEDULE_TYPE_ID_IS_NULL) {
            res = "SCHEDULE TYPE ID IS NULL";
        }
        if (code == SHIFT_TYPE_ID_IS_NULL) {
            res = "SHIFT TYPE ID IS NULL";
        }
        if (code == INTERNAL_ERROR) {
            res = "INTERNAL ERROR";
        }
        if (code == CONTEXT_IS_NOT_INITIALIZED) {
            res = "CONTEXT IS NOT INITIALIZED";
        }
        if (code == GARAGE_NUM_IS_NULL) {
            res = "GARAGE NUM IS NULL";
        }
        if (code == TAB_NUM_IS_NULL) {
            res = "TAB NUM IS NULL";
        }
        if (code == DRIVER_IS_NULL) {
            res = "DRIVER IS NULL";
        }
        if (code == RUN_AT_IS_NULL) {
            res = "RUN_AT_IS_NULL";
        }
        if (code == RETURN_AT_IS_NULL) {
            res = "RETURN AT IS NULL";
        }
        if (code == WAYBILL_OR_WARRANT_NOT_FOUND) {
            res = "WAYBILL OR WARRANT NOT FOUND";
        }
        if (code == TRANSPORT_STOP_BEGIN_IS_NULL) {
            res = "TRANSPORT STOP BEGIN IS NULL";
        }
        if (code == TRANSPORT_STOP_END_IS_NULL) {
            res = "TRANSPORT STOP END IS NULL";
        }
        if (code == LENGTH_IS_NULL) {
            res = "LENGTH IS NULL";
        }
        if (code == SHIFT_TYPE_IS_NULL) {
            res = "SHIFT TYPE IS NULL";
        }
        if (code == RUN_SCHEDULE_TYPE_IS_NULL) {
            res = "RUN SCHEDULE TYPE IS NULL";
        }
        if (code == ROUTE_SCHEDULE_IS_NULL) {
            res = "ROUTE SCHEDULE IS NULL";
        }
        if (code == WAYBILL_IS_NULL) {
            res = "WAYBILL IS NULL";
        }
        if (code == ROUTE_IS_NULL) {
            res = "ROUTE IS NULL";
        }
        return res;
    }

    public void addRecordInJournalDispatcherYOTK(Date date, String routeNum, RunScheduleType rsType, ShiftType shiftType, String garnumS, String tabnumS, String garnumD, String tabnumD, String cause, UsersGroup group, Integer view, String desc) {
        JournalDispatcherYOTK jdy = new JournalDispatcherYOTK();
        jdy.setCause(cause);
        jdy.setTabnumD(tabnumD);
        jdy.setTabnumS(tabnumS);
        jdy.setGarnumD(garnumD);
        jdy.setGarnumS(garnumS);
        jdy.setDate(date);
        jdy.setRouteNum(routeNum);
        jdy.setRsType(rsType);
        jdy.setShiftType(shiftType);
        jdy.setView(view);
        jdy.setGroup(group);
        String record = desc;
        if (record != null && record.length() > 0) {
            int s = 0;
            int e = this.SizeRecordInJournalDispatcherYOTK;
            while (s < record.length()) {
                String str = s == 0 ? "" : "\u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u0435: ";
                if (s + this.SizeRecordInJournalDispatcherYOTK < record.length()) {
                    e = s + this.SizeRecordInJournalDispatcherYOTK;
                    if ((e = record.lastIndexOf(" ", e)) == -1 || e < s) {
                        e = s + this.SizeRecordInJournalDispatcherYOTK;
                    }
                    str = String.valueOf(str) + record.substring(s, e) + "...";
                } else {
                    e = record.length();
                    str = String.valueOf(str) + record.substring(s, e);
                }
                s = e + 1;
                jdy.setDescription(str);
                this.JDYproxy.save(this.context, jdy);
            }
        }
    }

    public WayBill getWaybillFromTransportDateTime(Long transportId, Date diteTime) {
        WayBill res = null;
        if (transportId != null) {
            Long[] wbId = null;
            HashMap<Long, WayBill> map = new HashMap<Long, WayBill>();
            WayBillSearchCriteria wbSc = new WayBillSearchCriteria();
            wbSc.setWaybillDateFrom(CommonSearchCriteria.beginOfDay((Date)diteTime));
            wbSc.setWaybillDateTill(CommonSearchCriteria.endOfDay((Date)diteTime));
            wbSc.setTransportIdList(new Long[]{transportId});
            WayBillWSProxy.SearchResultListWayBill srList = this.proxy.getList(InitializedVariable.context, wbSc);
            if (srList != null && !srList.isEmpty()) {
                if (srList.getObjList().length == 1) {
                    return (WayBill)srList.getObjList()[0];
                }
                wbId = new Long[srList.getObjList().length];
                int i = 0;
                while (i < srList.getObjList().length) {
                    wbId[i] = ((WayBill)srList.getObjList()[i]).getId();
                    map.put(((WayBill)srList.getObjList()[i]).getId(), (WayBill)srList.getObjList()[i]);
                    ++i;
                }
            }
            if (wbId != null) {
                WaybillRunSearchCriteria wbrSc = new WaybillRunSearchCriteria();
                wbrSc.setActualFlagList(new Integer[]{0});
                wbrSc.setWaybillIdList(wbId);
                srList = this.waybillRunProxy.getList(InitializedVariable.context, wbrSc);
                if (srList != null && !srList.isEmpty()) {
                    Calendar st = Calendar.getInstance();
                    st.setTime(diteTime);
                    st.add(13, 1);
                    Calendar et = Calendar.getInstance();
                    et.setTime(diteTime);
                    et.add(13, -1);
                    int i = 0;
                    while (i < srList.getObjList().length) {
                        if (((WaybillRun)srList.getObjList()[i]).getRun() != null && ((WaybillRun)srList.getObjList()[i]).getRun().getRunAt() != null && ((WaybillRun)srList.getObjList()[i]).getRun().getReturnAt() != null && HelpUtils.beforeTime(((WaybillRun)srList.getObjList()[i]).getRun().getRunAt(), st.getTime()) && HelpUtils.afterTime(((WaybillRun)srList.getObjList()[i]).getRun().getReturnAt(), et.getTime())) {
                            res = (WayBill)map.get(((WaybillRun)srList.getObjList()[i]).getWaybill_id());
                        }
                        ++i;
                    }
                }
            }
        }
        return res;
    }

    public CheckPointType getCheckPointType(String code, String defaultCode, String defaultDescription) {
        CheckPointType cpt = null;
        DirectoriesSearchCriteria rtSc = new DirectoriesSearchCriteria();
        rtSc.setDescription("*" + code + "*");
        CheckPointTypeWSProxy.SearchResultListCheckPointType rList = this.checkPointTypeWSProxy.getList(this.context, rtSc);
        if (rList != null && rList.getObjList() != null && rList.getObjList().length > 0) {
            cpt = (CheckPointType)rList.getObjList()[0];
        } else {
            cpt = new CheckPointType();
            cpt.setCode(defaultCode);
            cpt.setDescription(defaultDescription);
            cpt = this.checkPointTypeWSProxy.save(this.context, cpt);
        }
        return cpt;
    }

    public TransportStop getTransportStop(String code, String defaultCode, String defaultDescription) {
        TransportStop ts = null;
        DirectoriesSearchCriteria tsSc = new DirectoriesSearchCriteria();
        tsSc.setDescription("*" + code + "*");
        TransportStopWSProxy.SearchResultListTransportStop rList = this.transportStopProxy.getList(this.context, tsSc);
        if (rList != null && rList.getObjList() != null && rList.getObjList().length > 0) {
            ts = (TransportStop)rList.getObjList()[0];
        } else {
            ts = new TransportStop();
            ts.setCode(defaultCode);
            ts.setDescription(defaultDescription);
            ts = this.transportStopProxy.save(this.context, ts);
        }
        return ts;
    }

    public ShiftType getShiftType(String code, String defaultCode, String defaultDescription) {
        DirectoriesSearchCriteria directorySc = new DirectoriesSearchCriteria();
        ShiftType shiftType = null;
        directorySc.setCode("*" + code + "*");
        ShiftTypeWSProxy.SearchResultListShiftType rList = this.shiftTypeProxy.getList(this.context, directorySc);
        if (rList != null && rList.getObjList() != null && rList.getObjList().length > 0) {
            shiftType = (ShiftType)rList.getObjList()[0];
        } else {
            shiftType = new ShiftType();
            shiftType.setCode(defaultCode);
            shiftType.setDescription(defaultDescription);
            shiftType = this.shiftTypeProxy.save(this.context, shiftType);
        }
        return shiftType;
    }

    public RunScheduleType getRsType(String code, String defaultCode, String defaultDescription) {
        DirectoriesSearchCriteria directorySc = new DirectoriesSearchCriteria();
        RunScheduleType rsType = null;
        directorySc.setCode("*" + code + "*");
        RunScheduleTypeWSProxy.SearchResultListRunScheduleType rList = this.runScheduleTypeProxy.getList(this.context, directorySc);
        if (rList != null && rList.getObjList() != null && rList.getObjList().length > 0) {
            rsType = (RunScheduleType)rList.getObjList()[0];
        } else {
            rsType = new RunScheduleType();
            rsType.setCode(defaultCode);
            rsType.setDescription(defaultDescription);
            rsType = this.runScheduleTypeProxy.save(this.context, rsType);
        }
        return rsType;
    }

    public CheckPoint getCheckPoint(String name, String defaultName) {
        CheckPoint checkPoint = null;
        CheckPointSearchCriteria sc = new CheckPointSearchCriteria();
        sc.setName("*" + name + "*");
        CheckPointWSProxy.SearchResultListCheckPoint rList = this.checkPointProxy.getList(this.context, sc);
        if (rList != null && rList.getObjList() != null && rList.getObjList().length > 0) {
            checkPoint = (CheckPoint)rList.getObjList()[0];
        } else {
            checkPoint = new CheckPoint();
            checkPoint.setName(defaultName);
            Long code = this.checkPointProxy.getNextCheckPointCode(this.context);
            checkPoint.setCode(code.toString());
            checkPoint.setLat(new Double(0.0));
            checkPoint.setLon(new Double(0.0));
            checkPoint = this.checkPointProxy.save(this.context, checkPoint);
        }
        return checkPoint;
    }

    public Route getRoute(String name, String defaultName, String defaultNum) {
        RouteSearchCriteria routeSc = new RouteSearchCriteria();
        routeSc.setName("*" + name + "*");
        Route route = null;
        RouteWSProxy.SearchResultListRoute rList = this.routeProxy.getList(this.context, routeSc);
        if (rList != null && rList.getObjList() != null && rList.getObjList().length > 0) {
            route = (Route)rList.getObjList()[0];
        } else {
            route = new Route();
            route.setName(defaultName);
            route.setNum(defaultNum);
            route = this.routeProxy.save(this.context, route);
        }
        return route;
    }

    public RouteExt getRouteWithTransportStop(String name, String defaultName, String defaultNum, TransportStop start, TransportStop end, Integer minute, Double length) {
        RouteExt route = null;
        if (start != null && end != null) {
            CheckPoint cpStart = this.getCheckPoint(start.getDescription(), start.getDescription());
            CheckPoint cpEnd = this.getCheckPoint(end.getDescription(), end.getDescription());
            CheckPointType cptStart = this.getCheckPointType("\u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f", "\u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f", "\u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f");
            CheckPointType cptEnd = this.getCheckPointType("\u043a\u043e\u043d\u0435\u0447\u043d\u0430\u044f", "\u043a\u043e\u043d\u0435\u0447\u043d\u0430\u044f", "\u043a\u043e\u043d\u0435\u0447\u043d\u0430\u044f");
            if (cpStart != null && cpEnd != null) {
                RouteSearchCriteria routeSc = new RouteSearchCriteria();
                routeSc.setName("*" + name + "*");
                RouteWSProxy.SearchResultListRoute srList = this.routeProxy.getList(this.context, routeSc);
                if (srList != null && srList.getObjList() != null && srList.getObjList().length > 0) {
                    route = (RouteExt)((Object)srList.getObjList()[0]);
                    route = (RouteExt)this.routeProxy.getCurrentObject(this.context, route.getId());
                    Route2CheckPointLinkSearchCriteria r2cplSc = new Route2CheckPointLinkSearchCriteria();
                    r2cplSc.setRouteIdList(new Long[]{route.getId()});
                    r2cplSc.setDirection(Integer.valueOf(0));
                    SortObject so = new SortObject();
                    so.setDirection(SortObject.DIRECTION_ASC);
                    so.setName("maxFactInSec");
                    r2cplSc.setListSort(new SortObject[]{so});
                    srList = this.route2CheckPointLinkProxy.getList(this.context, r2cplSc);
                    boolean routeExists = false;
                    boolean cpEq = cpStart.equals((Object)cpEnd);
                    Double sumLen = null;
                    int sumMin = 0;
                    long t1 = 0L;
                    long t2 = 0L;
                    if (srList != null && !srList.isEmpty()) {
                        int i = 0;
                        while (i < srList.getObjList().length) {
                            if (cpStart.equals((Object)((Route2CheckPointLink)srList.getObjList()[i]).getPoint()) && (!cpEq || cpEq && cptStart.equals((Object)((Route2CheckPointLink)srList.getObjList()[i]).getType()))) {
                                sumLen = new Double(0.0);
                                t1 = ((Route2CheckPointLinkExt)((Object)srList.getObjList()[i])).getOffsetKTFromRoute().getTime();
                            }
                            if (cpEnd.equals((Object)((Route2CheckPointLink)srList.getObjList()[i]).getPoint()) && (!cpEq || cpEq && cptEnd.equals((Object)((Route2CheckPointLink)srList.getObjList()[i]).getType())) && (sumLen == null || sumLen != null && Math.abs(sumLen - length) < 0.05) && (sumMin = (int)(((t2 = ((Route2CheckPointLinkExt)((Object)srList.getObjList()[i])).getOffsetKTFromRoute().getTime()) - t1) / 60000L)) == minute) {
                                routeExists = true;
                            }
                            if (sumLen != null) {
                                sumLen = sumLen + ((Route2CheckPointLink)srList.getObjList()[i]).getDistanceToNext();
                            }
                            ++i;
                        }
                    }
                    if (!routeExists) {
                        route = null;
                    }
                }
                if (route == null) {
                    route = new RouteExt();
                    route.setName(defaultName);
                    route.setNum(defaultNum);
                    route.setDistanceSub(new BigDecimal(length));
                    route.setRouteDurInMinSub(minute);
                    route.setFactRate(75L);
                    route.setRegRate(50L);
                    route.setMaxFactInSecDef(1200);
                    route.setMinFactInSecDef(1200);
                    route.setMaxOffsetInSecDef(180);
                    route.setMinOffsetInSecDef(180);
                    route.setRouteType(this.getRouteType("\u043f\u0435\u0440\u0435\u0433\u043e\u043d", "\u043f\u0435\u0440\u0435\u0433\u043e\u043d", "\u043f\u0435\u0440\u0435\u0433\u043e\u043d"));
                    route = (RouteExt)this.routeProxy.save(this.context, (Route)route);
                    Route2CheckPointLinkExt r2cpl = new Route2CheckPointLinkExt();
                    r2cpl.setRoute(route);
                    r2cpl.setPoint(cpStart);
                    r2cpl.setStop(start);
                    r2cpl.setDistanceToNext(length);
                    int time = 0;
                    if (r2cpl.getRoute().getMinOffsetInSecDef() != null && r2cpl.getMinOffsetInSec() == null) {
                        r2cpl.setMinOffsetInSec(time - r2cpl.getRoute().getMinOffsetInSecDef());
                    }
                    if (r2cpl.getRoute().getMaxOffsetInSecDef() != null && r2cpl.getMaxOffsetInSec() == null) {
                        r2cpl.setMaxOffsetInSec(time + r2cpl.getRoute().getMaxOffsetInSecDef());
                    }
                    if (r2cpl.getRoute().getMinFactInSecDef() != null && r2cpl.getMinFactInSec() == null) {
                        r2cpl.setMinFactInSec(time - r2cpl.getRoute().getMinFactInSecDef());
                    }
                    if (r2cpl.getRoute().getMaxFactInSecDef() != null && r2cpl.getMaxFactInSec() == null) {
                        r2cpl.setMaxFactInSec(time + r2cpl.getRoute().getMaxFactInSecDef());
                    }
                    r2cpl.setDirection(0);
                    r2cpl.setPointIndex(0);
                    r2cpl.setType(cptStart);
                    this.route2CheckPointLinkProxy.save(this.context, (Route2CheckPointLink)r2cpl);
                    r2cpl = new Route2CheckPointLinkExt();
                    r2cpl.setRoute(route);
                    r2cpl.setPoint(cpEnd);
                    r2cpl.setStop(end);
                    r2cpl.setDistanceToNext(0.0);
                    time = minute * 60;
                    if (r2cpl.getRoute().getMinOffsetInSecDef() != null && r2cpl.getMinOffsetInSec() == null) {
                        r2cpl.setMinOffsetInSec(time - r2cpl.getRoute().getMinOffsetInSecDef());
                    }
                    if (r2cpl.getRoute().getMaxOffsetInSecDef() != null && r2cpl.getMaxOffsetInSec() == null) {
                        r2cpl.setMaxOffsetInSec(time + r2cpl.getRoute().getMaxOffsetInSecDef());
                    }
                    if (r2cpl.getRoute().getMinFactInSecDef() != null && r2cpl.getMinFactInSec() == null) {
                        r2cpl.setMinFactInSec(time - r2cpl.getRoute().getMinFactInSecDef());
                    }
                    if (r2cpl.getRoute().getMaxFactInSecDef() != null && r2cpl.getMaxFactInSec() == null) {
                        r2cpl.setMaxFactInSec(time + r2cpl.getRoute().getMaxFactInSecDef());
                    }
                    r2cpl.setDirection(0);
                    r2cpl.setPointIndex(1);
                    r2cpl.setType(cptEnd);
                    this.route2CheckPointLinkProxy.save(this.context, (Route2CheckPointLink)r2cpl);
                }
            }
        } else {
            route = (RouteExt)this.getRoute(name, defaultName, defaultNum);
        }
        return route;
    }

    public RouteSchedule getRouteScheduleWithoutRunOnDay(Long id, Route defaultRoute, Date beginDate, Date endDate, TransportStop firstStop, TransportStop lastStop) {
        RouteScheduleSearchCriteria rsSc = new RouteScheduleSearchCriteria();
        RouteSchedule rs = null;
        rsSc.setRouteIdList(new Long[]{id});
        RouteScheduleWSProxy.SearchResultListRouteSchedule rList = this.routeScheduleProxy.getList(this.context, rsSc);
        if (rList != null && rList.getObjList() != null && rList.getObjList().length > 0) {
            rs = (RouteSchedule)rList.getObjList()[0];
        } else {
            rs = new RouteSchedule();
            rs.setRoute(defaultRoute);
            rs.setBeginDate(beginDate);
            rs.setEndDate(endDate);
            rs.setFirstStop(firstStop);
            rs.setLastStop(lastStop);
            rs.setRunOnSunday(Integer.valueOf(0));
            rs.setRunOnMonday(Integer.valueOf(0));
            rs.setRunOnTuesday(Integer.valueOf(0));
            rs.setRunOnWednesday(Integer.valueOf(0));
            rs.setRunOnThursday(Integer.valueOf(0));
            rs.setRunOnFriday(Integer.valueOf(0));
            rs.setRunOnSaturday(Integer.valueOf(0));
            rs = this.routeScheduleProxy.save(this.context, rs);
        }
        return rs;
    }

    public RouteScheduleRun newRouteScheduleRunLiteIsDeleted(RouteSchedule rs, Route route, Date runAt, Date returnAt, TransportStop firstStop, TransportStop lastStop, Integer idleTimeInMin, Integer runType, Route ownedRoute) {
        return this.newRouteScheduleRunLiteIsDeleted(rs, route, runAt, returnAt, firstStop, lastStop, idleTimeInMin, runType, null, null, ownedRoute);
    }

    public RouteScheduleRun newRouteScheduleRunLiteIsDeleted(RouteSchedule rs, Route route, Date runAt, Date returnAt, TransportStop firstStop, TransportStop lastStop, Integer idleTimeInMin, Integer runType, RunScheduleType rsType, ShiftType shiftType, Route ownedRoute) {
        RouteScheduleRun rsr = new RouteScheduleRun();
        rsr.setSchedule(rs);
        rsr.setRunAt(HelpUtils.getRouteScheduleRunTime(runAt));
        rsr.setReturnAt(HelpUtils.getRouteScheduleRunTime(returnAt));
        rsr.setRunOnSunday(Integer.valueOf(1));
        rsr.setRunOnMonday(Integer.valueOf(1));
        rsr.setRunOnTuesday(Integer.valueOf(1));
        rsr.setRunOnWednesday(Integer.valueOf(1));
        rsr.setRunOnThursday(Integer.valueOf(1));
        rsr.setRunOnFriday(Integer.valueOf(1));
        rsr.setRunOnSaturday(Integer.valueOf(1));
        if (shiftType == null) {
            rsr.setShiftType(this.getShiftType("*1*", "1", "1"));
        } else {
            rsr.setShiftType(shiftType);
        }
        if (rsType == null) {
            rsr.setRsType(this.getRsType("*1*", "1", "1"));
        } else {
            rsr.setRsType(rsType);
        }
        rsr.setRoute(route);
        rsr.setOwnedRoute(ownedRoute);
        rsr.setFirstStop(firstStop);
        rsr.setLastStop(lastStop);
        rsr.setIsDeleted(1);
        rsr.setId(null);
        rsr.setIdleTimeInMin(idleTimeInMin);
        rsr.setRunType(runType);
        rsr = this.routeScheduleRunProxy.save(this.context, rsr);
        return rsr;
    }

    public RouteType getRouteType(String code, String defaultCode, String defaultDescription) {
        RouteType rt = null;
        DirectoriesSearchCriteria rtSc = new DirectoriesSearchCriteria();
        rtSc.setDescription("*" + code + "*");
        RouteTypeWSProxy.SearchResultListRouteType rList = this.routeTypeWSProxy.getList(this.context, rtSc);
        if (rList != null && rList.getObjList() != null && rList.getObjList().length > 0) {
            rt = (RouteType)rList.getObjList()[0];
        } else {
            rt = new RouteType();
            rt.setCode(defaultCode);
            rt.setDescription(defaultDescription);
            rt = this.routeTypeWSProxy.save(this.context, rt);
        }
        return rt;
    }

    private Route getRoute(String name, TransportStop start, TransportStop end, BigDecimal mealage, Integer duration) {
        Route route = null;
        RouteSearchCriteria routeSc = new RouteSearchCriteria();
        routeSc.setName(name);
        int createNewRoute = -1;
        RouteWSProxy.SearchResultListRoute rList = this.routeProxy.getList(this.context, routeSc);
        if (rList != null && rList.getObjList() != null && rList.getObjList().length > 0) {
            int i = 0;
            while (i < rList.getObjList().length) {
                if (mealage != null && ((Route)rList.getObjList()[i]).getDistanceSub() != null && mealage.compareTo(((Route)rList.getObjList()[i]).getDistanceSub()) == 0 && duration != null && duration.equals(((Route)rList.getObjList()[i]).getRouteDurInMinSub())) {
                    createNewRoute = i;
                }
                ++i;
            }
        }
        if (createNewRoute > -1) {
            route = (Route)rList.getObjList()[createNewRoute];
        } else {
            route = new Route();
            route.setName(name);
            Integer num = new Integer(0);
            routeSc = new RouteSearchCriteria();
            routeSc.setCount(new Integer(1));
            SortObject so = new SortObject();
            so.setDirection(SortObject.DIRECTION_DESC);
            so.setName("oldID");
            routeSc.setListSort(new SortObject[]{so});
            RouteWSProxy.SearchResultListRoute l = this.routeProxy.getList(this.context, routeSc);
            if (l != null && l.getObjList() != null && l.getObjList().length > 0) {
                num = ((Route)l.getObjList()[0]).getOldID() + 1;
            }
            route.setNum(num.toString());
            route.setOldID(num);
            RouteType rt = this.getRouteType("*\u043f\u0435\u0440\u0435\u0433\u043e\u043d*", "\u043f\u0435\u0440\u0435\u0433\u043e\u043d", "\u043f\u0435\u0440\u0435\u0433\u043e\u043d");
            route.setRouteType(rt);
            route.setDistanceSub(mealage);
            route.setRouteDurInMinSub(duration);
            route = this.routeProxy.save(this.context, route);
        }
        return route;
    }

    private RouteSchedule getRouteSchedule(Date date, Long RouteId) {
        RouteSchedule res = null;
        RouteScheduleSearchCriteria rsSc = new RouteScheduleSearchCriteria();
        rsSc.setActiveOnDate(date);
        rsSc.setRouteIdList(new Long[]{RouteId});
        RouteScheduleWSProxy.SearchResultListRouteSchedule rList = this.routeScheduleProxy.getList(this.context, rsSc);
        if (rList != null && rList.getObjList() != null && rList.getObjList().length > 0) {
            res = (RouteSchedule)rList.getObjList()[0];
        }
        return res;
    }

    public WayBillExt fillWaybillExt(Long waybill_id) {
        WayBill waybill = (WayBill)this.proxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, waybill_id);
        return this.fillWaybillExt(waybill);
    }

    public WayBillExt fillWaybillExt(WayBill waybill) {
        int i;
        WaybillRunWSProxy.SearchResultListWaybillRun srList;
        WayBillExt wayillExt = (WayBillExt)waybill;
        ArrayList<WaybillRunExt> runShift1List = null;
        ArrayList<WaybillRunExt> runShift2List = null;
        WaybillStatisticWSProxy wbsProxy = (WaybillStatisticWSProxy)CurrentProxyFactory.getProxy(WaybillStatistic.class);
        WaybillStatisticSearchCriteria wbsSc = new WaybillStatisticSearchCriteria();
        WaybillStatistic wbs1 = null;
        WaybillStatistic wbs2 = null;
        if (wayillExt != null && wayillExt.getWarrant1() != null && wayillExt.getWarrant1().getId() != null && this.firstShiftType != null && this.firstShiftType.getId() != null && this.longShiftType != null && this.longShiftType.getId() != null) {
            runShift1List = new ArrayList<WaybillRunExt>();
            WaybillRunSearchCriteria wayBillRunSc1 = new WaybillRunSearchCriteria();
            wayBillRunSc1.setShiftTypeIdList(new Long[]{this.firstShiftType.getId(), this.longShiftType.getId()});
            wayBillRunSc1.setWaybillIdList(new Long[]{wayillExt.getId()});
            wayBillRunSc1.setCount(Integer.valueOf(Integer.MAX_VALUE));
            wayBillRunSc1.setActualFlagList(new Integer[]{0, 2});
            srList = this.waybillRunProxy.getList(this.context, wayBillRunSc1);
            if (srList != null && !srList.isEmpty()) {
                i = 0;
                while (i < srList.getObjList().length) {
                    runShift1List.add((WaybillRunExt)((Object)srList.getObjList()[i]));
                    ++i;
                }
            }
            wayillExt.setRunShift1List(runShift1List);
            wbsSc.setWaybillIdList(new Long[]{wayillExt.getId()});
            wbsSc.setWarrantIdList(new Long[]{wayillExt.getWarrant1().getId()});
            srList = wbsProxy.getList(this.context, wbsSc);
            if (srList != null && srList.getObjList() != null && srList.getObjList().length > 0) {
                wbs1 = wbsProxy.getCurrentObject(this.context, ((WaybillStatistic)srList.getObjList()[0]).getId());
            }
        }
        if (wayillExt != null && wayillExt.getWarrant2() != null && wayillExt.getWarrant2().getId() != null && this.secondShiftType != null && this.secondShiftType.getId() != null) {
            runShift2List = new ArrayList<WaybillRunExt>();
            WaybillRunSearchCriteria wayBillRunSc2 = new WaybillRunSearchCriteria();
            wayBillRunSc2.setShiftTypeIdList(new Long[]{this.secondShiftType.getId()});
            wayBillRunSc2.setWaybillIdList(new Long[]{wayillExt.getId()});
            wayBillRunSc2.setCount(Integer.valueOf(Integer.MAX_VALUE));
            wayBillRunSc2.setActualFlagList(new Integer[]{0, 2});
            srList = this.waybillRunProxy.getList(this.context, wayBillRunSc2);
            if (srList != null && !srList.isEmpty()) {
                i = 0;
                while (i < srList.getObjList().length) {
                    runShift2List.add((WaybillRunExt)((Object)srList.getObjList()[i]));
                    ++i;
                }
            }
            wayillExt.setRunShift2List(runShift2List);
            wbsSc.setWaybillIdList(new Long[]{wayillExt.getId()});
            wbsSc.setWarrantIdList(new Long[]{wayillExt.getWarrant2().getId()});
            srList = wbsProxy.getList(this.context, wbsSc);
            if (srList != null && srList.getObjList() != null && srList.getObjList().length > 0) {
                wbs2 = wbsProxy.getCurrentObject(this.context, ((WaybillStatistic)srList.getObjList()[0]).getId());
            }
        }
        wayillExt.setRunShift1List(runShift1List);
        wayillExt.setRunShift2List(runShift2List);
        wayillExt.setWaybillStatistic1(wbs1);
        wayillExt.setWaybillStatistic2(wbs2);
        return wayillExt;
    }

    public void remoteWaybillRun(WayBill waybill, List<RouteScheduleRunExt> listRSR) {
        this.logger.debug((Object)("remoteWaybillRun: " + listRSR));
        if (listRSR != null && listRSR.size() > 0) {
            Date date = new Date();
            if (waybill != null) {
                date = waybill.getWaybillDate();
            }
            Date startAt = null;
            Date endAt = null;
            int i = 0;
            while (i < listRSR.size()) {
                if (listRSR.get(i) != null) {
                    if (listRSR.get(i).getRunAt() != null) {
                        if (startAt == null) {
                            startAt = listRSR.get(i).getRunAt();
                        } else if (HelpUtils.afterTime(startAt, listRSR.get(i).getRunAt())) {
                            startAt = listRSR.get(i).getRunAt();
                        }
                    }
                    if (listRSR.get(i).getReturnAt() != null) {
                        if (endAt == null) {
                            endAt = listRSR.get(i).getReturnAt();
                        } else if (HelpUtils.beforeTime(endAt, listRSR.get(i).getReturnAt())) {
                            endAt = listRSR.get(i).getReturnAt();
                        }
                    }
                }
                ++i;
            }
            this.logger.debug((Object)("remoteWaybillRun start at: " + startAt));
            this.logger.debug((Object)("remoteWaybillRun end at: " + endAt));
            WaybillRunSearchCriteria wbrSc = new WaybillRunSearchCriteria();
            wbrSc.setActualFlagList(new Integer[]{new Integer(0), new Integer(1)});
            wbrSc.setWaybillDateFrom(CommonSearchCriteria.beginOfDay((Date)date));
            wbrSc.setWaybillDateTill(CommonSearchCriteria.endOfDay((Date)date));
            wbrSc.setRunScheduleTypeIdList(new Long[]{listRSR.get(0).getRsType().getId()});
            wbrSc.setShiftTypeIdList(new Long[]{listRSR.get(0).getShiftType().getId()});
            wbrSc.setRouteScheduleIdList(new Long[]{listRSR.get(0).getSchedule().getId()});
            wbrSc.setRunAtFrom(startAt);
            wbrSc.setReturnAtTill(endAt);
            wbrSc.setCount(Integer.valueOf(Integer.MAX_VALUE));
            WaybillRunWSProxy.SearchResultListWaybillRun srl = this.waybillRunProxy.getList(this.context, wbrSc);
            this.logger.debug((Object)("remoteWaybillRun list: " + srl));
            if (srl != null && !srl.isEmpty()) {
                int i2 = 0;
                while (i2 < srl.getObjList().length) {
                    boolean deleted = false;
                    int j = 0;
                    while (j < listRSR.size()) {
                        Date returnAt = null;
                        if (new Integer(TwoFlight).equals(listRSR.get(j).getRunType())) {
                            long time = (listRSR.get(j).getRunAt().getTime() + listRSR.get(j).getReturnAt().getTime()) / 2L;
                            if (listRSR.get(j).getRoute().getAdditionalInMin() != null) {
                                time -= (long)listRSR.get(j).getRoute().getAdditionalInMin().intValue() * 60L * 1000L / 2L;
                            }
                            returnAt = new Date(time);
                        }
                        if (HelpUtils.equalsTimeFromDate(((WaybillRun)srl.getObjList()[i2]).getRun().getRunAt(), listRSR.get(j).getRunAt()) && !((WaybillRun)srl.getObjList()[i2]).getRun().getId().equals(listRSR.get(j).getRunAt()) || returnAt != null && HelpUtils.equalsTimeFromDate(((WaybillRun)srl.getObjList()[i2]).getRun().getRunAt(), returnAt)) {
                            deleted = true;
                        }
                        ++j;
                    }
                    if (deleted) {
                        this.waybillRunProxy.delete(this.context, ((WaybillRun)srl.getObjList()[i2]).getId());
                    }
                    ++i2;
                }
            }
            wbrSc = new WaybillRunSearchCriteria();
            wbrSc.setActualFlagList(new Integer[]{new Integer(0)});
            wbrSc.setWaybillIdList(new Long[]{waybill.getId()});
            wbrSc.setCount(Integer.valueOf(Integer.MAX_VALUE));
            Calendar cStart = Calendar.getInstance();
            Calendar cEnd = Calendar.getInstance();
            cStart.setTime(startAt);
            cEnd.setTime(endAt);
            cStart.add(13, 1);
            cEnd.add(13, -1);
            wbrSc.setRunAtTill(cEnd.getTime());
            wbrSc.setReturnAtFrom(cStart.getTime());
            srl = this.waybillRunProxy.getList(this.context, wbrSc);
            this.logger.debug((Object)("remoteWaybillRun mark NO actual list: " + srl));
            if (srl != null && !srl.isEmpty()) {
                int i3 = 0;
                while (i3 < srl.getObjList().length) {
                    ((WaybillRun)srl.getObjList()[i3]).setActualFlag(Integer.valueOf(1));
                    this.waybillRunProxy.save(this.context, (WaybillRun)srl.getObjList()[i3]);
                    ++i3;
                }
            }
        }
    }

    public Integer adderRouteScheduleRunInWaybill(WayBillExt w, List<RouteScheduleRunExt> listRSR, Integer shift) {
        Route ownedRoute = null;
        TransportStop firstStop = null;
        TransportStop lastStop = null;
        Date firstTime = null;
        Date lastTime = null;
        Date similarityDate = null;
        WaybillRun wbr = null;
        RouteScheduleRun rsr = null;
        WaybillRun wbr2 = null;
        RouteScheduleRun rsr2 = null;
        Long warrant_id = null;
        Long waybill_id = null;
        int i = 0;
        this.remoteWaybillRun(w, listRSR);
        waybill_id = w.getId();
        if (new Integer(1).equals(shift) && w.getWarrant1() != null && w.getWarrant1().getId() != null) {
            warrant_id = w.getWarrant1().getId();
            if (w.getRunShift1List() != null && w.getRunShift1List().size() > 0) {
                i = 0;
                while (similarityDate == null && i < w.getRunShift1List().size()) {
                    if (new Integer(0).equals(w.getRunShift1List().get(i).getActualFlag()) && w.getRunShift1List().get(i).getRunAt() != null) {
                        similarityDate = w.getRunShift1List().get(i).getRunAt();
                    }
                    ++i;
                }
            }
        } else if (new Integer(2).equals(shift) && w.getWarrant2() != null && w.getWarrant2().getId() != null) {
            warrant_id = w.getWarrant2().getId();
            if (w.getRunShift2List() != null && w.getRunShift2List().size() > 0) {
                i = 0;
                while (similarityDate == null && i < w.getRunShift2List().size()) {
                    if (new Integer(0).equals(w.getRunShift2List().get(i).getActualFlag()) && w.getRunShift2List().get(i).getRunAt() != null) {
                        similarityDate = w.getRunShift2List().get(i).getRunAt();
                    }
                    ++i;
                }
            }
        }
        if (warrant_id != null && waybill_id != null) {
            User createdBy;
            UsersGroup group = null;
            if (listRSR.size() > 0 && listRSR.get(0).getRoute() != null && listRSR.get(0).getRoute().getCreatedBy_id() != null && (createdBy = this.userWSProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, listRSR.get(0).getRoute().getCreatedBy_id())) != null && createdBy.getPrimaryGroupId() != null) {
                group = this.usersGroupProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, createdBy.getPrimaryGroupId());
            }
            i = 0;
            while (i < listRSR.size()) {
                if (listRSR.get(i) != null && listRSR.get(i).getRunAt() != null && listRSR.get(i).getReturnAt() != null) {
                    if (ownedRoute == null) {
                        ownedRoute = listRSR.get(i).getOwnedRoute();
                    }
                    if (firstTime == null) {
                        firstTime = listRSR.get(i).getRunAt();
                        firstStop = listRSR.get(i).getFirstStop();
                    } else if (listRSR.get(i).getRunAt().before(firstTime)) {
                        firstTime = listRSR.get(i).getRunAt();
                        firstStop = listRSR.get(i).getFirstStop();
                    }
                    if (lastTime == null) {
                        lastTime = listRSR.get(i).getReturnAt();
                        lastStop = new Integer(TwoFlight).equals(listRSR.get(i).getRunType()) ? listRSR.get(i).getFirstStop() : listRSR.get(i).getLastStop();
                    } else if (listRSR.get(i).getReturnAt().after(lastTime)) {
                        lastTime = listRSR.get(i).getReturnAt();
                        lastStop = new Integer(TwoFlight).equals(listRSR.get(i).getRunType()) ? listRSR.get(i).getFirstStop() : listRSR.get(i).getLastStop();
                    }
                    wbr = new WaybillRun();
                    wbr2 = new WaybillRun();
                    if (new Integer(TwoFlight).equals(listRSR.get(i).getRunType())) {
                        long time = (listRSR.get(i).getRunAt().getTime() + listRSR.get(i).getReturnAt().getTime()) / 2L;
                        if (listRSR.get(i).getRoute().getAdditionalInMin() != null) {
                            time -= (long)listRSR.get(i).getRoute().getAdditionalInMin().intValue() * 60L * 1000L / 2L;
                        }
                        Date returnAt = new Date(time);
                        rsr = this.newRouteScheduleRunLiteIsDeleted(listRSR.get(i).getSchedule(), listRSR.get(i).getRoute(), HelpUtils.copyTimeFromDate(listRSR.get(i).getRunAt(), similarityDate), HelpUtils.copyTimeFromDate(returnAt, similarityDate), listRSR.get(i).getFirstStop(), listRSR.get(i).getLastStop(), 0, Flight, listRSR.get(i).getRsType(), listRSR.get(i).getShiftType(), listRSR.get(i).getOwnedRoute());
                        this.logger.debug((Object)("Create new rsr1: " + rsr));
                        wbr.setRun(rsr);
                        wbr.setWarrant_id(warrant_id);
                        wbr.setWaybill_id(waybill_id);
                        this.waybillRunProxy.save(this.context, wbr);
                        if (w.getWarrant1() != null) {
                            this.addRecordInJournalDispatcherYOTK(new Date(), listRSR.get(i).getRoute().getNum(), listRSR.get(i).getRsType(), listRSR.get(i).getShiftType(), w.getWarrant1().getTransport().getGarageNum(), w.getWarrant1().getDriver().getTabNum(), null, null, "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0439\u0441\u043e\u0432", group, new Integer(0), String.valueOf(new String("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0439\u0441\u043e\u0432 " + df_time_only.format(rsr.getRunAt()) + " \u043a \u043f\u0443\u0442\u0435\u0432\u043e\u043c\u0443 \u043b\u0438\u0441\u0442\u0443: " + w.getWaybillNum())) + " \u043e\u0442 " + df_date_only.format(w.getWaybillDate()));
                        } else {
                            this.addRecordInJournalDispatcherYOTK(new Date(), listRSR.get(i).getRoute().getNum(), listRSR.get(i).getRsType(), listRSR.get(i).getShiftType(), w.getWarrant2().getTransport().getGarageNum(), w.getWarrant2().getDriver().getTabNum(), null, null, "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0439\u0441\u043e\u0432", group, new Integer(0), String.valueOf(new String("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0439\u0441\u043e\u0432 " + df_time_only.format(rsr.getRunAt()) + " \u043a \u043f\u0443\u0442\u0435\u0432\u043e\u043c\u0443 \u043b\u0438\u0441\u0442\u0443: " + w.getWaybillNum())) + " \u043e\u0442 " + df_date_only.format(w.getWaybillDate()));
                        }
                        rsr2 = this.newRouteScheduleRunLiteIsDeleted(listRSR.get(i).getSchedule(), listRSR.get(i).getRoute(), HelpUtils.copyTimeFromDate(returnAt, similarityDate), HelpUtils.copyTimeFromDate(listRSR.get(i).getReturnAt(), similarityDate), listRSR.get(i).getLastStop(), listRSR.get(i).getFirstStop(), listRSR.get(i).getIdleTimeInMin(), Flight, listRSR.get(i).getRsType(), listRSR.get(i).getShiftType(), listRSR.get(i).getOwnedRoute());
                        this.logger.debug((Object)("Create new rsr2: " + rsr2));
                        wbr2.setRun(rsr2);
                        wbr2.setWarrant_id(warrant_id);
                        wbr2.setWaybill_id(waybill_id);
                        this.waybillRunProxy.save(this.context, wbr2);
                        if (w.getWarrant1() != null) {
                            this.addRecordInJournalDispatcherYOTK(new Date(), listRSR.get(i).getRoute().getNum(), listRSR.get(i).getRsType(), listRSR.get(i).getShiftType(), w.getWarrant1().getTransport().getGarageNum(), w.getWarrant1().getDriver().getTabNum(), null, null, "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0439\u0441\u043e\u0432", group, new Integer(0), String.valueOf(new String("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0439\u0441\u043e\u0432 " + df_time_only.format(rsr.getRunAt()) + " \u043a \u043f\u0443\u0442\u0435\u0432\u043e\u043c\u0443 \u043b\u0438\u0441\u0442\u0443: " + w.getWaybillNum())) + " \u043e\u0442 " + df_date_only.format(w.getWaybillDate()));
                        } else {
                            this.addRecordInJournalDispatcherYOTK(new Date(), listRSR.get(i).getRoute().getNum(), listRSR.get(i).getRsType(), listRSR.get(i).getShiftType(), w.getWarrant2().getTransport().getGarageNum(), w.getWarrant2().getDriver().getTabNum(), null, null, "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0439\u0441\u043e\u0432", group, new Integer(0), String.valueOf(new String("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0439\u0441\u043e\u0432 " + df_time_only.format(rsr.getRunAt()) + " \u043a \u043f\u0443\u0442\u0435\u0432\u043e\u043c\u0443 \u043b\u0438\u0441\u0442\u0443: " + w.getWaybillNum())) + " \u043e\u0442 " + df_date_only.format(w.getWaybillDate()));
                        }
                    } else {
                        if (listRSR.get(i).getIsDeleted() == 1) {
                            rsr = listRSR.get(i);
                        } else {
                            Integer runType = Flight;
                            if (listRSR.get(i).getRunType() != null) {
                                runType = listRSR.get(i).getRunType();
                            }
                            rsr = this.newRouteScheduleRunLiteIsDeleted(listRSR.get(i).getSchedule(), listRSR.get(i).getRoute(), HelpUtils.copyTimeFromDate(listRSR.get(i).getRunAt(), similarityDate), HelpUtils.copyTimeFromDate(listRSR.get(i).getReturnAt(), similarityDate), listRSR.get(i).getFirstStop(), listRSR.get(i).getLastStop(), listRSR.get(i).getIdleTimeInMin(), runType, listRSR.get(i).getRsType(), listRSR.get(i).getShiftType(), listRSR.get(i).getOwnedRoute());
                        }
                        this.logger.debug((Object)("Add new rsr: " + rsr));
                        wbr.setRun(rsr);
                        wbr.setWarrant_id(warrant_id);
                        wbr.setWaybill_id(waybill_id);
                        this.waybillRunProxy.save(this.context, wbr);
                        if (w.getWarrant1() != null) {
                            this.addRecordInJournalDispatcherYOTK(new Date(), listRSR.get(i).getRoute().getNum(), listRSR.get(i).getRsType(), listRSR.get(i).getShiftType(), w.getWarrant1().getTransport().getGarageNum(), w.getWarrant1().getDriver().getTabNum(), null, null, "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0439\u0441\u043e\u0432", group, new Integer(0), String.valueOf(new String("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0439\u0441\u043e\u0432 " + df_time_only.format(rsr.getRunAt()) + " \u043a \u043f\u0443\u0442\u0435\u0432\u043e\u043c\u0443 \u043b\u0438\u0441\u0442\u0443: " + w.getWaybillNum())) + " \u043e\u0442 " + df_date_only.format(w.getWaybillDate()));
                        } else {
                            this.addRecordInJournalDispatcherYOTK(new Date(), listRSR.get(i).getRoute().getNum(), listRSR.get(i).getRsType(), listRSR.get(i).getShiftType(), w.getWarrant2().getTransport().getGarageNum(), w.getWarrant2().getDriver().getTabNum(), null, null, "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0439\u0441\u043e\u0432", group, new Integer(0), String.valueOf(new String("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0439\u0441\u043e\u0432 " + df_time_only.format(rsr.getRunAt()) + " \u043a \u043f\u0443\u0442\u0435\u0432\u043e\u043c\u0443 \u043b\u0438\u0441\u0442\u0443: " + w.getWaybillNum())) + " \u043e\u0442 " + df_date_only.format(w.getWaybillDate()));
                        }
                    }
                }
                ++i;
            }
            if (firstStop != null && firstTime != null && lastStop != null && lastTime != null) {
                Calendar c;
                RouteSchedule rs;
                Route route;
                String name;
                TransportStop firstBaseStop = null;
                TransportStop lastBaseStop = null;
                Date firstBaseTime = null;
                Date lastBaseTime = null;
                TransportStop ts = this.getTransportStop("*\u041f\u0410\u0422\u041f \u21161*", "\u041f\u0410\u0422\u041f \u21161", "\u041f\u0410\u0422\u041f \u21161");
                String namePer = "\u041f\u0435\u0440\u0435\u0433\u043e\u043d*";
                Route routePer = this.getRoute(namePer, namePer, namePer);
                if (new Integer(1).equals(shift)) {
                    if (w.getRunShift1List() != null && w.getRunShift1List().size() > 0) {
                        i = 0;
                        while (i < w.getRunShift1List().size()) {
                            if (new Integer(0).equals(w.getRunShift1List().get(i).getActualFlag()) && w.getRunShift1List().get(i).getRoute() != null && w.getRunShift1List().get(i).getRunAt() != null && w.getRunShift1List().get(i).getReturnAt() != null) {
                                if (firstBaseTime == null && HelpUtils.beforeTime(w.getRunShift1List().get(i).getReturnAt(), firstTime)) {
                                    firstBaseTime = w.getRunShift1List().get(i).getReturnAt();
                                    firstBaseStop = new Integer(TwoFlight).equals(w.getRunShift1List().get(i).getRunType()) ? w.getRunShift1List().get(i).getFirstStop() : w.getRunShift1List().get(i).getLastStop();
                                } else if (firstBaseTime != null && HelpUtils.beforeTime(w.getRunShift1List().get(i).getReturnAt(), firstTime) && HelpUtils.afterTime(w.getRunShift1List().get(i).getReturnAt(), firstBaseTime)) {
                                    firstBaseTime = w.getRunShift1List().get(i).getReturnAt();
                                    firstBaseStop = new Integer(TwoFlight).equals(w.getRunShift1List().get(i).getRunType()) ? w.getRunShift1List().get(i).getFirstStop() : w.getRunShift1List().get(i).getLastStop();
                                }
                                if (lastBaseTime == null && HelpUtils.afterTime(w.getRunShift1List().get(i).getRunAt(), lastTime)) {
                                    lastBaseTime = w.getRunShift1List().get(i).getRunAt();
                                    lastBaseStop = w.getRunShift1List().get(i).getFirstStop();
                                } else if (lastBaseTime != null && HelpUtils.afterTime(w.getRunShift1List().get(i).getRunAt(), lastTime) && HelpUtils.beforeTime(w.getRunShift1List().get(i).getRunAt(), lastBaseTime)) {
                                    lastBaseTime = w.getRunShift1List().get(i).getRunAt();
                                    lastBaseStop = w.getRunShift1List().get(i).getFirstStop();
                                }
                            }
                            ++i;
                        }
                    }
                } else if (new Integer(2).equals(shift) && w.getRunShift2List() != null && w.getRunShift2List().size() > 0) {
                    i = 0;
                    while (i < w.getRunShift2List().size()) {
                        if (new Integer(0).equals(w.getRunShift2List().get(i).getActualFlag()) && w.getRunShift2List().get(i).getRoute() != null && w.getRunShift2List().get(i).getRunAt() != null && w.getRunShift2List().get(i).getReturnAt() != null) {
                            if (firstBaseTime == null && HelpUtils.beforeTime(w.getRunShift2List().get(i).getReturnAt(), firstTime)) {
                                firstBaseTime = w.getRunShift2List().get(i).getReturnAt();
                                firstBaseStop = w.getRunShift2List().get(i).getLastStop();
                            } else if (firstBaseTime != null && HelpUtils.beforeTime(w.getRunShift2List().get(i).getReturnAt(), firstTime) && HelpUtils.afterTime(w.getRunShift2List().get(i).getReturnAt(), firstBaseTime)) {
                                firstBaseTime = w.getRunShift2List().get(i).getReturnAt();
                                firstBaseStop = w.getRunShift2List().get(i).getLastStop();
                            }
                            if (lastBaseTime == null && HelpUtils.afterTime(w.getRunShift2List().get(i).getRunAt(), lastTime)) {
                                lastBaseTime = w.getRunShift2List().get(i).getRunAt();
                                lastBaseStop = w.getRunShift2List().get(i).getFirstStop();
                            } else if (lastBaseTime != null && HelpUtils.afterTime(w.getRunShift2List().get(i).getRunAt(), lastTime) && HelpUtils.beforeTime(w.getRunShift2List().get(i).getRunAt(), lastBaseTime)) {
                                lastBaseTime = w.getRunShift2List().get(i).getRunAt();
                                lastBaseStop = w.getRunShift2List().get(i).getFirstStop();
                            }
                        }
                        ++i;
                    }
                }
                if (firstBaseTime == null || firstBaseStop == null) {
                    firstBaseStop = ts;
                }
                if (lastBaseTime == null || lastBaseStop == null) {
                    lastBaseStop = ts;
                }
                if (firstBaseStop != null && firstStop != null && !firstBaseStop.equals((Object)firstStop) && firstTime != null) {
                    Date runAt;
                    name = RouteExt.getNameZeroUnderStop(firstBaseStop, firstStop);
                    route = this.getRoute(name, name, name);
                    rs = this.getRouteScheduleWithoutRunOnDay(routePer.getId(), routePer, new Date(), null, ts, ts);
                    if (route.getRouteDurInMin() != null) {
                        c = Calendar.getInstance();
                        c.setTime(firstTime);
                        c.add(12, -route.getRouteDurInMin().intValue());
                        runAt = c.getTime();
                    } else {
                        runAt = firstBaseTime;
                    }
                    if (runAt != null) {
                        rsr = this.newRouteScheduleRunLiteIsDeleted(rs, route, HelpUtils.copyTimeFromDate(runAt, similarityDate), HelpUtils.copyTimeFromDate(firstTime, similarityDate), firstBaseStop, firstStop, 0, 4, ownedRoute);
                        wbr = new WaybillRun();
                        wbr.setRun(rsr);
                        wbr.setWarrant_id(warrant_id);
                        wbr.setWaybill_id(waybill_id);
                        this.waybillRunProxy.save(this.context, wbr);
                    }
                }
                if (lastBaseStop != null && lastStop != null && !lastBaseStop.equals((Object)lastStop) && lastTime != null) {
                    Date returnAt;
                    name = RouteExt.getNameZeroUnderStop(lastStop, lastBaseStop);
                    route = this.getRoute(name, name, name);
                    rs = this.getRouteScheduleWithoutRunOnDay(routePer.getId(), routePer, new Date(), null, ts, ts);
                    if (route.getRouteDurInMin() != null) {
                        c = Calendar.getInstance();
                        c.setTime(lastTime);
                        c.add(12, route.getRouteDurInMin());
                        returnAt = c.getTime();
                    } else {
                        returnAt = lastBaseTime;
                    }
                    if (returnAt != null) {
                        rsr = this.newRouteScheduleRunLiteIsDeleted(rs, route, HelpUtils.copyTimeFromDate(lastTime, similarityDate), HelpUtils.copyTimeFromDate(returnAt, similarityDate), lastStop, lastBaseStop, 0, 4, ownedRoute);
                        wbr = new WaybillRun();
                        wbr.setRun(rsr);
                        wbr.setWarrant_id(warrant_id);
                        wbr.setWaybill_id(waybill_id);
                        this.waybillRunProxy.save(this.context, wbr);
                    }
                }
            }
        }
        return NO_ERROR;
    }

    public Integer ReplaceTransport(Transport transport, Date date, Driver driver, ReplaceReason reason, TransportStop baseStation, Integer run1, TransportStop stop1, Integer duration1, BigDecimal mealage1, String name1, Integer run2, TransportStop stop2, Integer duration2, BigDecimal mealage2, String name2, String routeNum, Long routeId, String transportGarNum, String driverTab, Long scheduleTypeId, Long shiftTypeId, Long waybillId, Long warrantId) {
        User createdBy;
        Calendar c;
        RouteScheduleRun rsr;
        RouteSchedule routeSchedule;
        Route route;
        this.logger.debug((Object)"Replace Transport start");
        if (this.context == null) {
            return CONTEXT_IS_NOT_INITIALIZED;
        }
        if (waybillId == null) {
            return WAYBILL_ID_IS_NULL;
        }
        if (transport == null || transport.getId() == null) {
            return TRANSPORT_IS_NULL;
        }
        if (date == null) {
            return DATE_IS_NULL;
        }
        if (reason == null) {
            return REASON_IS_NULL;
        }
        if (baseStation == null) {
            return BASE_STATION_IS_NULL;
        }
        if (routeId == null) {
            return ROUTE_ID_IS_NULL;
        }
        if (scheduleTypeId == null) {
            return SCHEDULE_TYPE_ID_IS_NULL;
        }
        if (shiftTypeId == null) {
            return SHIFT_TYPE_ID_IS_NULL;
        }
        this.logger.debug((Object)("Waybill id: " + waybillId));
        this.logger.debug((Object)("Transport: " + transport));
        this.logger.debug((Object)("Date: " + date));
        this.logger.debug((Object)("Reason: " + reason));
        this.logger.debug((Object)("Base Station: " + baseStation));
        this.logger.debug((Object)("Route id: " + routeId));
        this.logger.debug((Object)("Run schedule type id: " + scheduleTypeId));
        this.logger.debug((Object)("Shift type id: " + shiftTypeId));
        Long span1 = null;
        Long span2 = null;
        RunScheduleType rsType = this.runScheduleTypeProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, scheduleTypeId);
        ShiftType shiftType = this.shiftTypeProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, shiftTypeId);
        Route ownerRoute = this.routeProxy.getCurrentObject(this.context, routeId);
        if (new Integer(1).equals(run1) && stop1 != null && baseStation != null && name1 != null) {
            route = this.getRoute(name1, stop1, baseStation, mealage1, duration1);
            routeSchedule = this.getRouteSchedule(date, routeId);
            rsr = new RouteScheduleRun();
            rsr.setSchedule(routeSchedule);
            rsr.setRoute(route);
            rsr.setRsType(rsType);
            rsr.setShiftType(shiftType);
            rsr.setOwnedRoute(ownerRoute);
            c = Calendar.getInstance();
            c.setTime(date);
            if (duration1 != null) {
                c.add(12, -duration1.intValue());
            }
            rsr.setRunAt(HelpUtils.getRouteScheduleRunTime(c.getTime()));
            rsr.setReturnAt(HelpUtils.getRouteScheduleRunTime(date));
            rsr.setFirstStop(stop1);
            rsr.setLastStop(baseStation);
            rsr.setRunType(Integer.valueOf(4));
            rsr.setIsDeleted(new Integer(1).intValue());
            rsr = this.routeScheduleRunProxy.save(this.context, rsr);
            if (rsr != null) {
                span1 = rsr.getId();
            }
            this.logger.debug((Object)("Span1 id (RouteScheduleRun): " + span1));
        }
        if (new Integer(1).equals(run2) && baseStation != null && stop2 != null && name2 != null) {
            route = this.getRoute(name2, baseStation, stop2, mealage2, duration2);
            routeSchedule = this.getRouteSchedule(date, routeId);
            rsr = new RouteScheduleRun();
            rsr.setSchedule(routeSchedule);
            rsr.setRoute(route);
            rsr.setRsType(rsType);
            rsr.setShiftType(shiftType);
            rsr.setOwnedRoute(ownerRoute);
            c = Calendar.getInstance();
            c.setTime(date);
            if (duration2 != null) {
                c.add(12, duration2);
            }
            rsr.setRunAt(HelpUtils.getRouteScheduleRunTime(date));
            rsr.setReturnAt(HelpUtils.getRouteScheduleRunTime(c.getTime()));
            rsr.setFirstStop(baseStation);
            rsr.setLastStop(stop2);
            rsr.setRunType(Integer.valueOf(4));
            rsr.setIsDeleted(new Integer(1).intValue());
            rsr = this.routeScheduleRunProxy.save(this.context, rsr);
            if (rsr != null) {
                span2 = rsr.getId();
            }
            this.logger.debug((Object)("Span2 id (RouteScheduleRun): " + span2));
        }
        ReplaceWaybillTransport rwbt = new ReplaceWaybillTransport();
        rwbt.setDateTime(date);
        rwbt.setTransportId(transport.getId());
        rwbt.setReason(reason);
        rwbt.setWaybillId(waybillId);
        rwbt.setWarrantId(warrantId);
        rwbt.setBrokenTransportLastStop(baseStation.getId());
        if (driver != null) {
            rwbt.setDriverId(driver.getId());
        }
        rwbt.setContinuePartialRun(new Integer(1));
        rwbt.setNewTransportZeroRunId(span1);
        rwbt.setBrokenTransportLastRunId(span2);
        try {
            this.proxy.replaceWaybillTransport(this.context, rwbt);
        }
        catch (SOAPException sOAPException) {
            return INTERNAL_ERROR;
        }
        String garnumS = null;
        String tabnumS = null;
        String garnumD = null;
        String tabnumD = null;
        UsersGroup group = null;
        if (ownerRoute != null && ownerRoute.getCreatedBy_id() != null && (createdBy = this.userWSProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, ownerRoute.getCreatedBy_id())) != null && createdBy.getPrimaryGroupId() != null) {
            group = this.usersGroupProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, createdBy.getPrimaryGroupId());
        }
        garnumS = transportGarNum;
        tabnumS = driverTab;
        garnumD = transport.getGarageNum();
        tabnumD = driver.getTabNum();
        this.addRecordInJournalDispatcherYOTK(new Date(), routeNum, rsType, shiftType, garnumS, tabnumS, garnumD, tabnumD, reason.getDescription(), group, new Integer(0), new String("\u0417\u0430\u043c\u0435\u043d\u0430 \u0422\u0421 \u043e\u0442 " + df_date.format(date)));
        return NO_ERROR;
    }

    public Integer DescentTransport(Long transportId, String garnumS, Date date, String tabnumS, ReplaceReason reason, TransportStop baseStation, Long routeId, String routeNum, Long scheduleTypeId, Long shiftTypeId, Long waybillId, Long warrantId) {
        User createdBy;
        this.logger.debug((Object)"Descent Transport start");
        if (this.context == null) {
            return CONTEXT_IS_NOT_INITIALIZED;
        }
        if (waybillId == null) {
            return WAYBILL_ID_IS_NULL;
        }
        if (transportId == null) {
            return TRANSPORT_IS_NULL;
        }
        if (date == null) {
            return DATE_IS_NULL;
        }
        if (reason == null) {
            return REASON_IS_NULL;
        }
        if (baseStation == null) {
            return BASE_STATION_IS_NULL;
        }
        if (routeId == null) {
            return ROUTE_ID_IS_NULL;
        }
        if (scheduleTypeId == null) {
            return SCHEDULE_TYPE_ID_IS_NULL;
        }
        if (shiftTypeId == null) {
            return SHIFT_TYPE_ID_IS_NULL;
        }
        if (garnumS == null) {
            return GARAGE_NUM_IS_NULL;
        }
        if (tabnumS == null) {
            return TAB_NUM_IS_NULL;
        }
        this.logger.debug((Object)("Waybill id: " + waybillId));
        this.logger.debug((Object)("Warrant id: " + warrantId));
        this.logger.debug((Object)("Transport id: " + transportId));
        this.logger.debug((Object)("Date: " + date));
        this.logger.debug((Object)("Reason: " + reason));
        this.logger.debug((Object)("Base Station: " + baseStation));
        this.logger.debug((Object)("Route id: " + routeId));
        this.logger.debug((Object)("Run schedule type id: " + scheduleTypeId));
        this.logger.debug((Object)("Shift type id: " + shiftTypeId));
        this.logger.debug((Object)("Garage num: " + garnumS));
        this.logger.debug((Object)("Tab num: " + tabnumS));
        WaybillAction rwbt = new WaybillAction();
        rwbt.setDateTime(date);
        rwbt.setReason(reason);
        rwbt.setWaybillId(waybillId);
        rwbt.setWarrantId(warrantId);
        rwbt.setBrokenTransportLastStop(baseStation.getId());
        rwbt.setBrokenTransportId(transportId);
        try {
            this.proxy.cancelWaybill(this.context, rwbt);
        }
        catch (SOAPException sOAPException) {
            return INTERNAL_ERROR;
        }
        UsersGroup group = null;
        RunScheduleType rsType = this.runScheduleTypeProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, scheduleTypeId);
        ShiftType shiftType = this.shiftTypeProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, shiftTypeId);
        Route ownerRoute = this.routeProxy.getCurrentObject(this.context, routeId);
        if (ownerRoute != null && ownerRoute.getCreatedBy_id() != null && (createdBy = this.userWSProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, ownerRoute.getCreatedBy_id())) != null && createdBy.getPrimaryGroupId() != null) {
            group = this.usersGroupProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, createdBy.getPrimaryGroupId());
        }
        this.logger.debug((Object)("Group: " + group));
        this.addRecordInJournalDispatcherYOTK(new Date(), routeNum, rsType, shiftType, garnumS, tabnumS, null, null, reason.getDescription(), group, new Integer(0), new String("\u0421\u0445\u043e\u0434 \u0422\u0421 \u043e\u0442 " + df_date.format(date)));
        return NO_ERROR;
    }

    public Integer NewTransport(Transport transport, Date date, Driver driver, String routeNum, Long routeId, Long scheduleTypeId, Long shiftTypeId, Date runAt, Date returnAt, Long emptyWaybillId, Long emptyWarrantId) {
        this.logger.debug((Object)"New Transport start");
        if (this.context == null) {
            return CONTEXT_IS_NOT_INITIALIZED;
        }
        if (transport == null || transport.getId() == null) {
            return TRANSPORT_IS_NULL;
        }
        if (driver == null || driver.getId() == null) {
            return DRIVER_IS_NULL;
        }
        if (date == null) {
            return DATE_IS_NULL;
        }
        if (routeId == null) {
            return ROUTE_ID_IS_NULL;
        }
        if (scheduleTypeId == null) {
            return SCHEDULE_TYPE_ID_IS_NULL;
        }
        if (shiftTypeId == null) {
            return SHIFT_TYPE_ID_IS_NULL;
        }
        if (runAt == null) {
            return RUN_AT_IS_NULL;
        }
        if (returnAt == null) {
            return RETURN_AT_IS_NULL;
        }
        this.logger.debug((Object)("Transport id: " + transport.getId()));
        this.logger.debug((Object)("Driver id: " + driver.getId()));
        this.logger.debug((Object)("Date: " + date));
        this.logger.debug((Object)("Route id: " + routeId));
        this.logger.debug((Object)("Run schedule type id: " + scheduleTypeId));
        this.logger.debug((Object)("Shift type id: " + shiftTypeId));
        this.logger.debug((Object)("Run at: " + runAt));
        this.logger.debug((Object)("Return at: " + returnAt));
        Long waybill_id = null;
        Long warrant_id = null;
        RunScheduleType rsType = this.runScheduleTypeProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, scheduleTypeId);
        ShiftType shiftType = this.shiftTypeProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, shiftTypeId);
        Route route = this.routeProxy.getCurrentObject(this.context, routeId);
        UsersGroup group = null;
        Long userId = null;
        if (route != null && route.getCreatedBy_id() != null) {
            User createdBy = this.userWSProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, route.getCreatedBy_id());
            if (createdBy != null) {
                if (createdBy.getPrimaryGroupId() != null) {
                    group = this.usersGroupProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, createdBy.getPrimaryGroupId());
                }
                if (!createdBy.getName().equals(this.context.getUserName())) {
                    userId = route.getCreatedBy_id();
                }
            } else {
                userId = route.getCreatedBy_id();
            }
        }
        WayBillSearchCriteria wbSc = new WayBillSearchCriteria();
        wbSc.setTransportIdList(new Long[]{transport.getId()});
        wbSc.setWaybillDateFrom(CommonSearchCriteria.beginOfDay((Date)date));
        wbSc.setWaybillDateTill(CommonSearchCriteria.endOfDay((Date)date));
        wbSc.setDriverIdList(new Long[]{driver.getId()});
        WayBillWSProxy.SearchResultListWayBill srlwb = this.proxy.getList(this.context, wbSc);
        if (srlwb != null && !srlwb.isEmpty()) {
            waybill_id = ((WayBill)srlwb.getObjList()[0]).getId();
            this.logger.debug((Object)("Get waybill: " + (WayBill)srlwb.getObjList()[0]));
            if (((WayBill)srlwb.getObjList()[0]).getWarrant1() != null && ((WayBill)srlwb.getObjList()[0]).getWarrant1().getDriver() != null && driver.equals((Object)((WayBill)srlwb.getObjList()[0]).getWarrant1().getDriver())) {
                warrant_id = ((WayBill)srlwb.getObjList()[0]).getWarrant1().getId();
                this.logger.debug((Object)("Get warrant1: " + ((WayBill)srlwb.getObjList()[0]).getWarrant1()));
            } else if (((WayBill)srlwb.getObjList()[0]).getWarrant2() != null && ((WayBill)srlwb.getObjList()[0]).getWarrant2().getDriver() != null && driver.equals((Object)((WayBill)srlwb.getObjList()[0]).getWarrant2().getDriver())) {
                warrant_id = ((WayBill)srlwb.getObjList()[0]).getWarrant2().getId();
                this.logger.debug((Object)("Get warrant2: " + ((WayBill)srlwb.getObjList()[0]).getWarrant2()));
            }
        }
        if (warrant_id == null) {
            RouteScheduleWSProxy.SearchResultListRouteSchedule srlrs;
            Warrant w = new Warrant();
            w.setDriver(driver);
            w.setTransport(transport);
            w.setWarrantDate(date);
            w.setRsType(rsType);
            w.setShiftType(shiftType);
            RouteScheduleSearchCriteria rsSc = new RouteScheduleSearchCriteria();
            rsSc.setRouteIdList(new Long[]{route.getId()});
            rsSc.setActiveOnDate(date);
            if (group != null) {
                rsSc.setPrimaryGroupId(group.getId());
            }
            if ((srlrs = this.routeScheduleProxy.getList(this.context, rsSc)) != null && !srlrs.isEmpty()) {
                w.setRouteSchedule((RouteSchedule)srlrs.getObjList()[0]);
            }
            w.setStartAt(runAt);
            w.setStartAtRoute(runAt);
            w.setEndAt(returnAt);
            w.setEndAtRoute(returnAt);
            w = this.warrantProxy.save(this.context, w);
            if (userId != null) {
                w.setCreatedBy_id(userId);
                w = this.warrantProxy.save(this.context, w);
            }
            WayBill wb = new WayBill();
            wb.setTransport(transport);
            if (shiftType.getDescription().equalsIgnoreCase("2")) {
                wb.setWarrant2(w);
                this.logger.debug((Object)("Create new warrant2: " + w));
            } else {
                wb.setWarrant1(w);
                this.logger.debug((Object)("Create new warrant1: " + w));
            }
            wb.setWaybillDate(date);
            Integer num = this.proxy.getMaxNumber(this.context, date);
            if (num != null) {
                num = num + 1;
                wb.setWaybillIndex(num);
                wb.setWaybillNum(num.toString());
            }
            wb = this.proxy.save(this.context, wb);
            if (userId != null) {
                wb.setCreatedBy_id(userId);
                wb = this.proxy.save(this.context, wb);
                this.logger.debug((Object)("Create new waybill: " + wb));
            }
            waybill_id = wb.getId();
            warrant_id = w.getId();
        }
        if (waybill_id != null && warrant_id != null) {
            WaybillRunSearchCriteria wbrSc = new WaybillRunSearchCriteria();
            wbrSc.setRouteIdList(new Long[]{routeId});
            wbrSc.setShiftTypeIdList(new Long[]{shiftTypeId});
            wbrSc.setRunScheduleTypeIdList(new Long[]{scheduleTypeId});
            wbrSc.setActualFlagList(new Integer[]{new Integer(1)});
            wbrSc.setWaybillDateFrom(CommonSearchCriteria.beginOfDay((Date)date));
            wbrSc.setWaybillDateTill(CommonSearchCriteria.endOfDay((Date)date));
            wbrSc.setWarrantIdList(new Long[]{emptyWarrantId});
            wbrSc.setWaybillIdList(new Long[]{emptyWaybillId});
            wbrSc.setCount(Integer.valueOf(Integer.MAX_VALUE));
            wbrSc.setRunAtFrom(HelpUtils.copyTimeFromDate(date, runAt));
            wbrSc.setReturnAtTill(returnAt);
            WaybillRunWSProxy.SearchResultListWaybillRun srlwbr = this.waybillRunProxy.getList(this.context, wbrSc);
            this.logger.debug((Object)("Get list waybillRun: " + srlwbr));
            ArrayList<RouteScheduleRunExt> listRSR = new ArrayList<RouteScheduleRunExt>();
            if (srlwbr != null && !srlwbr.isEmpty()) {
                int i = 0;
                while (i < srlwbr.getObjList().length) {
                    listRSR.add((RouteScheduleRunExt)((WaybillRun)srlwbr.getObjList()[i]).getRun());
                    ++i;
                }
            }
            WayBillExt waybillExt = this.fillWaybillExt(waybill_id);
            if (shiftType != null && shiftType.getCode() != null && shiftType.getCode().equalsIgnoreCase("2")) {
                this.adderRouteScheduleRunInWaybill(waybillExt, listRSR, 2);
            } else {
                this.adderRouteScheduleRunInWaybill(waybillExt, listRSR, 1);
            }
            this.addRecordInJournalDispatcherYOTK(new Date(), routeNum, rsType, shiftType, null, null, transport.getGarageNum(), driver.getTabNum(), "\u041d\u043e\u0432\u044b\u0439 \u0431\u043e\u0440\u0442", group, new Integer(0), new String("\u041d\u043e\u0432\u044b\u0439 \u0431\u043e\u0440\u0442 \u043e\u0442 " + df_date.format(date)));
            return NO_ERROR;
        }
        return WAYBILL_OR_WARRANT_NOT_FOUND;
    }

    public Integer ZeroTransport(Date date, TransportStop startStop, TransportStop endStop, BigDecimal length, Date runAt, Date returnAt, Long shiftTypeId, Long scheduleTypeId, Long transportId) {
        long minute;
        this.logger.debug((Object)"Zero Transport start");
        if (this.context == null) {
            return CONTEXT_IS_NOT_INITIALIZED;
        }
        if (startStop == null) {
            return TRANSPORT_STOP_BEGIN_IS_NULL;
        }
        if (endStop == null) {
            return TRANSPORT_STOP_END_IS_NULL;
        }
        if (length == null) {
            return LENGTH_IS_NULL;
        }
        if (runAt == null) {
            return RUN_AT_IS_NULL;
        }
        if (returnAt == null) {
            return RETURN_AT_IS_NULL;
        }
        if (transportId == null) {
            return TRANSPORT_IS_NULL;
        }
        if (date == null) {
            return DATE_IS_NULL;
        }
        if (scheduleTypeId == null) {
            return SCHEDULE_TYPE_ID_IS_NULL;
        }
        if (shiftTypeId == null) {
            return SHIFT_TYPE_ID_IS_NULL;
        }
        this.logger.debug((Object)("Transport id: " + transportId));
        this.logger.debug((Object)("Date: " + date));
        this.logger.debug((Object)("Start stop: " + startStop));
        this.logger.debug((Object)("End stop: " + endStop));
        this.logger.debug((Object)("Length: " + length));
        this.logger.debug((Object)("Run at: " + runAt));
        this.logger.debug((Object)("Return at: " + returnAt));
        this.logger.debug((Object)("Run schedule type id: " + scheduleTypeId));
        this.logger.debug((Object)("Shift type id: " + shiftTypeId));
        RunScheduleType rsType = this.runScheduleTypeProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, scheduleTypeId);
        ShiftType shiftType = this.shiftTypeProxy._universalGetCurrentObject((ru.infor.ws.proxy.interfaces.InvocationContext)this.context, shiftTypeId);
        RouteSchedule routeSchedule = null;
        WayBillSearchCriteria wbSc = new WayBillSearchCriteria();
        wbSc.setTransportIdList(new Long[]{transportId});
        wbSc.setWaybillDateFrom(CommonSearchCriteria.beginOfDay((Date)date));
        wbSc.setWaybillDateTill(CommonSearchCriteria.endOfDay((Date)date));
        WayBillWSProxy.SearchResultListWayBill srList = this.proxy.getList(this.context, wbSc);
        WayBill waybill = null;
        if (srList != null && !srList.isEmpty() && srList.getObjList()[0] != null) {
            waybill = (WayBill)srList.getObjList()[0];
            this.logger.debug((Object)("Get waybill: " + waybill));
            if (this.getSecondShiftType() != null && this.getSecondShiftType().equals((Object)shiftType) && ((WayBill)srList.getObjList()[0]).getWarrant2() != null) {
                routeSchedule = ((WayBill)srList.getObjList()[0]).getWarrant2().getRouteSchedule();
            } else if (((WayBill)srList.getObjList()[0]).getWarrant1() != null) {
                routeSchedule = ((WayBill)srList.getObjList()[0]).getWarrant1().getRouteSchedule();
            }
        }
        RouteExt route = null;
        String name = RouteExt.getNameZeroUnderStop(startStop, endStop);
        route = this.getRouteWithTransportStop(name, name, name, startStop, endStop, new Integer((int)(minute = (returnAt.getTime() - runAt.getTime()) / 60000L)), length.doubleValue());
        if (!route.getCreatedBy_id().equals(waybill.getCreatedBy_id())) {
            RouteWSProxy routeProxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);
            route.setCreatedBy_id(waybill.getCreatedBy_id());
            route = routeProxy.save(this.context, (Route)route);
        }
        this.logger.debug((Object)("Get route: " + (Object)((Object)route)));
        RouteScheduleRun rsr = this.newRouteScheduleRunLiteIsDeleted(routeSchedule, route, HelpUtils.getRouteScheduleRunTime(runAt), HelpUtils.getRouteScheduleRunTime(returnAt), startStop, endStop, 0, 4, rsType, shiftType, null);
        ArrayList<RouteScheduleRunExt> listRSR = new ArrayList<RouteScheduleRunExt>();
        listRSR.add((RouteScheduleRunExt)rsr);
        this.logger.debug((Object)("listRSR: " + listRSR));
        WayBillExt waybillExt = this.fillWaybillExt(waybill);
        if (shiftType != null && shiftType.getCode() != null && shiftType.getCode().equalsIgnoreCase("2")) {
            this.adderRouteScheduleRunInWaybill(waybillExt, listRSR, 2);
            waybillExt.getWarrant2().getDriver().getTabNum();
        } else {
            this.adderRouteScheduleRunInWaybill(waybillExt, listRSR, 1);
            waybillExt.getWarrant1().getDriver().getTabNum();
        }
        return NO_ERROR;
    }

    public Integer addSimpleRunTransport(WayBillExt wb, Integer shift, Route route, Date runAt, Date returnAt) {
        this.logger.debug((Object)"Simple Transport start");
        if (this.context == null) {
            return CONTEXT_IS_NOT_INITIALIZED;
        }
        if (runAt == null) {
            return RUN_AT_IS_NULL;
        }
        if (returnAt == null) {
            return RETURN_AT_IS_NULL;
        }
        if (wb == null) {
            return WAYBILL_ID_IS_NULL;
        }
        if (shift == null) {
            return SHIFT_TYPE_IS_NULL;
        }
        if (route == null) {
            return ROUTE_IS_NULL;
        }
        this.logger.debug((Object)("Transport id: " + wb.getTransport().getId()));
        this.logger.debug((Object)("Date: " + df_date_only.format(wb.getWaybillDate())));
        this.logger.debug((Object)("Run at: " + df_time_only.format(runAt)));
        this.logger.debug((Object)("Return at: " + df_time_only.format(returnAt)));
        this.logger.debug((Object)("Route id: " + route.getId()));
        this.logger.debug((Object)("Shift: " + shift));
        TransportStop startStop = null;
        TransportStop endStop = null;
        Route2CheckPointLinkSearchCriteria r2cplSc = new Route2CheckPointLinkSearchCriteria();
        r2cplSc.setRouteIdList(new Long[]{route.getId()});
        Route2CheckPointLinkWSProxy.SearchResultListRoute2CheckPointLink srList = this.route2CheckPointLinkProxy.getList(this.context, r2cplSc);
        if (srList != null && !srList.isEmpty()) {
            int i = 0;
            while (i < srList.getObjList().length) {
                if ("\u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f".equals(((Route2CheckPointLink)srList.getObjList()[i]).getType().getDescription().toLowerCase())) {
                    startStop = ((Route2CheckPointLink)srList.getObjList()[i]).getStop();
                } else if ("\u043a\u043e\u043d\u0435\u0447\u043d\u0430\u044f".equals(((Route2CheckPointLink)srList.getObjList()[i]).getType().getDescription().toLowerCase())) {
                    endStop = ((Route2CheckPointLink)srList.getObjList()[i]).getStop();
                }
                ++i;
            }
        }
        RouteScheduleRun rsr = null;
        rsr = shift == 1 ? this.newRouteScheduleRunLiteIsDeleted(wb.getWarrant1().getRouteSchedule(), route, HelpUtils.getRouteScheduleRunTime(runAt), HelpUtils.getRouteScheduleRunTime(returnAt), startStop, endStop, 0, 4, wb.getWarrant1().getRsType(), wb.getWarrant1().getShiftType(), null) : this.newRouteScheduleRunLiteIsDeleted(wb.getWarrant2().getRouteSchedule(), route, HelpUtils.getRouteScheduleRunTime(runAt), HelpUtils.getRouteScheduleRunTime(returnAt), startStop, endStop, 0, 4, wb.getWarrant2().getRsType(), wb.getWarrant2().getShiftType(), null);
        ArrayList<RouteScheduleRunExt> listRSR = new ArrayList<RouteScheduleRunExt>();
        listRSR.add((RouteScheduleRunExt)rsr);
        this.logger.debug((Object)("listRSR: " + listRSR));
        this.adderRouteScheduleRunInWaybill(wb, listRSR, shift);
        return NO_ERROR;
    }
}

