/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.waybill.currentday.currentdaymap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.waybill.currentday.currentdaymap.MapValueDevicesStates;
import ru.infor.ws.objects.vms.NDDataThin;
import ru.infor.ws.objects.vms.ext.WaybillRealTimeExt;

public class MapDevicePainter<T extends JXMapViewer>
extends MapViewPainter<JXMapViewer> {
    MapValueDevicesStates mapValueDevicesStates;

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.mapValueDevicesStates = (MapValueDevicesStates)mapValueWithTrack;
    }

    @Override
    public void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.mapValueDevicesStates.getWarrantOnCurrentDay() != null) {
            WaybillRealTimeExt[] waybillRealTimeExtArray = this.mapValueDevicesStates.getWarrantOnCurrentDay().getWrt();
            int n = waybillRealTimeExtArray.length;
            int n2 = 0;
            while (n2 < n) {
                NDDataThin d;
                WaybillRealTimeExt w = waybillRealTimeExtArray[n2];
                if (this.mapValueDevicesStates.getWarrantOnCurrentDay().getShowOnMaps().contains(w.getTransportId()) && (d = w.getNddata()) != null) {
                    int y;
                    int x;
                    Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(d.getLat().doubleValue(), d.getLon().doubleValue()), map.getZoom());
                    if (vp2.contains(pointFrom)) {
                        x = (int)(pointFrom.getX() - ((RectangularShape)vp2).getX());
                        y = (int)(pointFrom.getY() - ((RectangularShape)vp2).getY());
                        g.translate(x, y);
                        this.paintS(g, w);
                        g.translate(-x, -y);
                    } else if (vp3.contains(pointFrom)) {
                        x = (int)(pointFrom.getX() - ((RectangularShape)vp3).getX());
                        y = (int)(pointFrom.getY() - ((RectangularShape)vp3).getY());
                        g.translate(x, y);
                        this.paintS(g, w);
                        g.translate(-x, -y);
                    }
                }
                ++n2;
            }
        }
    }

    protected void paintS(Graphics2D g, WaybillRealTimeExt w) {
        NDDataThin d = w.getNddata();
        Color c = Color.RED;
        Color line = new Color(c.getRed(), c.getGreen(), c.getBlue(), 255);
        Color cFill = new Color(c.getRed(), c.getGreen(), c.getBlue(), 50);
        Color cText = Color.BLACK;
        if (d.getNorthAngle() == null || d.getNorthAngle() < 0.0) {
            g.setColor(line);
            g.fillOval(-10, -10, 10, 10);
        } else {
            g.rotate(Math.toRadians(d.getNorthAngle() + 180.0));
            Polygon pBody = new Polygon();
            pBody.addPoint(-6, 16);
            pBody.addPoint(-8, 13);
            pBody.addPoint(-8, -15);
            pBody.addPoint(8, -15);
            pBody.addPoint(8, 13);
            pBody.addPoint(6, 16);
            g.setColor(Color.BLUE);
            g.drawPolygon(pBody);
            g.fillPolygon(pBody);
            Polygon wheel1 = new Polygon();
            wheel1.addPoint(-10, 10);
            wheel1.addPoint(-10, 6);
            wheel1.addPoint(-7, 6);
            wheel1.addPoint(-7, 10);
            Polygon wheel2 = new Polygon();
            wheel2.addPoint(10, 10);
            wheel2.addPoint(10, 6);
            wheel2.addPoint(7, 6);
            wheel2.addPoint(7, 10);
            Polygon wheel3 = new Polygon();
            wheel3.addPoint(-10, -10);
            wheel3.addPoint(-10, -6);
            wheel3.addPoint(-7, -6);
            wheel3.addPoint(-7, -10);
            Polygon wheel4 = new Polygon();
            wheel4.addPoint(10, -10);
            wheel4.addPoint(10, -6);
            wheel4.addPoint(7, -6);
            wheel4.addPoint(7, -10);
            Polygon window = new Polygon();
            window.addPoint(-4, 12);
            window.addPoint(-6, 8);
            window.addPoint(6, 8);
            window.addPoint(4, 12);
            Polygon bumper = new Polygon();
            bumper.addPoint(-5, 17);
            bumper.addPoint(-5, 15);
            bumper.addPoint(5, 15);
            bumper.addPoint(5, 17);
            g.setColor(Color.BLACK);
            g.drawPolygon(wheel1);
            g.fillPolygon(wheel1);
            g.drawPolygon(wheel2);
            g.fillPolygon(wheel2);
            g.drawPolygon(wheel3);
            g.fillPolygon(wheel3);
            g.drawPolygon(wheel4);
            g.fillPolygon(wheel4);
            g.drawPolygon(bumper);
            g.fillPolygon(bumper);
            g.setColor(Color.WHITE);
            g.drawPolygon(window);
            g.fillPolygon(window);
            g.rotate(-Math.toRadians(d.getNorthAngle() + 180.0));
        }
        g.setColor(cText);
        FontMetrics f = g.getFontMetrics();
        int h = f.getHeight();
        String[] hint = new String[]{w.getTransportGarNum()};
        int l = hint.length;
        int ww = 0;
        int i = 0;
        while (i < l) {
            int w1 = f.stringWidth(hint[i]);
            if (w1 > ww) {
                ww = w1;
            }
            ++i;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(-ww + ww / 2, -h * l - 20, ww + 10, h * l + 3);
        Polygon p = new Polygon();
        p.addPoint((int)bounds.getMinX(), (int)bounds.getMinY());
        p.addPoint((int)bounds.getMinX(), (int)bounds.getMaxY());
        p.addPoint((int)(bounds.getMinX() + ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
        p.addPoint(0, 0);
        p.addPoint((int)(bounds.getMinX() + 2.0 * ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
        p.addPoint((int)bounds.getMaxX(), (int)bounds.getMaxY());
        p.addPoint((int)bounds.getMaxX(), (int)bounds.getMinY());
        g.setColor(cFill);
        g.fillPolygon(p);
        g.setColor(line);
        g.drawPolygon(p);
        g.setColor(cText);
        g.setColor(cText);
        int i2 = 0;
        while (i2 < l) {
            g.drawString(hint[i2], (int)bounds.getMinX() + 5, (int)bounds.getMinY() + h + i2 * h);
            ++i2;
        }
    }
}

