/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.weather;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.weather.WeatherStationDirectoryViewer;
import ru.blok.vms.ui.weather.graphics.GraphicsViewer;
import ru.blok.vms.ui.weather.graphics.Parameter;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.swing.viewers.TimeFormatViewer;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.date.DateWithoutButton;
import ru.infor.client.soap.proxy.vms.WeatherConditionWSProxy;
import ru.infor.ws.objects.vms.WeatherConditionSearchCriteria;
import ru.infor.ws.objects.vms.entities.WeatherCondition;
import ru.infor.ws.objects.vms.entities.WeatherStation;

@ListView(views={@View(title="\u0413\u0440\u0430\u0444\u0438\u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043f\u043e\u0433\u043e\u0434\u044b", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class WeatherGraphics {
    WeatherStation station;
    private Date dateFrom;
    private Date dateTill;
    WeatherConditionWSProxy proxy = (WeatherConditionWSProxy)CurrentProxyFactory.getProxy(WeatherCondition.class);
    private BeanViewerAction<ViewerContext> apply = new BeanViewerAction<ViewerContext>(){

        public String getName() {
            return "\u041e\u0442\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u044c \u0433\u0440\u0430\u0444\u0438\u043a";
        }

        public void actionPerformed(Object message) {
            ArrayList<Parameter> pars;
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            if (WeatherGraphics.this.station == null || WeatherGraphics.this.getDateFrom() == null || WeatherGraphics.this.getDateTill() == null) {
                InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u0434\u0430\u0442\u044b \u0438 \u043c\u0435\u0442\u0435\u043e\u0441\u0442\u0430\u043d\u0446\u0438\u044e"), new BeanViewerAction[]{new MessageOKButton()});
                return;
            }
            WeatherConditionSearchCriteria sc = (WeatherConditionSearchCriteria)WeatherGraphics.this.proxy._getSearchCriteriaTemplate();
            sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
            sc.setDateFrom(WeatherGraphics.this.getDateFrom());
            sc.setDateTill(WeatherGraphics.this.getDateTill());
            sc.setStationIdList(new Long[]{WeatherGraphics.this.station.getId()});
            Object[] oo = WeatherGraphics.this.proxy.getList(InitializedVariable.context, sc).getObjList();
            WeatherGraphics.this.valuesTemperature = null;
            WeatherGraphics.this.valuesHydrarity = null;
            WeatherGraphics.this.valuesPreasure = null;
            WeatherGraphics.this.valuesWindSpeed = null;
            if (WeatherGraphics.this.isShowTemperature()) {
                pars = new ArrayList<Parameter>();
                pars.add(new Parameter("\u0422\u0435\u043c\u043f\u0435\u0440\u0430\u0442\u0443\u0440\u0430", 0, Color.RED));
                WeatherGraphics.this.valuesTemperature = new Object[]{pars, oo};
            }
            if (WeatherGraphics.this.isShowHydrarity()) {
                pars = new ArrayList();
                pars.add(new Parameter("\u041e\u0442\u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0432\u043b\u0430\u0436\u043d\u043e\u0441\u0442\u044c \u0432\u043e\u0437\u0434\u0443\u0445\u0430", 1, Color.BLUE));
                WeatherGraphics.this.valuesHydrarity = new Object[]{pars, oo};
            }
            if (WeatherGraphics.this.isShowPreasure()) {
                pars = new ArrayList();
                pars.add(new Parameter("\u0410\u0442\u043c\u043e\u0441\u0444\u0435\u0440\u043d\u043e\u0435 \u0434\u0430\u0432\u043b\u0435\u043d\u0438\u0435", 2, Color.MAGENTA));
                WeatherGraphics.this.valuesPreasure = new Object[]{pars, oo};
            }
            if (WeatherGraphics.this.isShowWindSpeed()) {
                pars = new ArrayList();
                pars.add(new Parameter("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0432\u0435\u0442\u0440\u0430", 3, Color.GREEN));
                WeatherGraphics.this.valuesWindSpeed = new Object[]{pars, oo};
            }
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("valuesTemperature");
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("valuesHydrarity");
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("valuesPreasure");
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("valuesWindSpeed");
        }
    };
    Object[] valuesTemperature;
    Object[] valuesHydrarity;
    Object[] valuesPreasure;
    Object[] valuesWindSpeed;
    private boolean showTemperature = true;
    private boolean showHydrarity = true;
    private boolean showPreasure = true;
    private boolean showWindSpeed = true;

    public WeatherGraphics() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        this.dateFrom = c.getTime();
        c.add(5, 1);
        this.dateTill = c.getTime();
    }

    @ListField(fields={@Field(title="\u0421  ", order=10, viewer={DateWithoutButton.class}, propertiesLayout="Split1/h/l/0.3:m1/wrap 1:0/fillx, wrap 4# w 105", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    @ListField(fields={@Field(title="", order=20, viewer={TimeFormatViewer.class}, propertiesLayout="Split1/h/l/0.3:m1:0#w 105", propertiesUI={"format=HH:mm:ss"})})
    public Date getTimeFrom() {
        return this.dateFrom;
    }

    public void setTimeFrom(Date dateFrom) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDateFrom());
        c2.setTime(dateFrom);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.dateFrom = c1.getTime();
    }

    @ListField(fields={@Field(title="\u043f\u043e ", order=30, viewer={DateWithoutButton.class}, propertiesLayout="Split1/h/l/0.3:m1:0", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDateTill() {
        return this.dateTill;
    }

    public void setDateTill(Date dateTill) {
        this.dateTill = dateTill;
    }

    @ListField(fields={@Field(title="", order=40, viewer={TimeFormatViewer.class}, propertiesLayout="Split1/h/l/0.3:m1:0", propertiesUI={"format=HH:mm:ss"})})
    public Date getTimeTill() {
        return this.dateTill;
    }

    public void setTimeTill(Date dateTill) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDateTill());
        c2.setTime(dateTill);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.dateTill = c1.getTime();
    }

    @ListField(fields={@Field(title="\u041c\u0435\u0442\u0435\u043e\u0441\u0442\u0430\u043d\u0446\u0438\u044f", order=50, viewer={WeatherStationDirectoryViewer.class}, propertiesLayout="Split1/h/l/0.3:m1:0# spanx 3")})
    public WeatherStation getStation() {
        return this.station;
    }

    public void setStation(WeatherStation station) {
        this.station = station;
    }

    @ListField(fields={@Field(title="", order=80, viewer={ActionButton.class}, propertiesLayout="Split1/h/l/0.3:m1:0# spanx 3")})
    public BeanViewerAction<ViewerContext> getApply() {
        return this.apply;
    }

    @ListField(fields={@Field(title="", order=100, viewer={GraphicsViewer.class}, readOnly=true, propertiesLayout="Split1/h/r/0.3")})
    public Object[] getValuesTemperature() {
        return this.valuesTemperature;
    }

    @ListField(fields={@Field(title="", order=100, viewer={GraphicsViewer.class}, readOnly=true, propertiesLayout="Split1/h/r/0.3")})
    public Object[] getValuesHydrarity() {
        return this.valuesHydrarity;
    }

    @ListField(fields={@Field(title="", order=100, viewer={GraphicsViewer.class}, readOnly=true, propertiesLayout="Split1/h/r/0.3")})
    public Object[] getValuesPreasure() {
        return this.valuesPreasure;
    }

    @ListField(fields={@Field(title="", order=100, viewer={GraphicsViewer.class}, readOnly=true, propertiesLayout="Split1/h/r/0.3")})
    public Object[] getValuesWindSpeed() {
        return this.valuesWindSpeed;
    }

    @ListField(fields={@Field(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u0442\u0435\u043c\u043f\u0435\u0440\u0430\u0442\u0443\u0440\u0443", order=210, propertiesLayout="Split1/h/l/0.3:m1:1/wrap 2, fillx")})
    public boolean isShowTemperature() {
        return this.showTemperature;
    }

    public void setShowTemperature(boolean showTemperature) {
        this.showTemperature = showTemperature;
    }

    @ListField(fields={@Field(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u0443\u044e \u0432\u043b\u0430\u0436\u043d\u043e\u0441\u0442\u044c \u0432\u043e\u0437\u0434\u0443\u0445\u0430", order=220, propertiesLayout="Split1/h/l/0.3:m1:1")})
    public boolean isShowHydrarity() {
        return this.showHydrarity;
    }

    public void setShowHydrarity(boolean showHydrarity) {
        this.showHydrarity = showHydrarity;
    }

    @ListField(fields={@Field(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u0430\u0442\u043c\u043e\u0441\u0444\u0435\u0440\u043d\u043e\u0435 \u0434\u0430\u0432\u043b\u0435\u043d\u0438\u0435", order=230, propertiesLayout="Split1/h/l/0.3:m1:1")})
    public boolean isShowPreasure() {
        return this.showPreasure;
    }

    public void setShowPreasure(boolean showPreasure) {
        this.showPreasure = showPreasure;
    }

    @ListField(fields={@Field(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c c\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0432\u0435\u0442\u0440\u0430", order=240, propertiesLayout="Split1/h/l/0.3:m1:1")})
    public boolean isShowWindSpeed() {
        return this.showWindSpeed;
    }

    public void setShowWindSpeed(boolean showWindSpeed) {
        this.showWindSpeed = showWindSpeed;
    }
}

