/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.weather;

import java.util.logging.Logger;
import ru.blok.common.ui.directories.FRCAsyncDirectoryViewer;
import ru.blok.common.ui.list.ObjectUIList;
import ru.blok.vms.ui.weather.WeatherStationList;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.simple.ExtendedDirectoryViewer;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.vms.WeatherStationSearchCriteria;
import ru.infor.ws.objects.vms.entities.WeatherStation;
import ru.infor.ws.objects.vms.entities.ext.WeatherStationExt;

public class WeatherStationDirectoryViewer<T>
extends FRCAsyncDirectoryViewer<T> {
    WeatherStationList list;

    public Class getTableCellViewerClass() {
        return WeatherStationDirectoryCellViewer.class;
    }

    public WeatherStationDirectoryViewer(UIFactory<T> factory) {
        super(factory);
    }

    public void setContentClass(Class<?> cls) {
        super.setContentClass(WeatherStationExt.class);
    }

    public String objectToString(Object o) {
        if (o == null) {
            return super.objectToString(o);
        }
        return ((WeatherStation)o).getName();
    }

    public CommonSearchCriteria updateSearchCriteria(CommonSearchCriteria sc, String value) {
        ((WeatherStationSearchCriteria)sc).setQuickSearch(value);
        return sc;
    }

    public void buttonActionPerfomed() {
        try {
            if (this.list == null) {
                this.list = new WeatherStationList();
            }
            this.getFactory().newPage(WeatherStation.class, WeatherStationList.class, (Object)this.list, this.getViewerContext(), "filterInList");
            Object o = this.getValue();
            ((ObjectUIList)this.list.getItems()).setSelection(o);
        }
        catch (Exception exception) {
            Logger.getLogger(ExtendedDirectoryViewer.class.getName()).severe("Can't create directory presentation " + this.getPresentationClass().getName());
        }
    }

    public static class WeatherStationDirectoryCellViewer<T>
    extends DefaultTableCellViewer<T> {
        public WeatherStationDirectoryCellViewer(UIFactory<T> factory) {
            super(factory);
        }

        public void setValue(Object object) {
            super.setValue((Object)(object == null ? "" : ((WeatherStation)object).getName()));
        }
    }
}

