/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.weather.graphics;

import java.awt.Color;
import java.awt.Paint;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import ru.blok.vms.ui.weather.graphics.Parameter;
import ru.infor.beanviewer.core.ChartPanel;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.common.BeanCopierGenerator;
import ru.infor.ws.objects.vms.entities.WeatherCondition;

public class GraphicsViewer<T>
extends FieldViewer<T>
implements SwingItem {
    static SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private T panel;
    private List<Parameter> parameters;
    private ArrayList<WeatherCondition> datasTemp;
    private Object[] datas;
    ChartPanel chartPanel;

    public GraphicsViewer(UIFactory<T> factory) {
        super(factory);
        this.panel = factory.getAugmentPanel();
    }

    public int getShape() {
        return 1;
    }

    public T getComponent(boolean isSelected, boolean hasFocus) {
        return this.panel;
    }

    public void setValue(Object object) {
        Object[] o = (Object[])object;
        if (o == null) {
            this.parameters = new ArrayList<Parameter>();
            this.datas = new Object[0];
        } else {
            this.parameters = (List)o[0];
            this.datas = (Object[])o[1];
        }
        this.init();
    }

    private JFreeChart createChart(List<TimeSeriesCollection> datasets) {
        XYPlot plot = new XYPlot();
        int i = 0;
        for (TimeSeriesCollection ds : datasets) {
            NumberAxis va = new NumberAxis(this.parameters.get(i).getName());
            va.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            plot.setDataset(i, (XYDataset)ds);
            plot.setRangeAxis(i, (ValueAxis)va);
            plot.mapDatasetToRangeAxis(i, i);
            StandardXYItemRenderer r = new StandardXYItemRenderer();
            r.setSeriesPaint(0, (Paint)this.parameters.get(i).getColor());
            plot.setRenderer(i, (XYItemRenderer)r);
            ++i;
        }
        plot.setDomainAxis((ValueAxis)new DateAxis("\u0412\u0440\u0435\u043c\u044f"));
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.getLegend().setVisible(false);
        return chart;
    }

    private void init() {
        this.getFactory().clearContainer(this.panel);
        ArrayList<TimeSeriesCollection> cc = new ArrayList<TimeSeriesCollection>();
        HashMap renders = new HashMap();
        if (this.parameters != null && this.parameters.size() > 0 && this.datas != null && this.datas.length > 0) {
            this.datasTemp = new ArrayList(this.datas.length);
            int i = 0;
            while (i < this.datas.length) {
                WeatherCondition ndd = new WeatherCondition();
                BeanCopierGenerator.getInstance(WeatherCondition.class, (boolean)false).copy((Object)((WeatherCondition)this.datas[i]), (Object)ndd, null);
                this.datasTemp.add(i, ndd);
                ++i;
            }
            for (Parameter parameter : this.parameters) {
                if (parameter == null) continue;
                String name = parameter.getName();
                TimeSeriesCollection tsc = new TimeSeriesCollection();
                TimeSeries ds = new TimeSeries((Comparable)((Object)name));
                switch (parameter.getType()) {
                    case 0: {
                        for (WeatherCondition n : this.datasTemp) {
                            if (n.getTemperature() == null) continue;
                            ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getDate()), (Number)n.getTemperature());
                        }
                        break;
                    }
                    case 1: {
                        for (WeatherCondition n : this.datasTemp) {
                            if (n.getHydrarity() == null) continue;
                            ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getDate()), (Number)n.getHydrarity());
                        }
                        break;
                    }
                    case 2: {
                        for (WeatherCondition n : this.datasTemp) {
                            if (n.getPreasure() == null) continue;
                            ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getDate()), (Number)n.getPreasure());
                        }
                        break;
                    }
                    case 3: {
                        for (WeatherCondition n : this.datasTemp) {
                            if (n.getWindSpeed() == null) continue;
                            ds.addOrUpdate((RegularTimePeriod)new FixedMillisecond(n.getDate()), (Number)n.getWindSpeed());
                        }
                        break;
                    }
                }
                tsc.addSeries(ds);
                cc.add(tsc);
            }
            JFreeChart f = this.createChart(cc);
            this.chartPanel = (ChartPanel)this.getFactory().getChartPanel(f);
            XYPlot plot = (XYPlot)this.chartPanel.getChart().getPlot();
            Iterator iterator = renders.keySet().iterator();
            while (iterator.hasNext()) {
                int i2 = (Integer)iterator.next();
                plot.setRenderer(i2, (XYItemRenderer)renders.get(i2));
            }
            this.getFactory().putObjectToContainer((Object)this.chartPanel, this.panel, null);
        }
        this.getFactory().revalidate(this.panel);
    }

    public Object getValue() {
        return null;
    }

    public void setChangeValueAction(BeanViewerAction<ViewerContext> changeAction) {
    }

    public void setEditable(boolean editable) {
    }
}

