/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.weather.maps;

import java.util.Calendar;
import java.util.Date;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.weather.maps.MapValuePoint;
import ru.blok.vms.ui.weather.maps.MapViewerWeather;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.swing.viewers.TimeFormatViewer;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.date.DateWithoutButton;
import ru.infor.client.soap.proxy.vms.WeatherConditionWSProxy;
import ru.infor.ws.objects.vms.WeatherConditionSearchCriteria;
import ru.infor.ws.objects.vms.entities.WeatherCondition;

@ListView(views={@View(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0442\u043e\u0447\u0435\u0447\u043d\u044b\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class WeatherGraphicsMap
extends CommonObjectWithKey {
    public Double[] coord;
    private Date date;
    WeatherConditionWSProxy proxy = (WeatherConditionWSProxy)CurrentProxyFactory.getProxy(WeatherCondition.class);
    private BeanViewerAction<ViewerContext> apply = new BeanViewerAction<ViewerContext>(){

        public String getName() {
            return "\u041e\u0442\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u044c \u0433\u0440\u0430\u0444\u0438\u043a";
        }

        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            if (WeatherGraphicsMap.this.getDate() == null) {
                InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u0434\u0430\u0442\u0443"), new BeanViewerAction[]{new MessageOKButton()});
                return;
            }
            WeatherConditionSearchCriteria sc = (WeatherConditionSearchCriteria)WeatherGraphicsMap.this.proxy._getSearchCriteriaTemplate();
            sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            c1.setTime(WeatherGraphicsMap.this.getDate());
            c1.set(12, 0);
            c1.set(13, 0);
            c1.set(14, 0);
            c2.setTime(c1.getTime());
            c2.set(12, 59);
            c2.set(13, 59);
            c2.set(14, 999);
            sc.setDateFrom(c1.getTime());
            sc.setDateTill(c2.getTime());
            Object[] oo = WeatherGraphicsMap.this.proxy.getList(InitializedVariable.context, sc).getObjList();
            WeatherGraphicsMap.this.valuePoint.setWeatherCondition(oo);
            WeatherGraphicsMap.this.valuePoint.setShowHydrarity(WeatherGraphicsMap.this.showHydrarity);
            WeatherGraphicsMap.this.valuePoint.setShowPreasure(WeatherGraphicsMap.this.showPreasure);
            WeatherGraphicsMap.this.valuePoint.setShowTemperature(WeatherGraphicsMap.this.showTemperature);
            WeatherGraphicsMap.this.valuePoint.setShowWindSpeed(WeatherGraphicsMap.this.showWindSpeed);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("valuePoint");
        }
    };
    MapValuePoint valuePoint;
    private boolean showTemperature = true;
    private boolean showHydrarity = true;
    private boolean showPreasure = true;
    private boolean showWindSpeed = true;

    public WeatherGraphicsMap(String keyPage) {
        super(keyPage);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        this.date = c.getTime();
        this.coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)keyPage));
        this.valuePoint = new MapValuePoint(this.coord[0], this.coord[1], this.coord[2].intValue());
    }

    @ListField(fields={@Field(title="\u0414\u0430\u0442\u0430", order=10, viewer={DateWithoutButton.class}, propertiesLayout="Split1/h/l/0.3:m1:0/fillx, wrap 4# w 105", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @ListField(fields={@Field(title="\u0427\u0430\u0441", order=20, viewer={TimeFormatViewer.class}, propertiesLayout="Split1/h/l/0.3:m1:0#w 100", propertiesField={"format=HH"})})
    public Date getTime() {
        return this.date;
    }

    public void setTime(Date date) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDate());
        c2.setTime(date);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.date = c1.getTime();
    }

    @ListField(fields={@Field(title="", order=80, viewer={ActionButton.class}, propertiesLayout="Split1/h/l/0.3:m1:0# spanx 3")})
    public BeanViewerAction<ViewerContext> getApply() {
        return this.apply;
    }

    @ListField(fields={@Field(title="", order=100, viewer={MapViewerWeather.class}, readOnly=true, propertiesLayout="Split1/h/r/0.3")})
    public MapValuePoint getValuePoint() {
        return this.valuePoint;
    }

    public void setValuePoint(MapValuePoint valuePoint) {
        this.valuePoint = valuePoint;
    }

    @ListField(fields={@Field(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u0442\u0435\u043c\u043f\u0435\u0440\u0430\u0442\u0443\u0440\u0443", order=210, propertiesLayout="Split1/h/l/0.3:m1:0## spanx 3")})
    public boolean isShowTemperature() {
        return this.showTemperature;
    }

    public void setShowTemperature(boolean showTemperature) {
        this.showTemperature = showTemperature;
    }

    @ListField(fields={@Field(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u0443\u044e \u0432\u043b\u0430\u0436\u043d\u043e\u0441\u0442\u044c \u0432\u043e\u0437\u0434\u0443\u0445\u0430", order=220, propertiesLayout="Split1/h/l/0.3:m1:0##spanx 3")})
    public boolean isShowHydrarity() {
        return this.showHydrarity;
    }

    public void setShowHydrarity(boolean showHydrarity) {
        this.showHydrarity = showHydrarity;
    }

    @ListField(fields={@Field(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u0430\u0442\u043c\u043e\u0441\u0444\u0435\u0440\u043d\u043e\u0435 \u0434\u0430\u0432\u043b\u0435\u043d\u0438\u0435", order=230, propertiesLayout="Split1/h/l/0.3:m1:0##spanx 3")})
    public boolean isShowPreasure() {
        return this.showPreasure;
    }

    public void setShowPreasure(boolean showPreasure) {
        this.showPreasure = showPreasure;
    }

    @ListField(fields={@Field(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c c\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0432\u0435\u0442\u0440\u0430", order=240, propertiesLayout="Split1/h/l/0.3:m1:0## spanx 3")})
    public boolean isShowWindSpeed() {
        return this.showWindSpeed;
    }

    public void setShowWindSpeed(boolean showWindSpeed) {
        this.showWindSpeed = showWindSpeed;
    }
}

