/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.weather.maps;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.weather.maps.MapValuePoint;
import ru.infor.ws.objects.vms.entities.WeatherCondition;
import ru.infor.ws.objects.vms.entities.WeatherStation;

public class WeatherPainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    protected MapValuePoint valuePoint;

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        this.paint(g, map, vp2, vp3);
    }

    protected void paint(Graphics2D g, T map, Rectangle2D vp2, Rectangle2D vp3) {
        if (this.valuePoint.getWeatherCondition() != null) {
            Object[] objectArray = this.valuePoint.getWeatherCondition();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                int y;
                int x;
                Object o = objectArray[n2];
                WeatherCondition w = (WeatherCondition)o;
                Point2D point = this.paintStantion(w.getStation(), map, g, vp2, vp3);
                if (vp2.contains(point)) {
                    x = (int)(point.getX() - vp2.getX());
                    y = (int)(point.getY() - vp2.getY());
                    g.translate(x, y);
                    this.paintCondidions(g, vp2, vp3, w);
                    g.translate(-x, -y);
                }
                if (vp3.contains(point)) {
                    x = (int)(point.getX() - vp3.getX());
                    y = (int)(point.getY() - vp3.getY());
                    g.translate(x, y);
                    this.paintCondidions(g, vp2, vp3, w);
                    g.translate(-x, -y);
                }
                ++n2;
            }
        }
    }

    protected Point2D paintStantion(WeatherStation w, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        int y;
        int x;
        Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(w.getLat().doubleValue(), w.getLon().doubleValue()), map.getZoom());
        if (vp2.contains(point)) {
            x = (int)(point.getX() - vp2.getX());
            y = (int)(point.getY() - vp2.getY());
            g.translate(x, y);
            this.paintStationHint(g, w.getName());
            g.translate(-x, -y);
        }
        if (vp3.contains(point)) {
            x = (int)(point.getX() - vp3.getX());
            y = (int)(point.getY() - vp3.getY());
            g.translate(x, y);
            this.paintStationHint(g, w.getName());
            g.translate(-x, -y);
        }
        return point;
    }

    private void paintStationHint(Graphics2D g, String name) {
        int h = g.getFontMetrics().getHeight();
        int w1 = g.getFontMetrics().stringWidth(name);
        Rectangle2D.Double bounds = new Rectangle2D.Double(-w1 - 15, -h - 20, w1 + 5, h + 5);
        Polygon p = new Polygon();
        p.addPoint((int)bounds.getMinX(), (int)bounds.getMinY());
        p.addPoint((int)bounds.getMinX(), (int)bounds.getMaxY());
        p.addPoint((int)(bounds.getMinX() + ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
        p.addPoint(0, 0);
        p.addPoint((int)(bounds.getMinX() + 2.0 * ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
        p.addPoint((int)bounds.getMaxX(), (int)bounds.getMaxY());
        p.addPoint((int)bounds.getMaxX(), (int)bounds.getMinY());
        Color c = Color.black;
        Color c1 = new Color(c.getRed(), c.getGreen(), c.getBlue(), 50);
        g.setColor(c1);
        g.fillPolygon(p);
        g.setColor(Color.BLACK);
        g.drawPolygon(p);
        g.drawString(name, (int)bounds.getMinX() + 5, (int)bounds.getMinY() + h);
    }

    private void paintParameterHint(Graphics2D g, Color c, String value, Integer by, Integer h, Integer dh) {
        int w1 = g.getFontMetrics().stringWidth(value);
        Rectangle2D.Double bounds = new Rectangle2D.Double(20.0, by.intValue(), w1 + 10, h + dh);
        Polygon p = new Polygon();
        p.addPoint((int)bounds.getMinX(), (int)bounds.getMinY());
        p.addPoint(0, 0);
        p.addPoint((int)bounds.getMinX(), (int)bounds.getMaxY());
        p.addPoint((int)bounds.getMaxX(), (int)bounds.getMaxY());
        p.addPoint((int)bounds.getMaxX(), (int)bounds.getMinY());
        Color c1 = new Color(c.getRed(), c.getGreen(), c.getBlue(), 50);
        g.setColor(c1);
        g.fillPolygon(p);
        g.setColor(c);
        g.drawPolygon(p);
        g.drawString(value, (int)bounds.getMinX() + 5, (int)bounds.getMinY() + h);
    }

    protected void paintCondidions(Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, WeatherCondition w) {
        String value;
        Integer count = 0;
        if (this.valuePoint.isShowHydrarity()) {
            count = count + 1;
        }
        if (this.valuePoint.isShowPreasure()) {
            count = count + 1;
        }
        if (this.valuePoint.isShowTemperature()) {
            count = count + 1;
        }
        if (this.valuePoint.isShowWindSpeed()) {
            count = count + 1;
        }
        int h = g.getFontMetrics().getHeight();
        int dh = 4;
        Integer he = (h + dh * 2) * count + dh * (count - 1);
        Integer b = -he.intValue() / 2;
        if (this.valuePoint.isShowTemperature()) {
            value = "T=";
            if (w.getTemperature() != null) {
                value = String.valueOf(value) + w.getTemperature();
            }
            this.paintParameterHint(g, Color.BLUE, value, b, h, dh);
            b = b + h + dh * 2;
        }
        if (this.valuePoint.isShowHydrarity()) {
            value = "H=";
            if (w.getHydrarity() != null) {
                value = String.valueOf(value) + w.getHydrarity();
            }
            this.paintParameterHint(g, Color.MAGENTA, value, b, h, dh);
            b = b + h + dh * 2;
        }
        if (this.valuePoint.isShowPreasure()) {
            value = "P=";
            if (w.getPreasure() != null) {
                value = String.valueOf(value) + w.getPreasure();
            }
            this.paintParameterHint(g, Color.RED, value, b, h, dh);
            b = b + h + dh * 2;
        }
        if (this.valuePoint.isShowWindSpeed()) {
            value = "WS=";
            if (w.getWindSpeed() != null) {
                value = String.valueOf(value) + w.getWindSpeed();
            }
            this.paintParameterHint(g, Color.GREEN, value, b, h, dh);
            b = b + h + dh * 2;
        }
    }

    public MapValuePoint getValuePoint() {
        return this.valuePoint;
    }

    public void setValuePoint(MapValuePoint valuePoint) {
        this.valuePoint = valuePoint;
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }
}

