/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.weather.mapspolygon;

import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import ru.blok.vms.ui.mapviewer.MapValue;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.weather.maps.WeatherPainter;
import ru.blok.vms.ui.weather.mapspolygon.MapValuePoint;
import ru.blok.vms.ui.weather.mapspolygon.WeatherPainter2;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.ws.objects.vms.entities.WeatherCondition;
import ru.infor.ws.objects.vms.entities.WeatherStation;

public class MapViewerWeather2
extends MapViewer {
    WeatherPainter<JXMapViewer> p2;

    @Override
    protected void init() {
        super.init();
        this.p2 = new WeatherPainter2<JXMapViewer>();
        this.painter.addPainter(this.p2);
    }

    public MapViewerWeather2(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    protected MapValue getNewInstance(double lat, double lon, int zoom) {
        return new MapValuePoint(this.coord[0], this.coord[1], this.coord[2].intValue());
    }

    @Override
    public void setValue(Object arg0) {
        super.setValue(arg0);
        this.p2.setValuePoint((MapValuePoint)arg0);
        this.zoomToTracks();
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected Double[] getMinMax() {
        MapValuePoint mvp = (MapValuePoint)this.getValue();
        if (mvp.getWeatherCondition() == null) {
            return null;
        }
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        Object[] objectArray = mvp.getWeatherCondition();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object t = objectArray[n2];
            WeatherStation d = ((WeatherCondition)t).getStation();
            if (minLat == null || d.getLat() < minLat) {
                minLat = d.getLat();
            }
            if (maxLat == null || d.getLat() > maxLat) {
                maxLat = d.getLat();
            }
            if (minLon == null || d.getLon() < minLon) {
                minLon = d.getLon();
            }
            if (maxLon == null || d.getLon() > maxLon) {
                maxLon = d.getLon();
            }
            if (minLat == null) {
                return null;
            }
            ++n2;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }
}

