/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.weather.mapspolygon;

import java.awt.Color;
import ru.infor.ws.objects.vms.entities.WeatherCondition;

public class Parameter {
    String name;
    String title;
    Color color;
    Double maxValue;
    Double minValue;
    public static Parameter temperature = new Parameter();
    public static Parameter hydrarity;
    public static Parameter preasure;
    public static Parameter windSpeed;

    static {
        temperature.setName("T");
        temperature.setTitle("\u0422\u0435\u043c\u043f\u0435\u0440\u0430\u0442\u0443\u0440\u0430");
        temperature.setColor(Color.RED);
        temperature.setMaxValue(50.0);
        temperature.setMinValue(-50.0);
        hydrarity = new Parameter();
        hydrarity.setName("H");
        hydrarity.setTitle("\u041e\u0442\u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0432\u043b\u0430\u0436\u043d\u043e\u0441\u0442\u044c \u0432\u043e\u0437\u0434\u0443\u0445\u0430");
        hydrarity.setColor(Color.BLUE);
        hydrarity.setMaxValue(100.0);
        hydrarity.setMinValue(0.0);
        preasure = new Parameter();
        preasure.setName("P");
        preasure.setTitle("\u0410\u0442\u043c\u043e\u0441\u0444\u0435\u0440\u043d\u043e\u0435 \u0434\u0430\u0432\u043b\u0435\u043d\u0438\u0435");
        preasure.setColor(Color.MAGENTA);
        preasure.setMaxValue(850.0);
        preasure.setMinValue(500.0);
        windSpeed = new Parameter();
        windSpeed.setName("WS");
        windSpeed.setTitle("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0432\u0435\u0442\u0440\u0430");
        windSpeed.setColor(Color.GREEN);
        windSpeed.setMaxValue(20.0);
        windSpeed.setMinValue(0.0);
    }

    public Color getColorForValue(Double value) {
        int b;
        int g;
        Double dmax = this.maxValue - this.minValue;
        Double dR = value - this.minValue;
        double k = dR / dmax;
        Color c = this.color;
        if (k > 1.0) {
            k = 1.0;
        } else if (k < 0.0) {
            k = 0.0;
        }
        int d = 200;
        int kd = (int)((double)d * k);
        int r = c.getRed();
        if (r == 0) {
            r = d - kd;
        }
        if ((g = c.getGreen()) == 0) {
            g = d - kd;
        }
        if ((b = c.getBlue()) == 0) {
            b = d - kd;
        }
        return new Color(r, g, b);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public String toString() {
        return this.title;
    }

    public void setMaxValue(Double maxValue) {
        this.maxValue = maxValue;
    }

    public Double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Double minValue) {
        this.minValue = minValue;
    }

    public double getValueFromWeatherCondition(WeatherCondition w) {
        if (temperature.equals(this)) {
            return w.getTemperature();
        }
        if (hydrarity.equals(this)) {
            return w.getHydrarity();
        }
        if (preasure.equals(this)) {
            return w.getPreasure();
        }
        if (windSpeed.equals(this)) {
            return w.getWindSpeed();
        }
        return 0.0;
    }
}

