/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.weather.mapspolygon;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.weather.mapspolygon.MapValuePoint;
import ru.blok.vms.ui.weather.mapspolygon.MapViewerWeather2;
import ru.blok.vms.ui.weather.mapspolygon.Parameter;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.ActionCalculatedObject;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.swing.viewers.TimeFormatViewer;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.RadioButtonViewer;
import ru.infor.beanviewer.viewer.simple.date.DateWithoutButton;
import ru.infor.client.soap.proxy.vms.WeatherConditionWSProxy;
import ru.infor.ws.objects.vms.WeatherConditionSearchCriteria;
import ru.infor.ws.objects.vms.entities.WeatherCondition;
import ru.infor.ws.objects.vms.entities.WeatherStation;

@ListView(views={@View(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u043e\u043b\u0438\u0433\u043e\u043d\u0430\u043c\u0438", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class WeatherGraphicsMapPolygon
extends CommonObjectWithKey {
    public Double[] coord;
    static HashMap<String, String> sp = null;
    private int r = 800;
    private Date date;
    WeatherConditionWSProxy proxy = (WeatherConditionWSProxy)CurrentProxyFactory.getProxy(WeatherCondition.class);
    private BeanViewerAction<ViewerContext> apply = new BeanViewerAction<ViewerContext>(){

        public String getName() {
            return "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435";
        }

        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            if (WeatherGraphicsMapPolygon.this.getDate() == null) {
                InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u0434\u0430\u0442\u0443"), new BeanViewerAction[]{new MessageOKButton()});
                return;
            }
            WeatherConditionSearchCriteria sc = (WeatherConditionSearchCriteria)WeatherGraphicsMapPolygon.this.proxy._getSearchCriteriaTemplate();
            sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            c1.setTime(WeatherGraphicsMapPolygon.this.getDate());
            c1.set(12, 0);
            c1.set(13, 0);
            c1.set(14, 0);
            c2.setTime(c1.getTime());
            c2.set(12, 59);
            c2.set(13, 59);
            c2.set(14, 999);
            sc.setDateFrom(c1.getTime());
            sc.setDateTill(c2.getTime());
            Object[] oo = WeatherGraphicsMapPolygon.this.proxy.getList(InitializedVariable.context, sc).getObjList();
            WeatherGraphicsMapPolygon.this.valuePoint.setWeatherCondition(oo);
            WeatherGraphicsMapPolygon.this.valuePoint.setParameter(WeatherGraphicsMapPolygon.this.parameter);
            WeatherGraphicsMapPolygon.this.valuePoint.setR(WeatherGraphicsMapPolygon.this.r);
            if (oo == null || oo.length == 0) {
                InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f"), new BeanViewerAction[]{new MessageOKButton()});
            } else {
                ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
            }
        }
    };
    private BeanViewerAction<ViewerContext> apply2 = new BeanViewerAction<ViewerContext>(){

        public String getName() {
            return "\u041e\u0442\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u044c \u0433\u0440\u0430\u0444\u0438\u043a";
        }

        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            if (WeatherGraphicsMapPolygon.this.getParameter() == null || WeatherGraphicsMapPolygon.this.valuePoint.getWeatherCondition() == null || WeatherGraphicsMapPolygon.this.valuePoint.getWeatherCondition().length == 0) {
                InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440"), new BeanViewerAction[]{new MessageOKButton()});
                return;
            }
            WeatherGraphicsMapPolygon.this.valuePoint.setParameter(WeatherGraphicsMapPolygon.this.parameter);
            WeatherGraphicsMapPolygon.this.valuePoint.setR(WeatherGraphicsMapPolygon.this.r);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("valuePoint");
        }
    };
    Parameter parameter;
    MapValuePoint valuePoint;
    public static String wkt4326 = "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]";
    public static String wkt3395 = "PROJCS[\"WGS 84 / World Mercator\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Mercator_1SP\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"3395\"]]";

    public WeatherGraphicsMapPolygon(String keyPage) {
        super(keyPage);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        this.date = c.getTime();
        this.coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)keyPage));
        this.valuePoint = new MapValuePoint(this.coord[0], this.coord[1], this.coord[2].intValue());
    }

    @ListField(fields={@Field(title="\u0414\u0430\u0442\u0430", order=10, viewer={DateWithoutButton.class}, propertiesLayout="Split1/h/l/0.3:m1:0/fillx, wrap 4# w 105", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @ListField(fields={@Field(title="\u0427\u0430\u0441", order=20, viewer={TimeFormatViewer.class}, propertiesLayout="Split1/h/l/0.3:m1:0#w 100", propertiesField={"format=HH"})})
    public Date getTime() {
        return this.date;
    }

    public void setTime(Date date) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDate());
        c2.setTime(date);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.date = c1.getTime();
    }

    @ListField(fields={@Field(title="\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", order=210, propertiesLayout="Split1/h/l/0.3:m1:0#spanx#wrap, spanx", viewer={ParViewer.class}, changeAction={ChangeParameter.class})})
    public Parameter getParameter() {
        return this.parameter;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    @ListField(fields={@Field(title="", order=80, viewer={ActionButton.class}, propertiesLayout="Split1/h/l/0.3:m1:0# spanx 3")})
    public BeanViewerAction<ViewerContext> getApply() {
        return this.apply;
    }

    @ListField(fields={@Field(title="", order=300, viewer={ActionButton.class}, propertiesLayout="Split1/h/l/0.3:m1:0# spanx 3")})
    public BeanViewerAction<ViewerContext> getApply2() {
        return this.apply2;
    }

    @ListField(fields={@Field(title="", order=100, viewer={MapViewerWeather2.class}, readOnly=true, propertiesLayout="Split1/h/r/0.3")})
    public MapValuePoint getValuePoint() {
        return this.valuePoint;
    }

    @ListField(fields={@Field(title="\u0420\u0430\u0434\u0438\u0443\u0441 \u043e\u043a\u0440\u0443\u0436\u043d\u043e\u0441\u0442\u0438, \u043c", order=250, propertiesLayout="Split1/h/l/0.3:m1:0# #spanx 3")})
    public int getR() {
        return this.r;
    }

    public void setR(int r) {
        this.r = r;
    }

    public void setValuePoint(MapValuePoint valuePoint) {
        this.valuePoint = valuePoint;
    }

    public static org.postgis.Polygon getDefaultPolygonStation(WeatherStation s, int r) {
        GeometryFactory f = new GeometryFactory();
        org.postgis.Polygon p3 = null;
        try {
            CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)wkt4326);
            CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)wkt3395);
            MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            GeneralDirectPosition pt1 = new GeneralDirectPosition(s.getLon().doubleValue(), s.getLat().doubleValue());
            DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
            Coordinate c = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
            Point pp = f.createPoint(c);
            Geometry buffer = pp.buffer((double)r);
            MathTransform math2 = CRS.findMathTransform((CoordinateReferenceSystem)targetCRS, (CoordinateReferenceSystem)sourceCRS);
            if (buffer instanceof Polygon) {
                Polygon p = (Polygon)buffer;
                Coordinate[] cc1 = new Coordinate[p.getCoordinates().length];
                int i = 0;
                while (i < p.getCoordinates().length) {
                    c = p.getCoordinates()[i];
                    pt1 = new GeneralDirectPosition(c.x, c.y);
                    pt2 = math2.transform((DirectPosition)pt1, null);
                    cc1[i] = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                    ++i;
                }
                Polygon p2 = f.createPolygon(f.createLinearRing(cc1), null);
                p3 = new org.postgis.Polygon(p2.toString());
                p3.setSrid(4326);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return p3;
    }

    public static class ChangeParameter
    extends ActionCalculatedObject {
        public void actionPerformed(Object message) {
            if (!initializing) {
                ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
                WeatherGraphicsMapPolygon pp = (WeatherGraphicsMapPolygon)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject());
                pp.getValuePoint().setParameter(pp.getParameter());
                pp.getValuePoint().setR(pp.getR());
                ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("valuePoint");
            }
        }
    }

    public static class ParViewer<T>
    extends RadioButtonViewer<T> {
        public ParViewer(UIFactory<T> factory) {
            super(factory);
        }

        public List<?> getRadioElement() {
            ArrayList<Parameter> l = new ArrayList<Parameter>();
            l.add(Parameter.temperature);
            l.add(Parameter.hydrarity);
            l.add(Parameter.preasure);
            l.add(Parameter.windSpeed);
            return l;
        }
    }
}

