/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.weather.mapspolygon;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.Point;
import ru.blok.vms.ui.weather.maps.WeatherPainter;
import ru.blok.vms.ui.weather.mapspolygon.MapValuePoint;
import ru.blok.vms.ui.weather.mapspolygon.Parameter;
import ru.blok.vms.ui.weather.mapspolygon.WeatherGraphicsMapPolygon;
import ru.infor.ws.objects.vms.entities.WeatherCondition;

public class WeatherPainter2<T extends JXMapViewer>
extends WeatherPainter<T> {
    protected void paintPolygon(Geometry polygon, JXMapViewer map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c, int k) {
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), k);
        Polygon pp = new Polygon();
        int i = 0;
        while (i < polygon.numPoints()) {
            Point p = polygon.getPoint(i);
            Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(p.y, p.x), map.getZoom());
            pp.addPoint((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()));
            ++i;
        }
        g.setColor(cc);
        g.drawPolygon(pp);
        g.fillPolygon(pp);
    }

    @Override
    protected void paint(Graphics2D g, T map, Rectangle2D vp2, Rectangle2D vp3) {
        if (this.valuePoint != null && this.valuePoint.getWeatherCondition() != null && ((MapValuePoint)this.valuePoint).getParameter() != null) {
            Object[] objectArray = this.valuePoint.getWeatherCondition();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                WeatherCondition w = (WeatherCondition)o;
                this.paintCondidions(g, vp2, vp3, w, map);
                this.paintStantion(w.getStation(), map, g, vp2, vp3);
                ++n2;
            }
        }
    }

    protected void paintCondidions(Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, WeatherCondition w, T map) {
        Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(w.getStation().getLat().doubleValue(), w.getStation().getLon().doubleValue()), map.getZoom());
        Parameter p = ((MapValuePoint)this.valuePoint).getParameter();
        double value = p.getValueFromWeatherCondition(w);
        Color c = p.getColorForValue(value);
        org.postgis.Polygon pp = WeatherGraphicsMapPolygon.getDefaultPolygonStation(w.getStation(), ((MapValuePoint)this.valuePoint).getR());
        this.paintPolygon((Geometry)pp, (JXMapViewer)map, g, vp2, vp3, c, 200);
        g.setColor(Color.BLACK);
        int x = (int)(point.getX() - vp2.getX());
        int y = (int)(point.getY() - vp2.getY());
        g.drawString(String.valueOf(p.getName()) + "=" + value, x, y);
    }
}

