/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.weather.placeonmap;

import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.mapviewer.MapValue;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.weather.placeonmap.MapValuePoint;
import ru.blok.vms.ui.weather.placeonmap.PlaceOnMap;
import ru.blok.vms.ui.weather.placeonmap.PointPainter;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.JScrollPopupMenu;
import ru.infor.beanviewer.swing.SwingFactory;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.client.soap.proxy.vms.BuildingWSProxy;
import ru.infor.ws.objects.vms.AdressNearPointParam;
import ru.infor.ws.objects.vms.NearestAddress;
import ru.infor.ws.objects.vms.entities.Building;
import ru.infor.ws.objects.vms.entities.ViewAddressADIS;
import ru.infor.ws.objects.vms.entities.ext.BuildingExt;

public class MapViewerPoint
extends MapViewer {
    PointPainter<JXMapViewer> p2;
    BuildingWSProxy buildingWSProxy = (BuildingWSProxy)CurrentProxyFactory.getProxy(Building.class);

    @Override
    protected void init() {
        super.init();
        this.p2 = new PointPainter();
        this.painter.addPainter(this.p2);
    }

    public MapViewerPoint(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    public void setValue(Object arg0) {
        super.setValue(arg0);
        this.p2.setValuePoint((MapValuePoint)arg0);
        this.zoomToTracks();
    }

    @Override
    protected MapValue getNewInstance(double lat, double lon, int zoom) {
        return new MapValuePoint(this.coord[0], this.coord[1], this.coord[2].intValue());
    }

    @Override
    protected void mouseClickedOnMap(double x, double y, GeoPosition gp, MouseEvent e) {
        super.mouseClickedOnMap(x, y, gp, e);
        ((MapValuePoint)this.getValue()).setLatlon(gp);
        this.repaint();
        AdressNearPointParam p = new AdressNearPointParam();
        p.setLat(Double.valueOf(gp.getLatitude()));
        p.setLon(Double.valueOf(gp.getLongitude()));
        p.setRadius(Integer.valueOf(50));
        p.setLimit(Integer.valueOf(1));
        NearestAddress[] ss = this.buildingWSProxy.getListNearAdress(InitializedVariable.context, p);
        if (ss != null && ss.length > 0) {
            BuildingExt buildingExt = (BuildingExt)this.buildingWSProxy.getCurrentObject(InitializedVariable.context, ss[0].getBuildingId());
            ((PlaceOnMap)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject())).updateAddress(buildingExt);
        } else {
            p.setLimit(Integer.valueOf(5));
            ViewAddressADIS[] aa1 = this.buildingWSProxy.calculateAddressPoint(InitializedVariable.context, p);
            if (aa1 != null && aa1.length > 0) {
                JScrollPopupMenu pop = new JScrollPopupMenu();
                ViewAddressADIS[] viewAddressADISArray = aa1;
                int n = aa1.length;
                int n2 = 0;
                while (n2 < n) {
                    final ViewAddressADIS a = viewAddressADISArray[n2];
                    BeanViewerAction bva = new BeanViewerAction(){

                        public String getName() {
                            StringBuilder st = new StringBuilder();
                            st.append(a.getTownName());
                            if (a.getStateName() != null && !"".equals(a.getStateName())) {
                                st.append(",").append(a.getStateName());
                            }
                            if (a.getStreetName() != null && !"".equals(a.getStreetName())) {
                                st.append(",").append(a.getStreetName());
                            }
                            if (a.getHouseNum() != null && !"".equals(a.getHouseNum())) {
                                st.append(",").append(a.getHouseNum());
                            }
                            return st.toString();
                        }

                        public void actionPerformed(Object message) {
                            Building b = new Building();
                            b.setCityName(a.getTownName());
                            b.setSettlement(a.getStateName());
                            b.setStreet(a.getStreetName());
                            b.setHouseNumber(a.getHouseNum());
                            b.setPostcode(a.getPostalCode());
                            b.setLat(a.getLat());
                            b.setLon(a.getLon());
                            b = MapViewerPoint.this.buildingWSProxy.save(InitializedVariable.context, b);
                            ((PlaceOnMap)((Object)((PanelContext)MapViewerPoint.this.getViewerContext().getParentContext()).getObject())).updateAddress(b);
                        }
                    };
                    JMenuItem mi = new JMenuItem();
                    mi.setAction(((SwingFactory)InitializedVariable.factory).createAction(bva, null, null));
                    pop.add(mi);
                    ++n2;
                }
                BeanViewerAction bva = new BeanViewerAction(){

                    public String getName() {
                        return "\u041e\u0442\u043c\u0435\u043d\u0430";
                    }

                    public void actionPerformed(Object message) {
                    }
                };
                JMenuItem mi = new JMenuItem();
                mi.setAction(((SwingFactory)InitializedVariable.factory).createAction(bva, null, null));
                pop.add(mi);
                pop.pack();
                pop.show((Component)this.map.getMainMap(), (int)e.getPoint().getX(), (int)e.getPoint().getY());
            }
        }
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected Double[] getMinMax() {
        MapValuePoint mvp = (MapValuePoint)this.getValue();
        if (mvp.getLatlon() == null) {
            return null;
        }
        return new Double[]{mvp.getLatlon().getLatitude(), mvp.getLatlon().getLatitude(), mvp.getLatlon().getLongitude(), mvp.getLatlon().getLongitude()};
    }
}

