/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.weather.placeonmap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RoutePainter;
import ru.blok.vms.ui.route.routegeom.RouteGeomBuilder;
import ru.blok.vms.ui.weather.placeonmap.MapValuePoint;

public class PointPainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    private MapValuePoint valuePoint;

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.valuePoint != null && this.valuePoint.getLatlon() != null) {
            int y;
            int x;
            Point2D point = map.getTileFactory().geoToPixel(this.valuePoint.getLatlon(), map.getZoom());
            if (vp2.contains(point)) {
                this.paintRad(this.valuePoint.getLatlon(), (JXMapViewer)map, vp2, g);
                x = (int)(point.getX() - ((RectangularShape)vp2).getX());
                y = (int)(point.getY() - ((RectangularShape)vp2).getY());
                g.translate(x, y);
                this.paintNode(g, (JXMapViewer)map);
                g.translate(-x, -y);
            }
            if (vp3.contains(point)) {
                this.paintRad(this.valuePoint.getLatlon(), (JXMapViewer)map, vp2, g);
                x = (int)(point.getX() - ((RectangularShape)vp3).getX());
                y = (int)(point.getY() - ((RectangularShape)vp3).getY());
                g.translate(x, y);
                this.paintNode(g, (JXMapViewer)map);
                g.translate(-x, -y);
            }
        }
    }

    public MapValuePoint getValuePoint() {
        return this.valuePoint;
    }

    public void setValuePoint(MapValuePoint valuePoint) {
        this.valuePoint = valuePoint;
    }

    public void paintRad(GeoPosition gp, JXMapViewer map, Rectangle2D vp2, Graphics2D g) {
        if (this.valuePoint.getRadius() != null) {
            org.postgis.Polygon p = RouteGeomBuilder.getDefaultPolygonStation(gp.getLatitude(), gp.getLongitude(), this.valuePoint.getRadius());
            RoutePainter.paintPolygon((Geometry)p, map, g, vp2, Color.RED, 100);
        }
    }

    public boolean paintNode(Graphics2D g, JXMapViewer ma) {
        Polygon p = new Polygon();
        p.addPoint(0, -15);
        p.addPoint(-15, -15);
        p.addPoint(-15, -25);
        p.addPoint(1, -25);
        p.addPoint(1, 0);
        g.setColor(Color.BLACK);
        g.drawPolygon(p);
        g.setColor(Color.RED);
        g.fillPolygon(p);
        return false;
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }
}

