/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.objects.energy.entities.ext;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.MultiLineString;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.powerline.geompl.ListViewerT;
import ru.blok.vms.ui.powerline.geompl.MapValue;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.ws.objects.energy.entities.PowerLine;
import ru.infor.ws.objects.energy.entities.PowerLineItems;
import ru.infor.ws.objects.energy.entities.ext.PowerLineItemsExt;

public class PowerLineExt
extends PowerLine {
    private static final long serialVersionUID = -5309042791648267380L;
    private List<PowerLineItemsExt> itemsList;
    PowerLineItemsExt select;
    MapValue value;

    public List<PowerLineItemsExt> getItemsList() {
        return this.itemsList;
    }

    public void setItemsList(List<PowerLineItemsExt> itemsList) {
        this.itemsList = itemsList;
        if (itemsList == null) {
            super.setItems(null);
            super.setGeom(null);
        } else {
            super.setItems(itemsList.toArray(new PowerLineItems[0]));
            if (itemsList.size() > 0) {
                GeometryFactory f = new GeometryFactory();
                Coordinate[] src = new Coordinate[itemsList.size()];
                int i = 0;
                while (i < itemsList.size()) {
                    Coordinate c;
                    PowerLineItemsExt e = itemsList.get(i);
                    src[i] = c = new Coordinate(e.getLon().doubleValue(), e.getLat().doubleValue());
                    ++i;
                }
                LineString s = f.createLineString(src);
                try {
                    MultiLineString m = new MultiLineString(new org.postgis.LineString[]{new org.postgis.LineString(s.toString())});
                    this.setGeom(m.toString());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else {
                this.setGeom(null);
            }
        }
    }

    public PowerLineItemsExt getSelect() {
        return this.select;
    }

    public void setSelect(PowerLineItemsExt select) {
        this.select = select;
    }

    public MapValue getValue() {
        return this.value;
    }

    public void setValue(MapValue value) {
        this.value = value;
    }

    public void setSelect(PowerLineItemsExt select, PanelContext pc) {
        this.setSelect(select);
        if (select != null) {
            ((MapViewer)pc.getPanel().getPresentatorForName("value").getViewer()).setCenterPosition(new double[]{select.getLat(), select.getLon()});
        } else {
            ((MapViewer)pc.getPanel().getPresentatorForName("value").getViewer()).repaint();
        }
    }

    public void removeItemsList(PowerLineItemsExt e) {
    }

    public void addItems(GeoPosition gp, PanelContext pc, boolean begin) {
        PowerLineItemsExt e = new PowerLineItemsExt();
        e.setLat(gp.getLatitude());
        e.setLon(gp.getLongitude());
        int index = 0;
        if (!begin && this.select != null) {
            index = this.getSelect().getIndex();
        }
        e.setIndex(index);
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<PowerLineItemsExt>();
        }
        this.itemsList.add(index, e);
        int i = 0;
        while (i < this.itemsList.size()) {
            this.itemsList.get(i).setIndex(i + 1);
            ++i;
        }
        pc.getPanel().updateUIForPresentatorName("itemsList");
        if (index == 0 && this.itemsList.size() > 0) {
            return;
        }
        ((ListViewerT)pc.getPanel().getPresentatorForName("itemsList").getViewer()).getTM().setSelectedRows(new int[]{index});
    }
}

