/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.ws.objects.vms.entities.ext;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.infor.client.soap.proxy.vms.Route2CheckPointLinkWSProxy;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.ws.objects.vms.entities.OffsetInSec;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.Route2CheckPointLink;
import ru.infor.ws.objects.vms.entities.RouteDayPart;

public class OffsetInSecExt
extends OffsetInSec {
    private static final long serialVersionUID = 8097449245808601313L;
    private static Long link_id = null;
    private static RouteDayPart[] intervals = null;
    private int difMin = 0;
    private int difMax = 0;
    Route2CheckPointLinkWSProxy r2cpLProxy = (Route2CheckPointLinkWSProxy)CurrentProxyFactory.getProxy(Route2CheckPointLink.class);
    RouteWSProxy routeProxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);
    DateFormat df = new SimpleDateFormat("HH:mm:ss");

    public static void clearRoute2CheckPointLink() {
        link_id = null;
    }

    public static void setRoute2CheckPointLinkIntervals(RouteDayPart[] in) {
        intervals = in;
    }

    public String getInterval() {
        String res = "";
        if (this.getHour() != null) {
            if ((link_id == null || link_id != null && !link_id.equals(this.getLinkId())) && this.getLinkId() != null) {
                Route route = null;
                Route2CheckPointLink link = this.r2cpLProxy.getCurrentObject(InitializedVariable.context, this.getLinkId());
                if (link.getRoute() != null && link.getRoute().getDayParts() == null) {
                    route = this.routeProxy.getCurrentObject(InitializedVariable.context, link.getRoute().getId());
                }
                if (link.getRoute() != null && route != null) {
                    intervals = route.getDayParts();
                    link_id = this.getLinkId();
                }
            }
            if (intervals != null) {
                int i = 0;
                while (i < intervals.length) {
                    if (this.getHour().equals(intervals[i].getIndex())) {
                        res = String.valueOf(this.df.format(intervals[i].getStartsAt())) + " - " + this.df.format(intervals[i].getEndsAt());
                    }
                    ++i;
                }
            }
        }
        return res;
    }

    public String getIdentifierOffsetInSec() {
        String rez = "";
        if (this.getMinInSec() != null) {
            rez = rez.concat(this.getMinInSec().toString());
        }
        if (this.getMaxInSec() != null) {
            rez = rez.concat(" - ").concat(this.getMaxInSec().toString());
        }
        return rez;
    }

    public void setMinOffset(Date timeMin) {
        if (timeMin != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(timeMin);
            int time = c.get(11) * 3600 + c.get(12) * 60 + c.get(13);
            this.setMinInSec(time);
        }
    }

    public Date getMinOffset() {
        Calendar c = Calendar.getInstance();
        c.set(1, 0);
        c.set(2, 0);
        c.set(5, 0);
        c.set(11, 0);
        c.set(12, 0);
        if (this.getMinInSec() != null) {
            c.set(13, this.getMinInSec());
        } else {
            c.set(13, 0);
        }
        c.set(14, 0);
        return c.getTime();
    }

    public void setMaxOffset(Date timeMax) {
        if (timeMax != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(timeMax);
            int time = c.get(11) * 3600 + c.get(12) * 60 + c.get(13);
            this.setMaxInSec(time);
        }
    }

    public Date getMaxOffset() {
        Calendar c = Calendar.getInstance();
        c.set(1, 0);
        c.set(2, 0);
        c.set(5, 0);
        c.set(11, 0);
        c.set(12, 0);
        if (this.getMaxInSec() != null) {
            c.set(13, this.getMaxInSec());
        } else {
            c.set(13, 0);
        }
        c.set(14, 0);
        return c.getTime();
    }

    public Date getOffset() {
        Integer r = this.getOffsetInSec();
        Calendar c = Calendar.getInstance();
        c.set(1, 0);
        c.set(2, 0);
        c.set(5, 0);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, r);
        c.set(14, 0);
        return c.getTime();
    }

    public Integer getOffsetInSec() {
        Integer r = 0;
        if (this.getMinInSec() != null && this.getMaxInSec() != null) {
            r = (this.getMinInSec() + this.getMaxInSec()) / 2;
            this.difMin = this.getMinInSec() - r;
            this.difMax = this.getMaxInSec() - r;
        }
        return r;
    }

    public void setOffset(Date timeT) {
        if (timeT != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(timeT);
            int time = c.get(11) * 3600 + c.get(12) * 60 + c.get(13);
            this.setMaxInSec(time + this.difMax);
            this.setMinInSec(time + this.difMin);
        }
    }
}

