/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DateFormatter;
import net.sf.nachocalendar.components.ArrowButton;
import net.sf.nachocalendar.components.CalendarUtils;
import net.sf.nachocalendar.components.DatePanel;
import net.sf.nachocalendar.components.DayPanel;
import net.sf.nachocalendar.components.DayRenderer;
import net.sf.nachocalendar.components.DefaultDayRenderer;
import net.sf.nachocalendar.components.DefaultHeaderRenderer;
import net.sf.nachocalendar.components.HeaderRenderer;
import net.sf.nachocalendar.model.DataModel;

public class DateField
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private List<FocusListener> fls = new ArrayList<FocusListener>();
    private WindowPanel windowpanel;
    private DatePanel datepanel;
    private JFormattedTextField field;
    private JButton button;
    private Calendar calendar;
    private boolean showWeekNumbers;
    private DateFormatter formatter;
    private boolean antiAliased;
    private boolean printMoon;
    private Locale locale;
    private SimpleDateFormat dateFormat;
    private Date baseDate;
    private JFormattedTextField.AbstractFormatterFactory formatterFactory = new JFormattedTextField.AbstractFormatterFactory(){

        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
            return new DateFormatter(DateField.this.dateFormat);
        }
    };
    private transient ArrayList<ChangeListener> changeListenerList;
    private boolean showOkCancel;
    private int firstDayOfWeek;
    private boolean[] workingDays;

    @Override
    public void setForeground(Color fg) {
        if (this.field != null) {
            this.field.setForeground(fg);
        }
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        this.fls.add(l);
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        this.fls.remove(l);
    }

    public DateField(boolean showWeekNumbers) {
        this.showWeekNumbers = showWeekNumbers;
        this.init();
    }

    public DateField() {
        this(false);
    }

    public DateField(DateFormatter formatter) {
        this.formatter = formatter;
        this.init();
    }

    public DateField(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.init();
    }

    public DateField(Locale locale) {
        this.locale = locale;
        this.init();
    }

    private void init() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.calendar = Calendar.getInstance();
        this.calendar.set(10, 0);
        this.calendar.set(12, 0);
        this.calendar.set(14, 0);
        this.datepanel = new DatePanel(this.showWeekNumbers);
        this.datepanel.setFirstDayOfWeek(this.firstDayOfWeek);
        this.datepanel.setWorkingDays(this.workingDays);
        this.datepanel.setSelectionMode(0);
        this.setRenderer(new DefaultDayRenderer());
        this.setHeaderRenderer(new DefaultHeaderRenderer());
        this.setLayout(new BorderLayout());
        if (this.dateFormat != null) {
            this.field = new JFormattedTextField(this.dateFormat);
        } else {
            if (this.formatter == null) {
                this.formatter = new DateFormatter(DateFormat.getDateInstance(3, this.locale));
            }
            this.field = new JFormattedTextField(this.formatter);
        }
        this.field.setFocusLostBehavior(3);
        this.add((Component)this.field, "Center");
        this.button = new ArrowButton(5);
        this.add((Component)this.button, "East");
        this.button.addActionListener(this);
        this.field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getOppositeComponent() == null || !e.getOppositeComponent().equals(DateField.this.button) && !e.getOppositeComponent().getClass().equals(DayPanel.class) && !e.getOppositeComponent().getClass().equals(WindowPanel.class)) {
                    for (FocusListener fl : DateField.this.fls) {
                        fl.focusGained(e);
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() == null || !e.getOppositeComponent().equals(DateField.this.button)) {
                    for (FocusListener fl : DateField.this.fls) {
                        fl.focusLost(e);
                    }
                }
            }
        });
        this.button.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getOppositeComponent() == null || !e.getOppositeComponent().equals(DateField.this.field) && !e.getOppositeComponent().getClass().equals(DayPanel.class) && !e.getOppositeComponent().getClass().equals(WindowPanel.class)) {
                    for (FocusListener fl : DateField.this.fls) {
                        fl.focusGained(e);
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() == null || !e.getOppositeComponent().equals(DateField.this.field) && !e.getOppositeComponent().getClass().equals(DayPanel.class) && !e.getOppositeComponent().getClass().equals(WindowPanel.class)) {
                    for (FocusListener fl : DateField.this.fls) {
                        fl.focusLost(e);
                    }
                }
            }
        });
        this.field.setValue(new Date());
        this.field.addPropertyChangeListener("value", this);
        Border border = this.field.getBorder();
        this.field.setBorder(null);
        this.setBorder(border);
        this.field.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DateField.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
    }

    private void aceptar() {
        this.windowpanel.setVisible(false);
        this.field.setValue(this.windowpanel.getDate());
    }

    private void cancelar() {
        this.windowpanel.setVisible(false);
    }

    private void createWindow() {
        Container c;
        for (c = this; !(c instanceof Dialog) && c != null; c = c.getParent()) {
        }
        if (c != null) {
            this.windowpanel = new WindowPanel((Dialog)c, this.showWeekNumbers);
            return;
        }
        Frame f = JOptionPane.getFrameForComponent(this);
        this.windowpanel = new WindowPanel(f, this.showWeekNumbers);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Date da;
        if (this.windowpanel == null) {
            this.createWindow();
        }
        if ((da = (Date)this.field.getValue()) == null) {
            da = this.baseDate;
        }
        if (da == null) {
            da = this.calendar.getTime();
        }
        this.windowpanel.setDate(da);
        Point p = this.getLocationOnScreen();
        p.y += this.getHeight();
        this.windowpanel.setLocation(p);
        this.windowpanel.setVisible(true);
    }

    public void setValue(Object value) {
        try {
            if (value == null) {
                this.field.setText("");
            } else {
                this.field.setValue(CalendarUtils.convertToDate(value, this.dateFormat));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public Object getValue() {
        String ret = this.field.getText();
        if (ret.trim().equals("")) {
            return null;
        }
        try {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)this.field.getValue());
            Date d2 = CalendarUtils.convertToDate(ret, this.dateFormat);
            Calendar c2 = Calendar.getInstance();
            c2.setTime(d2);
            String format = this.dateFormat.toPattern();
            if (!format.contains("H") && !format.contains("h")) {
                c2.set(11, c.get(11));
            }
            if (!format.contains("m")) {
                c2.set(12, c.get(12));
            }
            if (!format.contains("s")) {
                c2.set(13, c.get(13));
            }
            if (!format.contains("S") && !format.contains("h")) {
                c2.set(14, c.get(14));
            }
            return c2.getTime();
        }
        catch (ParseException e) {
            return this.field.getValue();
        }
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (this.changeListenerList == null) {
            this.changeListenerList = new ArrayList();
        }
        this.changeListenerList.add(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (this.changeListenerList != null) {
            this.changeListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeListenerStateChanged(ChangeEvent event) {
        ArrayList list;
        DateField dateField = this;
        synchronized (dateField) {
            if (this.changeListenerList == null) {
                return;
            }
            list = (ArrayList)this.changeListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ChangeListener)list.get(i)).stateChanged(event);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireChangeListenerStateChanged(new ChangeEvent(this));
    }

    public DayRenderer getRenderer() {
        return this.datepanel.getRenderer();
    }

    public void setRenderer(DayRenderer renderer) {
        this.datepanel.setRenderer(renderer);
    }

    public DataModel getModel() {
        return this.datepanel.getModel();
    }

    public void setModel(DataModel model) {
        this.datepanel.setModel(model);
    }

    public HeaderRenderer getHeaderRenderer() {
        return this.datepanel.getHeaderRenderer();
    }

    public void setHeaderRenderer(HeaderRenderer headerRenderer) {
        this.datepanel.setHeaderRenderer(headerRenderer);
    }

    public boolean getShowOkCancel() {
        return this.showOkCancel;
    }

    public void setShowOkCancel(boolean showOkCancel) {
        if (this.showOkCancel == showOkCancel) {
            return;
        }
        boolean old = this.showOkCancel;
        this.showOkCancel = showOkCancel;
        this.windowpanel = null;
        this.firePropertyChange("showOkCancel", old, showOkCancel);
    }

    public boolean getAllowsInvalid() {
        return this.formatter.getAllowsInvalid();
    }

    public void setAllowsInvalid(boolean b) {
        boolean old = this.formatter.getAllowsInvalid();
        this.formatter.setAllowsInvalid(b);
        this.firePropertyChange("allowsInvalid", old, b);
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        int old = this.firstDayOfWeek;
        if (this.datepanel != null) {
            this.datepanel.setFirstDayOfWeek(firstDayOfWeek);
        }
        this.firstDayOfWeek = firstDayOfWeek;
        this.firePropertyChange("firstDayOfWeek", old, firstDayOfWeek);
    }

    public boolean[] getWorkingDays() {
        return this.workingDays;
    }

    public void setWorkingDays(boolean[] workingDays) {
        boolean[] old = this.workingDays;
        if (this.datepanel != null) {
            this.datepanel.setWorkingDays(workingDays);
        }
        this.workingDays = workingDays;
        this.firePropertyChange("workingDays", old, workingDays);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
        this.field.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.button.isEnabled();
    }

    public JFormattedTextField getFormattedTextField() {
        return this.field;
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        boolean old = this.antiAliased;
        this.antiAliased = antiAliased;
        this.datepanel.setAntiAliased(antiAliased);
        this.firePropertyChange("antiAliased", old, antiAliased);
    }

    public boolean isPrintMoon() {
        return this.printMoon;
    }

    public void setPrintMoon(boolean printMoon) {
        this.datepanel.setPrintMoon(printMoon);
        this.repaint();
        this.printMoon = printMoon;
    }

    public void setShowToday(boolean show) {
        this.datepanel.setShowToday(show);
        this.repaint();
    }

    public boolean getShowToday() {
        return this.datepanel.getShowToday();
    }

    public void setTodayCaption(String caption) {
        this.datepanel.setTodayCaption(caption);
    }

    public String getTodayCaption() {
        return this.datepanel.getTodayCaption();
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.field.setFormatterFactory(this.formatterFactory);
    }

    public Date getBaseDate() {
        return this.baseDate;
    }

    public void setBaseDate(Date baseDate) {
        this.baseDate = baseDate;
    }

    class WindowPanel
    extends JDialog {
        public WindowPanel(Frame parent, boolean showWeekNumbers) {
            super(parent, false);
            this.init(showWeekNumbers);
        }

        public WindowPanel(Dialog parent, boolean showWeekNumbers) {
            super(parent, false);
            this.init(showWeekNumbers);
        }

        private void init(boolean showWeekNumbers) {
            this.setUndecorated(true);
            this.setFocusable(true);
            JPanel todo = new JPanel(new BorderLayout());
            this.getContentPane().add(todo);
            todo.add(DateField.this.datepanel);
            todo.setBorder(BorderFactory.createLineBorder(Color.black));
            if (DateField.this.showOkCancel) {
                JPanel abajo = new JPanel();
                todo.add((Component)abajo, "South");
                JButton ok = new JButton("Ok");
                JButton cancel = new JButton("Cancel");
                abajo.add(ok);
                abajo.add(cancel);
                this.getRootPane().setDefaultButton(ok);
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DateField.this.aceptar();
                    }
                });
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DateField.this.cancelar();
                    }
                });
            } else {
                DateField.this.datepanel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DateField.this.aceptar();
                    }
                });
            }
            KeyAdapter klistener = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\n') {
                        DateField.this.aceptar();
                    }
                    if (e.getKeyChar() == '\u001b') {
                        DateField.this.cancelar();
                    }
                }
            };
            DateField.this.datepanel.addKeyListener(klistener);
            this.addKeyListener(klistener);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent e) {
                    DateField.this.cancelar();
                }
            });
            this.pack();
        }

        public Date getDate() {
            return DateField.this.datepanel.getDate();
        }

        public void setDate(Date d) {
            DateField.this.datepanel.setDate(d);
        }
    }
}

