/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.demo;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import net.sf.nachocalendar.components.CalendarPanel;
import net.sf.nachocalendar.components.DateField;
import net.sf.nachocalendar.components.DatePanel;
import net.sf.nachocalendar.customizer.CustomizerFactory;
import net.sf.nachocalendar.demo.ComponentForm;

public class CustomizerDemo
extends JDialog {
    private JFileChooser chooser;
    private JButton bBrowse;
    private JButton bCalendarPanel;
    private JButton bClose;
    private JButton bDateField;
    private JButton bDatePanel;
    private JTextField tCustomizer;

    public CustomizerDemo(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        this.bClose = new JButton();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.tCustomizer = new JTextField();
        this.bBrowse = new JButton();
        JPanel jPanel3 = new JPanel();
        this.bDateField = new JButton();
        this.bDatePanel = new JButton();
        this.bCalendarPanel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Customizer Demo");
        this.bClose.setText("Close");
        this.bClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerDemo.this.bCloseActionPerformed(evt);
            }
        });
        jPanel1.add(this.bClose);
        this.getContentPane().add((Component)jPanel1, "South");
        jPanel2.setLayout(new GridBagLayout());
        jLabel2.setText("Customization");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.tCustomizer, gridBagConstraints);
        this.bBrowse.setText("Browse...");
        this.bBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerDemo.this.bBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.bBrowse, gridBagConstraints);
        this.bDateField.setText("DateField");
        this.bDateField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerDemo.this.bDateFieldActionPerformed(evt);
            }
        });
        jPanel3.add(this.bDateField);
        this.bDatePanel.setText("DatePanel");
        this.bDatePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerDemo.this.bDatePanelActionPerformed(evt);
            }
        });
        jPanel3.add(this.bDatePanel);
        this.bCalendarPanel.setText("CalendarPanel");
        this.bCalendarPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerDemo.this.bCalendarPanelActionPerformed(evt);
            }
        });
        jPanel3.add(this.bCalendarPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.pack();
    }

    private void bBrowseActionPerformed(ActionEvent evt) {
        int result;
        if (this.chooser == null) {
            this.createChooser();
        }
        if ((result = this.chooser.showOpenDialog(this)) == 0) {
            this.tCustomizer.setText(this.chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void bCalendarPanelActionPerformed(ActionEvent evt) {
        File f = this.verifyFile();
        if (f == null) {
            return;
        }
        CustomizerFactory factory = null;
        try {
            factory = new CustomizerFactory(f);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        ComponentForm form = new ComponentForm((Dialog)this, true);
        CalendarPanel calendarpanel = factory.createCalendarPanel();
        form.addComponent(calendarpanel);
        form.setVisible(true);
    }

    private void bDatePanelActionPerformed(ActionEvent evt) {
        File f = this.verifyFile();
        if (f == null) {
            return;
        }
        CustomizerFactory factory = null;
        try {
            factory = new CustomizerFactory(f);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        ComponentForm form = new ComponentForm((Dialog)this, true);
        DatePanel datepanel = factory.createDatePanel();
        form.addComponent(datepanel);
        form.setVisible(true);
    }

    private void bDateFieldActionPerformed(ActionEvent evt) {
        File f = this.verifyFile();
        if (f == null) {
            return;
        }
        CustomizerFactory factory = null;
        try {
            factory = new CustomizerFactory(f);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        ComponentForm form = new ComponentForm((Dialog)this, true);
        DateField datefield = factory.createDateField();
        form.addComponent(datefield);
        form.setVisible(true);
    }

    private void bCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private File verifyFile() {
        File f = new File(this.tCustomizer.getText());
        if (!f.exists()) {
            JOptionPane.showMessageDialog(this, "File doesn't exist!");
            return null;
        }
        return f;
    }

    private void createChooser() {
        this.chooser = new JFileChooser();
        this.chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "XML files (*.xml)";
            }
        });
        this.chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(".properties");
            }

            @Override
            public String getDescription() {
                return "Properties files (*.properties)";
            }
        });
    }
}

